
#include "bullet.h"
#include <aldumb.h>



//functions
bool CreateBullet(int SourceX, int SourceY, int SourceHeading,bool ps,bool triple);
bool CreateMissile(int SourceX, int SourceY, int SourceHeading,bool imm, ship * targ, bool ps);
void CollisionCheck();
void DrawNumber(int x, int y, int val,int thewidth);
void DrawHSNumber(int val,int number);
int RaiseToPower(int number, int power);
void NewFormation(int Pattern, bool Hard, bool MissileChuckers, int NumberOn, int Number,int Side, int Sector, int FP, int imType, int spd);

void MakeStandardLevelFormation();
void MakeSpecialLevelFormation();
void initLevels();

int CreateShip(int elx,int ely,int d, bool explodes, int imType,bool invince, bool Kami, int spd,bool Miss,bool PlS,int FP);
bool SetLevel();
void GeneratePlanetSurface(int WhichRock);
bool CheckCorners(int x,int y, int w, int h);
void ClearSprites();
void BigChunkOCode();
void GetFunky();




//synchronozation handler
//void KitchenSync();
volatile int SyncFlag=0;

//void SetSyncFlag();
void SetSyncFlag()
{
	SyncFlag++;
}
END_OF_FUNCTION(SetSyncFlag);


//high score table

typedef struct _HSDATA{int score; char name[8];} HSDATA;
HSDATA HighScoreTable[8];

void OpenHighScores();
void SaveHighScores();


//Bitmaps
BITMAP *PLANET_SURFACE;
BITMAP *PLANET_SURFACE4;
BITMAP * SHIPS[SHIP_GRAPHIC_COUNT][MAX_FRAME_COUNT];
BITMAP * NUMBER[10];
BITMAP * HSNUMBERS[10];
BITMAP * BULLET_SHOT[2];
BITMAP * TARGET_ID;
BITMAP * LIFE;
BITMAP * DIVE;
BITMAP * SLOMO;
BITMAP * REPAIRING;

BITMAP *BUFFER;
BITMAP *BUFFER2;
BITMAP *SHIPS_LEFT;
BITMAP *SHIPS_LEFT_COVER;
BITMAP *TMP;
BITMAP * TMP_SURFACE;
//BITMAP * TMPNUM;
BITMAP * BIG_BOOM_BOOMS[9];
BITMAP * SCENERY[19];
BITMAP * FBACK;
BITMAP * PLANETFELL;
BITMAP * GAME_OVER;
BITMAP * LETRAS[28];
BITMAP * LOW_SCORE;
BITMAP * FOUR_SHIPS;
BITMAP * LOW_SCORE_2;
BITMAP * YOUR_NAME_PLEASE;
BITMAP * USE_KEY_BOARD;
BITMAP * USE_JOY_STICK;
BITMAP * USE_MUSIC;
BITMAP * USE_SOUND;
BITMAP * USE_NO_MUSIC;
BITMAP * USE_NO_SOUND;
//BITMAP * CON_JOY_STICK;

SAMPLE * THE_SAMPLES[SAMPLE_COUNT];

//BITMAP * COPYRIGHT;
PALETTE THE_PALETTE;

//array type definitions
typedef struct _SHIPINFO {ship* theShip; bool hasShip;} SHIPINFO;
typedef struct _BULLETINFO {bullet* theBullet; bool hasBullet;} BULLETINFO;

typedef struct _LEVELTYPE {int speed; int size; int numberon; int hs; int mc; int stdfptypes[3]; int hsfp; int mcfp;int formation;} LEVELTYPE;


SHIPINFO theShips[MAX_SHIP_COUNT];
BULLETINFO theBullets[MAX_BULLET_COUNT];
ship * PlayerShip;
FlightPattern * FPArray[FLIGHT_PATTERN_COUNT];
LEVELTYPE Levels[LEVEL_COUNT];

//void CreateShip(int elx,int ely,int d, bool explodes, int imType,bool invince, bool Kami);
//void DestroyShip(ship * theShip);

int MissKills=0;
int BullKills=0;
int Deaths=0;
int Level=0;

int pLives=5;
int pDives=5;
int pointsToShow=0;
int points=0;
int shot = 0;
bool hasSloMo = true;
bool changinglevel=false;
int tmpWidth=512;
int tmpHeight=512;
bool growing=false;
int deathroes=0;

bool joyinstalled=false;
bool joyconfigured=false;
bool usingjoy=false;
bool HaveMuzak=false;
bool HaveSound=false;
	
int slomo = 1; //controls the gamespeed

int main(int argc, char * argv[])
{
	int i;
	int a;
	

	
	//Initialization of graphics
	allegro_init();
	atexit(&dumb_exit);
	dumb_register_stdfiles();
	
	install_keyboard(); 
	install_timer();
	
	

	
	
//	printf("  ______  ___                             __    _____       ___    ___\n");
//	printf(" /\\  __ \\/\\_ \\                           /\\ \\_ /\\  __\\     /\\_ \\  /\\_ \\\n");
//	printf(" \\ \\ \\_\\ \\//\\ \\     ___   _ ___      __ /\\__  _\\_\\ \\_/   __\\//\\ \\ \\//\\ \\\n");
//	printf("  \\ \\  ___\\\\ \\ \\   / __`\\/\\`'_ `\\  /'__`\\/_/\\ \\/\\__  _\\/'__`\\\\ \\ \\  \\ \\ \\\n");
//	printf("   \\ \\ \\__/ \\_\\ \\_/\\ \\L\\ \\ \\ \\ \\ \\/\\  __/  \\ \\ \\/_/\\ \\/\\  __/ \\_\\ \\_ \\_\\ \\_\n");
//	printf("    \\ \\_\\   /\\____\\ \\___,_\\ \\_\\ \\_\\ \\____\\  \\ \\_\\ \\ \\_\\ \\____\\/\\____\\/\\____\\\n");
//	printf("     \\/_/   \\/____/\\/___/_/\\/_/\\/_/\\/____/   \\/_/  \\/_/\\/____/\\/____/\\/____/\n\n");
//	printf("                                                     (c)2003 Ben Bartle\n");
	
////////////////////////////////////////////	
/*	if (usingjoy)
	{
		printf ("using joystick...");
	}
	else
	{
		printf ("not using joystick...");
	}
	readkey();
///////////////////////////////////////////////
*/
	srand(time(NULL));
	
	set_color_depth(8);     //256 color mode
//	set_color_depth(24);
	if (set_gfx_mode(GFX_SAFE, 1024, 768, 0, 0) != 0)           //set up screen
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
		return 1;
	}
	
	
	BUFFER = create_bitmap(SCREEN_WIDTH,SCREEN_WIDTH);               //create the back buffer   remember: height is 768 and width is 1024. The height needs to be bigger to keep memory safe!!!
	clear_bitmap(BUFFER);

	BUFFER2 = create_bitmap(SCREEN_WIDTH,512);               //create the back buffer for stretch-out 

	clear_bitmap(BUFFER2);

	FBACK = create_bitmap(512,512);
	
	clear_bitmap(FBACK);
     
//	for (i=0;i<1000;i++)                                                 //stars
//		putpixel(FBACK,rand()%512,rand()%512,(rand()%4)+1);

	
	
	
	PLANET_SURFACE4 = create_bitmap(BACKGROUND_WIDTH*2,BACKGROUND_HEIGHT*2);                     //m
	
	for (i=0;i<SHIP_GRAPHIC_COUNT;i++)

	{
		for (a=0;a<MAX_FRAME_COUNT;a++)
		{
			SHIPS[i][a] = create_bitmap (32,32);                            //m
		}
	}	
	for(i=0;i<9;i++)
	{
		BIG_BOOM_BOOMS[i]=create_bitmap(64,64);
	}
	BULLET_SHOT[0] = create_bitmap (10,10);                                    //m
	BULLET_SHOT[1] = create_bitmap (10,10);                                    //m
	TARGET_ID = create_bitmap(32,32);                                           //m
	LIFE = create_bitmap(32,32);                                     //m
	SLOMO = create_bitmap(32,32);                                      //m
	DIVE = create_bitmap(32,32);                                      //m
	SHIPS_LEFT = create_bitmap(32,200);                             //m
	SHIPS_LEFT_COVER = create_bitmap(32,200);                             //m
	REPAIRING = create_bitmap(190,NUMBER_HEIGHT);
	PLANETFELL = create_bitmap(128,512);
	GAME_OVER = create_bitmap(128,512);
	LOW_SCORE = create_bitmap(152,152);
	LOW_SCORE_2 = create_bitmap(152,152);
	YOUR_NAME_PLEASE = create_bitmap(496,LETTER_HEIGHT);

	
	FOUR_SHIPS=create_bitmap(64*LEVEL_GRAPHIC_COUNT,32);
	
//	COPYRIGHT = create_bitmap(24,122);
	for (i=0;i<28;i++)
	{
		LETRAS[i]= create_bitmap(LETTER_WIDTH,LETTER_HEIGHT);
	}
	
	for (i=0;i<10;i++)
	{
		NUMBER[i] = create_bitmap(NUMBER_WIDTH,NUMBER_HEIGHT);
		HSNUMBERS[i] = create_bitmap(NUMBER_WIDTH,NUMBER_HEIGHT);
	}
	for(i=0;i<4;i++)
	{
		SCENERY[i] = create_bitmap(64,64);
	}
	for(i=4;i<12;i++)
	{
		SCENERY[i] = create_bitmap(32,32);
	}
	SCENERY[12] = create_bitmap(128,128);
	SCENERY[13] = create_bitmap(32,128);
	SCENERY[14] = create_bitmap(32,96);
	SCENERY[15] = create_bitmap(64,96);
	SCENERY[16] = create_bitmap(128,32);
	SCENERY[17] = create_bitmap(32,32);
	SCENERY[18] = create_bitmap(96,64);


	USE_KEY_BOARD = create_bitmap(177,40);
	USE_JOY_STICK = create_bitmap(177,40);
	USE_MUSIC = create_bitmap(177,40);
	USE_SOUND = create_bitmap(177,40);
	USE_NO_MUSIC = create_bitmap(177,40);
	USE_NO_SOUND = create_bitmap(177,40);
	
	TMP_SURFACE= create_bitmap(1024,1024);
	
	//Numbers

//	TMPNUM = load_bitmap(/*"c:/djgpp/mystuff/planetfell/"*/"Numbers256.bmp", THE_PALETTE);                        //Load
//	if (!TMPNUM) 
//	{
//		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
//		allegro_message("Error reading bitmap file\n");
//		return false;
//	}
//
	PLANET_SURFACE = create_bitmap(1024,1024);
//	PLANET_SURFACE = load_bitmap(/*"c:/djgpp/mystuff/planetfell/"*/"surface1.bmp", THE_PALETTE);                            //Load
//	if (!PLANET_SURFACE) 
//	{
//		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
//		allegro_message("Error reading bitmap file\n");
//		return false;
//	}
//		//Load the image of the ships
	
	
	
//	BITMAP*TMPO = create_bitmap(2225,545);
	
//	BITMAP*YEAH = load_bitmap("yeah.bmp",NULL);
	TMP = load_bitmap(/*"c:/djgpp/mystuff/planetfell/"*/"graphics.bmp", THE_PALETTE);                          //Load
//	blit(TMP,TMPO,0,0,0,0,2200,545);
	
//	blit(YEAH,TMPO,0,0,2225-177,152,YEAH->w,YEAH->h);
//	save_bitmap("output.bmp",TMPO,THE_PALETTE);
//	destroy_bitmap(YEAH);
//	destroy_bitmap(TMPO);
	
	if (!TMP) 
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Error reading bitmap file\n");
		return false;
	}

	set_palette(THE_PALETTE);     //Set the palette
	
	//blit to the planetfell graphic
	blit(TMP,PLANETFELL,1792,0,0,0,128,512);
	
	//blit to the game over graphic
	blit(TMP,GAME_OVER,1920,0,0,0,128,512);

	//blit to letters
	for (i=0;i<28;i++)
	{
		blit(TMP,LETRAS[i],i*LETTER_WIDTH,512,0,0,LETTER_WIDTH,LETTER_HEIGHT);
	}
	
	//blit to high score numbers
	for (i=0;i<10;i++)
	{
		blit(TMP,HSNUMBERS[i],i*NUMBER_WIDTH+(28*LETTER_WIDTH),512,0,0,NUMBER_WIDTH,NUMBER_HEIGHT);
	}
	blit(TMP,LOW_SCORE,2048,0,0,0,152,152);
	
	clear_bitmap(FOUR_SHIPS);
	for(i=0;i<LEVEL_GRAPHIC_COUNT;i++)
		blit(TMP,FOUR_SHIPS,192*i,0,64*i,0,32,32);
	
	blit(TMP,YOUR_NAME_PLEASE,1116,512,0,0,536,LETTER_HEIGHT);

	blit(TMP,USE_NO_SOUND,2048,152,0,0,177,40);
	blit(TMP,USE_SOUND,2048,152+40,0,0,177,40);
	blit(TMP,USE_NO_MUSIC,2048,152+80,0,0,177,40);
	blit(TMP,USE_MUSIC,2048,152+120,0,0,177,40);
	blit(TMP,USE_KEY_BOARD,2048,152+160,0,0,177,40);
	blit(TMP,USE_JOY_STICK,2048,152+200,0,0,177,40);
	
//	blit(TMP,COPYRIGHT,1920,0,0,0,24,122);	

//8888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888
	
	if (load_joystick_data("joy.dat") != 0)
	{
		if (install_joystick(JOY_TYPE_AUTODETECT) == 0)
		{
			joyinstalled=true;
		}
	}
	else
	{
		joyinstalled=true;
		joyconfigured=true;
	}
	

	
	
	/* calibration of joystick
				clear(screen);
				joyconfigured=true;
				while (joy[0].flags & JOYFLAG_CALIBRATE) 
				{
					textout_centre(screen,font,calibrate_joystick_name(0),512,128,4);
					textout_centre(screen,font,"Then press a key",512,138,4);    			
					readkey();
					if (calibrate_joystick(0) != 0) 
					{
						joyconfigured=false;
						break;
					}
				}
				if (joyconfigured)
				{
					save_joystick_data("joy.dat");
					textout_centre(screen,font,"Joystick Calibrated!",512,138,4);
				}
				else
				{
					textout_centre(screen,font,"Joystick Calibration Failed!",512,138,4);
				}
				readkey();
				
			*/


	

//8888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888888

	
	// Load flight paths
	

	for (a=0;a<FLIGHT_PATTERN_COUNT;a++)
		FPArray[a] = new FlightPattern(a);
	

	PlayerShip=new ship(0,0,0,true,PLAYER_IMAGE,false,false,3,false,true,FPArray[SMALL_FIGURE_8],SMALL_FIGURE_8,usingjoy);
	
	for (i=0;i<MAX_SHIP_COUNT;i++)
		theShips[i].hasShip=false;
	

	
	initLevels();

	bool soundable = true;
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, argv[0]) != 0) 
	{
    		soundable=false;
	}


	OpenHighScores();
	
	FILE*theFile;
	theFile=fopen("HighScores.who","r");
	
	HaveSound=getc(theFile)-'0';
	HaveMuzak=getc(theFile)-'0';
	if (joyinstalled && joyconfigured)
		usingjoy = getc(theFile)-'0';
	
	fclose(theFile);
	
	if (!soundable)
	{
		HaveMuzak=false;
		HaveSound=false;
	}

	
//	if (HaveSound)
//	{
		THE_SAMPLES[SHOOT] = load_sample("oddio/bullet.wav");
//		THE_SAMPLES[MUZAK] = load_sample("oddio/bullet.wav");
		THE_SAMPLES[BOOM] = load_sample("oddio/boom.wav");
		THE_SAMPLES[DIVE_DOWN] = load_sample("oddio/dive.wav");
		THE_SAMPLES[DIVE_UP] = load_sample("oddio/dive.wav");
		THE_SAMPLES[MISSILE] = load_sample("oddio/missile.wav");
		THE_SAMPLES[SLO_ON] = load_sample("oddio/slo.wav");
		THE_SAMPLES[SLO_OFF] = load_sample("oddio/slo.wav");
		THE_SAMPLES[REPAIR] = load_sample("oddio/repair.wav");
		THE_SAMPLES[BOOM2] = load_sample("oddio/boom2.wav");
//	}
	
//	
//	MIDI * theMuzak;
//	if (HaveMuzak)
//	{
//		theMuzak = load_midi("oddio/axelf.mid");
///	}	
//
	DUH * theDumbMuzak = dumb_load_xm("oddio/music.xm");
	AL_DUH_PLAYER *dp
	
	
	LOCK_VARIABLE (SyncFlag);
	LOCK_FUNCTION ((void *)SetSyncFlag);

	install_int(SetSyncFlag, DELAY_LENGTH);
	
	



	
	bool undone=true;
	int keyboardpause=30;
	
	//intro variables
/*	int fx = 256;
	int fy = 256;
	int fdx = 5;
	int fdy = 3;	
	int fa=0;
*/
	int Ply=4096;
	int Plv=0;
	int gravpause=128;
	bool quitpause=false;
	int GameOver=BIG_BOOM_BOOM_COUNT*CYCLES_PER_EXPLOSION_CHANGE;

/*	int cx=500;
	int cy=-128;
	int ca=128;
	int cac=1;
	int cflipcount=0;
	int cnextchange=0;     //what angle should I change at next. When flip count is a multiple of 4, increase by only 64.
	int ppy=12;
*/	////////........////////........
//	play_sample(THE_SAMPLES[MUZAK],200,128,1000,true);


	
	if (HaveMuzak)
		dp = al_start_duh(theDumbMuzak, 1, 0, 1.0f, 4096, 48000);

	//	play_midi(theMuzak, TRUE);

	for(;undone;)
	{
		
		clear_bitmap(BUFFER);
		blit(BUFFER,screen,0,0,0,0,1024,768);
		Ply=4096;
		Plv = 0;
		gravpause=128;

		//reset game/////////////////////////////////////////////////
		pLives=5;
		pDives=5;
		pointsToShow=0;
		points=0;
		shot = 0;
		hasSloMo = true;
		slomo = 1;
		changinglevel=false;
		tmpWidth=512;
		tmpHeight=512;
		growing=false;
		deathroes=0;
		
		MissKills=0;
		BullKills=0;
		Deaths=0;
		Level=0;
		ClearSprites();
		GameOver=BIG_BOOM_BOOM_COUNT*CYCLES_PER_EXPLOSION_CHANGE;

		delete PlayerShip;
		PlayerShip=new ship(0,0,0,true,PLAYER_IMAGE,false,false,3,false,true,FPArray[SMALL_FIGURE_8],SMALL_FIGURE_8,usingjoy);
		SetLevel();
		////////////////////////////////////////////////////////////
		
		
		//********************Intro Loop**************************
		for(;;)
		{
			poll_keyboard();

			if (HaveMuzak)
				al_poll_duh(dp);
			
			if (usingjoy)
				poll_joystick();
			if (keyboardpause==0)
			{
				if (key[KEY_ESC])
				{
					undone=false;
					break;
				}
				if (usingjoy)			
				{
					if (joy[0].button[0].b)
					{
						keyboardpause=30;
						break;
					}	
				}
				else
				{
					if(key[KEY_SPACE])
					{
						keyboardpause=30;
						break;
					}
				}
				if (key[KEY_J])
				{
					if (joyinstalled&&joyconfigured)
					{
						keyboardpause=30;
						usingjoy = !usingjoy;
						
					}
				}
				if (key[KEY_S])
				{
					if (soundable)
					{
						keyboardpause=30;
						HaveSound = !HaveSound;
						
					}
				}
				if (key[KEY_M])
				{
					if (soundable)
					{
						keyboardpause=30;
						HaveMuzak = !HaveMuzak;
						if (HaveMuzak)
						{
							dp = al_start_duh(theDumbMuzak, 1, 0, .9f, 4096, 48000);
						//	play_midi(theMuzak,TRUE);
						}
						else
						{
							al_stop_duh(dp);
						//	stop_midi();
						}
						
					}
				}
			}
			else
			{
				keyboardpause--;
			}

			
			//starfield
			blit(FBACK,BUFFER,0,0,(SCREEN_WIDTH/2)-256, (SCREEN_HEIGHT/2)-256,512,512);
						
			//high scores
			int so;
			
			for(so=0;so<HIGH_SCORE_COUNT;so++)
			{	
				for(i=0;i<8;i++)
				{
					if ((HighScoreTable[so].name[i] >=0)&&(HighScoreTable[so].name[i]<=26))
					{
						draw_sprite(BUFFER,LETRAS[HighScoreTable[so].name[i]],i*LETTER_WIDTH+256,so*(LETTER_HEIGHT+SPACE_BETWEEN_HIGH_SCORE_LIST)+128+SCORE_OFFSET);
					}
						
					
				}
				DrawHSNumber(HighScoreTable[so].score,so);
			}
		
			
			//planetfell fall
			if (gravpause==0)
			{
				Plv -= F_GRAVITY;
			}
			else
			{
				gravpause--;
			}
			Ply += Plv;
			if (Ply<=0)
			{
				Ply=0;
				Plv= -(( Plv*9)/10);
			}
			rectfill(BUFFER,256,512-(Ply/8),256+512,128+512,0);
			rotate_sprite(BUFFER,PLANETFELL,448,320-(Ply/8),itofix(192));
			
			
		/*	//bouncer
			fx += fdx;
			if ((fx>=480)||(fx<=0))
				fdx = -fdx;
			fy += fdy;
			if ((fy>=480)||(fy<=0))
				fdy = -fdy;
			fa++;
			fa %= 256;
			rotate_sprite(BUFFER,SHIPS[PLAYER_IMAGE][0],fx+256,fy+128,itofix(fa));
		*/
			
			//KitchenSync();
//			vsync();
			if (usingjoy)
			{
				draw_sprite(BUFFER,USE_JOY_STICK,(SCREEN_WIDTH/2)+256 - 177, (SCREEN_HEIGHT/2)+260);
			}
			else
			{
				draw_sprite(BUFFER,USE_KEY_BOARD,(SCREEN_WIDTH/2)+256 - 177, (SCREEN_HEIGHT/2)+260);
			}
			if (HaveSound)
			{
				draw_sprite(BUFFER,USE_SOUND,(SCREEN_WIDTH/2)-256 , (SCREEN_HEIGHT/2)+260);
			}
			else
			{
				draw_sprite(BUFFER,USE_NO_SOUND,(SCREEN_WIDTH/2)-256 , (SCREEN_HEIGHT/2)+260);
			}
			if (HaveMuzak)
			{
				draw_sprite(BUFFER,USE_MUSIC,(SCREEN_WIDTH/2)-115 , (SCREEN_HEIGHT/2)+260);
			}
			else
			{
				draw_sprite(BUFFER,USE_NO_MUSIC,(SCREEN_WIDTH/2)-115 , (SCREEN_HEIGHT/2)+260);
			}
			//rest(DELAY_LENGTH);
			blit(BUFFER, screen, (SCREEN_WIDTH/2)-256, (SCREEN_HEIGHT/2)-256, (SCREEN_WIDTH/2)-256, (SCREEN_HEIGHT/2)-256,512, 556); 	
		//	blit(BUFFER, screen, 0, 0, 0, 0,1024, 768); 
		}
		//********************intro loop************************
		
		clear_bitmap(BUFFER);
		blit(BUFFER,screen,0,0,0,0,SCREEN_WIDTH,SCREEN_HEIGHT);

		
		SyncFlag=0;
		//************************GameLoop******************
   		if (undone)
		{
			//Gameloop
			long tsls=RELOAD_RATE;
			long tsls2=RELOAD_RATE;
			long tsld=50;
			
			long ct=0;

			int livediveangle=0;	
			int slomocount=0;
			bool debugOn=false;/////////////Remove
			bool donotquitgameloop = true;
			for(;donotquitgameloop;)
			{
		
				if (HaveMuzak)
					al_poll_duh(dp);
				for(;SyncFlag>=slomo;ct++,tsls++,tsls2++,tsld++,livediveangle++)
				{
		
					SyncFlag-=slomo;
					PlayerShip->Move(0,0);
					for (i=0;i<MAX_SHIP_COUNT;i++)
						if (theShips[i].hasShip)
						{
							theShips[i].theShip->Move(PlayerShip->X(),PlayerShip->Y());
							if (theShips[i].theShip->Marked())
							{
								if (theShips[i].theShip==PlayerShip->Target())
									PlayerShip->Detarget();
								theShips[i].hasShip=false;
								delete theShips[i].theShip;
							
							}
						}
		 
		
		
		
					for (i=0;i<MAX_BULLET_COUNT;i++)
						if (theBullets[i].hasBullet)
						{
							theBullets[i].theBullet->Move(PlayerShip->X(),PlayerShip->Y());
							if (theBullets[i].theBullet->Marked())
							{
								theBullets[i].hasBullet=false;
								delete theBullets[i].theBullet;
							}
							
						}
				
					poll_keyboard();
					
					
				//	textprintf(BUFFER,font,0,512,2,"num: %i",joy[0].num_buttons);			
	
					if(keyboardpause==0)
					{
						if (key[KEY_ESC])
						{
						//		allegro_message("coords: [%i][%i]    Background Size: %ix%i", PlayerShip->X(),PlayerShip->Y(),BACKGROUND_WIDTH,BACKGROUND_HEIGHT);
							keyboardpause=100;
							donotquitgameloop = false;
							if (HaveSound)
								stop_sample(THE_SAMPLES[REPAIR]);
							break;
						}
						if(!deathroes)
						{
							if (usingjoy)
							{
								poll_joystick();
								int ang = -541;
								if (((joy[0].stick[0].axis[1].pos < -16)||(joy[0].stick[0].axis[1].pos > 16)) ||((joy[0].stick[0].axis[0].pos < -16)||(joy[0].stick[0].axis[0].pos > 16)))
								{
									int rf=1;
									if (shot>0)
									{
										if ((shot %128)<64)
											rf=-1;
									}				
									ang = fixtoi(fixatan2(itofix(joy[0].stick[0].axis[1].pos*rf), itofix(joy[0].stick[0].axis[0].pos*rf)));
									ang = ang - (ang %4);
				
								}

								if (ang !=-541)                              //turn
								{
									int angle1=((PlayerShip->Heading()-ang)+512)%256;
									int angle2=((ang-PlayerShip->Heading())+512)%256;
									if (angle1>angle2)
									{
										if (angle1*angle1>16)
										{
											PlayerShip->Rotate(4);
										}
										else
										{
											PlayerShip->Rotate(0);        //must "rotate" zero degrees in order to trip graphics animations
										}
									}
									else
									{
										if (angle2*angle2>16)
										{
											PlayerShip->Rotate(-4);
										}	
										else
										{
											PlayerShip->Rotate(0);
										}
									}
								}
								else
								{
									PlayerShip->Rotate(0);        //must "rotate" zero degrees in order to trip graphics animations even if the joystick is centered
								}
								if (joy[0].button[0].b)          //shoot
								{
									if ((tsls>RELOAD_RATE)&&(!PlayerShip->Dived()))
									{
										tsls=0;
										PlayerShip->Load();
									}
								}
								
								if (joy[0].button[1].b)                   //missile
								{
									if ((tsls2>RELOAD_RATE)&&(!PlayerShip->Dived())&&(PlayerShip->Targeted()))
									{
										tsls2=0;
										PlayerShip->LoadMissile();
									}
								}
								
								
								if ((joy[0].button[3].b)||(key[KEY_S]))                   //slow
								{
									if (hasSloMo)
									{
										slomo=3;
										slomocount=SLOMO_LENGTH;
										hasSloMo=false;
										if (HaveSound)
											play_sample(THE_SAMPLES[SLO_ON],255,128,1000,false);
									}
								}
								if ((joy[0].button[2].b)||(key[KEY_DOWN])||(key[KEY_D]))         //dive
								{
									if ((pDives>0)&&(tsld>16)&&(!PlayerShip->Dived()))
									{		
										tsld=0;
										pDives--;
										PlayerShip->Dive();
										if (HaveSound)
											play_sample(THE_SAMPLES[DIVE_DOWN],255,128,1000/slomo,false);
									}	
								}
								
							}	
							
							else        //keyboard
							{
								if (key[KEY_LEFT])                            //turn
								{
									PlayerShip->Rotate(-4);
								}
								
								if (key[KEY_RIGHT])
								{
									PlayerShip->Rotate(4);
								}
								
							
							
								if (key[KEY_SPACE])                               //shoot
								{
									if ((tsls>RELOAD_RATE)&&(!PlayerShip->Dived()))
									{
										tsls=0;
										
										PlayerShip->Load();
									
									}	
								}
							
	
							
								if (key[KEY_LCONTROL])                //missile
								{
									if ((tsls2>RELOAD_RATE)&&(!PlayerShip->Dived())&&(PlayerShip->Targeted()))
									{
										tsls2=0;
										
										PlayerShip->LoadMissile();
									}
									
								}
								
								if (key[KEY_S])                   //slow
								{
									if (hasSloMo)
									{
										slomo=3;
										slomocount=SLOMO_LENGTH;
										hasSloMo=false;
										if (HaveSound)
											play_sample(THE_SAMPLES[SLO_ON],255,128,1000,false);
//										adjust_sample(THE_SAMPLES[MUZAK],255,128,333,true);
									}
								}
								if ((key[KEY_DOWN])||(key[KEY_D]))         //dive
								{
									if ((pDives>0)&&(tsld>16)&&(!PlayerShip->Dived()))
									{		
										tsld=0;
										pDives--;
										PlayerShip->Dive();
										if (HaveSound)
											play_sample(THE_SAMPLES[DIVE_DOWN],255,128,1000/slomo,false);
									}	
								}
							}
							////////////////////////////////////////////////////////////////////

							if( (tsls == MINI_SHOT)||(tsls == MINI_SHOT*2))
								PlayerShip->Load();		
						
						}
				
						if ((key[KEY_B]) && (key[KEY_E]) && (key[KEY_N]) && (key[KEY_RSHIFT]) && (key[KEY_RCONTROL]))      //remove
							debugOn=true;
						if (key[KEY_F2])
							save_bitmap("out.bmp", BUFFER, THE_PALETTE);
						if (key[KEY_P])                       //pause
						{
						//	for(i=0;i<35;i++)   //pause to allow them to take there finger off the key
						//	{
							//	rest(1000);
						//	}
							for(;;)
							{
								poll_keyboard();
								if (key[KEY_O])
									break;
								if (key[KEY_ESC])
								{
									quitpause=true;
									
									break;
								}
								SyncFlag=0;
							}		

							
								
							
						}
						
						if (quitpause)
						{
							quitpause=false;
							keyboardpause=100;
							donotquitgameloop = false;
							break;
						}
						
						
						if (debugOn)                         //remove
						{
							
							if (key[KEY_L])//////////////    remove      -changes level
							{
								
								if ((tsls>RELOAD_RATE)&&(!PlayerShip->Dived()))
								{
									tsls=0;
									tmpWidth=512;
									tmpHeight=512;
									growing=false;
									Level++;
									ClearSprites();
									changinglevel=true;
								}
							
				
							}
							if (key[KEY_R])        //remove these two
							{
								slomo=3;
							}
							if (key[KEY_T])
							{
								slomo=1;
							}
						}
					}
					else
					{
						keyboardpause--;
					}
						
					if (slomocount>0)
					{
						slomocount--;
						if (slomocount==0)
						{
							slomo=1;
							if (HaveSound)
								play_sample(THE_SAMPLES[SLO_OFF],255,128,1000,false);
//							adjust_sample(THE_SAMPLES[MUZAK],255,128,1000,true);
						}
					}
		
					
			/*		if (key[KEY_B])
				{	
						if (tsls2>16)
						{
							tsls2=0;
							NewFormation(ARROW, false, false,5,tnum, 0,0,8);
							tnum++;
							if (tnum==7)
								tnum=1;
						}
			
					}
					elseif (key[KEY_A])
					{
						if (tsls2>16)
						{
							tsls2=0;
							NewFormation(ARROW, false, false,5, 5, tSide,tSector,8);
							tSector++;
							if (tSector==3)
							{
								tSector=0;
								tSide++;
								if (tSide==4)
									tSide=0;
							}
						}
					}
					else if (key[KEY_S])
					{
						if (tsls2>16)
						{
							tsls2=0;
							NewFormation(RIGHT_ECHELON, false, false, 0, 3, 0,0);
							NewFormation(LINE, false, false, 0, 3, 0,1);
							NewFormation(LEFT_ECHELON, false, false, 0, 3, 0,2);
						
						}
					}
			*/		
									
					
					if (PlayerShip->Loaded())
					{
						CreateBullet(PlayerShip->X(),PlayerShip->Y(),PlayerShip->Heading(),true,false);	
						PlayerShip->Shoot();
						if ((HaveSound)&&(tsls==0))
							play_sample(THE_SAMPLES[SHOOT],255,128,1000/slomo,false);
					}
					else if (PlayerShip->MissileLoaded())
					{
						CreateMissile(PlayerShip->X(),PlayerShip->Y(),PlayerShip->Heading(),true,PlayerShip->Target(),true);
						PlayerShip->ShootMissile();
						if (HaveSound)
							play_sample(THE_SAMPLES[MISSILE],255,128,1000/slomo,false);
					}
			
					
					//Check Collisions	
					CollisionCheck();
					if (pLives==-1)                              ///////////////////////////////////////////should be -1 ///////////////////////////////////////////////
						GameOver--;	
	
					if (GameOver==0)
					{
						donotquitgameloop = false;
						break;
					}				
					for (i=0;i<MAX_SHIP_COUNT;i++)
						if (theShips[i].hasShip)
						{
							
								
							if (theShips[i].theShip->Loaded())
							{
								CreateBullet(theShips[i].theShip->X(),theShips[i].theShip->Y(),theShips[i].theShip->Heading(),false,false);	
								theShips[i].theShip->Shoot();
							}
							else if (theShips[i].theShip->MissileLoaded())
							{
								CreateMissile(theShips[i].theShip->X(),theShips[i].theShip->Y(),theShips[i].theShip->Heading(),false,PlayerShip,false);
								theShips[i].theShip->ShootMissile();
							}
							theShips[i].theShip->AI();
							
					
							
							
						}
			
					if (shot>1)
					{
						shot--;
						PlayerShip->FPErratik();             
					}	
					else if (shot ==1)
					{
						shot = 0;
						PlayerShip->TurnTo(PlayerShip->Heading() - (PlayerShip->Heading() % 4));
						if (HaveSound)
							stop_sample(THE_SAMPLES[REPAIR]);
					}
	
	
				
		
	
	
					
					//create new ships
					if ((!changinglevel)&&(!deathroes))
					{
						if (!(ct % QUARTER_CT))
						{
							MakeStandardLevelFormation();
		
		
		
						}
						if (ct >= MAX_CT)
						{
				//			void NewFormation(int Pattern, bool Hard, bool MissileChuckers, int NumberOn, int Number,int Side, int Sector, int FP);
				
							MakeSpecialLevelFormation();
							ct=0;
		
		
						}
					}	
				
					
					int tmpLevel = (Level >= LEVEL_COUNT) ? (LEVEL_COUNT-1) : Level;
					
					int b;
					int m = tmpLevel >= 4 ? 2:1;
					for (i=0;i<m;i++)
					{
						a = rand() % MAX_SHIP_COUNT; 
						b = rand() % 150;
						if ((theShips[a].hasShip)&&(!b))
							theShips[a].theShip->SetTarget(PlayerShip);
					}
				
	
				}			
					//DRAW!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		
				blit(PLANET_SURFACE4, BUFFER, PlayerShip->X()+256, PlayerShip->Y()+256,  (SCREEN_WIDTH-DISPLAY_WIDTH)/2,  (SCREEN_HEIGHT-DISPLAY_HEIGHT)/2, 512,512); 


		

				int x,y;

	
		
				if (PlayerShip->Dived())
					rotate_sprite(BUFFER,SHIPS[PlayerShip->Image()][PlayerShip->Frame()],SCREEN_WIDTH/2 -16,  SCREEN_HEIGHT/2-16,itofix(PlayerShip->Heading()));        //Draw player
	
		
				for (i=0;i<MAX_SHIP_COUNT;i++)
					if (theShips[i].hasShip)
					{
						x=((theShips[i].theShip->X()-PlayerShip->X()+SCREEN_WIDTH/2 -16)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
						y=((theShips[i].theShip->Y()-PlayerShip->Y()+SCREEN_HEIGHT/2 -16)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
						if (theShips[i].theShip->Saucer())
						{
							//draw saucers
							rotate_sprite(BUFFER,SHIPS[theShips[i].theShip->Image()][theShips[i].theShip->Frame()],x,y,itofix(theShips[i].theShip->HardAngle()));
						}
						else
						{
							//draw non saucers
							rotate_sprite(BUFFER,SHIPS[theShips[i].theShip->Image()][theShips[i].theShip->Frame()],x,y,itofix(theShips[i].theShip->Heading()));						
						}
					}
			
		
				if (PlayerShip->Targeted())
				{
					x=((PlayerShip->Target()->X()-PlayerShip->X()+SCREEN_WIDTH/2 -16)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;         //Draw Target ID
					y=((PlayerShip->Target()->Y()-PlayerShip->Y()+SCREEN_HEIGHT/2 -16)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
					//rotate_sprite(BUFFER,TARGET_ID,x,y,itofix(PlayerShip->Target()->Heading()));
					draw_sprite(BUFFER,TARGET_ID,x,y);
				}
				
				for (i=0;i<MAX_BULLET_COUNT;i++)
					if (theBullets[i].hasBullet)
					{
						x=((theBullets[i].theBullet->X()-PlayerShip->X()+SCREEN_WIDTH/2 -5)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
						y=((theBullets[i].theBullet->Y()-PlayerShip->Y()+SCREEN_HEIGHT/2 -5)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
						draw_sprite(BUFFER,BULLET_SHOT[theBullets[i].theBullet->Color()],x,y);        //Draw bullets		
					}
	
			
				if (!PlayerShip->Dived())   //Draw player
					if (deathroes)
					{
						if (deathroes > DEATHROES_LENGTH-BIG_BOOM_BOOM_COUNT*3)
						{
							rotate_sprite(BUFFER,BIG_BOOM_BOOMS[(DEATHROES_LENGTH-deathroes)/3],SCREEN_WIDTH/2 -24,  SCREEN_HEIGHT/2-24,itofix(PlayerShip->Heading()));   	
						}
						else if (deathroes <= DEATHROES_LENGTH-BIG_BOOM_BOOM_COUNT*3)
						{
							PlayerShip->TurnTo(0);
						}
						deathroes--;
					}
					else
					{
						rotate_sprite(BUFFER,SHIPS[PlayerShip->Image()][PlayerShip->Frame()],SCREEN_WIDTH/2 -16,  SCREEN_HEIGHT/2-16,itofix(PlayerShip->Heading()));      
					}
				
	//			void rotate_scaled_sprite(BITMAP *bmp, BITMAP *sprite, int x, int y, fixed angle, fixed scale);
	
			
	
	
			
				if (points > pointsToShow)
					pointsToShow+=1;
				DrawNumber(768-((NUMBER_WIDTH+1)*8)-4,128+4,pointsToShow,8);
			

				livediveangle %= 256;
				//draw lives

				for (i=0;i<pLives;i++)
				{	
				
					rotate_sprite(BUFFER,LIFE,256+(40+(i*36)),128+4,itofix(livediveangle *  ((i % 2) ? -1:1)));
				}
			
				//draw dives
				for (i=0;i<pDives;i++)
				{
					rotate_sprite(BUFFER,DIVE,256+4,128+(40+(i*36)),itofix(-livediveangle *  ((i % 2) ?  -1:1)));
				}
				// draw slomo
				if (hasSloMo)
				{
					draw_sprite(BUFFER,SLOMO,256+4,128+4);
				}
				else if (slomo==3)
				{
					rotate_scaled_sprite(BUFFER, SLOMO, 256+4, 128+4,itofix(0), fixdiv(itofix(slomocount),itofix(SLOMO_LENGTH)));
					//stretch_sprite(BUFFER, SLOMO, 256+4, 128+4, (32*slomocount)/SLOMO_LENGTH, (32*slomocount)/SLOMO_LENGTH);
				}
	
	
				if (shot>0)
					draw_sprite(BUFFER,REPAIRING,256+512-194-40,128+512-36);
				
				DrawNumber(256+4,512+128-40,Level+1,2);
			
	     //draws the individual step count
	//			DrawNumber(512,128+4,ct,3); 




				//void masked_blit(BITMAP *source, BITMAP *dest, int source_x, int source_y, int dest_x, int dest_y, int width, int height);
			
				if (BullKills<LEVEL_CHANGE)
					masked_blit(SHIPS_LEFT,BUFFER,0,BullKills*4,512 + 256 - 4 - 32, (512 + 128 - 4 - 200) + (BullKills*4),32,(LEVEL_CHANGE-BullKills)*4);
					
				draw_sprite(BUFFER,SHIPS_LEFT_COVER ,512 + 256 - 4 - 32 , 512 + 128 - 4 - 200 );
			


			
				//copy the buffer to the screen
				for (i=0; i<slomo;i++)
				{
					//KitchenSync();
					//vsync();
				//	rest(DELAY_LENGTH*slomo);
				}	

				if (changinglevel)
				{
					if (growing)
					{
						tmpWidth-=LEVEL_CHANGE_STEP;
						tmpHeight+=LEVEL_CHANGE_STEP;
					}
					else
					{
						tmpWidth+=LEVEL_CHANGE_STEP;
						tmpHeight-=LEVEL_CHANGE_STEP;
					}
					
					if (tmpHeight==0)
					{
						growing=true;
						SetLevel();	
					}
					else if (tmpHeight==512)
					{
						changinglevel=false;
					}
				
					clear_bitmap(BUFFER2);
					stretch_blit(BUFFER, BUFFER2, (SCREEN_WIDTH/2)-256, (SCREEN_HEIGHT/2)-256, DISPLAY_WIDTH, DISPLAY_HEIGHT, (SCREEN_WIDTH/2)-(tmpWidth/2), 256-(tmpHeight/2), tmpWidth, tmpHeight);
					blit(BUFFER2, screen, 0, 0, 0, (768-512)/2,1024, 512);
	
				}
				else
				{
					if (debugOn)
					{
					//	textprintf(BUFFER, font, 20, 512, 4, "ZCC: %i              ", PlayerShip->ZeroChangeCount);
						blit(BUFFER, screen, 0, 0, 0, 0,1024, 768); 
					}
					else
					{
						blit(BUFFER, screen, (SCREEN_WIDTH/2)-256, (SCREEN_HEIGHT/2)-256, (SCREEN_WIDTH/2)-256, (SCREEN_HEIGHT/2)-256,512, 512); 
					}
				}
				//end draw
			}
		}
		//*******************GameLoop***********************	 
	

		
		//*******************Game Over Screen**************
		if ((undone)&&(GameOver==0))
		{
			for(i=0;i<(512/GAME_OVER_FALL_ROW_HEIGHT);i++)
			{
				if (HaveMuzak)
					al_poll_duh(dp);
				rectfill(BUFFER,256,i*GAME_OVER_FALL_ROW_HEIGHT+128,512+256,(i+1)*GAME_OVER_FALL_ROW_HEIGHT+128,0);
				rotate_sprite(BUFFER,GAME_OVER,256+256-64,128,itofix(192));	
				//KitchenSync();
				blit(BUFFER, screen, (SCREEN_WIDTH/2)-256, (SCREEN_HEIGHT/2)-256, (SCREEN_WIDTH/2)-256, (SCREEN_HEIGHT/2)-256,512, 512); 
			}
		}
		//*******************Game Over Screen**************
		
		
		
		
		//******************High Score Screen**************
		if ((undone)&&(GameOver==0))
		{
			int so=0;
			bool goodtogo=false;
			for (so=0;so<8;so++)
			{
				if (points>HighScoreTable[so].score)
				{
					for (i=6;i>=so;i--)
					{
						HighScoreTable[i+1].score=HighScoreTable[i].score;
						for(a=0;a<8;a++)
						{
							HighScoreTable[i+1].name[a]=HighScoreTable[i].name[a];
						}
					}
					
					HighScoreTable[so].score=points;
					for(i=0;i<8;i++)
					{
						HighScoreTable[so].name[i]=-1;
					}	
					
					goodtogo=true;
					break;
				}

			}
			if (goodtogo)
			{
				int LetterOn=0;			
				clear_bitmap(BUFFER);
				int p=0;
				int spot=0;
				
				int fpos=0;
				int hsa=0;
				int w=152;
				int dir = 2;
				SyncFlag = 0;
				bool donotstop = true;
				for(;donotstop;)
				{
					
					
				
					while(SyncFlag > 0)
					{
						SyncFlag--;
						rect(BUFFER,(LetterOn%7)*40+256,(LetterOn/7)*40+128,(LetterOn%7)*40+256+36,(LetterOn/7)*40+128+36,0);
						poll_keyboard();
						if (HaveMuzak)
							al_poll_duh(dp);

						//if (key[KEY_U])
						//	break;
						if (p==0)
						{
							if (usingjoy)                  //joystick//////////-----------/;--///////////-/-/-/-/-/-;///roe8twsiu bhrpoiew7fy5-<F7>
							{
								poll_joystick();
								if (joy[0].stick[0].axis[1].pos < -16)
								{
									if ((LetterOn-7)>=0)
										LetterOn-=7;
									p=15;
								}
								else if (joy[0].stick[0].axis[1].pos > 16)
								{
									if ((LetterOn+7)<=27)
										LetterOn+=7;
										p=15;
								}
								else if (joy[0].stick[0].axis[0].pos < -16)
								{
									if (LetterOn>0)
										LetterOn--;
									p=15;
								}
								else if (joy[0].stick[0].axis[0].pos > 16)
								{
									if (LetterOn<27)
										LetterOn++;
									p=15;
								}
								else if (joy[0].button[0].b)
								{
									p=20;
									if (LetterOn<26)
									{
										if (spot<8)
										{
											HighScoreTable[so].name[spot]= LetterOn;
											spot++;
										}
									}
									else if (LetterOn==26)
									{
										if (spot>0)
											spot--;
										HighScoreTable[so].name[spot]=-1;
									
									}
									else if (LetterOn==27)
									{
										keyboardpause=30;
										donotstop=false;
										break;
									}
	
								}
							}
							else
							{
								if (key[KEY_UP])
								{
									if ((LetterOn-7)>=0)
										LetterOn-=7;
									p=15;
								}
								else if (key[KEY_DOWN])
								{
									if ((LetterOn+7)<=27)
										LetterOn+=7;
										p=15;
								}
								else if (key[KEY_LEFT])
								{
									if (LetterOn>0)
										LetterOn--;
									p=15;
								}
								else if (key[KEY_RIGHT])
								{
									if (LetterOn<27)
										LetterOn++;
									p=15;
								}
								else if (key[KEY_SPACE])
								{
									p=20;
									if (LetterOn<26)
									{
										if (spot<8)
										{
											HighScoreTable[so].name[spot]= LetterOn;
											spot++;
										}
									}
									else if (LetterOn==26)
									{
										if (spot>0)
											spot--;
										HighScoreTable[so].name[spot]=-1;
									
									}
									else if (LetterOn==27)
									{
										keyboardpause=30;
										donotstop=false;
										break;
									}
	
								}
							}
	
						}
						else
						{
							p--;
						}
					}
					
				
					//Draw Letters
					for(i=0;i<28;i++)
						draw_sprite(BUFFER, LETRAS[i],(i%7)*40+256+1,(i/7)*40+128+1);
					rect(BUFFER,(LetterOn%7)*40+256,(LetterOn/7)*40+128,(LetterOn%7)*40+256+36,(LetterOn/7)*40+128+36,4);	
					int x;
					int y = 6 * (LETTER_HEIGHT +SPACE_BETWEEN_HIGH_SCORE_LIST)+128+SCORE_OFFSET ;
					//Draw High Score
					
				
				
					for(i=0;i<8;i++)
					{
						rectfill(BUFFER,i*LETTER_WIDTH+256,y,(i+1)*LETTER_WIDTH+256,y+LETTER_WIDTH,0);
						if ((HighScoreTable[so].name[i] >=0)&&(HighScoreTable[so].name[i]<=26))
						{
							draw_sprite(BUFFER,LETRAS[HighScoreTable[so].name[i]],i*LETTER_WIDTH+256+1,y);
						}
					}
					DrawHSNumber(points , 6);
					
					
					//flyers
					fpos++;
					fpos%=(LEVEL_GRAPHIC_COUNT*64);
						
						
					
					//fpos%=32;
					for (i=0;i<3;i++)
					{
						x=(fpos-(LEVEL_GRAPHIC_COUNT*64))+((LEVEL_GRAPHIC_COUNT*64)*i)+256;
						y=240+128;
						rectfill(BUFFER,x,y,x+(LEVEL_GRAPHIC_COUNT*64),y+32,0);
						draw_sprite(BUFFER,FOUR_SHIPS,x,y  );
					
						x=(-fpos)+((LEVEL_GRAPHIC_COUNT*64)*i)+256;
						y=310+128;
						rectfill(BUFFER,x,y,x+(LEVEL_GRAPHIC_COUNT*64),y+32,0);
						rotate_sprite(BUFFER,FOUR_SHIPS,x,y,itofix(128) );
					}
					
					
					w-=dir;
					if ((w<=4)||(w>=152))
						dir*=-1;
					hsa++;
					hsa%=256;
					
					if ((dir<0)||(!COOL_ANIMATION))
						rectfill(BUFFER,256+512-232,128,256+512,128+232,0);
						
					clear_bitmap(LOW_SCORE_2);
					
					stretch_sprite(LOW_SCORE_2, LOW_SCORE, (152-w)/2, (152-w)/2, w, w);
					
					rotate_sprite(BUFFER,LOW_SCORE_2,256+512-152-32,128+32,itofix(hsa));
					
					draw_sprite(BUFFER,YOUR_NAME_PLEASE,512-248,512);
					
					//KitchenSync();     //KitchenSync may not be needed, but might as well
					blit(BUFFER, screen, (SCREEN_WIDTH/2)-256, (SCREEN_HEIGHT/2)-256, (SCREEN_WIDTH/2)-256, (SCREEN_HEIGHT/2)-256,512, 512); 
				}
				SaveHighScores();
			}
		}
		//*******************High Score Screen**************
		
	}
	

//	destroy_midi(theMuzak);
//
	SaveHighScores();

	if (HaveMuzak)
		al_stop_duh(dp);

	unload_duh(theDumbMuzak);
		destroy_sample(THE_SAMPLES[SHOOT]);
	//	destroy_sample(THE_SAMPLES[MUZAK]);
		destroy_sample(THE_SAMPLES[BOOM]);
		destroy_sample(THE_SAMPLES[DIVE_DOWN]);
		destroy_sample(THE_SAMPLES[DIVE_UP]);
		destroy_sample(THE_SAMPLES[MISSILE]);
		destroy_sample(THE_SAMPLES[SLO_ON]);
		destroy_sample(THE_SAMPLES[SLO_OFF]);
		destroy_sample(THE_SAMPLES[REPAIR]);
		destroy_sample(THE_SAMPLES[BOOM2]);
	
	
	
	
	for (i=0;i<SHIP_GRAPHIC_COUNT;i++)
		for (a=0;a<MAX_FRAME_COUNT;a++)		
			destroy_bitmap(SHIPS[i][a]);
	for(i=0;i<9;i++)
	{
		destroy_bitmap(BIG_BOOM_BOOMS[i]);
	}
	for (i=0;i<19;i++)
	{
		destroy_bitmap(SCENERY[i]);
	}
	for (i=0;i<28;i++)
	{
		destroy_bitmap(LETRAS[i]);
	}
	for (i=0;i<10;i++)
	{
		destroy_bitmap(NUMBER[i]);
		destroy_bitmap(HSNUMBERS[i]);
	}

	destroy_bitmap(FOUR_SHIPS);
	
	destroy_bitmap(PLANET_SURFACE);
	destroy_bitmap(BUFFER);
	destroy_bitmap(PLANET_SURFACE4);
	destroy_bitmap(BULLET_SHOT[0]);
	destroy_bitmap(BULLET_SHOT[1]);
	destroy_bitmap(TARGET_ID);
	destroy_bitmap(LIFE);
	destroy_bitmap(DIVE);
	destroy_bitmap(SLOMO);
	destroy_bitmap(REPAIRING);
	destroy_bitmap(BUFFER2);
	destroy_bitmap(SHIPS_LEFT);
	destroy_bitmap(SHIPS_LEFT_COVER);
	destroy_bitmap (TMP);
	destroy_bitmap (TMP_SURFACE);
	destroy_bitmap (FBACK);
	destroy_bitmap (PLANETFELL);
	destroy_bitmap(GAME_OVER);
	destroy_bitmap(LOW_SCORE);
	destroy_bitmap(LOW_SCORE_2);
	destroy_bitmap(YOUR_NAME_PLEASE);
//	destroy_bitmap (COPYRIGHT);
	destroy_bitmap(USE_KEY_BOARD);
	destroy_bitmap(USE_JOY_STICK);
	destroy_bitmap(USE_MUSIC);
	destroy_bitmap(USE_SOUND);
	destroy_bitmap(USE_NO_MUSIC);
	destroy_bitmap(USE_NO_SOUND);
	
	for (i=0;i<MAX_SHIP_COUNT;i++)
		if (theShips[i].hasShip)
			delete theShips[i].theShip;
	for (i=0;i<MAX_BULLET_COUNT;i++)
		if (theBullets[i].hasBullet)
			delete theBullets[i].theBullet;
	for (a=0;a<FLIGHT_PATTERN_COUNT;a++)
		delete FPArray[a];
	
	delete PlayerShip;
		
	if (HaveSound)
		for(i=0;i<SAMPLE_COUNT;i++)
			destroy_sample(THE_SAMPLES[i]);
	
	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
//	printf("Ships you shot down with bullets: %i\n",BullKills + (LEVEL_CHANGE * Level));
//	printf("Ships you shot down with missiles: %i\n",MissKills);
//	printf("Times you died: %i\n",Deaths);
//	printf("PLANETFELL (c)2003 Ben Bartle\n\n");
//	
//	printf("Much thanks to everyone involved with Allegro!!!\n\n");



	allegro_exit() ;
	return 0;
}

END_OF_MAIN();

void NewFormation(int Pattern, bool Hard, bool MissileChuckers, int NumberOn, int Number,int Side, int Sector,  int FP, int imType, int spd)
{
	int i;
	XYCOORD places[6];
	int directions[6];
	bool on[6];
	int a;

	if (Number>6)
		Number=6;
	if (NumberOn>Number)
		NumberOn=Number;
//	if (Pattern == ARROW)  //must be odd
//		Number-= (Number%2) ? 0:1;

	XYCOORD ALP;
	for (i=0;i<Number;i++)
	{

		
		//Line
		if (Pattern !=ARROW)
		{
			a=i-((Number-(Number%2))/2);	
			a*=48;
			a+= (((Sector+1)*512)/4);
			places[i].x=PlayerShip->X();
			places[i].y=PlayerShip->Y();
			switch (Side)
			{
				case 0:
					places[i].x+=275;
					places[i].y+=a-256;
					directions[i]=128;
					break;
				case 1:
					places[i].x+=a-256;
					places[i].y-=275;
					directions[i]=64;
					break;
				case 2:
					places[i].x-=275;
					places[i].y+=a-256;
					directions[i]=0;
					break;	
				case 3:
					places[i].x+=a-256;
					places[i].y+=275;
					directions[i]=192;
					break;
			}
		}
		else
		{
			if (i==0)
			{
			ALP.x=PlayerShip->X();
			ALP.y=PlayerShip->Y();
			}
		}
		
		
		switch (Pattern)
		{
			case LEFT_ECHELON:
				switch (Side)
				{
					case 0:
						places[i].x+=(48*i);
						break;
					case 1:
						places[i].y-=(48*i);
						break;
					case 2:
						places[i].x+=(48*i)-(48*(Number-1));
						break;
					case 3:
						places[i].y-=(48*i)-(48*(Number-1));
						break;
				}
				break;
			case RIGHT_ECHELON:
				switch (Side)
				{
					case 0:
						places[i].x-=(48*i)-(48*(Number-1));	
						break;
					case 1:
						places[i].y+=(48*i)-(48*(Number-1));		
						break;
					case 2:
						places[i].x-=(48*i);
						break;
					case 3:
						places[i].y+=(48*i);
						break;
				}
				break;
			case ARROW:
				
				switch (Side)
				{
					case 0:
						if (i==0)
						{
							ALP.x+=275;
						}
						else
						{
							if ((i%2)==1)   //odd
							{
								ALP.x+=48;
								ALP.y-=(i*48);				
							}
							else      //even
							{
								ALP.y+=(i*48);
								
							}
						}
						places[i].x=ALP.x;
						places[i].y=ALP.y-256+(((Sector+1)*512)/4);						
						directions[i]=128;
						break;
					case 1:
						if (i==0)
						{
							ALP.y-=275;
						}
						else
						{
							if ((i%2)==1)   //odd
							{
								ALP.y-=48;
								ALP.x+=(i*48);				
							}
							else      //even
							{
								ALP.x-=(i*48);
								
							}
						}
						places[i].x=ALP.x-256+(((Sector+1)*512)/4);
						places[i].y=ALP.y;						
						directions[i]=128;
						break;
					case 2:
						if (i==0)
						{
							ALP.x-=275;
						}
						else
						{
							if ((i%2)==1)   //odd
							{
								ALP.x-=48;
								ALP.y-=(i*48);				
							}
							else      //even
							{
								ALP.y+=(i*48);
								
							}
						}
						places[i].x=ALP.x;
						places[i].y=ALP.y-256+(((Sector+1)*512)/4);						
						directions[i]=0;
						break;
					case 3:
						if (i==0)
						{
							ALP.y+=275;
						}
						else
						{
							if ((i%2)==1)   //odd
							{
								ALP.y+=48;
								ALP.x+=(i*48);				
							}
							else      //even
							{
								ALP.x-=(i*48);
								
							}
						}
						places[i].x=ALP.x-256+(((Sector+1)*512)/4);
						places[i].y=ALP.y;						
						directions[i]=128;
						break;
				}
				break;
			case LINE:
			/*	a=i-((Number-(Number%2))/2);	
				a*=48;
				a+= (((Sector+1)*512)/4);
				places[i].x=PlayerShip->X();
				places[i].y=PlayerShip->Y();
				switch (Side)
				{
					case 0:
						places[i].x+=275;
						places[i].y+=a-256;
						directions[i]=128;
						break;
					case 1:
						places[i].x+=a-256;
						places[i].y-=275;
						directions[i]=64;
						break;
					case 2:
						places[i].x-=275;
						places[i].y+=a-256;
						directions[i]=0;
						break;
					case 3:
						places[i].x+=a-256;
						places[i].y+=275;
						directions[i]=192;
						break;


				}*/
				break;
		}

		places[i].x=(places[i].x+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
		places[i].y=(places[i].y+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
		on[i]=false;
	}
	int t;
	for (i=0;i<NumberOn;i++)
	{
		do
		{
			t=rand()%Number;
		}while (on[t]); 		
		on[t]=true;
		
	}
	
	for (i=0;i<Number;i++)
	{
		t=CreateShip(places[i].x,places[i].y,directions[i],false,imType,Hard,false,3,MissileChuckers,false, FP);
		if (on[i])
		{
			theShips[t].theShip->SetTarget(PlayerShip);
	
		}


	}
	
	
	
}
int CreateShip(int elx,int ely,int d, bool explodes, int imType,bool invince, bool Kami, int spd,bool Miss,bool PlS,int FP)
{
	int made=-1;
	int i;
	for (i=0;i<MAX_SHIP_COUNT;i++)
	{
		if (!theShips[i].hasShip)
		{
			theShips[i].hasShip=true;
			theShips[i].theShip=new ship(elx, ely, d,  explodes,  imType, invince,  Kami,  spd, Miss, PlS,FPArray[FP],FP,usingjoy);
			
			
			made=i;
			break;
		}

	}
	return made;
}
void CollisionCheck()
{
	int i,a;
	int deltax1;
	int deltay1;
	int deltax2;
	int deltay2;
			
	int dx;
	int dy;
	int x;
	int y;
	int px=PlayerShip->X();
	int py=PlayerShip->Y();
	bool killed = false;

	if (!PlayerShip->Dived())
		for(i=0;i<MAX_SHIP_COUNT;i++)                 //Non-Player-Shot AI ship and Player
			if (theShips[i].hasShip)
				if ((!theShips[i].theShip->PlayerShot())&&(!theShips[i].theShip->Exploding()))
				{	
					x=theShips[i].theShip->X();
					y=theShips[i].theShip->Y();
				
					deltax1 = ((x-px)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
					deltay1 = ((y-py)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
					deltax2 = ((px-x)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
					deltay2 = ((py-y)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
				
					dx = (deltax1>deltax2) ? deltax2:deltax1 ;
					dy = (deltay1>deltay2) ? deltay2:deltay1 ;	

			
					if ((dx<=SHIP_TO_SHIP_THRESHOLD)&&(dy<=SHIP_TO_SHIP_THRESHOLD))
						if ((sqrt((dx*dx)+(dy*dy)))<=SHIP_TO_SHIP_THRESHOLD)
						{
							//PlayerExplode
							if (HaveSound)
								play_sample(THE_SAMPLES[BOOM],255,128,1000/slomo,false);
							Deaths++;
							killed=true;
							deathroes=DEATHROES_LENGTH;
						
							if (theShips[i].theShip==PlayerShip->Target())
								PlayerShip->Detarget();
							theShips[i].hasShip=false;
							delete theShips[i].theShip;
							//theShips[i].theShip->Explode();
						}
				}
	
	


	for(i=0;i<MAX_SHIP_COUNT;i++)                 //Non-Player-Shot AI ship and Player Shot AI Ship
		for (a=0;a<MAX_SHIP_COUNT;a++)
			if ((theShips[i].hasShip)&&(theShips[a].hasShip)&&(a!=i))
				if ((!theShips[i].theShip->PlayerShot())&&(theShips[i].theShip==theShips[a].theShip->Target()))
				{	
					x=theShips[i].theShip->X();
					y=theShips[i].theShip->Y();
					px=theShips[a].theShip->X();
					py=theShips[a].theShip->Y();
					
					deltax1 = ((x-px)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
					deltay1 = ((y-py)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
					deltax2 = ((px-x)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
					deltay2 = ((py-y)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
			
					dx = (deltax1>deltax2) ? deltax2:deltax1 ;
					dy = (deltay1>deltay2) ? deltay2:deltay1 ;	

				
					if ((dx<=SHIP_TO_SHIP_THRESHOLD)&&(dy<=SHIP_TO_SHIP_THRESHOLD))
						if (theShips[a].theShip->PlayerShot())
							if ((sqrt((dx*dx)+(dy*dy)))<=SHIP_TO_SHIP_THRESHOLD)
							{
								if (!theShips[i].theShip->Exploding())
								{
									MissKills++;
									if (HaveSound)
										play_sample(THE_SAMPLES[BOOM2],255,128,1000/slomo,false);
									if (theShips[i].theShip->MissileChucker())
									{
										if (pLives < 6)
											pLives++;
										points+=POINTS_FOR_MISSILE_CHUCKER;//
									}
									else
									{
										if (pDives < 6)
											pDives++;
										
										points+=POINTS_FOR_HARD_SHOOTER;//
									}
									
									if (BullKills >= LEVEL_CHANGE)
									{
										BullKills = 0;
										tmpWidth=512;
										tmpHeight=512;
										growing=false;
										ClearSprites();
											
										Level++;
										
										
										changinglevel=true;
										
									}
										
								}
								theShips[a].theShip->Explode();
								theShips[i].theShip->Explode();
							}
				}

	if (!PlayerShip->Dived())
		for(a=0;a<MAX_BULLET_COUNT;a++)        //Non-Player-Shot Bullet and Player
			if (theBullets[a].hasBullet)
				if (!theBullets[a].theBullet->PlayerShot())
				{
					x=theBullets[a].theBullet->X();
					y=theBullets[a].theBullet->Y();
					px=PlayerShip->X();
					py=PlayerShip->Y();
				
					deltax1 = ((x-px)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
					deltay1 = ((y-py)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
					deltax2 = ((px-x)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
					deltay2 = ((py-y)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
		
					dx = (deltax1>deltax2) ? deltax2:deltax1 ;
					dy = (deltay1>deltay2) ? deltay2:deltay1 ;	
					
					if ((dx<=BULLET_TO_SHIP_THRESHOLD)&&(dy<=BULLET_TO_SHIP_THRESHOLD))
						if ((sqrt((dx*dx)+(dy*dy)))<=BULLET_TO_SHIP_THRESHOLD)
						{
							if (shot>0)
							{
								//kill player
								Deaths++;
								if (HaveSound)
									play_sample(THE_SAMPLES[BOOM],255,128,1000/slomo,false);
								killed=true;
								
								deathroes=DEATHROES_LENGTH;
							}
							else
							{
								shot = REPAIR_TIME;
								if (HaveSound)
									play_sample(THE_SAMPLES[REPAIR],255,128,1000,true);
							}
							theBullets[a].hasBullet=false;
							delete theBullets[a].theBullet;
						}
				}


	for(a=0;a<MAX_BULLET_COUNT;a++) //Player-Shot Bullet and Non-Player-Shot Ship
		for (i=0;i<MAX_SHIP_COUNT;i++)
			if ((theBullets[a].hasBullet)&&(theShips[i].hasShip))
				if ((theBullets[a].theBullet->PlayerShot())&&(!theShips[i].theShip->PlayerShot())&&(!theShips[i].theShip->Exploding()))
				{
					x=theBullets[a].theBullet->X();
					y=theBullets[a].theBullet->Y();
					px=theShips[i].theShip->X();
					py=theShips[i].theShip->Y();
					

					
					deltax1 = ((x-px)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
					deltay1 = ((y-py)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
					deltax2 = ((px-x)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
					deltay2 = ((py-y)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
		
					dx = (deltax1>deltax2) ? deltax2:deltax1 ;
					dy = (deltay1>deltay2) ? deltay2:deltay1 ;	
				
					if ((dx<=BULLET_TO_SHIP_THRESHOLD)&&(dy<=BULLET_TO_SHIP_THRESHOLD))
						if ((sqrt((dx*dx)+(dy*dy)))<=BULLET_TO_SHIP_THRESHOLD)
						{
							if (theShips[i].theShip->Immune())
							{
								PlayerShip->SetTarget(theShips[i].theShip);
							}
							else
							{
								theShips[i].theShip->Explode();	
								if (HaveSound)
									play_sample(THE_SAMPLES[BOOM2],255,128,1000/slomo,false);
							}

							BullKills++;
							

							
							points+=POINTS_FOR_SHOOTER;//
							
							theBullets[a].hasBullet=false;
							delete theBullets[a].theBullet;

							if ((BullKills >= LEVEL_CHANGE)&&(Level==0))
							{
								BullKills = 0;
				
								
									
									tmpWidth=512;
									tmpHeight=512;
									growing=false;
									ClearSprites();
									
									Level++;
									changinglevel=true;
								
								
							}
						}
			}	
			
	
	if (killed)
	{
		for (i=0;i<MAX_SHIP_COUNT;i++)
			if (theShips[i].hasShip)
			{
				delete theShips[i].theShip;
				theShips[i].hasShip=false;
			}
		for (i=0;i<MAX_BULLET_COUNT;i++)
			if (theBullets[i].hasBullet)
			{
				delete theBullets[i].theBullet;
				theBullets[i].hasBullet = false;
			}
		PlayerShip->Detarget();
		pLives--;
		if ((shot>0)&&(HaveSound))
			stop_sample(THE_SAMPLES[REPAIR]);
		shot = 0;
	}
}


bool CreateBullet(int SourceX, int SourceY, int SourceHeading,bool ps,bool triple)
{
	
	
	
	int i;
	bool made=false;
	int a=0;
	int max=1;
	if (triple) 
		max=3;
	int it=20;
	for(a=0;a<max;a++)
	{
		for (i=0;i<MAX_BULLET_COUNT;i++)
		{
			if (!theBullets[i].hasBullet)
			{
				if (a==1)
				{
					it=5;
				}
				else if (a==2)
				{
					it = -10;
				}
				fixed tmpx= itofix(SourceX);
				fixed tmpy= itofix(SourceY);
				tmpx += it*fixcos(itofix(SourceHeading));
				tmpy += it*fixsin(itofix(SourceHeading));
				if (tmpx >= BACKGROUND_WIDTH)
				{
					tmpx -= itofix(BACKGROUND_WIDTH) ;
				}
				else if (tmpx < 0)
				{
					tmpx += itofix(BACKGROUND_WIDTH) ;
				}
				if (tmpy >= BACKGROUND_HEIGHT)
				{
					tmpy -= itofix(BACKGROUND_HEIGHT) ;
				}
				else if (tmpy < 0)
				{
					tmpy += itofix(BACKGROUND_HEIGHT );
				}
				made=true;
				theBullets[i].hasBullet=true;
				theBullets[i].theBullet=new bullet(tmpx,tmpy,SourceHeading,ps);
				break;
			}
		}		
	}
	return made;
}

bool CreateMissile(int SourceX, int SourceY, int SourceHeading,bool imm, ship * targ, bool ps)
{
	int i;
	bool made=false;
	for (i=0;i<MAX_SHIP_COUNT;i++)
	{
		if (!theShips[i].hasShip)
		{
			fixed tmpx= itofix(SourceX);
			fixed tmpy= itofix(SourceY);
			tmpx += 36*fixcos(itofix(SourceHeading));
			tmpy += 36*fixsin(itofix(SourceHeading));
			if (tmpx >= BACKGROUND_WIDTH)
			{
				tmpx -= itofix(BACKGROUND_WIDTH) ;
			}
			else if (tmpx < 0)
			{
				tmpx += itofix(BACKGROUND_WIDTH) ;
			}
			if (tmpy >= BACKGROUND_HEIGHT)
			{
				tmpy -= itofix(BACKGROUND_HEIGHT) ;
			}
			else if (tmpy < 0)
			{
				tmpy += itofix(BACKGROUND_HEIGHT );
			}
			made=true;
			theShips[i].hasShip=true;
			theShips[i].theShip=new ship(fixtoi(tmpx),fixtoi(tmpy),SourceHeading, true, MISSILE_IMAGE,imm,true,MISSILE_SPEED,false,ps,FPArray[NO_TURN],NO_TURN,usingjoy);
			if (targ!=NULL)
				theShips[i].theShip->SetTarget(targ);
			break;
		}
			
	}
	return made;
}

void ClearSprites()
{
	int i;
	
	
	
	PlayerShip->Detarget();

		for (i=0;i<MAX_SHIP_COUNT;i++)
			if (theShips[i].hasShip)
			{
						
				
					delete theShips[i].theShip;
					theShips[i].hasShip=false;
				
			}
	
		for (i=0;i<MAX_BULLET_COUNT;i++)
			if (theBullets[i].hasBullet)
			{
				delete theBullets[i].theBullet;	
				theBullets[i].hasBullet = false;
			}
}
void GeneratePlanetSurface(int WhichRock, int sCount)
{

	int i,a;
	int tx;
	int ty;
	int tt;
	
	if(WhichRock<LEVEL_GRAPHIC_COUNT)
	{
	
		for(i=0;i<4;i++)
		{
			blit(TMP,SCENERY[i],768+WhichRock*256+i*64,256,0,0,64,64); 
		}
		for(i=0;i<8;i++)
		{
			blit(TMP,SCENERY[i+4],768+WhichRock*256+i*32,320,0,0,32,32) ;
		}	

		blit(TMP,SCENERY[12],768+WhichRock*256,352,0,0,128,128);
		blit(TMP,SCENERY[13],896+WhichRock*256,352,0,0,32,128);
		blit(TMP,SCENERY[14],928+WhichRock*256,352,0,0,32,96);
		blit(TMP,SCENERY[15],960+WhichRock*256,352,0,0,64,96);
		blit(TMP,SCENERY[16],768+WhichRock*256,480,0,0,128,32);
		blit(TMP,SCENERY[17],896+WhichRock*256,480,0,0,32,32);
		blit(TMP,SCENERY[18],928+WhichRock*256,448,0,0,96,64);

	
		for(i=0;i<4;i++)
			for(a=0;a<4;a++)
				blit(TMP,PLANET_SURFACE,768+256*WhichRock,0,i*256,a*256,256,256);	

		clear_bitmap(TMP_SURFACE);
	

		for(i=0;i<sCount;i++)    //create sCount scenery objects
		{
			tt= rand() % 19	;
			do
			{	
				tx= rand() % 1024 ;
				ty= rand() % 1024 ;
			}
			while (!CheckCorners(tx,ty,SCENERY[tt]->w,SCENERY[tt]->h));
			
			
			if ((tt>12)&&(tt!=17))    //non-square
			{
				rotate_sprite(PLANET_SURFACE,SCENERY[tt],tx,ty, itofix((rand()%2)*128));
			}
			else      //square
			{
				rotate_sprite(PLANET_SURFACE,SCENERY[tt],tx,ty, itofix((rand()%4)*64));
			}
			rectfill(TMP_SURFACE, tx, ty, tx+SCENERY[tt]->w,ty+SCENERY[tt]->h , 1);
	
		}
	}
	else if (WhichRock==LEVEL_GRAPHIC_COUNT)    //Space
	{
		clear_bitmap(PLANET_SURFACE);
		for (i=0;i<sCount;i++)
			for(a=0;a<sCount;a++)
				putpixel(PLANET_SURFACE,rand()%1024,rand()%1024,(rand()%4)+1);

	}
	else		//The "Me" Level
	{
		blit(TMP,SCENERY[4],896,480,0,0,32,32);
		blit(TMP,SCENERY[5],896+256,480,0,0,32,32);
		blit(TMP,SCENERY[6],896+512,480,0,0,32,32);
		blit(TMP,SCENERY[7],896+768,480,0,0,32,32);
				
		for(i=0;i<4;i++)
			for(a=0;a<4;a++)
				blit(TMP,PLANET_SURFACE,768,0,i*256,a*256,256,256);

		BigChunkOCode();
	}
}
bool CheckCorners(int x,int y, int w, int h)
{
	int tmp=true;
	
	int i;
	int a;
	for (i=0;i<=w/32;i++)
		for(a=0;a<=h/32;a++)
		{
			if  (getpixel(TMP_SURFACE,x+i*32,y+a*32)!=0)		
				tmp=false;
			
		}
	
//	return ((getpixel(TMP_SURFACE,x,y)==0)&&(getpixel(TMP_SURFACE,x+w,y)==0)&&(getpixel(TMP_SURFACE,x,y+h)==0)&&(getpixel(TMP_SURFACE,x+w,y+h)==0));

	return tmp;
}


bool SetLevel()
{
	int i,a;	
		

	int tmpLevel = Level % LEVEL_GRAPHIC_COUNT;
	//+tmpLevel*1024
	


	if (Level == 9)
	{
		GeneratePlanetSurface(LEVEL_GRAPHIC_COUNT+1,50);   //the "Me" Level	
	}
	else
	{
		i = rand() % 8;
		if (i==7)
		{
			GeneratePlanetSurface(LEVEL_GRAPHIC_COUNT,50);	//space
		}
		else
		{
			GeneratePlanetSurface(tmpLevel,50); //generate the planets surface 
		}
	}	

	

	
	blit(PLANET_SURFACE, PLANET_SURFACE4,0,0,512,512,BACKGROUND_WIDTH,BACKGROUND_HEIGHT);

	blit(PLANET_SURFACE, PLANET_SURFACE4,512,512,0,0,512,512);  //nw corner
	blit(PLANET_SURFACE, PLANET_SURFACE4,0,0,1024+512,1024+512,512,512);    //se corner
	blit(PLANET_SURFACE, PLANET_SURFACE4,0,512,1024+512,0,512,512);  //sw corner
	blit(PLANET_SURFACE, PLANET_SURFACE4,512,0,0,1024+512,512,512);    //ne corner

	blit (PLANET_SURFACE,PLANET_SURFACE4,512,0,0,512,512,1024); //west side
	blit (PLANET_SURFACE,PLANET_SURFACE4,0,0,1024+512,512,512,1024);// east side

	blit (PLANET_SURFACE,PLANET_SURFACE4,0,512,512,0,1024,512);//north side
	blit (PLANET_SURFACE,PLANET_SURFACE4,0,0,512,1024+512,1024,512);//south side
	



	

	//Assign each ship it's portion of the image of all the ships
	int q;
	for (i=0;i<SHIP_GRAPHIC_COUNT;i++)

	{
		if (i== EXPLOSION_IMAGE )
		{
			for (a=0;a<MAX_FRAME_COUNT;a++)
			{
				blit(TMP,SHIPS[i][a],96 + tmpLevel*192,a*32,0,0,32,32);
			}
			
		}
		else if (i==PLAYER_DIVED)
		{
			for (a=0;a<MAX_FRAME_COUNT;a++)
			{
				clear_bitmap(SHIPS[i][a]);
				stretch_blit(SHIPS[PLAYER_IMAGE][a],SHIPS[i][a], 0, 0, 32, 32, 4, 4, 24, 24);
	//////////////////////////////
			}
		}
		else 
		{
			q= (i>PLAYER_DIVED) ? 32 : 0;
			q += (i>EXPLOSION_IMAGE) ? 32 : 0;
			for (a=0;a<MAX_FRAME_COUNT;a++)
			{
				blit(TMP,SHIPS[i][a],a*32+ tmpLevel*192,i*32 - q,0,0,32,32);
			}
		}
	}
	for(i=0;i<BIG_BOOM_BOOM_COUNT/3;i++)
		for(a=0;a<3;a++)
		{
			blit(TMP,BIG_BOOM_BOOMS[i*3+a],a*64+ tmpLevel*192,i*64+256,0,0,64,64);

		}
			
	blit(TMP,BULLET_SHOT[0],160 + tmpLevel*192,224,0,0,10,10);
	

	blit(TMP,BULLET_SHOT[1],170+ tmpLevel*192,224,0,0,10,10);
	

	blit(TMP,TARGET_ID, tmpLevel*192,224,0,0,32,32);

	

	blit(TMP,LIFE,32+ tmpLevel*192,224,0,0,32,32);	
	

	blit(TMP,DIVE,64+ tmpLevel*192,224,0,0,32,32);
	

	blit(TMP,SLOMO,128+ tmpLevel*192,224,0,0,32,32);
	//////////////////////
	
	for (i=0;i<10;i++)
	{
		
		blit(TMP,NUMBER[i],tmpLevel*192+i*NUMBER_WIDTH,448,0,0,NUMBER_WIDTH,NUMBER_HEIGHT);
	}
	
	blit(TMP,REPAIRING,tmpLevel*192,NUMBER_HEIGHT+448,0,0,190,NUMBER_HEIGHT);
	
	clear_bitmap(SHIPS_LEFT);
	clear_bitmap(SHIPS_LEFT_COVER);
	
	blit(TMP,SHIPS_LEFT,128+ tmpLevel*192,0,0,0,32,200);
	blit(TMP,SHIPS_LEFT_COVER,160+ tmpLevel*192,0,0,0,32,200);
	

	return true;
}



void MakeStandardLevelFormation()
{
	int tmpLevel = (Level >= LEVEL_COUNT) ? (LEVEL_COUNT-1) : Level;
	int tmpform=Levels[tmpLevel].formation;
	if (Level>=3)
		tmpform += rand()%2;
	NewFormation(tmpform, false, false,Levels[tmpLevel].numberon, Levels[tmpLevel].size , rand()%4,rand()%3,Levels[tmpLevel].stdfptypes[rand()%3], COMPUTER_STD_IMAGE, Levels[tmpLevel].speed);
		
}
void MakeSpecialLevelFormation()
{
	int tmpLevel = (Level >= LEVEL_COUNT) ? (LEVEL_COUNT-1) : Level;
	bool mcs = false;
	int a = (rand() % 10);
	if (a < 5)    //Missile Chuckers
	{
		mcs = true;
		if (!Levels[tmpLevel].mc)
			mcs = false;
	}
	int tmpim;
	int tmpPat;
	int tmpsize;
	
	if (mcs)
	{
		if ((Levels[tmpLevel].mcfp == TO_AND_FRO)||(Levels[tmpLevel].mcfp == TO_AND_FROWARD))
		{
			tmpim = COMPUTER_MC_180;
		}
		else
		{
			tmpim = COMPUTER_MC_IMAGE;
		}
		tmpPat = Levels[tmpLevel].mcfp;
		tmpsize = Levels[tmpLevel].mc;
	}
	else
	{
		if ((Levels[tmpLevel].hsfp == TO_AND_FRO)||(Levels[tmpLevel].hsfp == TO_AND_FROWARD))
		{
			tmpim = COMPUTER_HS_180;
		}
		else
		{
			tmpim = COMPUTER_HS_IMAGE;			
		}
		tmpPat = Levels[tmpLevel].hsfp;
		tmpsize = Levels[tmpLevel].hs;
	}
//void NewFormation(int Pattern, bool Hard, bool MissileChuckers, int NumberOn, int Number,int Side, int Sector, int FP, int imType, int spd);
	NewFormation(ARROW,true,mcs,0,tmpsize , rand()%4,rand()%3,tmpPat,tmpim,3);
}

//{int speed; int size; int numberon; int hs; int mc; int stdfptypes[3]; int hsfp; int mcfp;} LEVELTYPE;
void DrawNumber(int x, int y, int val,int thewidth)
{
	int Numbers[8];
	int i;
	int a=0;
	bool zero=!val;
//	x+=((thewidth-1)*LETTERWIDTH);
	for(i=0;i<8;i++)
	{
		a=(RaiseToPower(10,i+1));
		Numbers[i]=(val%a)/(a/10);
		val -= (Numbers[i]*a/10);
	
	}
	bool found=false;
	for (i=thewidth-1;i>=0;i--)
	{
		if (Numbers[i]!=0)
			found=true;
		
		if (found)
			draw_sprite(BUFFER,NUMBER[Numbers[i]],x,y);
		
//		BitBlt (hBufferDC,x,y,LETTERWIDTH, LETTERHEIGHT,hMemDC,384+(Numbers[i]+1)*LETTERWIDTH,240,SRCCOPY);
	//	x-=LETTERWIDTH;
		x+=NUMBER_WIDTH+1;
	}
	if (zero)
		draw_sprite(BUFFER,NUMBER[0],x-NUMBER_WIDTH,y);
//BitBlt (hBufferDC,x-LETTERWIDTH,y,LETTERWIDTH, LETTERHEIGHT,hMemDC,411,240,SRCCOPY);

}


void DrawHSNumber(int val,int number)
{
	int thewidth=8;
	int x = 512+256- 9*NUMBER_WIDTH;
	int y = number * (LETTER_HEIGHT +SPACE_BETWEEN_HIGH_SCORE_LIST)+128+SCORE_OFFSET ;    //letter height is correct
	int Numbers[8];
	int i;
	int a=0;
//	bool zero=!val;
//	x+=((thewidth-1)*LETTERWIDTH);
	for(i=0;i<8;i++)
	{
		a=(RaiseToPower(10,i+1));
		Numbers[i]=(val%a)/(a/10);
		val -= (Numbers[i]*a/10);
	
	}
	bool found=false;
	for (i=thewidth-1;i>=0;i--)
	{
		if (Numbers[i]!=0)
			found=true;
		
		if (found)
			draw_sprite(BUFFER,HSNUMBERS[Numbers[i]],x,y);
		
//		BitBlt (hBufferDC,x,y,LETTERWIDTH, LETTERHEIGHT,hMemDC,384+(Numbers[i]+1)*LETTERWIDTH,240,SRCCOPY);
	//	x-=LETTERWIDTH;
		x+=NUMBER_WIDTH+1;
	}
//	if (zero)
	//	draw_sprite(BUFFER,HSNUMBERS[0],x-NUMBER_WIDTH,y);
//BitBlt (hBufferDC,x-LETTERWIDTH,y,LETTERWIDTH, LETTERHEIGHT,hMemDC,411,240,SRCCOPY);

}


int RaiseToPower(int number, int power)
{
	int i;
	int tmp=1;
	for(i=0;i<power;i++)
		tmp *=number;
	return tmp;
		
}

void initLevels()
{
	Levels[0].speed = 1;
	Levels[0].size = 3;
	Levels[0].numberon = 0;	
	Levels[0].hs = 0;
	Levels[0].mc = 0;
	Levels[0].stdfptypes[0]=LARGE_FIGURE_8;
	Levels[0].stdfptypes[1]=LARGE_SIN;
	Levels[0].stdfptypes[2]=LARGE_CIRCLE;
	Levels[0].hsfp=NO_TURN;//none
	Levels[0].mcfp=NO_TURN;//none
	Levels[0].formation = RIGHT_ECHELON;

	Levels[1].speed = 2;
	Levels[1].size = 4;
	Levels[1].numberon = 0;	
	Levels[1].hs = 1;
	Levels[1].mc = 0;
	Levels[1].stdfptypes[0]=MEDIUM_FIGURE_8;
	Levels[1].stdfptypes[1]=MEDIUM_SIN;
	Levels[1].stdfptypes[2]=MEDIUM_CIRCLE;
	Levels[1].hsfp=CIRCLE_OFF;
	Levels[1].mcfp=NO_TURN;//none
	Levels[1].formation = ARROW;

	Levels[2].speed = 3;
	Levels[2].size = 4;
	Levels[2].numberon = 1;	
	Levels[2].hs = 2;
	Levels[2].mc = 1;
	Levels[2].stdfptypes[0]=LARGE_ZIG_ZAG;
	Levels[2].stdfptypes[1]=X_FIGURE_8;
	Levels[2].stdfptypes[2]=MEDIUM_CIRCLE;
	Levels[2].hsfp=DEVIATE;
	Levels[2].mcfp=OCTAGONAL;
	Levels[2].formation = LINE;

	Levels[3].speed = 3;
	Levels[3].size = 5;
	Levels[3].numberon = 1;	
	Levels[3].hs = 3;
	Levels[3].mc = 1;
	Levels[3].stdfptypes[0]=MEDIUM_SIN;
	Levels[3].stdfptypes[1]=CIRCLE_OFF;
	Levels[3].stdfptypes[2]=MEDIUM_FIGURE_8;
	Levels[3].hsfp=TO_AND_FRO;
	Levels[3].mcfp=SMALL_SQUARE;
	Levels[3].formation = ARROW;

	Levels[4].speed = 4;  
	Levels[4].size = 5;
	Levels[4].numberon = 1;	
	Levels[4].hs = 3;
	Levels[4].mc = 2;
	Levels[4].stdfptypes[0]=MEDIUM_ZIG_ZAG;
	Levels[4].stdfptypes[1]=X_FIGURE_8;
	Levels[4].stdfptypes[2]=SMALL_CIRCLE;
	Levels[4].hsfp=DEVIATE;
	Levels[4].mcfp=TO_AND_FROWARD;
	Levels[4].formation = ARROW;

	Levels[5].speed = 4;
	Levels[5].size = 6;
	Levels[5].numberon = 2;	
	Levels[5].hs = 4;
	Levels[5].mc = 2;
	Levels[5].stdfptypes[0]=SMALL_SIN;
	Levels[5].stdfptypes[1]=X_FIGURE_8;
	Levels[5].stdfptypes[2]=SMALL_ZIG_ZAG;
	Levels[5].hsfp=SMALL_FIGURE_8;
	Levels[5].mcfp=MEDIUM_CIRCLE;
	Levels[5].formation = ARROW;

	Levels[6].speed = 5;
	Levels[6].size = 6;
	Levels[6].numberon = 2;	
	Levels[6].hs = 4;
	Levels[6].mc = 3;
	Levels[6].stdfptypes[0]=SUPER_SMALL_ZIG_ZAG;
	Levels[6].stdfptypes[1]=SMALL_SQUARE;
	Levels[6].stdfptypes[2]=MEDIUM_CIRCLE;
	Levels[6].hsfp=CIRCLE_OFF;
	Levels[6].mcfp=DEVIATE;
	Levels[6].formation = ARROW;
}


void BigChunkOCode()
{
draw_sprite(PLANET_SURFACE,SCENERY[4],0,64);
draw_sprite(PLANET_SURFACE,SCENERY[4],0,96);
draw_sprite(PLANET_SURFACE,SCENERY[4],0,128);
draw_sprite(PLANET_SURFACE,SCENERY[4],0,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],0,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],0,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],0,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],0,320);
draw_sprite(PLANET_SURFACE,SCENERY[4],32,64);
draw_sprite(PLANET_SURFACE,SCENERY[4],32,160);
draw_sprite(PLANET_SURFACE,SCENERY[7],32,320);
draw_sprite(PLANET_SURFACE,SCENERY[4],64,64);
draw_sprite(PLANET_SURFACE,SCENERY[4],64,96);
draw_sprite(PLANET_SURFACE,SCENERY[4],64,128);
draw_sprite(PLANET_SURFACE,SCENERY[4],64,160);
draw_sprite(PLANET_SURFACE,SCENERY[7],64,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],64,448);
draw_sprite(PLANET_SURFACE,SCENERY[6],64,480);
draw_sprite(PLANET_SURFACE,SCENERY[6],64,512);
draw_sprite(PLANET_SURFACE,SCENERY[5],64,640);
draw_sprite(PLANET_SURFACE,SCENERY[5],64,672);
draw_sprite(PLANET_SURFACE,SCENERY[5],64,704);
draw_sprite(PLANET_SURFACE,SCENERY[5],64,736);
draw_sprite(PLANET_SURFACE,SCENERY[5],64,768);
draw_sprite(PLANET_SURFACE,SCENERY[7],96,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],96,416);
draw_sprite(PLANET_SURFACE,SCENERY[6],96,544);
draw_sprite(PLANET_SURFACE,SCENERY[5],96,640);
draw_sprite(PLANET_SURFACE,SCENERY[5],96,704);
draw_sprite(PLANET_SURFACE,SCENERY[5],96,768);
draw_sprite(PLANET_SURFACE,SCENERY[5],96,832);
draw_sprite(PLANET_SURFACE,SCENERY[5],96,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],96,896);
draw_sprite(PLANET_SURFACE,SCENERY[5],96,928);
draw_sprite(PLANET_SURFACE,SCENERY[5],96,960);
draw_sprite(PLANET_SURFACE,SCENERY[4],128,128);
draw_sprite(PLANET_SURFACE,SCENERY[4],128,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],128,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],128,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],128,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],128,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],128,384);
draw_sprite(PLANET_SURFACE,SCENERY[6],128,448);
draw_sprite(PLANET_SURFACE,SCENERY[6],128,480);
draw_sprite(PLANET_SURFACE,SCENERY[6],128,512);
draw_sprite(PLANET_SURFACE,SCENERY[6],128,576);
draw_sprite(PLANET_SURFACE,SCENERY[5],128,640);
draw_sprite(PLANET_SURFACE,SCENERY[5],128,672);
draw_sprite(PLANET_SURFACE,SCENERY[5],128,736);
draw_sprite(PLANET_SURFACE,SCENERY[5],128,768);
draw_sprite(PLANET_SURFACE,SCENERY[5],128,832);
draw_sprite(PLANET_SURFACE,SCENERY[5],128,896);
draw_sprite(PLANET_SURFACE,SCENERY[5],128,960);
draw_sprite(PLANET_SURFACE,SCENERY[7],160,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],160,384);
draw_sprite(PLANET_SURFACE,SCENERY[6],160,448);
draw_sprite(PLANET_SURFACE,SCENERY[6],160,512);
draw_sprite(PLANET_SURFACE,SCENERY[6],160,576);
draw_sprite(PLANET_SURFACE,SCENERY[5],160,832);
draw_sprite(PLANET_SURFACE,SCENERY[5],160,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],160,928);
draw_sprite(PLANET_SURFACE,SCENERY[5],160,960);
draw_sprite(PLANET_SURFACE,SCENERY[4],192,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],192,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],192,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],192,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],192,416);
draw_sprite(PLANET_SURFACE,SCENERY[6],192,544);
draw_sprite(PLANET_SURFACE,SCENERY[5],192,672);
draw_sprite(PLANET_SURFACE,SCENERY[5],192,704);
draw_sprite(PLANET_SURFACE,SCENERY[5],192,736);
draw_sprite(PLANET_SURFACE,SCENERY[5],192,768);
draw_sprite(PLANET_SURFACE,SCENERY[4],224,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],224,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],224,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],224,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],224,448);
draw_sprite(PLANET_SURFACE,SCENERY[6],224,480);
draw_sprite(PLANET_SURFACE,SCENERY[6],224,512);
draw_sprite(PLANET_SURFACE,SCENERY[5],224,672);
draw_sprite(PLANET_SURFACE,SCENERY[5],224,704);
draw_sprite(PLANET_SURFACE,SCENERY[5],224,768);
draw_sprite(PLANET_SURFACE,SCENERY[5],224,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],224,928);
draw_sprite(PLANET_SURFACE,SCENERY[5],224,960);
draw_sprite(PLANET_SURFACE,SCENERY[4],256,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],256,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],256,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],256,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],256,320);
draw_sprite(PLANET_SURFACE,SCENERY[5],256,672);
draw_sprite(PLANET_SURFACE,SCENERY[5],256,704);
draw_sprite(PLANET_SURFACE,SCENERY[5],256,768);
draw_sprite(PLANET_SURFACE,SCENERY[5],256,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],256,928);
draw_sprite(PLANET_SURFACE,SCENERY[5],256,960);
draw_sprite(PLANET_SURFACE,SCENERY[7],288,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],288,416);
draw_sprite(PLANET_SURFACE,SCENERY[6],288,512);
draw_sprite(PLANET_SURFACE,SCENERY[6],288,544);
draw_sprite(PLANET_SURFACE,SCENERY[5],288,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],288,896);
draw_sprite(PLANET_SURFACE,SCENERY[5],288,928);
draw_sprite(PLANET_SURFACE,SCENERY[5],288,960);
draw_sprite(PLANET_SURFACE,SCENERY[4],320,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],320,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],320,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],320,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],320,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],320,416);
draw_sprite(PLANET_SURFACE,SCENERY[6],320,480);
draw_sprite(PLANET_SURFACE,SCENERY[6],320,544);
draw_sprite(PLANET_SURFACE,SCENERY[5],320,672);
draw_sprite(PLANET_SURFACE,SCENERY[5],320,704);
draw_sprite(PLANET_SURFACE,SCENERY[5],320,736);
draw_sprite(PLANET_SURFACE,SCENERY[5],320,768);
draw_sprite(PLANET_SURFACE,SCENERY[4],352,160);
draw_sprite(PLANET_SURFACE,SCENERY[7],352,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],352,448);
draw_sprite(PLANET_SURFACE,SCENERY[6],352,544);
draw_sprite(PLANET_SURFACE,SCENERY[5],352,672);
draw_sprite(PLANET_SURFACE,SCENERY[5],352,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],352,896);
draw_sprite(PLANET_SURFACE,SCENERY[5],352,928);
draw_sprite(PLANET_SURFACE,SCENERY[5],352,960);
draw_sprite(PLANET_SURFACE,SCENERY[4],384,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],384,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],384,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],384,320);
draw_sprite(PLANET_SURFACE,SCENERY[5],384,704);
draw_sprite(PLANET_SURFACE,SCENERY[5],384,736);
draw_sprite(PLANET_SURFACE,SCENERY[5],384,768);
draw_sprite(PLANET_SURFACE,SCENERY[5],384,864);
draw_sprite(PLANET_SURFACE,SCENERY[7],416,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],416,448);
draw_sprite(PLANET_SURFACE,SCENERY[6],416,480);
draw_sprite(PLANET_SURFACE,SCENERY[6],416,512);
draw_sprite(PLANET_SURFACE,SCENERY[5],416,896);
draw_sprite(PLANET_SURFACE,SCENERY[4],448,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],448,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],448,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],448,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],448,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],448,416);
draw_sprite(PLANET_SURFACE,SCENERY[6],448,544);
draw_sprite(PLANET_SURFACE,SCENERY[4],480,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],480,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],480,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],480,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],480,448);
draw_sprite(PLANET_SURFACE,SCENERY[6],480,480);
draw_sprite(PLANET_SURFACE,SCENERY[6],480,512);
draw_sprite(PLANET_SURFACE,SCENERY[5],480,864);
draw_sprite(PLANET_SURFACE,SCENERY[4],512,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],512,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],512,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],512,320);
draw_sprite(PLANET_SURFACE,SCENERY[5],512,832);
draw_sprite(PLANET_SURFACE,SCENERY[5],512,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],512,896);
draw_sprite(PLANET_SURFACE,SCENERY[5],512,928);
draw_sprite(PLANET_SURFACE,SCENERY[5],512,960);
draw_sprite(PLANET_SURFACE,SCENERY[7],544,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],544,448);
draw_sprite(PLANET_SURFACE,SCENERY[6],544,480);
draw_sprite(PLANET_SURFACE,SCENERY[6],544,512);
draw_sprite(PLANET_SURFACE,SCENERY[4],576,160);
draw_sprite(PLANET_SURFACE,SCENERY[7],576,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],576,416);
draw_sprite(PLANET_SURFACE,SCENERY[6],576,544);
draw_sprite(PLANET_SURFACE,SCENERY[5],576,832);
draw_sprite(PLANET_SURFACE,SCENERY[5],576,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],576,896);
draw_sprite(PLANET_SURFACE,SCENERY[5],576,928);
draw_sprite(PLANET_SURFACE,SCENERY[5],576,960);
draw_sprite(PLANET_SURFACE,SCENERY[4],608,128);
draw_sprite(PLANET_SURFACE,SCENERY[4],608,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],608,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],608,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],608,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],608,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],608,448);
draw_sprite(PLANET_SURFACE,SCENERY[6],608,480);
draw_sprite(PLANET_SURFACE,SCENERY[6],608,512);
draw_sprite(PLANET_SURFACE,SCENERY[7],640,320);
draw_sprite(PLANET_SURFACE,SCENERY[5],640,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],640,896);
draw_sprite(PLANET_SURFACE,SCENERY[5],640,928);
draw_sprite(PLANET_SURFACE,SCENERY[5],640,960);
draw_sprite(PLANET_SURFACE,SCENERY[4],672,128);
draw_sprite(PLANET_SURFACE,SCENERY[4],672,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],672,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],672,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],672,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],672,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],672,416);
draw_sprite(PLANET_SURFACE,SCENERY[6],672,480);
draw_sprite(PLANET_SURFACE,SCENERY[6],672,544);
draw_sprite(PLANET_SURFACE,SCENERY[5],672,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],672,896);
draw_sprite(PLANET_SURFACE,SCENERY[5],672,960);
draw_sprite(PLANET_SURFACE,SCENERY[4],704,128);
draw_sprite(PLANET_SURFACE,SCENERY[4],704,192);
draw_sprite(PLANET_SURFACE,SCENERY[7],704,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],704,416);
draw_sprite(PLANET_SURFACE,SCENERY[6],704,480);
draw_sprite(PLANET_SURFACE,SCENERY[6],704,544);
draw_sprite(PLANET_SURFACE,SCENERY[5],704,864);
draw_sprite(PLANET_SURFACE,SCENERY[5],704,896);
draw_sprite(PLANET_SURFACE,SCENERY[5],704,960);
draw_sprite(PLANET_SURFACE,SCENERY[7],736,320);
draw_sprite(PLANET_SURFACE,SCENERY[6],736,448);
draw_sprite(PLANET_SURFACE,SCENERY[6],736,512);
draw_sprite(PLANET_SURFACE,SCENERY[4],768,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],768,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],768,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],768,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],768,320);
draw_sprite(PLANET_SURFACE,SCENERY[4],800,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],800,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],800,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],800,320);
draw_sprite(PLANET_SURFACE,SCENERY[4],832,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],832,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],832,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],832,320);
draw_sprite(PLANET_SURFACE,SCENERY[7],864,320);
draw_sprite(PLANET_SURFACE,SCENERY[4],896,128);
draw_sprite(PLANET_SURFACE,SCENERY[4],896,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],896,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],896,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],896,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],896,320);
draw_sprite(PLANET_SURFACE,SCENERY[7],928,320);
draw_sprite(PLANET_SURFACE,SCENERY[4],960,128);
draw_sprite(PLANET_SURFACE,SCENERY[4],960,160);
draw_sprite(PLANET_SURFACE,SCENERY[4],960,192);
draw_sprite(PLANET_SURFACE,SCENERY[4],960,224);
draw_sprite(PLANET_SURFACE,SCENERY[4],960,256);
draw_sprite(PLANET_SURFACE,SCENERY[7],960,320);
draw_sprite(PLANET_SURFACE,SCENERY[7],992,320);


	

}
/*void KitchenSync()
{
	while (!SyncFlag){};
	SyncFlag=false;
}*/

void OpenHighScores()
{
	int i;
	FILE *theFile;
	theFile=fopen("HighScores.who","r");
	

	getc(theFile);
	getc(theFile);
	getc(theFile);
	getc(theFile);

	int so;
	for (so=0;so<HIGH_SCORE_COUNT;so++)
	{
		for (i=0;i<8;i++)
		{
			HighScoreTable[so].name[i] = getc(theFile) - 'A';
		}
		HighScoreTable[so].score=0;
		for (i=0;i<8;i++)
		{
			HighScoreTable[so].score*= 10;
			HighScoreTable[so].score+= (getc(theFile)-'0');
		}
		getc(theFile);   //clear the line return
	
	}
	fclose(theFile);
}
void SaveHighScores()
{
	int i;
	FILE *theFile;
	theFile=fopen("HighScores.who","w");
	
	

	
	putc((HaveSound) ? '1' : '0',theFile);
	putc((HaveMuzak) ? '1' : '0',theFile);
	putc((usingjoy) ? '1' : '0',theFile);
	putc('\n',theFile);

	int so;
	for (so=0;so<HIGH_SCORE_COUNT;so++)
	{
		for(i=0;i<8;i++)
		{
			putc(HighScoreTable[so].name[i]+'A',theFile);
		}
		int sc = HighScoreTable[so].score;
		int sco[8];
		for(i=0;i<8;i++)
		{
			sco[i]=sc%10;
			sc-=sco[i];
			sc/=10;
		}
		for(i=7;i>=0;i--)
		{
			putc(sco[i]+'0',theFile);
		}
		putc('\n',theFile);
	}
	fclose(theFile);


}

