#include "bullet.h"



bullet::bullet(fixed elx,fixed ely,int d,bool ps): pHeading(d),	pPlayerShot(ps)
{
	pLocal.x=elx;	
	pLocal.y=ely;
	pMarked=false;

}
int bullet::Color()
{
	if (pPlayerShot)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}
bool bullet::PlayerShot()
{
	return pPlayerShot;
}
int bullet::X()
{
	return fixtoi(pLocal.x);
}
int bullet::Y()
{
	return fixtoi(pLocal.y);
}
void bullet::Move(int px, int py)
{
	pLocal.x += BULLET_SPEED*fixcos(itofix(pHeading));
	pLocal.y += BULLET_SPEED*fixsin(itofix(pHeading));
	if (X() >= BACKGROUND_WIDTH)
	{
		pLocal.x -= itofix(BACKGROUND_WIDTH) ;
	}
	else if (X() < 0)
	{
		pLocal.x += itofix(BACKGROUND_WIDTH) ;
	}
	if (Y() >= BACKGROUND_HEIGHT)
	{
		pLocal.y -= itofix(BACKGROUND_HEIGHT) ;
	}
	else if (Y() < 0)
	{
		pLocal.y += itofix(BACKGROUND_HEIGHT );
	}
	int deltax1 = ((X()-px)+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
	int deltay1 = ((Y()-py)+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
	int deltax2 = ((px-X())+(BACKGROUND_WIDTH*2))%BACKGROUND_WIDTH;
	int deltay2 = ((py-Y())+(BACKGROUND_HEIGHT*2))%BACKGROUND_HEIGHT;
			
	int dx = (deltax1>deltax2) ? deltax2:deltax1 ;
	int dy = (deltay1>deltay2) ? deltay2:deltay1 ;
	if ((dx>BORDER)||(dy>BORDER))
		pMarked=true;
}
bool bullet::Marked()
{
	return pMarked;	
}
