/*
 *    Example program for the Allegro library, by Grzegorz Adam Hankiewicz
 *
 *    This program uses the Allegro library to detect and read the value
 *    of a joystick. The output of the program is a small target sight
 *    on the screen which you can move. At the same time the program will
 *    tell you what you are doing with the joystick (moving or firing).
 */


#include "allegro.h"



int main()
{



	AL_CONST char *msg;
	allegro_init();        

	install_keyboard();     
	if (set_gfx_mode(GFX_SAFE, 320, 200, 0, 0) != 0) 
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
		return 1;
	}
	set_palette(default_palette);
	clear_bitmap(screen);
	
	textout_centre(screen, font, "Please center the joystick", SCREEN_W/2, SCREEN_H/2 - 36, palette_color[255]);
	textout_centre(screen, font, "and press a key.", SCREEN_W/2, SCREEN_H/2 - 20, palette_color[255]);

	if ((readkey()&0xFF) == 27)
      		return 0;


	if (install_joystick(JOY_TYPE_AUTODETECT) != 0) 
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Error initialising joystick\n%s\n", allegro_error);
		return 1;
	}


	if (!num_joysticks) 
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Error: joystick not found\n");
		return 1;
   	}

   	while (joy[0].flags & JOYFLAG_CALIBRATE) 
   	{
		
	   	msg = calibrate_joystick_name(0);

		clear_bitmap(screen);
		textout_centre(screen, font, msg, SCREEN_W/2, 64, palette_color[255]);
      		textout_centre(screen, font, "and press a key.", SCREEN_W/2, 80, palette_color[255]);

		if ((readkey()&0xFF) == 27)
			return 0;

		if (calibrate_joystick(0) != 0) 
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
	 		allegro_message("Error calibrating joystick!\n");
	 		return 1;
      		}
   	}
	clear_bitmap(screen);
	textout_centre(screen, font, "The joystick has been calibrated.", SCREEN_W/2,SCREEN_H/2 - 20, palette_color[255]);
	save_joystick_data("joy.dat");
	readkey();
   
	return 0;
}

END_OF_MAIN();
