/* GIVE PEACE A CHANCE */

/*
	game.c

	This contains the ... game! The bulk of the game code is in
	the play_game() function. The computer AI is also in here
*/

#include <memory.h>
#include <stdlib.h>
#include <time.h>

#include <allegro.h>

#include "main.h"

#ifndef NO_DUMB
#include <aldumb.h>
#endif

#include "data.h"
#include "game.h"
#include "gfx.h"
#include "hiscore.h"
#include "player.h"
#include "rain.h"
#include "textout.h"

int basement_drops = 0;        /* number of drops that the player has missed */
int game_status = GAME_TITLE;  /* keeps track of where in the game we are */
int current_level = 1;         /* current level, duh! */
int game_mode = MODE_NORMAL;   /* differents modes such as demo, playback */

/*
	logic handler for cpu - this is actually pretty solid. A couple improvements
	could be made, such as not going for a drop far away, if it means you are going
	to miss a couple of other ones that are grouped together.

	keys is an array of ints from 0 to MAX_INPUTS that holds a boolean value for
	key presses.
*/
void game_cpu_proc(int *keys)
{
	RAIN_DROP *rd = rain_drop_list;
	int closest_x = SCREEN_W / 2, closest_y = 0;
	
	/* clear out the old keys */
	memset(keys, 0, sizeof(int) * MAX_INPUTS);	

	while (rd)
	{
		/* 
			if this drop is farther down, and it is not 'underneath' 
			the player	and the player can reach it
		*/
		if ( closest_y < rd->y && rd->y <= player->y && (abs(player->y - rd->y)/2 > abs(player->x-rd->x)/12) )
		{ 
			closest_x = rd->x;
			closest_y = rd->y;			
		}
		rd = rd->next;
	}

	if (player->drops >= MAX_MISSED_DROPS-1 || (player->drops >= MAX_MISSED_DROPS/3 && (abs(player->y-closest_y)/2 > abs(player->x-closest_x)/12 + (SCREEN_W-player->x)/6)))
	{
		/*
			Empty the bucket if it is full or if it is getting full
			and the sink is within reach 
		*/			
		keys[IH_RIGHT] = 1;
	}
	else if (closest_x < player->x)
	{
		/* move left if the drop is that way */
		keys[IH_LEFT] = 1;
	}
	else if (closest_x > player->x + player->sprite[0]->w)
	{
		/* move right if the drop is that way */
		keys[IH_RIGHT] = 1;
	}

	/* always running :D */
	keys[IH_BUTTON_A] = 1;
	keys[IH_BUTTON_B] = key[KEY_TAB];

	return;
}


/* play game */
void play_game(void)
{	
	int bottom_x, bottom_y;	
	int last_thunder = 0;
	int drops_left = 20, next_drop_timer;
	int game_over = 0;
	int lightning_effect = 0;	
	int seed;
	int old_handler = player->ih->type, old_device = player->ih->device;
	
	RGB le[8] = {
		{0,0,0,0},
		{0,0,0,0},
		{31,31,31,0},
		{31,31,31,0},
		{47,47,47,0},
		{47,47,47,0},
		{63,63,63,0},
		{63,63,63,0}
	};

	/* dumb is used to play the music */
#ifndef NO_DUMB
	AL_DUH_PLAYER *dp;
	DUH *duh = (DUH *)datafile[IT_GAME].dat;
	dp = al_start_duh(duh, 2, 0, 1.0, 4096, 44100);
#endif

	/* position of the bottom image */
	bottom_x = 0;
	bottom_y = SCREEN_H - ((RLE_SPRITE*)datafile[RLE_BOTTOM].dat)->h;

	/* position the player */
	player->x = 0;
	player->y = bottom_y - player->sprite[0]->h + 39;
	player->drops = 0;
	player->score = 0;
	basement_drops = 0;

	/* play the rain drops */
	rain_drop_create();

	/* initialize the timing */
	game_timer = 0;
	next_drop_timer = timestamp + SECOND;
	last_thunder = timestamp;

	/* get the rain goin' */
	play_sample((SAMPLE*)datafile[SAMP_RAIN_LOOP].dat, 128, 128, 1000, 1);

	/* reset the game */
	game_status = GAME_NEXT_LEVEL;
	current_level = 1;

	/* get the specific game mode running */
	seed = time(0);
	if (game_mode == MODE_DEMO)
	{
		input_handler_destroy(player->ih);
		player->ih = input_handler_create(HANDLER_CPU, 0);
		player->ih->cpu_proc = &game_cpu_proc;
	}
	else if (game_mode == MODE_LOG)
	{
		player->ih->type = HANDLER_LOG;
		input_handler_log(player->ih, "log");
		pack_fread(&seed, sizeof(seed), player->ih->log);
	}
	else
	{		
		input_handler_log(player->ih, "log");
		pack_fwrite(&seed, sizeof(seed), player->ih->log);
	}
	srand(seed);

	/* main game loop */
	while (!end_game && !game_over && game_status != GAME_TITLE)
	{
		while (game_timer)
		{
#ifndef NO_DUMB
			al_poll_duh(dp);
#endif
			player_update(player);

			/* we only allow 4 drops at a time ... if the fourth was destroyed, reset the timer */
			if (rain_drops_count == 4)
				next_drop_timer = timestamp + SECOND - current_level * 5;

			rain_drop_update();

			/* add a drop if there's still more to come */
			if (game_status == GAME_PLAYING && drops_left && rain_drops_count < 4 && basement_drops < MAX_MISSED_DROPS && next_drop_timer < timestamp)
			{
				drops_left--;
				rain_drop_add();
				next_drop_timer = timestamp + SECOND - current_level * 5;
			}

			/* raise level if no drops falling or coming */
			if (!drops_left && !rain_drop_list)
			{
				game_status = GAME_NEXT_LEVEL;
				drops_left = 20 + current_level * 5;
				current_level++;
				next_drop_timer = timestamp + SECOND * 2;				
			}

			/* check if game over */
			if (basement_drops >= MAX_MISSED_DROPS && !rain_drops_count && game_status == GAME_PLAYING)
			{				
				/* 
					we use the temp flags to control the players 'panic' movement
					flag1 is used to flop between left & right
					flag2 is used to count how many 'steps' the guy takes or seconds he waits
				*/				
				player->flag1 = 0; 
				player->flag2 = SECOND * .5;
				game_status = GAME_LEAVING;							
			}

			/* play thunder randomly, as well as no less than once every 15 seconds */
			if ( last_thunder < timestamp - (15*SECOND) || (rand() % 1000) < 3 )
			{
				play_sample((SAMPLE*)datafile[SAMP_THUNDER_BIG+((rand()>>2) % 3)].dat, 255, 128, 1000, 0);
				#if RUMBLE		
					if (player->ih->type == HANDLER_JOYSTICK && joy_can_rumble[player->ih->device]) 
						ff_play_effect(ff_effect_a[player->ih->device]);
				#endif

				last_thunder = timestamp;
				lightning_effect = 6;
			}

			if ( lightning_effect )
			{	
			//	vsync();
				set_color(0, &le[lightning_effect]);
				lightning_effect--;
			}

			/* user wants to quit */
			if (player->ih->status[IH_BUTTON_B] == IH_STATUS_RELEASED)
			{
				game_status = GAME_LEAVING;
				player->flag1 = 10; 
				player->flag2 = 0;
			}

			if (key[KEY_ESC]) end_game = 1;
		
			game_timer--;
		}
				
		gfx_frame_start(gfx_engine);
		/* draw the background */
		draw_rle_sprite(gfx_engine->buffer, (RLE_SPRITE*)datafile[RLE_BOTTOM].dat, bottom_x,bottom_y);
		if (player->drops) rectfill(gfx_engine->buffer, 290,480- (player->drops*2) , 365,480, 39);
		if (basement_drops) rectfill(gfx_engine->buffer, 0, 393-(basement_drops*2), 639,392, 39);

		/* show the scores in the background */
		if (player->ih->type == HANDLER_CPU)
			hiscore_draw(gfx_engine->buffer, 180,20);

		/* draw the sprites */
		player_draw(player, gfx_engine->buffer);
		rain_drop_draw(gfx_engine->buffer);

		/* print the scores and level */
		print_number(current_level, BMP_GRAY_NUMBERS, 1, gfx_engine->buffer, 354, 400);
		print_number(player->score, BMP_WHITE_NUMBERS, 5, gfx_engine->buffer, 178, 448);
		print_number(high_score[0], BMP_WHITE_NUMBERS, 5, gfx_engine->buffer, 466, 448);

#ifdef _DEBUG			
		fps_running++;
		textprintf(gfx_engine->buffer, font, 0,SCREEN_H-8, makecol(255,255,255), "(Drawn) FPS: %i", fps);
#endif

		//vsync();
		gfx_frame_end(gfx_engine);
	}

	/* set things back to normal */
	set_color(0, &le[0]);
	stop_sample((SAMPLE*)datafile[SAMP_RAIN_LOOP].dat);
#ifndef NO_DUMB
	al_stop_duh(dp);	
#endif

	/* close the specific game mode */	
	if (game_mode == MODE_DEMO)
	{			
		input_handler_destroy(player->ih);
		player->ih = input_handler_create(old_handler, old_device);
	}
	else if (game_mode == MODE_LOG)
	{
		input_handler_log(player->ih, 0);
		player->ih->type = old_handler;
	}
	else
	{		
		input_handler_log(player->ih, 0);
		hiscore_add(gfx_engine, player->score);
	}
	
	game_status = 0;

	rain_drop_destroy();
	
	return;
}

