/* GIVE PEACE A CHANCE */

/*
	title.c

	The title screen controls all of the options. Pressing the
	function keys does magical things.
*/

#include <string.h>
#include <stdio.h>
#include <allegro.h>

#include "main.h"
#include "data.h"
#include "game.h"
#include "gfx.h"
#include "hiscore.h"
#include "input.h"
#include "player.h"
#include "textout.h"
#include "title.h"

int title_screen()
{
	INPUT_HANDLER *ih_menu = input_handler_create(HANDLER_KEYBOARD, 0);
	int logo_x, logo_y;
	int press_x, press_y;
	int bottom_x, bottom_y;
	int ok_to_draw = 1;
	int last_scroll = 0;
	int play_game = 0;
	char msg[100] = {0};
	int msg_timer = 0;
	int demo_timeout = SECOND * 10;

	/* setup the keys for the menu */
	ih_menu->map[0] = KEY_ESC;
	ih_menu->map[1] = KEY_F1;
	ih_menu->map[2] = KEY_F2;
	ih_menu->map[3] = KEY_F3;
	ih_menu->map[4] = KEY_F4;


	logo_x = SCREEN_W / 2 - ((RLE_SPRITE*)datafile[RLE_LOGO].dat)->w / 2;
	logo_y = 84;

	press_x = SCREEN_W;
	press_y = logo_y + ((RLE_SPRITE*)datafile[RLE_LOGO].dat)->h + 6;

	bottom_x = 0;
	bottom_y = SCREEN_H - ((RLE_SPRITE*)datafile[RLE_BOTTOM].dat)->h;

	text_mode(-1);
	game_timer = 0;


	while (!end_game && !play_game)
	{
		while (game_timer)
		{
			input_handler_poll(player->ih);
			input_handler_poll(ih_menu);

			/* ESC: exit game */
			if (ih_menu->status[0] == IH_STATUS_RELEASED) end_game = 1;
			
			/* F1: toggle through controller settings */
			if (ih_menu->status[1] == IH_STATUS_PRESSED)
			{
				int new_device = 0, new_handler = 0;

				switch (player->ih->type)
				{
					case HANDLER_KEYBOARD:						
						if (num_joysticks)
						{
							/* if joysticks are available, lets use them */
							new_device = 0;
							new_handler = HANDLER_JOYSTICK;
							strcpy(msg, "USING JOYSTICK #1");
						}
						else
						{
							/* if no joysticks, then stick with keyboard */
							new_device = 0;
							new_handler = HANDLER_KEYBOARD;
							strcpy(msg, "USING KEYBOARD");
						}
					break;

					case HANDLER_JOYSTICK:
						if ((new_device = player->ih->device + 1) >= num_joysticks)
						{
							/* no more joysticks found, back to keyboard */
							new_device = 0;
							new_handler = HANDLER_KEYBOARD;
							strcpy(msg, "USING KEYBOARD");

						}
						else
						{
							/* found a joystick to use */
							sprintf(msg, "USING JOYSTICK #%d", new_device+1);
							new_handler = HANDLER_JOYSTICK;
						}
					break;

					default:
						new_device = 0;
						new_handler = HANDLER_KEYBOARD;
					break;
				}

				/* if the input was actually changed, then do an update */
				if (new_handler != player->ih->type || new_device != player->ih->device)
				{
					input_handler_destroy(player->ih);
					player->ih = input_handler_create(new_handler, new_device);
				}
				msg_timer = timestamp + SECOND * 3;		
				
				demo_timeout = SECOND * 10;
			}

			/* F2: toggle between graphics modes */
			if (ih_menu->status[2] == IH_STATUS_RELEASED)
			{
				int new_type = GFX_NONE;
				if (gfx_engine->type == GFX_DOUBLE_BUFFER)				
					new_type = GFX_PAGE_FLIP;
				else if (gfx_engine->type == GFX_PAGE_FLIP)
					new_type = GFX_DOUBLE_BUFFER;

				gfx_switch_type(&gfx_engine, new_type);
				strcpy(msg, gfx_name[gfx_engine->type]);
				msg_timer = timestamp + SECOND * 3;		
				demo_timeout = SECOND * 10;
			}

			/* F3: toggle between full screen */
			if (ih_menu->status[3] == IH_STATUS_RELEASED)
			{
				int old_type = gfx_engine->type;
				gfx_destroy(gfx_engine);

				if (gfx_driver->windowed)
				{					
					set_color_depth(8);
					if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0))
						if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0))
						{
							allegro_message("That didn't work, and I wouldn't recommend trying again.");
							exit(1);
						}
					set_palette((RGB*)datafile[PAL_GAME].dat);
				}
				else
				{
					set_color_depth(8);
					if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0))
						if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0))
						{
							allegro_message("That didn't work, and I wouldn't recommend trying again.");
							exit(1);
						}
					set_palette((RGB*)datafile[PAL_GAME].dat);
				}

				strcpy(msg, gfx_driver->windowed ? "WINDOWED" : "FULLSCREEN");
				msg_timer = timestamp + SECOND * 3;	
				gfx_engine = gfx_create(old_type);
				demo_timeout = SECOND * 10;
			}

			/* F4: Replay */
			if (ih_menu->status[4] == IH_STATUS_RELEASED)
			{
				PACKFILE *pf = pack_fopen("log", "pr");
				if (pf)
				{
					pack_fclose(pf);
					play_game = 1;
					game_mode = MODE_LOG;
				}
			}

			/* after so many seconds, the demo plays with the highscore listed */
			if (!demo_timeout--)
			{
				play_game = 1;
				game_mode = MODE_DEMO;
			}

			/* button a: play the game */
			if (player->ih->status[IH_BUTTON_A] == IH_STATUS_RELEASED) 
			{
				play_game = 1;
				game_mode = MODE_NORMAL;
			}

			/* button b: end the game */
			if (player->ih->status[IH_BUTTON_B] == IH_STATUS_RELEASED) end_game = 1;

			/* scroll the press fire message */
			if (timestamp - last_scroll > 8)
			{
				press_x -= 16;
				if (press_x + ((BITMAP*)datafile[RLE_PRESS_BUTTON].dat)->w < 0) press_x = SCREEN_W; 
				ok_to_draw = 1;
				last_scroll = timestamp;
			}

			/* reset the message timer if it has expired */
			if (msg_timer && msg_timer < timestamp) 
			{
				msg[0] = 0;
				msg_timer = 0;
				ok_to_draw = 1;
			}
			if (msg_timer) ok_to_draw = 1;
			
			game_timer--;
		}

		if (ok_to_draw)
		{
			gfx_frame_start(gfx_engine);
			
			/* draw the logo and stuff */
			draw_rle_sprite(gfx_engine->buffer, (RLE_SPRITE*)datafile[RLE_LOGO].dat, logo_x,logo_y);
			draw_rle_sprite(gfx_engine->buffer, (RLE_SPRITE*)datafile[RLE_PRESS_BUTTON].dat, press_x,press_y);
			draw_rle_sprite(gfx_engine->buffer, (RLE_SPRITE*)datafile[RLE_BOTTOM].dat, bottom_x,bottom_y);

			/* print the scores */
			print_number(player->score, BMP_WHITE_NUMBERS, 5, gfx_engine->buffer, 178, 448);
			print_number(high_score[0], BMP_WHITE_NUMBERS, 5, gfx_engine->buffer, 466, 448);

			/* print the message */
			if (msg_timer) textprintf(gfx_engine->buffer, (FONT *)datafile[FONT_C64].dat, 2,2, makecol(255,255,255), "%s", msg);
			
#ifdef _DEBUG			
			fps_running++;
			textprintf(gfx_engine->buffer, font, 0,SCREEN_H-8, makecol(255,255,255), "(Drawn) FPS: %i", fps);
#endif
			
			gfx_frame_end(gfx_engine);
			ok_to_draw = 0;
		}
		
	}

	input_handler_destroy(ih_menu);
	
	return play_game;
}

