/* GIVE PEACE A CHANCE */

/*
	player.c

	Does just about anything you want to the little guy.
	The player_update routine is sorta longish, but it
	handls all of the in game processing for the player,
	such as handling keystrokes, etc.
*/

#include <math.h>
#include "main.h"

#include "game.h"
#include "input.h"
#include "player.h"

PLAYER *player;

/*
	Creates a player and initalizes all of the data.
*/
PLAYER *player_create(void)
{
	PLAYER *p = malloc(sizeof(PLAYER));

	p->ih = 0;
	p->sprite = 0;
	p->sprite_count = 0;
	p->sprite_frame = 0;
	p->x = p->y = 21;
	p->facing = 0;
	p->drops = 0;
	p->score = 0;
	p->acceleration = 0;
	p->sprite_timer = 0;
	p->flag1 = p->flag2 = 0;
	
	return p;	
}

/*
	This will destroy the player and any sub data 
	it may contain.
*/
void player_destroy(PLAYER *p)
{
	if (p) 
	{
		if (p->ih)
		{
			free(p->ih);
			p->ih = 0;
		}

		while (p->sprite_count--)			
			destroy_bitmap(p->sprite[p->sprite_count]);
		p->sprite_count = 0;

		free(p);
		p = 0;
	}
	
	return;
}

/*
	draws the current frame of animation onto the bitamp
*/
void player_draw(PLAYER *p, BITMAP *bmp)
{
	if (!p->facing)	
		draw_sprite(bmp, p->sprite[p->sprite_frame], p->x, p->y);
	else
		draw_sprite_h_flip(bmp, p->sprite[p->sprite_frame], p->x, p->y);
}

/*
	holds the logic for moving the player
*/
void player_update(PLAYER *p)
{	
	/* this checks the input and sets various flags namely in ih->status[] */
	input_handler_poll(p->ih);

	/* check to see if the player should be moved to the center of the screen */
	if (game_status == GAME_NEXT_LEVEL)
	{
		p->ih->status[IH_LEFT] = IH_UP;
		p->ih->status[IH_RIGHT] = IH_UP;

		/* basically, we cheat and auto set he controls here */
		if (p->x < SCREEN_W / 2 - p->sprite[0]->w / 2) 
			p->ih->status[IH_RIGHT] = IH_DOWN;
		else if (p->x > SCREEN_W / 2)
			p->ih->status[IH_LEFT] = IH_DOWN;
		else
			game_status = GAME_PLAYING;
	}
	/* if the game is over, lets make the guy run off the screen */
	else if (game_status == GAME_LEAVING)
	{
		p->ih->status[IH_LEFT] = IH_UP;
		p->ih->status[IH_RIGHT] = IH_UP;

		/* panic for a little bit before running away */
		if (!p->flag1)
		{
			/* first he waits */			
			p->facing = (p->x < SCREEN_W/2) ? 1 : 0;
			if (--(p->flag2) == 0) 
			{
				p->flag2 = 35;
				p->flag1++;
			}
		}
		else if (p->flag1 < 8)
		{
			/* then he moves back and forth */
	
			if (--(p->flag2) == 0) 
			{
				p->flag1++;
				p->flag2 = (rand() % 10) + 5;
				p->facing = 1 - p->facing;					
			}
			p->ih->status[IH_BUTTON_A] = IH_DOWN;
			p->ih->status[p->facing ? IH_RIGHT : IH_LEFT] = IH_DOWN;
		}
		else
		{
			/* finally he runs off of the screen */		
			if (p->x > 0)
				p->ih->status[IH_LEFT] = IH_DOWN;
			else	
				game_status = GAME_TITLE;
		}
	}

	/* if he is running, make his feet move faster */
	if (p->ih->status[IH_BUTTON_A] == IH_STATUS_DOWN) 
		p->sprite_timer++;
	else if (p->acceleration > 7) 
		p->acceleration = 7;

	/* check the movement */	
	if (p->ih->status[IH_LEFT]) 
	{
		if (p->facing != 0)
		{
			/* switching directions, lose half of acceleration */
			p->facing = 0;
			p->acceleration /= 2;
		}

		/* move player */
		p->x -= p->acceleration;
		if (p->x < 0) p->x = 0;

		/* update animation */
		if (p->sprite_timer++ >= 4)
		{
			p->sprite_frame = 1 - p->sprite_frame;
			p->sprite_timer = 0;
		}

		/* update acceleration */
		if (p->acceleration < 12 && p->ih->status[IH_BUTTON_A] == IH_STATUS_DOWN) 
			p->acceleration += 1;
		else if (p->acceleration < 8)
			p->acceleration += 1;
	}
	else if (p->ih->status[IH_RIGHT]) 
	{
		if (p->facing != 1)
		{
			/* switching directions, lose half of acceleration */
			p->facing = 1;
			p->acceleration /= 2;
		}

		/* move player */
		p->x += p->acceleration;
		if (p->x > SCREEN_W-p->sprite[0]->w - 20) p->x = SCREEN_W-p->sprite[0]->w - 20;

		/* update animation */
		if (p->sprite_timer++ >= 4)
		{
			p->sprite_frame = 1 - p->sprite_frame;
			p->sprite_timer = 0;
		}
		
		/* update acceleration */		
		if (p->acceleration < 12 && p->ih->status[IH_BUTTON_A] == IH_STATUS_DOWN) 
			p->acceleration += 1;
		else if (p->acceleration < 8)
			p->acceleration += 1;
	}	
	else
	{
		/* this guy can stop on a dime... */
		p->acceleration = 0;
		p->sprite_frame = 0;
		p->sprite_timer = 0;
	}
	
	/* empty the bucket if the player reaches the sink */
	if (p->x > SCREEN_W-p->sprite[0]->w-30) p->drops = 0;
}

