/* GIVE PEACE A CHANCE */

/*
	hiscore.c

	Adds a hiscore, including handling user input. Also
	displays the hiscore and loads/saves it to disk.
*/

#include <stdio.h>
#include <string.h>
#include <allegro.h>

#include "main.h"
#include "data.h"
#include "game.h"
#include "gfx.h"
#include "hiscore.h"

int high_score[10];
char high_name[10][255];

/*
	The score is checked to make sure it really belongs.
	If it does, the user gets to type in his name.
*/
void hiscore_add(GFX *gfx, int score)
{
	int i, pos;

	/* check to see if the high score belongs */
	for (pos = 0; pos != 10; pos++)
	{
		if (score >= high_score[pos])
			break;		
	}

	if (pos < 10)
	{
		/* yes, we have a winner! */
		int k;
		char buffer[25];
		buffer[0] = 0;

		clear_keybuf();
		clear(gfx->buffer);

		do
		{
			/* draw the *very* basic screen */
			gfx_frame_start(gfx);
			clear(gfx->buffer);
			textprintf(gfx->buffer, (FONT*)datafile[FONT_C64].dat, 150, 80, makecol(255,224,224), "YOU ARE A HIGH SCORER!");
			textprintf(gfx->buffer, (FONT*)datafile[FONT_C64].dat, 150, 160, makecol(255,224,224), "SO GIVE PEACE A CHANCE");
			textprintf(gfx->buffer, (FONT*)datafile[FONT_C64].dat, 150, 232, makecol(255,255,255), "Your name, please:");
			textprintf(gfx->buffer, (FONT*)datafile[FONT_C64].dat, 166, 248, makecol(255,255,255), "%s", buffer);
			gfx_frame_end(gfx);
			
			/* wait for a key */
			k = readkey() & 0xff;
			if ( strlen(buffer) < 20 && ( (k >= 'A' && k <= 'Z') || (k >= 'a' && k <= 'z') || k == 32) )
			{
				/* ok, it was a valid character, now add it to the buffer */
				char buf[2] = { 0, 0 };
				sprintf(buf, "%c", k);
				strcat(buffer, buf);				
			}
			else if (strlen(buffer)  && k == 8)
			{
				/* backspace */
				buffer[strlen(buffer)-1] = 0;
			}
		} while (k != 13); /* enter */

		/* move all the old scores down a notch */
		for (i=9; i!=pos; i--)
		{
			strcpy(high_name[i], high_name[i-1]);
			high_score[i] = high_score[i-1];
		}

		/* add this score :) */
		strcpy(high_name[pos], buffer);
		high_score[pos] = score;
	}

	return;
}

/*
	Draw the top 10 score onto the bitmap. Another
	crude hack. :)
*/
void hiscore_draw(BITMAP *bmp, int x, int y)
{
	static int hiscore_timer = 0;
	static int over=0, dir=1;
	int i,c;
	if (hiscore_timer < timestamp)
	{
		over += dir;
		if (over == 0 || over == 9) dir = -dir;	
		hiscore_timer = timestamp + SECOND/2;
	}
	acquire_bitmap(bmp);		
	for (i=0; i!=10; i++)
	{		
		c = 196 / (abs(i - over)+1);		
		textprintf(bmp, (FONT*)datafile[FONT_C64].dat, x+0, y+i*32, makecol(c,c,c), "%2i: %-20s%5i", i+1, high_name[i], high_score[i]);
	}
	release_bitmap(bmp);	
		
}

/*
	Loads the highscore from a file. If it's not found,
	it makes one up.
*/
void hiscore_load(char *filename)
{
	PACKFILE *pf;

	if ( (pf = pack_fopen(filename, "rp")) )
	{
		/* read from file */
		pack_fread(high_name, sizeof(high_name), pf);
		pack_fread(high_score, sizeof(high_score), pf);		
		pack_fclose(pf);
	}
	else
	{
		/* crazy way to fulfill the requirement */
		strcpy(high_name[0], "GIVE PEACE A CHANCE");
		strcpy(high_name[1], "GIVE PEACE A CHANCE");
		strcpy(high_name[2], "GIVE PEACE A CHANCE");
		strcpy(high_name[3], "GIVE PEACE A CHANCE");
		strcpy(high_name[4], "GIVE PEACE A CHANCE");
		strcpy(high_name[5], "GIVE PEACE A CHANCE");
		strcpy(high_name[6], "GIVE PEACE A CHANCE");
		strcpy(high_name[7], "GIVE PEACE A CHANCE");
		strcpy(high_name[8], "GIVE PEACE A CHANCE");
		strcpy(high_name[9], "GIVE PEACE A CHANCE");

		high_score[0] = 11000;
		high_score[1] = 9000;
		high_score[2] = 7200;
		high_score[3] = 5600;		
		high_score[4] = 4200;
		high_score[5] = 3000;
		high_score[6] = 2000;
		high_score[7] = 1200;
		high_score[8] = 600;
		high_score[9] = 200;
	}
}

/* 
	Saves the hiscores to a compressed packfile.
*/
void hiscore_save(char *filename)
{
	PACKFILE *pf;

	if ( (pf = pack_fopen(filename, "wp")) )
	{
		pack_fwrite(high_name, sizeof(high_name), pf);
		pack_fwrite(high_score, sizeof(high_score), pf);
		pack_fclose(pf);
	}	
}

