#ifndef _GFX_H_
#define _GFX_H_

#include <allegro.h>

#define GFX_NONE          (0)
#define GFX_DOUBLE_BUFFER (1)
#define GFX_PAGE_FLIP     (2)

extern char *gfx_name[];

typedef struct GFX
{
	BITMAP **pages;
	BITMAP *buffer;
	int num_pages;
	int type;
	int current_page;
} GFX;

GFX *gfx_create(int type);
void gfx_destroy(GFX *gfx);
void gfx_frame_start (GFX *gfx);
void gfx_frame_end (GFX *gfx);
void gfx_switch_type (GFX **gfx, int type);

#endif
