/* GIVE PEACE A CHANCE */

/*
	gfx.c

	This is a graphics engine capable of a couple different
	rendering styles. It can also swap out on the fly, but
	could be very buggy, I dunno.

	Perhaps of all the modules, this is the most over-zealous.
	Considering there is only need for one "gfx_engine", the
	create, destroy, etc functions are abit much. But I was
	in the module mood.
*/

#include <allegro.h>

#include "main.h"

#include "gfx.h"

char *gfx_name[] = {"NONE", "DOUBLE BUFFER", "PAGE FLIP"};

/*
	Creates the graphics engine. You must pass the type
	of updating you would like.

	This could use a lot of error handling!
*/
GFX *gfx_create(int type)
{
	GFX *gfx = malloc(sizeof(GFX));
	int error = 0;

	gfx->type = type;
	
	switch (type)
	{
		case GFX_DOUBLE_BUFFER:
			gfx->pages = malloc(sizeof(BITMAP*));
			gfx->num_pages = 1;
			gfx->pages[0] = create_bitmap(SCREEN_W, SCREEN_H);
			gfx->buffer = gfx->pages[0];
			gfx->current_page = 0;
			
			if (!gfx->pages[0]) error = 1;
		break;

		case GFX_PAGE_FLIP:
			gfx->pages = malloc(sizeof(BITMAP*)*2);
			gfx->num_pages = 2;
			gfx->pages[0] = create_video_bitmap(SCREEN_W, SCREEN_H);
			gfx->pages[1] = create_video_bitmap(SCREEN_W, SCREEN_H);
			gfx->buffer = gfx->pages[0];
			gfx->current_page = 0;

			if (!gfx->pages[0] || !gfx->pages[1]) error = 1;
		break;

		default:
			gfx->num_pages = 0;
			gfx->pages = 0;
		break;
	}

	if (error)
	{
		gfx_destroy(gfx);
		gfx = 0;
	}
	
	return gfx;
}

/*
	Destroys the engine and frees all memory from the bitmaps
*/
void gfx_destroy(GFX *gfx)
{
	if (gfx)
	{
		if (gfx->pages)
		{
			while (--gfx->num_pages >= 0)			
				if (gfx->pages[gfx->num_pages]) destroy_bitmap(gfx->pages[gfx->num_pages]);			
			free(gfx->pages);
			gfx->pages = 0;
		}
		free(gfx);		
	}
}

/*
	This needs to be called before you draw any graphics to aa
	new frame.
*/
void gfx_frame_start (GFX *gfx)
{
	switch (gfx->type)
	{
		case GFX_DOUBLE_BUFFER:
			clear(gfx->buffer);
		break;

		case GFX_PAGE_FLIP:
			clear(gfx->buffer = gfx->pages[gfx->current_page = 1 - gfx->current_page]);
		break;
	}
}

/*
	This draws the graphics to the screen.
*/
void gfx_frame_end (GFX *gfx)
{
	switch (gfx->type)
	{
		case GFX_DOUBLE_BUFFER:
			acquire_screen();
			blit(gfx->buffer, screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
			release_screen();			
		break;

		case GFX_PAGE_FLIP:
			show_video_bitmap(gfx->buffer);			
		break;
	}
}

/*
	This is a useful function, but is very ugly, and perhaps buggy.
	It lets you switch between different types of updating on the fly.
*/
void gfx_switch_type (GFX **gfx, int type)
{
	BITMAP *bmp_temp;
	switch ((*gfx)->type)
	{
		case GFX_DOUBLE_BUFFER:			
			bmp_temp = create_bitmap(SCREEN_W, SCREEN_H);
			blit((*gfx)->buffer, bmp_temp, 0,0, 0,0, SCREEN_W, SCREEN_H);
			gfx_destroy(*gfx);

			if (!(*gfx = gfx_create(type)))
			{
				allegro_message("Unable to swap!");
				exit(1);
			}
			gfx_frame_start(*gfx);
			blit(bmp_temp, (*gfx)->buffer, 0,0 ,0,0, SCREEN_W, SCREEN_H);
			gfx_frame_end(*gfx);
			destroy_bitmap(bmp_temp);
		break;

		case GFX_PAGE_FLIP:
			bmp_temp = create_bitmap(SCREEN_W, SCREEN_H);
			blit((*gfx)->buffer, bmp_temp, 0,0, 0,0, SCREEN_W, SCREEN_H);
			gfx_destroy(*gfx);
			show_video_bitmap(screen);

			if (!(*gfx = gfx_create(type)))
			{
				allegro_message("Unable to swap!");
				exit(1);
			}
			gfx_frame_start(*gfx);
			blit(bmp_temp, (*gfx)->buffer, 0,0 ,0,0, SCREEN_W, SCREEN_H);
			gfx_frame_end(*gfx);
			destroy_bitmap(bmp_temp);
		break;
	}

	return;
}

