#ifndef _GFX_H_
#define _GFX_H_

#include <allegro.h>

#define GFX_NONE             (0)
#define GFX_DOUBLE_BUFFER    (1)
#define GFX_SCREEN_BUFFER    (2)
#define GFX_PAGE_FLIP        (3)
#define GFX_TRIPLE_BUFFER    (4)
#define GFX_DIRTY_RECTANGLES (5)

extern char *gfx_name[];

/* dirty rectangle stuff */

#define GFX_MAX_DIRTY      (100) 

typedef struct GFX_DIRTY_RECTANGLE
{
	int x, y;
	int w, h;
} GFX_DIRTY_RECTANGLE;

typedef struct GFX_DIRTY_LIST
{
	int count;
	GFX_DIRTY_RECTANGLE rect[GFX_MAX_DIRTY];
} GFX_DIRTY_LIST;

typedef struct GFX
{
	BITMAP **pages;
	BITMAP *buffer;
	int num_pages;
	int type;
	int current_page;

	GFX_DIRTY_LIST *dirty, *old_dirty;	
} GFX;

void gfx_add_dirt(GFX_DIRTY_LIST *list, int x, int y, int w, int h);
GFX *gfx_create(int type);
void gfx_destroy(GFX *gfx);
void gfx_frame_start (GFX *gfx);
void gfx_frame_end (GFX *gfx);
int gfx_switch_type (GFX **gfx, int type);

#endif
