/* GIVE PEACE A CHANCE */

/*
	gfx.c

	This is a graphics engine capable of a couple different
	rendering styles. It can also swap out on the fly, but
	could be very buggy, I dunno.

	Perhaps of all the modules, this is the most over-zealous.
	Considering there is only need for one "gfx_engine", the
	create, destroy, etc functions are abit much. But I was
	in the module mood.
*/

#include <memory.h>
#include <allegro.h>

#include "main.h"

#include "gfx.h"

char *gfx_name[] = {
     "NONE",
     "DOUBLE BUFFER",
     "SCREEN BUFFER",
     "PAGE FLIP",
     "TRIPLE BUFFER",
     "DIRTY RECTANGLES"
};

/* 
	adds a new screen area to the dirty rectangle list 
*/
void gfx_add_dirt(GFX_DIRTY_LIST *list, int x, int y, int w, int h)
{
	if (list)
	{
		list->rect[list->count].x = x;
		list->rect[list->count].y = y;
		list->rect[list->count].w = w;
		list->rect[list->count].h = h;
		list->count++; 
	}

   return;
}
 
/*
	Creates the graphics engine. You must pass the type
	of updating you would like.

	This could use a lot of error handling!
*/
GFX *gfx_create(int type)
{
	GFX *gfx = malloc(sizeof(GFX));
	int error = (gfx_driver->windowed && (type != GFX_DOUBLE_BUFFER && type != GFX_DIRTY_RECTANGLES));
	
	gfx->type = type;	
	gfx->dirty = 0;
	gfx->old_dirty = 0;
	
	switch (type)
	{
 		case GFX_DOUBLE_BUFFER:
			gfx->pages = malloc(sizeof(BITMAP*));
			gfx->num_pages = 1;
			gfx->pages[0] = create_bitmap(SCREEN_W, SCREEN_H);
			gfx->buffer = gfx->pages[0];
			gfx->current_page = 0;
			if (!gfx->pages[0]) error = 1;
		break;

		case GFX_SCREEN_BUFFER:
			gfx->pages = malloc(sizeof(BITMAP*) * 2);
			gfx->num_pages = 2;
			gfx->pages[0] = create_video_bitmap(SCREEN_W, SCREEN_H);
			gfx->pages[1] = create_video_bitmap(SCREEN_W, SCREEN_H);
            show_video_bitmap(gfx->pages[0]);
			gfx->buffer = gfx->pages[1];
			gfx->current_page = 0;
			if (!gfx->pages[0] || !gfx->pages[1]) error = 1;
		break;

		case GFX_PAGE_FLIP:			
			gfx->pages = malloc(sizeof(BITMAP*)*2);
			gfx->num_pages = 2;
			gfx->pages[0] = create_video_bitmap(SCREEN_W, SCREEN_H);
			gfx->pages[1] = create_video_bitmap(SCREEN_W, SCREEN_H);
			gfx->buffer = gfx->pages[0];
			gfx->current_page = 0;

			if (!gfx->pages[0] || !gfx->pages[1]) error = 1;
		break;

		case GFX_TRIPLE_BUFFER:
			if (!(gfx_capabilities && GFX_CAN_TRIPLE_BUFFER))
				enable_triple_buffer();
			if (!(gfx_capabilities && GFX_CAN_TRIPLE_BUFFER))
			{
				gfx_destroy(gfx);
				return 0;
			}
			gfx->pages = malloc(sizeof(BITMAP*)*3);
			gfx->num_pages = 3;
			gfx->pages[0] = create_video_bitmap(SCREEN_W, SCREEN_H);
			gfx->pages[1] = create_video_bitmap(SCREEN_W, SCREEN_H);
			gfx->pages[2] = create_video_bitmap(SCREEN_W, SCREEN_H);
			gfx->buffer = gfx->pages[0];
			gfx->current_page = 0;
		break;

        case GFX_DIRTY_RECTANGLES:
             gfx->pages = malloc(sizeof(BITMAP*)*1);
			 gfx->num_pages = 1;
             gfx->pages[0] = create_bitmap(SCREEN_W,SCREEN_H);
             gfx->buffer = gfx->pages[0];
             gfx->current_page = 0;

			 gfx->dirty = malloc(sizeof(GFX_DIRTY_LIST));
			 gfx->dirty->count = 0;
			 gfx->old_dirty = malloc(sizeof(GFX_DIRTY_LIST));			 
			 gfx->old_dirty->count = 0;
        break;

		default:
			gfx->num_pages = 0;
			gfx->pages = 0;
		break;
	}

	if (error)
	{
		gfx_destroy(gfx);
		gfx = 0;
	}
	
	return gfx;
}

/*
	Destroys the engine and frees all memory from the bitmaps
*/
void gfx_destroy(GFX *gfx)
{	
	if (gfx)
	{		
		if (gfx->pages)
		{
			while (--gfx->num_pages >= 0)			
				if (gfx->pages[gfx->num_pages]) destroy_bitmap(gfx->pages[gfx->num_pages]);			
			free(gfx->pages);
			gfx->pages = 0;
		}

		if (gfx->dirty) free(gfx->dirty);
		if (gfx->old_dirty) free(gfx->old_dirty);

		free(gfx);		
	}
}

/*
	This needs to be called before you draw any graphics to aa
	new frame.
*/
void gfx_frame_start (GFX *gfx)
{
	int c;

	switch (gfx->type)
	{
		case GFX_DOUBLE_BUFFER:
        case GFX_SCREEN_BUFFER:
			clear(gfx->buffer);
		break;

		case GFX_PAGE_FLIP:
			clear(gfx->buffer = gfx->pages[gfx->current_page = 1 - gfx->current_page]);
		break;

		case GFX_TRIPLE_BUFFER:
			if (++gfx->current_page == 3) gfx->current_page = 0;			
			clear(gfx->buffer = gfx->pages[gfx->current_page]);
		break;

		case GFX_DIRTY_RECTANGLES:
		{
			GFX_DIRTY_LIST *temp_list;			
			
			for (c=0; c<gfx->dirty->count; c++)
			{
				if ((gfx->dirty->rect[c].w == 1) && (gfx->dirty->rect[c].h == 1))
				{
					putpixel(gfx->buffer, gfx->dirty->rect[c].x, gfx->dirty->rect[c].y, 0);
				}
				else 
				{
					rectfill(
						gfx->buffer, 
						gfx->dirty->rect[c].x, gfx->dirty->rect[c].y, 
						gfx->dirty->rect[c].x + gfx->dirty->rect[c].w, 
						gfx->dirty->rect[c].y+  gfx->dirty->rect[c].h, 0
					);
				}
			}
			
			//memcpy(gfx->old_dirty, gfx->dirty, sizeof(*(gfx->dirty)));			

			temp_list = gfx->old_dirty;
			gfx->old_dirty = gfx->dirty;
			gfx->dirty = temp_list;
			gfx->dirty->count = 0;
		}
		break;
	}
}

/*
	This draws the graphics to the screen.
*/
void gfx_frame_end (GFX *gfx)
{
	int c;

	switch (gfx->type)
	{
		case GFX_DOUBLE_BUFFER:
        case GFX_SCREEN_BUFFER:
			acquire_screen();
			blit(gfx->buffer, screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
			release_screen();			
		break;

		case GFX_PAGE_FLIP:			
			show_video_bitmap(gfx->buffer);			
		break;

		case GFX_TRIPLE_BUFFER:
			while (poll_scroll());
			request_video_bitmap(gfx->buffer);
		break;

		case GFX_DIRTY_RECTANGLES:
			/* for dirty rectangle animation, only copy the areas that changed */
			for (c=0; c<gfx->dirty->count; c++)
				gfx_add_dirt(gfx->old_dirty, gfx->dirty->rect[c].x, gfx->dirty->rect[c].y, gfx->dirty->rect[c].w, gfx->dirty->rect[c].h);

			/* sorting the objects really cuts down on bank switching */
			//if (!gfx_driver->linear)
			//	qsort(old_dirty.rect, old_dirty.count, sizeof(DIRTY_RECT), rect_cmp);

			acquire_screen();

			for (c=0; c<gfx->old_dirty->count; c++) {
				if ((gfx->old_dirty->rect[c].w == 1) && (gfx->old_dirty->rect[c].h == 1))
				{
					putpixel(screen, gfx->old_dirty->rect[c].x, gfx->old_dirty->rect[c].y, 
					getpixel(gfx->buffer, gfx->old_dirty->rect[c].x, gfx->old_dirty->rect[c].y));
				}
				else 
				{
					blit(gfx->buffer, screen, gfx->old_dirty->rect[c].x, gfx->old_dirty->rect[c].y, 
					gfx->old_dirty->rect[c].x, gfx->old_dirty->rect[c].y, 
					gfx->old_dirty->rect[c].w, gfx->old_dirty->rect[c].h);
				}
			}
			release_screen();
		break;
	}
}

/*
	This is a useful function, but is very ugly, and perhaps buggy.
	It lets you switch between different types of updating on the fly.
*/
int gfx_switch_type (GFX **gfx, int type)
{
	BITMAP *bmp_temp;

	if (type == (*gfx)->type) return 0;

	bmp_temp = create_bitmap(SCREEN_W, SCREEN_H);
	/* try to save the screen contents if memory is available */
	if (bmp_temp)	
		blit((*gfx)->buffer, bmp_temp, 0,0, 0,0, SCREEN_W, SCREEN_H);
	
	/* make sure we are currently on the first page of video memory */
	while ((*gfx)->current_page != 0)
		gfx_frame_start(*gfx);

	if ((*gfx)->type == GFX_SCREEN_BUFFER || (*gfx)->type == GFX_PAGE_FLIP || (*gfx)->type == GFX_TRIPLE_BUFFER)
		show_video_bitmap(screen);

	gfx_destroy(*gfx);
	
	if (!(*gfx = gfx_create(type)))
	{
		return 1;	
	}

	if (bmp_temp)
	{
		gfx_frame_start(*gfx);
		blit(bmp_temp, (*gfx)->buffer, 0,0 ,0,0, SCREEN_W, SCREEN_H);
		gfx_frame_end(*gfx);
		destroy_bitmap(bmp_temp);
	}

	return 0;
}

