#include <allegro.h>

#include "main.h"
#include "player.h"
#include "input.h"
#include "settings.h"

SETTINGS settings;

void settings_load()
{
	settings.gfx_type = get_config_int("GFX", "engine", GFX_DOUBLE_BUFFER); 		
	settings.windowed = get_config_int("GFX", "windowed", 0);
	settings.input_handler = get_config_int("INPUT", "handler", HANDLER_KEYBOARD);
	settings.input_device = get_config_int("INPUT", "device", 0);
}

void settings_save()
{
	if (gfx_engine)
	{
		set_config_int("GFX", "engine", gfx_engine->type);
		set_config_int("GFX", "windowed", gfx_driver->windowed);
	}

	if (player && player->ih)
	{
		set_config_int("INPUT", "handler", player->ih->type);
		set_config_int("INPUT", "device", player->ih->device);
	}
}