/* GIVE PEACE A CHANCE */

/*
	rain.c

	Those little rain drops deserve their own file, right? :)
	The rain drops are stored via a linked list. I hope I
	did everything right...
*/

#include <allegro.h>

#include "main.h"
#include "data.h"
#include "game.h"
#include "gfx.h"
#include "player.h"
#include "rain.h"

RAIN_DROP *rain_drop_list = 0;
int rain_drops_count = 0;
int rain_drop_die = 386;

/*
	Adds another rain drop to the "list"	
*/
void rain_drop_add()
{
	RAIN_DROP *rd = malloc(sizeof(RAIN_DROP));

	rd->x = (rand() % 600) + 8;
	rd->y = 0;

	rd->next = rain_drop_list;
	rain_drop_list = rd;
	rain_drops_count++;

	return;
}

/*
	Initializes the linked list	
*/

void rain_drop_create()
{
	rain_drop_list = 0;	
	rain_drops_count = 0;
	return;
}

/*
	Destroys the rain drop list and frees memory	
*/
void rain_drop_destroy()
{
	RAIN_DROP *tmp;
	
	while (rain_drop_list)
	{
		tmp = rain_drop_list;		
		rain_drop_list = rain_drop_list->next;
		free(tmp);		
	}

	return;
}


/*
	Draws a list of rain drop onto the bitmap
*/
void rain_drop_draw(BITMAP *bmp)
{
	RAIN_DROP *rd = rain_drop_list;
	while (rd)
	{
		if (gfx_engine->dirty) 
			gfx_add_dirt(gfx_engine->dirty, rd->x, rd->y, ((RLE_SPRITE*)datafile[RLE_DRIP].dat)->w, ((RLE_SPRITE*)datafile[RLE_DRIP].dat)->h);
		draw_rle_sprite(bmp, (RLE_SPRITE*)datafile[RLE_DRIP].dat, rd->x, rd->y);
		rd = rd->next;
	}

	return;
}

/*
	Handles the raindrops 
*/
void rain_drop_update()
{
	RAIN_DROP **list = &rain_drop_list;
	RAIN_DROP *rd = *list;
	RAIN_DROP *tmp;

	while (rd) 
	{		
		rd->y += 2;

		if (rd->y > rain_drop_die-basement_drops*2 || (player->drops < 23 && rd->y >= player->y - 8 && rd->y <= player->y && rd->x >= player->x && rd->x <= player->x+player->sprite[0]->w)) 
		{
			play_sample((SAMPLE*)datafile[SAMP_DRIP_1+(rand()>>2)%6].dat, 128, 128, 1000 , 0);

			if (!(rd->y > rain_drop_die-basement_drops*2))
			{
				player->drops++;
				player->score += current_level * 10;
			}
			else if (basement_drops < MAX_MISSED_DROPS)
				basement_drops++;

			rain_drops_count--;
			

			*list = rd->next;
			tmp = rd;
			rd = rd->next;
			free(tmp);
		}
		else
		{
			list = &rd->next;
			rd = rd->next;
		}
	}

	return;
}

