#ifndef _PLAYER_H_
#define _PLAYER_H_

#include <allegro.h>
#include "input.h"



/*
	setup the PLAYER struct
*/
typedef struct PLAYER
{
	INPUT_HANDLER *ih; /* handles the input from joystick or keyboard */

	int x, y;          /* the locations of the race car on the map */
	int facing;        /* 0=left; 1=right; */
	int acceleration;  /* the number of pixels to skip */

	int drops;         /* number of drops in the bucket */

	int score;         /* the player's score */
	
	BITMAP **sprite;   /* an array of bitmaps that contain the car */
	int sprite_count;  /* the number of frames of sprites */
	int sprite_frame;  /* the current frame */
	int sprite_timer;  /* a simple countdown that affects how long the same frame is shown */

	int flag1,flag2;   /* temporary variables used by the game to store various things */
} PLAYER;

extern PLAYER *player;



PLAYER *player_create();
void player_destroy(PLAYER *p);
void player_draw(PLAYER *p, BITMAP *bmp);
void player_update(PLAYER *p);

#endif
