/* GIVE PEACE A CHANCE */

/*
	Flash Flood
	
	Copyright 2002 by Matthew Leverton
	
	Created for the Allegro Speedhack 2002, a 3-day code compo

	This was originally going to be a racing game, but I realized
	it wouldn't get done. So about 20 hours into the competition,
	it got switch to this. I figured they had similar gameplay.

	This makes use of a modified Allegro to use joystick rumble 
	effects, and the addon DUMB library for music. If you want
	to use the rumble effects, you'll need to #define RUMBLE
	to enable it. Similariliy, if you do not want to compile the
	support for DUMB, #define NO_DUMB.
	
	The source in this file can be re-used, modified, or whatever
	as long as you give credit. 
*/

/*
	main.c

	Timer routines, initializes allegro, and starts the game.

	Notes: You must #define RUMBLE in order to use the rumble
	driver. But as of now, you'll need to hack it into the
	Allegro 4 library to get it to work. I've got pre-compiled
	Windows versions of the game availble at my website. When
	creating the rumble version, I static link to avoid 
	distributing a modified DLL.
*/


#include <allegro.h>
#include <stdio.h>
#include <time.h>

#include "main.h"

#ifndef NO_DUMB
#include <aldumb.h>
#endif

#include "data.h"
#include "game.h"
#include "gfx.h"
#include "hiscore.h"
#include "input.h"
#include "player.h"
#include "rain.h"
#include "settings.h"
#include "textout.h"
#include "title.h"

#ifdef RUMBLE
FFEFFECT **ff_effect_a;
int *joy_can_rumble;
#endif

GFX *gfx_engine = 0;


/* timer stuff */
volatile int game_timer = 0;
volatile int timestamp = 0;
#ifdef _DEBUG
volatile int fps = 0;
volatile int fps_running = 0;
volatile int fps_counter = 0;
#endif

void game_timer_proc(void)
{
	game_timer++;
	timestamp++;
#ifdef _DEBUG
	if (fps_counter++ >= SECOND)
	{
		fps = fps_running;
		fps_counter = fps_running = 0;
	}
#endif
}
END_OF_FUNCTION(game_timer_proc);

/* this is called if the user presses the X to close the window */
volatile int end_game = 0;
void user_wants_out(void) 
{
	end_game = 1;
}
END_OF_FUNCTION(user_wants_out);

/* it all begins here */
int main (void)
{
	int depths[] = {8, 16, 0};
	int color_depth;
	int i = 0;

	allegro_init();
	
	set_config_file("ff.ini");
	set_window_title("Flash Flood");
	set_window_close_hook(&user_wants_out);

	install_timer();
	install_keyboard();
	install_joystick(JOY_TYPE_AUTODETECT);
	install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);

#ifndef NO_DUMB
	dumb_register_dat_it(DUMB_DAT_IT);
#endif

#ifdef RUMBLE
	/* setup the rumble joysticks and create special effects */
	if (num_joysticks)
	{
		joy_can_rumble = malloc(sizeof(int) * num_joysticks);
		ff_effect_a = malloc(sizeof(FFEFFECT*) * num_joysticks);

		for (i=0; i<num_joysticks; i++)
		{
			if ((joy_can_rumble[i] = ff_joystick_has(i)))
			{				
				ff_effect_a[i] = ff_create_effect();
				ff_make_periodic_effect(i, ff_effect_a[i]);				
			}
			else
			{
				ff_effect_a[i] = 0;
			}

		}
	}
	else
		joy_can_rumble = 0;

	i = 0;
#endif

	/* 
		sort through the available color depths 
		Note, this was going to be different game running under
		hicolor - I never bothered removing the code.
	*/	

	settings_load();

	while ((color_depth = depths[i++]))
	{
		if (color_depth == -1) color_depth = desktop_color_depth();
		set_color_depth(color_depth);
		if (!set_gfx_mode(settings.windowed ? GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT, 640, 480, 0, 0)) break;
	}
	
	if (!color_depth)
	{		
		allegro_message("Unable to set a graphic mode\n%s\n", allegro_error);
		return 1;
	}

	/* load the data file ;) */
	if (!(datafile = load_datafile("data.dat")))
	{
		allegro_message("Sorry, but the datafile (data.dat) looks corrupted!");
		exit(1);
	};

	/* set the 8-bit palette */
	set_palette((RGB *)datafile[PAL_GAME].dat);

	/* create the player(s) - this is for demo purposes right now */	
	player = player_create();
	player->sprite = malloc(sizeof(BITMAP *)  * 2);
	player->sprite[0] = create_bitmap( ((BITMAP *)datafile[BMP_CHRIS_1].dat)->w, ((BITMAP *)datafile[BMP_CHRIS_1].dat)->h );	
	player->sprite[1] = create_bitmap( ((BITMAP *)datafile[BMP_CHRIS_1].dat)->w, ((BITMAP *)datafile[BMP_CHRIS_1].dat)->h );	
	blit((BITMAP *)datafile[BMP_CHRIS_1].dat, player->sprite[0], 0,0, 0,0, player->sprite[0]->w, player->sprite[0]->h);
	blit((BITMAP *)datafile[BMP_CHRIS_2].dat, player->sprite[1], 0,0, 0,0, player->sprite[0]->w, player->sprite[0]->h);
	
	player->sprite_count = 2;

	/* set up the input handler */
	if (settings.input_handler == HANDLER_JOYSTICK && num_joysticks > settings.input_device)
		player->ih = input_handler_create(HANDLER_JOYSTICK, settings.input_device);
	else
		player->ih = input_handler_create(HANDLER_KEYBOARD, 0);
	

	/* set up the timer */
	LOCK_VARIABLE(end_game);
	LOCK_FUNCTION(user_wants_out);
	LOCK_VARIABLE(game_timer);
	LOCK_FUNCTION(game_timer_proc);

#ifdef _DEBUG
	LOCK_VARIABLE(fps);
	LOCK_VARIABLE(fps_running);
	LOCK_VARIABLE(fps_counter);
#endif

	install_int_ex(game_timer_proc, BPS_TO_TIMER(SECOND));

	/* I think this should be plenty random enough :P */
	srand(time(0));

	if ((gfx_engine = gfx_create(settings.gfx_type)))
	{	
		hiscore_load("score");
		while (!end_game)
		{
			if (title_screen())
			{
				play_game();		
				hiscore_save("score");
			}
		}

		settings_save();		
		
		gfx_destroy(gfx_engine);		
	}
	else
	{
		set_gfx_mode(GFX_TEXT, 0,0,0,0);
		allegro_message("Unable to initialize graphics.");
	}

	/* clean up */
	player_destroy(player);

   
#ifndef NO_DUMB
	dumb_exit();
#endif
	
#ifdef RUMBLE
	for (i=0; i<num_joysticks; i++)
	{
		if (ff_effect_a[i]) ff_destroy_effect(ff_effect_a[i]);		
	}
	free(joy_can_rumble);
#endif

	unload_datafile(datafile);

	set_gfx_mode(GFX_TEXT, 0,0,0,0);
	allegro_message("Thanks for playing.\n\nThis game was created for a 3-day competition called the SpeedHack.\n\nWritten by Matthew Leverton\nmatthew@leverton.cc\nhttp://www.leverton.cc");
	
	return 0;
}
END_OF_MAIN();

