#ifndef _INPUT_H_
#define _INPUT_H_

#include <allegro.h>

#define HANDLER_NONE     (0)
#define HANDLER_KEYBOARD (1)
#define HANDLER_JOYSTICK (2)
#define HANDLER_LOG      (3)
#define HANDLER_CPU      (4)

#define MAX_INPUTS   (6)

#define IH_UP       (0)
#define IH_DOWN     (1)
#define IH_LEFT     (2)
#define IH_RIGHT	(3)
#define IH_BUTTON_A	(4)
#define IH_BUTTON_B	(5)

#define IH_STATUS_UP       (0)
#define IH_STATUS_PRESSED  (1)
#define IH_STATUS_DOWN     (2)
#define IH_STATUS_RELEASED (3)


typedef struct INPUT_HANDLER
{
	int type; /* see HANDLER_* macros */
	
	int device; /* only useful for joystick */

	int down[MAX_INPUTS];
	int status[MAX_INPUTS];
	int map[MAX_INPUTS];

	PACKFILE *log;
	void (*cpu_proc)(int *);

} INPUT_HANDLER;



INPUT_HANDLER *input_handler_create(int type, int device);
void input_handler_destroy(INPUT_HANDLER *ih);
void input_handler_log(INPUT_HANDLER *ih, char *filename);
void input_handler_poll(INPUT_HANDLER *ih);


#endif
