
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <allegro.h>

/****************************************************************************/

#define WINDOWS                      TRUE  
#define TAMANHO_INICIAL                 5 
#define MAXIMO_COMIDA                  10
#define RESOLUCAO_X                   640
#define RESOLUCAO_Y                   480
#define INFINITO                     8000
#define NUMERO_ESTRELAS               300
#define FUNDOS                          2
#define TAMANHO_QUADRADO               20

/****************************************************************************/

#define ACERTOU                      ( (SAMPLE *) arquivo [ 0].dat )
#define FOTO_BORDA                   ( (BITMAP *) arquivo [ 1].dat )
#define FOTO_COBRA                   ( (BITMAP *) arquivo [ 2].dat ) 
#define FOTO_FRUTA                   ( (BITMAP *) arquivo [ 3].dat ) 
#define FOTO_FUNDO                   ( (BITMAP *) arquivo [ 4].dat )
#define FOTO_PORTAL                  ( (BITMAP *) arquivo [ 5].dat )
#define MORREU1                      ( (SAMPLE *) arquivo [ 6].dat )
#define MORREU2                      ( (SAMPLE *) arquivo [ 7].dat )
#define MUSICA                       ( (MIDI *)   arquivo [ 8].dat )
#define PALETA                       ( (RGB *)    arquivo [ 9].dat )
#define VORTEX                       ( (SAMPLE *) arquivo [10].dat )

/****************************************************************************/

struct cobra

       {

       int    x;
       int    y;
       struct cobra *proximo;

       };

struct coordenada

       {

       int x, y;

       };


enum    { esquerda, direita, cima, baixo };

struct   cobra *inicio = NULL, *ultimo = NULL;
struct   coordenada comida [MAXIMO_COMIDA], portal;
BITMAP   *buffer, *fundo [FUNDOS];
DATAFILE *arquivo = NULL;
int      tamanho_cobra, tempo, pontos, maximo_pontos, y [FUNDOS], tamanho_execucao, milesimos = 0, sair = FALSE;

/****************************************************************************/

void inicializa_allegro ();
void inicializa_jogo    ();
void le_score           ();
void grava_score        ();
void gera_comida        (int ponto);
void gera_portal        ();
void jogar              ();
void movimenta          (int nova_direcao);
int  suicidio           ();
int  verifica_colisao   ();
void aumenta_cobra      (int numero_vezes);
int  entrou_portal      ();
void muda_posicao       (int novo_portal);
void recomeca_jogo      ();
void tempo_jogo         ();
void milesimos_passados ();
int  pause              ();
void atualiza           ();
int  colisao            (BITMAP *bmp1, int x1, int y1, BITMAP *bmp2, int x2, int y2);
int  colisao_portal     (BITMAP *bmp, int x_bmp, int y_bmp);
void finaliza           ();
void fechar_janela      ();

/****************************************************************************/

int main ()

{

inicializa_allegro ();
inicializa_jogo    ();

do

      jogar ();

while (! key [KEY_ESC] && sair == FALSE);


finaliza ();


return (0);

}

END_OF_MAIN ();

/****************************************************************************/

void tempo_jogo ()

{

tempo++;

}

END_OF_FUNCTION (tempo_jogo);

/****************************************************************************/

void milesimos_passados ()

{

milesimos++;

}

END_OF_FUNCTION (milesimos_passados);

/****************************************************************************/

void le_score ()

{

FILE *score;
int  pontuacao_arquivo = 0;


score = fopen ("cobra.hi", "r"); 


if (score != NULL)  // quer dizer que o arquivo existe e no est vazio
                                 
   {

   fscanf (score, "%d", &pontuacao_arquivo);
   
   maximo_pontos = pontuacao_arquivo;
   
   fclose (score);
   
   }
   
else

   maximo_pontos = 0;
      
}

/****************************************************************************/


void inicializa_allegro ()

{

int i;

srand ( time (0) );  //  o mesmo que o randomize () do turbo c


le_score ();  // le o arquivo cobra.hi para pegar o score contido l


allegro_init ();

install_keyboard ();
install_timer    ();

set_color_depth (8);


if (WINDOWS == TRUE)

   set_gfx_mode (GFX_AUTODETECT_WINDOWED, RESOLUCAO_X, RESOLUCAO_Y, 0, 0);
   
else

   set_gfx_mode (GFX_AUTODETECT, RESOLUCAO_X, RESOLUCAO_Y, 0, 0);


set_window_title      ("Space Cobra");
set_window_close_hook (fechar_janela);  // no caso de apertar o "x" de fechar


install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

buffer = create_bitmap (RESOLUCAO_X, RESOLUCAO_Y);


for (i = 0; i < FUNDOS; i++)

    {

    fundo [i] = create_bitmap (RESOLUCAO_X, RESOLUCAO_Y);

    clear (fundo [i]);

    }


clear (buffer);
clear (screen);


arquivo = load_datafile ("cobra.dat");

if (arquivo == NULL)

   {

   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);

   allegro_message ("O arquivo \"cobra.dat\" nao foi encontrado.   ");
   
   exit (1);
   
   }


set_palette (PALETA);

set_volume (128, 200);
play_midi  (MUSICA, TRUE);

LOCK_VARIABLE (tempo);
LOCK_FUNCTION (tempo_jogo);
install_int   (tempo_jogo, 1000);

LOCK_VARIABLE (milesimos);
LOCK_FUNCTION (milesimos_passados);
install_int   (milesimos_passados, 1);

}

/****************************************************************************/

void inicializa_jogo ()

{

int    i, j, dx, dy;
struct cobra *aux;


aux = (struct cobra *) malloc ( sizeof (struct cobra) );


inicio = ultimo = aux;

(inicio -> proximo) = NULL;
(inicio -> x)       = 0;
(inicio -> y)       = 12 * (FOTO_BORDA -> h);

tamanho_cobra    = 1;
tamanho_execucao = 1;

for (i = 0; i < MAXIMO_COMIDA; i++)

    {
   
    comida [i].x = INFINITO;
    comida [i].y = INFINITO;
      
    }


gera_portal ();


for (i = 0; i < MAXIMO_COMIDA; i++)

    gera_comida (i);


aumenta_cobra (TAMANHO_INICIAL - 1);

pontos = 0;


for (i = 0; i < FUNDOS; i++)

    {

    for (j = 1; j <= NUMERO_ESTRELAS - (25 * i); j++)

        {

        dx = rand () % RESOLUCAO_X;
        dy = rand () % RESOLUCAO_Y;

        putpixel (fundo [i], dx, dy, 255);

        }

    y [i] = 0;

    }


atualiza ();

set_palette (black_palette);

rest (100);

fade_in (PALETA, 1);

tempo = 0;

}

/****************************************************************************/

void gera_comida (int ponto)

{

struct cobra *i;
int    repete, contador, erro = 0;


do
      {

      comida [ponto].x =     (FOTO_BORDA -> w) + rand () % (RESOLUCAO_X - 2 * (FOTO_BORDA -> w) );
      comida [ponto].y = 2 * (FOTO_BORDA -> h) + rand () % (RESOLUCAO_Y - 3 * (FOTO_BORDA -> h) );
      
      repete = FALSE;
      
      
      if (comida [ponto].x % TAMANHO_QUADRADO != 0 || comida [ponto].y % TAMANHO_QUADRADO != 0)
      
         {
         
         repete = TRUE;
         
         continue;
         
         }
     
      
      for ( i = inicio; i != NULL; i = (i -> proximo) )
      
          if (colisao (FOTO_FRUTA, comida [ponto].x, comida [ponto].y, FOTO_COBRA, i -> x, i -> y) == TRUE)
          
             {
             
             repete = TRUE; break;
             
             }
             
             
      for (contador = 0; contador < MAXIMO_COMIDA; contador++)
      
          if (contador != ponto)
          
             if (colisao (FOTO_FRUTA, comida [ponto].x, comida [ponto].y, FOTO_FRUTA, comida [contador].x, comida [contador].y) == TRUE)
             
                {
             
                repete = TRUE; break;
               
                }


      if (colisao (FOTO_FRUTA, comida [ponto].x, comida [ponto].y, FOTO_PORTAL, portal.x, portal.y) == TRUE)
      
         repete = TRUE;


      if (erro++ > 100)
      
         {
         
         comida [ponto].x = INFINITO / 10;
         comida [ponto].y = INFINITO / 10;

         repete = FALSE; 
         
         }

      }

while (repete == TRUE);

}

/****************************************************************************/

void gera_portal ()

{

struct cobra *i;
int    repete, contador;
int    centro_x_portal, centro_y_portal;

do    

      {

      portal.x = 150 + rand () % (RESOLUCAO_X - 300);
      portal.y = 150 + rand () % (RESOLUCAO_Y - 300);
      
      centro_x_portal = ( (2 * portal.x) + (FOTO_PORTAL -> w) ) / 2;
      centro_y_portal = ( (2 * portal.y) + (FOTO_PORTAL -> h) ) / 2;


      repete = FALSE;

      if ( (centro_x_portal - 9) % TAMANHO_QUADRADO != 0 || (centro_y_portal - 9) % TAMANHO_QUADRADO != 0 )
      
         {
         
         repete = TRUE;
         
         continue; 
         
         }

     
      for ( i = inicio; i != NULL; i = (i -> proximo) )

          if (colisao (FOTO_COBRA, i -> x, i -> y, FOTO_PORTAL, portal.x, portal.y) == TRUE)

             {

             repete = TRUE; break;

             }
      
             
      for (contador = 0; contador < MAXIMO_COMIDA; contador++)
      
          if (colisao (FOTO_FRUTA, comida [contador].x, comida [contador].y, FOTO_PORTAL, portal.x, portal.y) == TRUE)

             {

             repete = TRUE; break;

             }
                                  
      }

while (repete == TRUE);

}

/****************************************************************************/

void jogar ()

{

if (pause () == FALSE)

   {
   
   movimenta (FALSE);


   if (suicidio () == TRUE)

      recomeca_jogo ();
   

   if (entrou_portal () == TRUE)

      muda_posicao (TRUE);

   
   if (verifica_colisao () == TRUE)
 
      aumenta_cobra (4);
      
   }


atualiza ();

}

/****************************************************************************/

void movimenta (int nova_direcao)

{

struct cobra *i;
static int direcao = direita, direcao_anterior = esquerda;
int    x_ant, y_ant, x_atual, y_atual, tecla;


if (nova_direcao == TRUE)

   {
   
   direcao          = direita;
   direcao_anterior = esquerda;   
   
   return;
   
   }


x_atual = (inicio -> x);
y_atual = (inicio -> y);


if ( (inicio -> x) <= RESOLUCAO_X && (inicio -> x) >= 0 &&
     (inicio -> y) <= RESOLUCAO_Y && (inicio -> y) >= 0 && (ultimo -> x) > 0  )

   while ( keypressed () )

         { 
      
         tecla = (readkey () >> 8); 
   
         if (tecla == KEY_LEFT  && direcao_anterior != direita)  direcao = esquerda;
         if (tecla == KEY_RIGHT && direcao_anterior != esquerda) direcao = direita;
         if (tecla == KEY_UP    && direcao_anterior != baixo)    direcao = cima;
         if (tecla == KEY_DOWN  && direcao_anterior != cima)     direcao = baixo;
         
         }
   

switch (direcao)

       {

       case esquerda:

                    (inicio -> x) -= (FOTO_COBRA -> w);

                    direcao_anterior = direcao;

                    break;


       case direita :

                    (inicio -> x) += (FOTO_COBRA -> w);

                    direcao_anterior = direcao;

                    break;


       case cima    :

                    (inicio -> y) -= (FOTO_COBRA -> w);

                    direcao_anterior = direcao;

                    break;


       case baixo   :

                    (inicio -> y) += (FOTO_COBRA -> w);

                    direcao_anterior = direcao;

                    break;

       }


for (i = (inicio -> proximo); i != NULL; i = (i -> proximo) )

    {

    x_ant = (i -> x);
    y_ant = (i -> y);

    (i -> x) =  x_atual;
    (i -> y) =  y_atual;

    x_atual = x_ant;
    y_atual = y_ant;

    }

}

/****************************************************************************/

int suicidio ()

{

struct cobra *i;

for ( i = (inicio -> proximo); i != NULL; i = (i -> proximo) )

    if ( (inicio -> x) == (i -> x) && (inicio -> y) == (i -> y) )

       {
       
       play_sample (MORREU2, 255, 128, 1000, FALSE);
       
       return (TRUE);
       
       }


if ( (inicio -> x) < (FOTO_BORDA -> w) || (inicio -> x) > ( RESOLUCAO_X - 2 * (FOTO_BORDA -> w) ) ||
     (inicio -> y) < (FOTO_BORDA -> h) || (inicio -> y) > ( RESOLUCAO_Y - 2 * (FOTO_BORDA -> h) ) )

   if ( (inicio -> x) >= -1 * (FOTO_BORDA -> w) && (inicio -> x) <= RESOLUCAO_X )
   
      if ( (inicio -> x) <= RESOLUCAO_X && (inicio -> x) > -2 * (FOTO_BORDA -> w) &&
           (inicio -> y) <= RESOLUCAO_Y && (inicio -> y) > -2 * (FOTO_BORDA -> h) )  

         {
      
         play_sample (MORREU1, 255, 128, 1000, FALSE);
      
         return (TRUE);
      
         }


return (FALSE);

}

/****************************************************************************/

int verifica_colisao ()

{

int i;

for (i = 0; i < MAXIMO_COMIDA; i++)

    if ( colisao (FOTO_COBRA, inicio -> x, inicio -> y, FOTO_FRUTA, comida [i].x, comida [i].y) == TRUE)

       {
       
       gera_comida (i);

       play_sample (ACERTOU, 255, 128, 1000, FALSE);

       return (TRUE);

       }


return (FALSE);

}

/****************************************************************************/

int entrou_portal ()

{

int entrou = FALSE;

if (colisao_portal (FOTO_COBRA, inicio -> x, inicio -> y) == TRUE && ( (ultimo -> x) != INFINITO && (ultimo -> y) != INFINITO) )

   {

   (inicio -> x) = INFINITO;
   (inicio -> y) = INFINITO;

   play_sample (VORTEX, 255, 128, 1000, FALSE);

   }


if ( (ultimo -> x) == INFINITO && (ultimo -> y) == INFINITO)

   entrou = TRUE;


return (entrou);

}

/****************************************************************************/

void muda_posicao (int novo_portal)

{

int centro_x_portal, centro_y_portal;


if (novo_portal == TRUE)

   gera_portal ();



centro_x_portal = ( (2 * portal.x) + (FOTO_PORTAL -> w) ) / 2;
centro_y_portal = ( (2 * portal.y) + (FOTO_PORTAL -> h) ) / 2;

(inicio -> x) =  centro_x_portal - 9;
(inicio -> y) =  centro_y_portal - 9;

}

/****************************************************************************/

void aumenta_cobra (int numero_vezes)

{

struct cobra *aux;
int    contador = 1;


do

      {

      aux = (struct cobra *) malloc ( sizeof (struct cobra) );

      (aux -> x) = (inicio -> x);
      (aux -> y) = (inicio -> y);

      (aux -> proximo) = inicio;

      inicio = aux;

      tamanho_cobra++;
      
      if (tamanho_cobra > maximo_pontos)
      
         maximo_pontos = tamanho_cobra;
         
      
      if (tamanho_cobra > tamanho_execucao)
      
         tamanho_execucao = tamanho_cobra; 
            
      
      contador++;

      }

while (contador <= numero_vezes);


pontos++;

}

/****************************************************************************/

void recomeca_jogo ()

{

struct cobra *i, *aux;


for (i = (inicio -> proximo), aux = i; i != NULL; i = aux )

    {

    aux = (i -> proximo);

    free (i);

    }


(inicio -> proximo) = NULL;
(inicio -> x)       =  0;
(inicio -> y)       = 12 * (FOTO_BORDA -> h);


ultimo = inicio;


tamanho_cobra = 1;

aumenta_cobra (TAMANHO_INICIAL - 1);

tempo = pontos = 0;

movimenta (TRUE);  // significa que a direco vai ser mudada 

}

/****************************************************************************/

void atualiza ()

{

struct cobra *i;
int    contador;
static int angulo1 = 10, angulo2 = 1, muro = 1;


if ( (inicio -> x) == 0 && (inicio -> y) == 12 * (FOTO_BORDA -> h) )
          
   muro = 1;
    

stretch_sprite (buffer, FOTO_FUNDO, FOTO_BORDA -> w, FOTO_BORDA -> h, RESOLUCAO_X - FOTO_BORDA -> w, RESOLUCAO_Y - FOTO_BORDA -> h);


textprintf (buffer, font,  40, 30, 25, "Tamanho maximo : %3d", maximo_pontos);
textprintf (buffer, font, 220, 30, 35, "Tamanho atual : %2d", tamanho_cobra);
textprintf (buffer, font, 390, 30, 45, "Pontos : %2d", pontos);
textprintf (buffer, font, 500, 30, 55, "Tempo : %02d:%02d", tempo / 60, tempo % 60);



for (contador = 0; contador < FUNDOS; contador++)

    {

    draw_sprite (buffer, fundo [contador], 0, y [contador]);
    draw_sprite (buffer, fundo [contador], 0, y [contador] - RESOLUCAO_Y);


    y [contador] += (contador + 1);


    if (y [contador] > RESOLUCAO_Y)

       y [contador] -= RESOLUCAO_Y;

    }

    
for ( contador = 0; contador <= RESOLUCAO_Y; contador += (FOTO_BORDA -> h) )

    {

    if ( contador != 12 * (FOTO_BORDA -> h) )
    
       draw_sprite (buffer, FOTO_BORDA, 0, contador);
       
    else
    
       if (tempo > 1)
       
          draw_sprite (buffer, FOTO_BORDA, 0, contador);
          
           
    
    draw_sprite (buffer, FOTO_BORDA, RESOLUCAO_X - (FOTO_BORDA -> w), contador);

    }


for ( contador = 0; contador <= RESOLUCAO_X; contador += (FOTO_BORDA -> w) )

    {

    draw_sprite (buffer, FOTO_BORDA, contador, 0);
    draw_sprite (buffer, FOTO_BORDA, contador, RESOLUCAO_Y - (FOTO_BORDA -> h) );

    }


rotate_sprite (buffer, FOTO_PORTAL, portal.x, portal.y, itofix (angulo1 -= 30) );


for (contador = 0; contador < MAXIMO_COMIDA; contador++)

    draw_sprite (buffer, FOTO_FRUTA, comida [contador].x, comida [contador].y);


for ( i = inicio; i != NULL; i = (i -> proximo) )

    rotate_sprite ( buffer, FOTO_COBRA, (i -> x), (i -> y), itofix (angulo2--) );
    


blit (buffer, screen, 0, 0, 0, 0, RESOLUCAO_X, RESOLUCAO_Y);

clear (buffer);


if ( (inicio -> x) == INFINITO || (inicio -> y) == INFINITO || pause () == TRUE)

   rest (5);

else

   rest (60);

}

/****************************************************************************/

int pause ()

{

static int pause = FALSE, tempo_anterior = 0;


if (key [KEY_P] && (ultimo -> x) > 0)  

   if (milesimos - tempo_anterior > 200)  // s pode depois de 200 milisegundos

      {
      
      if (pause == TRUE )
       
         pause = FALSE;
      
      else
   
         pause = TRUE;
         

      tempo_anterior = milesimos;
      
      }


if (milesimos > INFINITO)

   tempo_anterior = milesimos = 0;
   

if (pause == TRUE)

   if (key [KEY_LEFT] || key [KEY_RIGHT] || key [KEY_UP] || key [KEY_DOWN])
   
      pause = FALSE;


return (pause);

}

/****************************************************************************/

int colisao (BITMAP *bmp1, int x1, int y1, BITMAP *bmp2, int x2, int y2)

{

if ( (x1 < x2 + (bmp2 -> w) ) && (x2 < x1 + (bmp1 -> w) ) &&
     (y1 < y2 + (bmp2 -> h) ) && (y2 < y1 + (bmp1 -> h) ) )

   return (TRUE);


return (FALSE);

}

/****************************************************************************/

int colisao_portal (BITMAP *bmp, int x_bmp, int y_bmp)

{

int x_portal, y_portal;


// o portal est sendo considerado 60 x 60

x_portal = ( (2 * portal.x) + (FOTO_PORTAL -> w) ) / 2 - 29;
y_portal = ( (2 * portal.y) + (FOTO_PORTAL -> h) ) / 2 - 29;


if ( (x_bmp < x_portal + 60 ) && (x_portal < x_bmp + (bmp -> w) ) &&
     (y_bmp < y_portal + 60 ) && (y_portal < y_bmp + (bmp -> h) ) )

   return (TRUE);


return (FALSE);

}

/****************************************************************************/

void finaliza ()

{

fade_out (2);

remove_int (tempo_jogo);


stop_midi ();


set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);  // muda para o modo texto para escrever uma mensagem

if (tamanho_execucao == maximo_pontos)

   allegro_message ("Voce quebrou um novo recorde !!  \n\n O tamanho maximo agora e'  %d.   ", maximo_pontos);
   
else

   allegro_message ("Seu recorde nessa partida foi  %d.  \n\n    O tamanho maximo e'  %d.   ", tamanho_execucao, maximo_pontos);


allegro_exit ();


grava_score ();

}

/****************************************************************************/

void fechar_janela ()

{

sair = TRUE;

}

/****************************************************************************/

void grava_score ()

{

FILE *score;
int  pontuacao_arquivo = 0;


score = fopen ("cobra.hi", "r"); 


if (score != NULL)  // quer dizer que existe e tem coisa nele !
                                 
   {

   fscanf (score, "%d", &pontuacao_arquivo);
   
   fclose (score);
   
   }


if (maximo_pontos > pontuacao_arquivo || score == NULL)
      
   {
      
   score = fopen ("cobra.hi", "w");  // "w" cria outro arquivo
      
   fprintf (score, "%d", maximo_pontos);
      
   fclose (score);
      
   }
      
}

/****************************************************************************/

