//////////////////////////////////////////////////////////////////////
// Includes															//
//////////////////////////////////////////////////////////////////////
						//											//
#include "shrapnel.h"	// Shrapnel header							//
#include "tank.h"		// TANK class definition					//
						//											//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Draw the tank to buffer											//
//////////////////////////////////////////////////////////////////////
void TANK::Draw()
{	
	if (!dead)
	{
		// Draw turret
		pivot_sprite(buffer, turret, x - g_iTopleftx, y - g_iToplefty - pic->h + 4, 0, 4, itofix(256 - (int)(angle * 256/360.0)) + xBodyAngle);

		// Draw tank
		if ( bFacingRight )
			rotate_sprite(buffer, pic, x - g_iTopleftx - pic->w/2, y  - g_iToplefty - pic->h, xBodyAngle);
		else
			rotate_sprite_v_flip(buffer, pic, x - g_iTopleftx - pic->w/2, y - g_iToplefty - pic->h, xBodyAngle + itofix(128));

		if( Shield )
			Shield->Draw();
	}
}

//////////////////////////////////////////////////////////////////////
// Remove tank from buffer											//
//////////////////////////////////////////////////////////////////////
void TANK::Ungrab()
{	
	if (!dead)
	{			
		if (grab == NULL)
		{
			grab = create_bitmap(pic->w + 40, pic->h + 40);
			clear(grab);
		} else blit(grab, buffer, 0, 0, x - g_iTopleftx - pic->w/2 - 20, y - g_iToplefty - pic->h - 20, pic->w + 40, pic->h + 40);
	}
}

//////////////////////////////////////////////////////////////////////
// Grab area behind tank											//
//////////////////////////////////////////////////////////////////////
void TANK::Grab()
{
	if (!dead)
		blit(buffer, grab, x - g_iTopleftx - pic->w/2 - 20, y - g_iToplefty - pic->h-20, 0, 0, pic->w + 40, pic->h + 40);
}

//////////////////////////////////////////////////////////////////////
// Update shield graphics											//
//////////////////////////////////////////////////////////////////////
void TANK::UpdateShield()
{
	if( Shield )
		Shield->Update(); 
}

//////////////////////////////////////////////////////////////////////
// Initialisation routines											//
//////////////////////////////////////////////////////////////////////
void TANK::Reset()
{
	dead = false;
	selected_weapon = WeaponType.getfirst();
	health = 100;
	cash += 1000;		
	xBodyAngle = 0;
	Shield = NULL;
	
	if (grab)
	{
		destroy_bitmap(grab);
		grab = NULL;
	}
}

//////////////////////////////////////////////////////////////////////
// Activate tank's shield											//
//////////////////////////////////////////////////////////////////////
void TANK::ActivateShield(SHIELD_TYPE *type)
{
	if( !Shield )
		Shield = new SHIELD (x, y - pic->h / 2, 253, type);
}

//////////////////////////////////////////////////////////////////////
// Deactivate tank's shield											//
//////////////////////////////////////////////////////////////////////
void TANK::DeactivateShield()
{
	SHIELD_TYPE *t = Shield->GetType();

	if( t->duration == 0 )
		t->quantity[turn]--;

	delete Shield;
	Shield = NULL;	
}

//////////////////////////////////////////////////////////////////////
// Move tank to (x, y)												//
//////////////////////////////////////////////////////////////////////
void TANK::Move(int x, int y)
{
	if( Shield )
		Shield->Move(x, y - pic->h / 2);
}

//////////////////////////////////////////////////////////////////////
// Shield has been hit												//
//////////////////////////////////////////////////////////////////////
void TANK::HitShield()
{
	if( Shield->Hit() )
	{
		Shield->GetType()->quantity[turn]--;

		delete Shield;
		Shield = NULL;
	}
}

//////////////////////////////////////////////////////////////////////
// Return whether tank has a shield on or not						//
//////////////////////////////////////////////////////////////////////
SHIELD_TYPE *TANK::HasShield()
{
	if( Shield )
		return Shield->GetType();
	else return NULL;
}

//////////////////////////////////////////////////////////////////////