#ifndef SHRAPNEL_H		// Check for duplicate includes

#define SHRAPNEL_H

//////////////////////////////////////////////////////////////////////////////////
// Defines																		//
//////////////////////////////////////////////////////////////////////////////////
											//									//
#define CLOUDS			  5					// Number of clouds					//
#define MAXPOWER		 32					// Maximum allowable power			//
#define MAXPOINTS		  6					// Most corners on a debris piece	//
#define ROUNDS			  1					// Games between shop visits		//
#define THINGS			  4					// Amount of debris under ground	//
#define MAXPLAYERS		  5					// Max number of players in a game	//
#define MAX_GRADIENT    1.5					// Greatest scalable gradient		//
#define MAX_PARTICLES   500					// Greatest number of particles		//
#define UCHAR unsigned char					// Convenient abbreviation			//
#define SHRAPNEL_VERSION "Version 0.863"	// Shrapnel Version string			//
											//									//
//////////////////////////////////////////////////////////////////////////////////
// Includes																		//
//////////////////////////////////////////////////////////////////////////////////
						//														//
#include <stdio.h>		// Standard I/O routines								//
#include <stdlib.h>		// Standard library routines							//
#include <math.h>		// Maths routines										//
#include <allegro.h>	// Allegro header file									//
#include <libnet.h>		// Libnet header file									//
#include "graphics.h"	// Data file header										//
#include "loading.h"	// 'Loading' data file header							//
#include "array.h"		// Linked List class definition							//
#include "weapons.h"	// WeaponType structure definition						//
#include "menu.h"		// SHRAPNEL_MENU class definition						//
#include "projectile.h"	// PROJECTILE class definition							//
#include "shield.h"		// SHIELD class definition								//
#include "tank.h"		// TANK class definition								//
#include "structs.h"	// Various structure and class definitions				//
						//														//
//////////////////////////////////////////////////////////////////////////////////
// Prototypes																	//
//////////////////////////////////////////////////////////////////////////////////
							//													//
extern void NextTurn();		// Pass control on to next player					//
extern void ScreenShot();	// Take a screen shot								//
extern void Exit(int n);	// Exit the game									//
							//													//
//////////////////////////////////////////////////////////////////////////////////
// Global variables																//
//////////////////////////////////////////////////////////////////////////////////
										//										//
extern BITMAP *buffer; 					// Back buffer							//
extern BITMAP *toolbar;					// Sub-bitmap used for toolbar			//
extern BITMAP *g_bmpMap;				// The map								//
extern DATAFILE *data; 					// Graphics file						//
extern DATAFILE *loaddata;				// 'Loading' data file					//
extern ARRAY<CExplosion> Explosion;		// Linked list of particle explosions	//
extern ARRAY<PROJECTILE> Projectile;	// Linked list of projectiles			//
extern ARRAY<AREA> Area;				// Linked list of areas					//
extern ARRAY<WEAPONTYPE> WeaponType;	// Linked list of weapon types			//
extern ARRAY<SHIELD_TYPE> ShieldType;	// Linked list of shield types			//
extern ELEMENT<WEAPONTYPE> *weapon;		// Element pointing to selected weapon	//
extern ARRAY<PLAYER>  g_llPlayers;		// Linked list of multiplayer nodes		//
extern ARRAY<char> g_llClasses;			// List of weapons classes				//
extern TANK tank[MAXPLAYERS];			// Tank details							//
extern char *g_strName;					// Player name							//
extern unsigned int *terrain_y; 		// Height of terrain at each x value	//
extern unsigned int MAP_W, MAP_H;		// Size of map							//
extern bool g_bSound;					// Has sound been enabled?				//
extern bool g_bOutsideRange;			// Has projectile passed out of range	//
extern bool g_bServer;					// Is this computer the server?			//
extern bool g_bMultiplayer;				// Is this a multiplayer game			//
extern int g_iPlayers;					// Number of players					//
extern int g_iRemaining;				// Number of remaining players			//
extern int g_iDestx, g_iTopleftx;		// Scrolling x co-ordinates				//
extern int g_iDesty, g_iToplefty;		// Scrolling y co-ordinates				//
extern int g_iWay;						// Scrolling direction					//
extern int turn; 						// Whose turn it is						//
extern int shooting; 					// What mode the game is in				//
extern int g_nPlayerID;					// Player ID							//
extern int g_iRound;					// Shots fired							//
extern int SKY_COL;						// Colour to use for the sky			//
extern int EARTH_COL;					// Colour to use for the ground			//
extern int GRASS_COL;					// Colour to use for the grass			//
extern int BLACK_COL;					// Black palette index					//
extern int g_nLongestClass;				// Largest no. of weapons per class		//
extern int g_nParticles;                // Number of particles on screen		//
										//										//
//////////////////////////////////////////////////////////////////////////////////

#endif

//////////////////////////////////////////////////////////////////////
