/*
-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
=														=
-  SS	 H	H  RRR	  AA	PPP   NN  N    EEEE   L 	-
= S  S	 H	H  R  R  A	A	P  P  NN  N    E	  L 	=
- S 	 H	H  R  R  A	A	P  P  N N N    E	  L 	-
=  SS	 HHHH  RRR	 AAAA	PPP   N N N    EEE	  L 	=
-	 S	 H	H  R  R  A	A	P	  N N N    E	  L 	-
= S  S	 H	H  R  R  A	A	P	  N  NN    E	  L 	=
-  SS	 H	H  R  R  A	A	P	  N  NN    EEEE   LLLLL -
=														=
-		 Shrapnel, by Andrew Geers, 1999 - 2000 		-
=				 andy@geerswj.clara.net 				=
-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
*/

//////////////////////////////////////////////////////////////////////////
// Includes																//
//////////////////////////////////////////////////////////////////////////
						//												//
#include <string.h>		// String manipulation functions				//
#include <time.h>		// Time routines								//
#include "shrapnel.h"	// Shrapnel header								//
#include "projectile.h"	// PROJECTILE class definition					//
#include "jrnd.h"		// Prototypes for random number generator		//
						//												//
//////////////////////////////////////////////////////////////////////////
// Function Prototypes													//
//////////////////////////////////////////////////////////////////////////
							//											//
void NextTurn();			// Pass control onto next player			//
void Explode(int);			// Blow up a tank							//
void DisplayTanks();		// Draw all tanks to buffer					//
void UngrabTanks();			// Remove all tanks from buffer				//
void GrabTanks();			// Grab area behind each tank				//
void Game();				// Main game loop							//
void PollNetwork();			// Check for network messages				//
void RefreshScreen();		// Redraw entire screen						//
//////////////////////////////////////////////////////////////////////////
extern void Shop();			// Enter shop								//
extern void Title();		// Title screen and main menu				//
extern void LoadWeapons();	// Load weapon definition files				//
							//											//
//////////////////////////////////////////////////////////////////////////
// Global variables														//
//////////////////////////////////////////////////////////////////////////
								//										//
BITMAP *buffer; 				// Back buffer							//
BITMAP *toolbar;				// Sub-bitmap used for toolbar			//	
BITMAP *g_bmpMap;				// The map								//
BITMAP *pointgrab;				// Area behind big green arrow			//
DATAFILE *data; 				// Graphics file						//
CLOUD cloud[CLOUDS];			// Array of clouds						//
unsigned int *terrain_y;		// Height of terrain at each x value	//
float *g_nGradient; 			// Gradient of terrain at each x value	//
unsigned int MAP_W, MAP_H;		// Size of map							//
int g_iPlayers; 				// Number of players					//
int g_iRemaining;				// Number of remaining players			//
int games;						// How many games since last shop visit	//
int cloudcounter=0; 			// Timer for cloud movement				//
bool g_bSound;					// Has sound been enabled?				//
bool g_bServer; 				// Is this computer the server?			//
bool g_bMultiplayer;			// Is this game multiplayer?			//
char *g_strName;				// Player name							//
int g_nPlayerID;				// Player ID							//
UCHAR g_MPString[513];			// Network messages						//
NET_CHANNEL *listenchan;		// Server channel for incoming messages	//
int g_iDestx, g_iTopleftx;		// Scrolling x co-ordinates				//
int g_iDesty, g_iToplefty;		// Scrolling y co-ordinates				//
int g_iWay; 					// Scrolling direction					//
int pointy = -1, pointx;		// Co-ordinates of big green arrow		//
int wind_speed; 				// Wind speed							//
int g_nScrollSpeed;				// Rate of scrolling					//
float power=10.0;				// Selected power						//
float powery;					// Vertical component of selected power	//
int shotssaved=0;				// No of screen shots taken				//
int turn = 0; 					// Whose turn it is						//
int shooting=0; 				// What mode the game is in				//
volatile int counter;			// Timer								//
volatile int scroll_count;		// Timer for scrolling					//
bool g_bOutsideRange;			// Has projectile passed out of range	//
bool g_bShopped = false;		// Has player just returned from shop	//
int g_nParticles;				// Number of particles on screen		//
int g_iRound;					// Number of shots fired				//
int g_iDelay;					// Frames since last round fired		//
bool bUpdateEx; 				// Should explosions be updated?		//
TANK tank[MAXPLAYERS];			// Tank details							//
COLOR_MAP g_TransTable;			// Transparency Table					//
PALETTE g_palGame;				// Game palette							//
PALETTE g_palWhite; 			// Totally white palette				//
int SKY_COL;					// Colour to use for the sky			//
int EARTH_COL;					// Colour to use for the ground			//
int GRASS_COL;					// Colour to use for the grass			//
int BLACK_COL;					// Black palette index					//
SHIELD_TYPE *g_pShield;			// Selected shield type					//
ARRAY<CExplosion> Explosion;	// Linked list of particle explosions	//
ARRAY<PROJECTILE> Projectile;	// Linked list of projectiles			//
ARRAY<AREA> Area;				// Linked list of areas					//	
ARRAY<WEAPONTYPE> WeaponType;	// Linked list of weapon types			//
ARRAY<SHIELD_TYPE> ShieldType;	// Linked list of shield types			//
ELEMENT<WEAPONTYPE> *weapon;	// Element pointing to selected weapon	//
ARRAY<PLAYER> g_llPlayers;		// Linked list of multiplayer nodes		//
								//										//
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Timer call back routine											//
//////////////////////////////////////////////////////////////////////
void inccounter()
{
	counter++;
}
END_OF_FUNCTION(inccounter);

//////////////////////////////////////////////////////////////////////
// Call back routine for scrolling timer							//
//////////////////////////////////////////////////////////////////////
void incscroll()
{
	scroll_count++;
}
END_OF_FUNCTION(incscroll);

//////////////////////////////////////////////////////////////////////
// Create a new particle explosion at (xx, yy) with radius s		//
//////////////////////////////////////////////////////////////////////
CExplosion::CExplosion(int xx,int yy,int s)
{
	AREA *ar;

	if (!s)
		return;

	bits = (int)((3.142 * s*s)/13);

	if( bits > MAX_PARTICLES - g_nParticles )
		bits = MAX_PARTICLES - g_nParticles;
	if( bits < 0 )
		bits = 0;

	x = xx;
	y = yy;
	size = s;

	UngrabTanks();	// Blit from tank's grab bitmaps to buffer

	circlefill(buffer, x - g_iTopleftx, y - g_iToplefty, size, SKY_COL);	// Make hole on buffer...
	circlefill(g_bmpMap, x, y, size, SKY_COL);	// ...and on map

	GrabTanks();	// Blit from buffer to tank's grab bitmaps
	DisplayTanks(); // Draw tanks

	// Blit from buffer to screen
	blit(buffer, screen, x - size - g_iTopleftx, y - size - g_iToplefty, x - g_iTopleftx - size, y - g_iToplefty - size, size*2, size*2);

	sand = new SAND[bits];

	// Initialise each sand particle
	for (int a=0;a<bits;a++)
	{
		g_nParticles++;		
		sand[a].x = x + (longrand() % size) * cos((3.142/180) * (longrand() % 360)); // longrandom position
		sand[a].y = y + (longrand() % size) * sin((3.142/180) * (longrand() % 360));
		sand[a].angle=((longrand() % 800) / 10.0) + 50; // Random angle of projection
		sand[a].started = false;	// Not been drawn yet
		sand[a].power = sand[a].powery = (longrand()%50) / 10.0;	// Random power
               sand[a].finished = 0;   // Not finished yet (pretty obviously)
	}	

	ar = new AREA;	// Create new area (so that terrain will collapse)
	ar->bound1 = x - size - 2;
	ar->bound2 = x + size + 2;
	if (ar->bound1 < 0) // Check limits are not off screen
		ar->bound1 = 0;
	if (ar->bound2 >= (int)MAP_W)
		ar->bound2 = MAP_W - 1;
	Area.additem(ar);	// Add area to linked list

	Explosion.additem(this);	// Add explosion to linked list
}

//////////////////////////////////////////////////////////////////////
// Remove and explosion from the buffer								//
//////////////////////////////////////////////////////////////////////
void CExplosion::Remove()
{
	for (int a = 0; a < bits; a++)
	{
		if (!sand[a].finished)
		{
			if (sand[a].started)
				putpixel(buffer, (int)sand[a].x - g_iTopleftx, (int)sand[a].y - g_iToplefty, SKY_COL);
		}
	}
}

//////////////////////////////////////////////////////////////////////
// Update particle explosion										//
//////////////////////////////////////////////////////////////////////
void CExplosion::Update()
{
	int x1,x2,y1,y2;
	int a,b,c;
	int col = SKY_COL;
	int col2 = makecol(150,125,0);

	x1 = x - size;
	x2 = x + size;
	y1 = y - size;
	y2 = y + size;
	for (a = 0; a < bits; a++)
	{
		if (!sand[a].finished)
		{
			sand[a].started = true;
			if (sand[a].x < x1) // Find bounding box around particles
				x1 = (int)sand[a].x;	// i.e. the furthest left, the further right, etc
			if (sand[a].x > x2)
				x2 = (int)sand[a].x;
			if (sand[a].y < y1)
				y1 = (int)sand[a].y;
			if (sand[a].y > y2)
				y2 = (int)sand[a].y;
			
			// Move particles and reduce vertical power (so they fall)
			sand[a].x += sand[a].power*cos((3.142/180)*sand[a].angle);
			sand[a].y -= sand[a].powery*sin((3.142/180)*sand[a].angle);
			sand[a].powery-=.2; 		
		}
	}
	
	c=0;
	for (a = 0; a < bits; a++)
	{	// Check if any have 'landed'
		if( !sand[a].finished )
		{
			b = getpixel(buffer, (int)sand[a].x - g_iTopleftx, (int)sand[a].y - g_iToplefty);
			
			if ((sand[a].x < 0) || (sand[a].x > MAP_W) || (sand[a].y < 0) || (sand[a].y > MAP_H))
			{				
				g_nParticles--;
				sand[a].finished = 1;			
			}
			
			if (((int)sand[a].power == 0) && ((int)sand[a].powery == 0))
			{				
				g_nParticles--;
				sand[a].finished = 1;
			}
			
			// Particle is either on top of a bit of sky, or on another particle
			if ((!sand[a].finished) && ((b == col) || (b == col2)))
			{
				putpixel(buffer, (int)sand[a].x - g_iTopleftx, (int)sand[a].y - g_iToplefty, col2); // Draw particle
				c=1;
				// Find bounding box again
				if (sand[a].x < x1)
					x1 = (int)sand[a].x;
				if (sand[a].x > x2)
					x2 = (int)sand[a].x;
				if (sand[a].y < y1)
					y1 = (int)sand[a].y;
				if (sand[a].y > y2)
					y2 = (int)sand[a].y;
			} else {
				sand[a].finished = 1;
				g_nParticles--;
			}
		}
	}
	
	DisplayTanks();
	blit(buffer, screen, x1 - g_iTopleftx, y1 - g_iToplefty, x1 - g_iTopleftx, y1 - g_iToplefty, x2 - x1, y2 - y1);
	
	if (!c)
	{
		Explosion.removeitem(this);
		delete[] sand;
		delete this;
	}
}

//////////////////////////////////////////////////////////////////////
// Take screen shot													//
//////////////////////////////////////////////////////////////////////
void ScreenShot()
{
	BITMAP *shot;
	char shotfile[30];
	
	sprintf(shotfile,"scrshot%d.pcx",shotssaved);
	shotssaved++;
	
	shot = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
	save_bitmap(shotfile, shot, NULL);
	destroy_bitmap(shot);
}

//////////////////////////////////////////////////////////////////////
// Blow up tank[t]													//
//////////////////////////////////////////////////////////////////////
void Explode(int t)
{
	int r,a,b,c;	
	int bits=35;
	DEBRIS debris[35];//bits];
	V3D_f *pointy[MAXPOINTS+1];
	BITMAP *pic;
	BITMAP *grab = create_bitmap(130, 85);
	bool grabbed = false;
	int frame=0, time=0;

	tank[t].cash -= 750;	// I know it's weird, but they start with 1000
							// extra at the start of the round.

	tank[t].dead = true;

	// Play sound effect
	SAMPLE *bigexplode = load_sample("weapons/explode4.wav");
	if ((g_bSound) && (bigexplode))
		play_sample(bigexplode, 255, 128, 1000, 0);

	for (a = 0;a < MAXPOINTS + 1; a++)	// Create 3D vertex for each corner
		pointy[a] = new V3D_f;

	// Initialise each bit of debris
	for (a = 0; a < bits; a++)
	{
		debris[a].fangle = (longrand()%100) + 40;
		debris[a].fpowery = debris[a].fpower = (longrand()%10)+2;
		debris[a].x = tank[t].x;
		debris[a].y = tank[t].y;
		debris[a].points = (longrand()%(MAXPOINTS-3)) + 3;
		debris[a].grab = create_bitmap(20,20);
		debris[a].ox = -1000;

		// Generate random shape by picking a distance and angle for each corner
		for (b=0;b<debris[a].points;b++)
		{
			debris[a].dist[b]=(longrand()%8)+1;
			debris[a].ang[b]=longrand()%360;
		}

		do {	// Do a bubble sort so each corner is in order (couldn't be bothered to do a qsort)
			c=0;
			for (b=0;b<debris[a].points-1;b++)
			{
				if (debris[a].ang[b]>debris[a].ang[b+1])
				{
					r=debris[a].ang[b];
					debris[a].ang[b]=debris[a].ang[b+1];
					debris[a].ang[b+1]=r;
					c=1;
				}
			}
		} while (c);
	}

	clear_keybuf();

	for (;;)	// Loop indefinitely
	{
		while(!counter);
		counter=0;

		if (grabbed)
			blit(grab, buffer, 0, 0, tank[t].x - g_iTopleftx - grab->w/2, tank[t].y - g_iToplefty - grab->h/2 - tank[t].grab->h/2, grab->w, grab->h);

		for (a=0;a<bits;a++)
		{
			if (debris[a].ox!=-1000)
				blit(debris[a].grab,buffer,0,0,debris[a].ox,debris[a].oy,20,20);
		}

		if (frame > 0)
		{
			pic=tank[t].pic;			
			blit(tank[t].grab, buffer, 0, 0, tank[t].x - g_iTopleftx - pic->w/2 - 20, tank[t].y - g_iToplefty - pic->h - 20, pic->w + 40, pic->h + 40);
		}

		blit(buffer, grab, tank[t].x - g_iTopleftx - grab->w/2, tank[t].y - g_iToplefty - grab->h/2 - tank[t].grab->h/2, 0, 0, grab->w, grab->h);

		for (a=0;a<bits;a++)
			blit(buffer, debris[a].grab, (int)debris[a].x - g_iTopleftx - 10, (int)debris[a].y - g_iToplefty - 10, 0, 0, 20, 20);

		grabbed = true;
		if (frame < 7)
		{
			pic = (BITMAP *)data[EXPLODE1 + frame].dat;
			draw_sprite(buffer, pic, tank[t].x - g_iTopleftx - pic->w/2, tank[t].y - g_iToplefty - pic->h/2 - tank[t].grab->h/2);
		}

		time++; 	

		if (time > 2)
		{
			frame++;
			time = 0;
			if (frame >= 20)			
				break;			
		}				 

		for (a=0;a<bits;a++)
		{
			// Make 3D polygon from the corners of the debris
			for (b=0;b<debris[a].points;b++)
			{
				pointy[b]->x = debris[a].x - g_iTopleftx + debris[a].dist[b]*cos((3.142/180)*debris[a].ang[b]);
				pointy[b]->y = debris[a].y - g_iToplefty + debris[a].dist[b]*sin((3.142/180)*debris[a].ang[b]);
				pointy[b]->c = BLACK_COL;
			}

			// Draw polygon
			polygon3d_f(buffer,POLYTYPE_FLAT,NULL,debris[a].points,pointy);

			// Rotate each point
			for (b=0;b<debris[a].points;b++)
			{
				debris[a].ang[b] += 20;
				if (debris[a].ang[b] >= 360)
					debris[a].ang[b] -= 360;
			}

			blit(buffer, screen, (int)debris[a].x - g_iTopleftx - 10, (int)debris[a].y - g_iToplefty - 10, (int)debris[a].x - g_iTopleftx - 10, (int)debris[a].y - g_iToplefty - 10, 20, 20);
			blit(buffer, screen, debris[a].ox, debris[a].oy, debris[a].ox, debris[a].oy, 20, 20);

			debris[a].ox = (int)debris[a].x-10 - g_iTopleftx;
			debris[a].oy = (int)debris[a].y-10 - g_iToplefty;
			debris[a].x += debris[a].fpower*cos((3.142/180)*debris[a].fangle);	// Move debris
			debris[a].y -= debris[a].fpowery*sin((3.142/180)*debris[a].fangle);
			debris[a].fpowery-=0.3;
		}

		blit(buffer,screen,tank[t].x - grab->w/2 - g_iTopleftx, tank[t].y - g_iToplefty - grab->h/2 - tank[t].grab->h/2, tank[t].x - g_iTopleftx - grab->w/2, tank[t].y - g_iToplefty - grab->h/2 - tank[t].grab->h/2, grab->w, grab->h);

		if (key[KEY_F12])
			ScreenShot();
		rest(5);
	}

	g_iRemaining--;

	if (g_iRemaining <= 1)
	{
		for (int i = 0; i < g_iPlayers; i++)
			if (!tank[i].dead)
				textprintf_centre(screen, (FONT *)data[FONT2].dat, SCREEN_W/2, SCREEN_H/2, -1, "Player %d wins!", i + 1);

		readkey();
		turn = t;

		if (games>=ROUNDS)
			Shop(); // Go to shop if enough rounds have passed

		games = 0;
		
		delete[] terrain_y;
		delete[] g_nGradient;

		Game(); // Play another round
		return;
	}

	if (!shooting)
		NextTurn();

	RefreshScreen();
}

//////////////////////////////////////////////////////////////////////
// Create graphics for each tank by changing the colours around		//
//////////////////////////////////////////////////////////////////////
void CreateTankGraphics()
{
	int b, x, y;
	BITMAP *pic;

	for (int a = 0; a < 5; a++)
	{
		pic = (BITMAP *)data[TANK1].dat;
		tank[a].pic = create_bitmap(pic->w, pic->h);

		clear(tank[a].pic);

		draw_sprite(tank[a].pic, pic, 0, 0);

		for (x = 0; x < tank[a].pic->w; x++)
		{
			for (y = 0; y < tank[a].pic->h; y++)
			{
				b = getpixel(tank[a].pic, x, y);
				if (b > 6 && b!=31 && b!=59 && b!=76 && b!=83 && b!=90 && b!=94 && b!=95 && b!=99 && b!=101 && b!=105 && b!=111 && b!=114 && b!=119 && b!=121 && b!=161)
					putpixel(tank[a].pic, x, y, b + 12 * a);
			}
		}

		pic = (BITMAP *)data[TURRET1].dat;
		tank[a].turret = create_bitmap(pic->w, pic->h);

		clear(tank[a].turret);

		draw_sprite(tank[a].turret, pic, 0, 0);

		for (x = 0; x < tank[a].turret->w; x++)
		{
			for (y = 0; y < tank[a].turret->h; y++)
			{
				b = getpixel(tank[a].turret, x, y);
				if (b && b != 161)
					putpixel(tank[a].turret, x, y, b + 12 * a);
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////
// Draw both tanks													//
//////////////////////////////////////////////////////////////////////
void DisplayTanks()
{		
	for (int a = 0; a < g_iPlayers; a++)	
		tank[a].Draw();	
}

//////////////////////////////////////////////////////////////////////
// Blit from grab to buffer											//
//////////////////////////////////////////////////////////////////////
void UngrabTanks()
{
	for (int a=0;a<g_iPlayers;a++)
		tank[a].Ungrab();
}

//////////////////////////////////////////////////////////////////////
// Update shields													//
//////////////////////////////////////////////////////////////////////
void UpdateShields()
{
	for (int a=0; a < g_iPlayers; a++)
		tank[a].UpdateShield();
}

//////////////////////////////////////////////////////////////////////
// Blit from buffer to grab											//
//////////////////////////////////////////////////////////////////////
void GrabTanks()
{
	for (int a = 0; a < g_iPlayers; a++)	
		tank[a].Grab();
}

//////////////////////////////////////////////////////////////////////
// Like DisplayTanks, except this ungrabs and regrabs as well		//
//////////////////////////////////////////////////////////////////////
void DrawTanks()
{
	for (int a = 0; a < g_iPlayers; a++)
	{
		tank[a].Ungrab();
		tank[a].Grab();
		tank[a].Draw();
	}
}

//////////////////////////////////////////////////////////////////////
// Display Exit Screen												//
//////////////////////////////////////////////////////////////////////
void Exit(int n)
{
	BITMAP *pic, *pic2;
	PALETTE	blackpal;

	for (int a = 0; a < 256; a++)
		blackpal[a].r = blackpal[a].g = blackpal[a].b = 0;

	get_palette(g_palGame);

	fade_from(g_palGame, blackpal, 4);
	clear_to_color(screen, 178);		

	pic = (BITMAP *)data[TITLE].dat;
	draw_sprite(screen, pic, SCREEN_W / 2 - pic->w / 2, 10);

	pic2 = (BITMAP *)data[ADDRESS].dat;
	draw_sprite(screen, pic2, SCREEN_W / 2 - pic2->w / 2, 20 + pic->h);

	pic = (BITMAP *)data[THANKS].dat;
	draw_sprite(screen, pic, SCREEN_W / 2 - pic->w / 2, 350);

	textout_centre(screen, (FONT *)data[FONT1].dat, "Thank you for playing Shrapnel. Please take the time to fill out the", SCREEN_W / 2, 415, BLACK_COL);
	textout_centre(screen, (FONT *)data[FONT1].dat, "included Response Form and e-mail it back to me at andy@geerswj.clara.net", SCREEN_W / 2, 430, BLACK_COL);
	textout_centre(screen, (FONT *)data[FONT1].dat, "so that I may continue to improve Shrapnel and fix any bugs", SCREEN_W / 2, 445, BLACK_COL);

	fade_from(blackpal, (RGB *)data[THANKPAL].dat, 4);

	scroll_count = 0;

	clear_keybuf();

	while (scroll_count < 600 && !keypressed());

	fade_from((RGB *)data[THANKPAL].dat, blackpal, 4);

	exit(n);
}

//////////////////////////////////////////////////////////////////////
// Draw tool bar													//
//////////////////////////////////////////////////////////////////////
void DrawWeapon()
{
	BITMAP *pic;

	// Draw weapon picture
	if( !g_pShield )
		pic = weapon->contents->icon;
	else pic = g_pShield->icon;
	
	draw_sprite(toolbar, pic, 25 - pic->w/2 + (int)(turn * (680.0 / (g_iPlayers - 1))), 25 - pic->h/2);

	// Display health
	for (int a=0;a<g_iPlayers;a++)
		textprintf_centre(toolbar, (FONT *)data[FONT1].dat, 80 + (int)(a * (680.0 / (g_iPlayers - 1))), 18, BLACK_COL, "%d", (tank[a].health >= 0 ? tank[a].health : 0));
}

//////////////////////////////////////////////////////////////////////
// Pass play to next player											//
//////////////////////////////////////////////////////////////////////
void NextTurn()
{
	static float oldpower=10.0; 

	while (!weapon->contents->quantity[turn])
	{
		weapon = weapon->next;
		if (weapon == NULL)
			weapon = WeaponType.getfirst();
		tank[turn].selected_weapon = weapon;
	}

	rectfill(toolbar,15 + (int)(turn * (680.0 / (g_iPlayers - 1))), 15, 35 + (int)(turn * (680.0 / (g_iPlayers - 1))),35,makecol(255,99,0));
	blit(buffer,screen,25+turn*750,25,25+turn*750,25,20,20);
	shooting = 0;

	do {
		turn++;
		if (turn >= g_iPlayers)
			turn = 0;
	} while (tank[turn].dead);

	weapon = tank[turn].selected_weapon;
	g_iRound = 0;
	g_iDelay = 1000;

	g_iWay = 0;
	if (tank[turn].x < g_iTopleftx + SCREEN_W/2)
		g_iWay = -1;
	else if (tank[turn].x > g_iTopleftx + SCREEN_W/2)
		g_iWay = 1;
	g_iDestx = tank[turn].x - SCREEN_W/2;

	if( tank[turn].HasShield() )
		tank[turn].DeactivateShield();

	DrawWeapon();

	DrawTanks();
}

//////////////////////////////////////////////////////////////////////
// Generate a random landscape										//
//////////////////////////////////////////////////////////////////////
void GenerateTerrain()
{
	int a, b, g, h;
	int x = 0;
	int way = longrand()%2;
	float c,d,e,i,j;

	for (a = 0; a < g_iPlayers; a++)
		tank[a].x = -10;

	g_bmpMap = create_bitmap(MAP_W, MAP_H);

	clear_to_color(g_bmpMap, SKY_COL);

	b = 0;
	c = 60.0f;
	d = 1.0f;
	h = (longrand() % 75) + 15; 
	i = ((longrand() % 14) / 10 - 0.7) / (float)h;	

	// Generate a cosine curve, with a randomly fluctuating amplitude and frequency
	do {
		g = (longrand() % 100) + 15;
		e = ((longrand() % 95) - c) / (float)g;
		for (a = x; (a < x + g) && (a <= (int)MAP_W); a++)
		{				
			terrain_y[a] = 100 - (int)(c * cos((3.142/180) * a * d) + longrand()%3 - 1);			

			j = sin((3.142/180)*a*d);		  

			if (j<0)
				j*=-1;

			c += e;
			h--;
			if (h<=0)
			{
				h=(longrand()%75)+15;
				i=((longrand()%10)/10 + 0.5 - d)/(float)h;
			}
			d+=i;
		}
		x = a;
	} while(x < (int)MAP_W);

	// Check each tank has a starting place
	for (a = 0; a < g_iPlayers; a++)
			tank[a].x = (int)(2 * a * MAP_W/(2.0 * g_iPlayers - 1) + longrand()%(int)(MAP_W/(2.0 * g_iPlayers - 1)));//a * MAP_W/3*2 + (rand()%(MAP_W/3));

	for (x = 0; x < (int)MAP_W; x++)
	{
		a=0;
		g=0;

		for (int y = -1; y <= 1; y++)
		{
			if ((x + y >= 0) && (x + y < (int)MAP_W))
			{
				a += terrain_y[x + y];
				g++;
			}
		}

		if( x > 0 && x < (int)MAP_W - 1 )
			g_nGradient[x] = (int)(terrain_y[x + 1] - terrain_y[x - 1]) / 2;
		else g_nGradient[x] = 0;
		
		terrain_y[x] = a / g;

		if (terrain_y[x] <= 0)
			terrain_y[x] = 1;

		vline(g_bmpMap, x, MAP_H - terrain_y[x] + 2, MAP_H, EARTH_COL);
		circlefill(g_bmpMap, x, MAP_H - terrain_y[x] + 3, 2, GRASS_COL);		
	}

	for (a = 0; a < 4; a++)
	{
		for (x = 1; x < (int)MAP_W - 1; x++)
		{	
			e = 0;
			
			for (int y = -1; y <= 1; y++)
			{
				e += g_nGradient[x + y];
			}
			
			g_nGradient[x] = e / 3;
		}
	}

	for (a = 0; a < 15 * g_iPlayers; a++)
	{
		b = longrand() % MAP_W;
		g = (terrain_y[b] > 10 ? longrand() % (terrain_y[b] - 10) : 0);
		h = (longrand() % ((longrand() % 2) + 1)) + 1;
		for (x=0; x<h; x++)
			for (int y=0; y<h;y++)
				putpixel(g_bmpMap, b + x, MAP_H - g + y, BLACK_COL);
	}

	for (a = 0; a < THINGS; a++)
	{
		int bit[THINGS];

		do {
			b = 0;
			bit[a] = longrand() % 7;

			for (g = 0; g < a; g++)
			{
				if (bit[a] == bit[g])
				{
					b = 1;
					break;
				}
			}
		} while (b);

		BITMAP *pic = (BITMAP *)data[THING1 + bit[a]].dat;

		do {
			b = longrand() % (MAP_W - pic->w);
			d = 0;
			h = -1;
			for (x = 0; x < pic->w; x++)
			{
				if ((int)terrain_y[x + b] < pic->h + 10)
				{
					d = 1;
					break;
				}
				if (((int)terrain_y[x + b] < h) || (h == -1))
					h = terrain_y[x + b];
			}
		} while (d);

		d = longrand() % (h - pic->h);

		draw_sprite(g_bmpMap, pic, b, MAP_H - pic->h - (int)d);
	}	 

	blit(g_bmpMap, buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

//////////////////////////////////////////////////////////////////////
// Select the weapon you want to use								//
//////////////////////////////////////////////////////////////////////
void SelectWeapon()
{
	int nWidth = g_nLongestClass * 26 + 2;
	int nHeight = g_llClasses.size * 32 + 28;
	char *strOptions[1] = { NULL };
	int x = (int)((SCREEN_W - 10 - nWidth) / (float)(g_iPlayers - 1) * turn + 5);
	int y = 55;
	int a;
	
	SHRAPNEL_MENU WeaponMenu;

	WeaponMenu.Open(x, y, nWidth, nHeight, 0, 0, strOptions, NULL);

	set_mouse_sprite((BITMAP *)data[CURSOR].dat);	

	for (a = 1; a < g_nLongestClass; a++)
		rectfill(buffer, x + a * 26, y + 3, x + 2 + a * 26, y + nHeight - 28, makecol(125, 125, 125));

	for (a = 1; a <= g_llClasses.size; a++)	
		rectfill(buffer, x + 3, y + a * 32, nWidth + x - 3, y + 2 + a * 32, makecol(125, 125, 125));

	ELEMENT<WEAPONTYPE> *elWeap;	
	int *nWeapons;

	nWeapons = new int[WeaponType.size];

	for (a = 0; a < WeaponType.size; a++)
		nWeapons[a] = 0;

	for (elWeap = WeaponType.getfirst(); elWeap != NULL; elWeap = elWeap->next)
	{
		if( elWeap->contents->quantity[turn] || elWeap->contents->cost )
		{		
			if( !g_pShield && elWeap == weapon )			
			{
				rect(buffer, x + 3 + elWeap->contents->nNumber * 26, y + 3 + elWeap->contents->nClass * 32, x + 25 + elWeap->contents->nNumber * 26, y + 26 + elWeap->contents->nClass * 32, makecol(255, 255, 0));
				if( elWeap->contents->quantity[turn] > -1 )
					textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", elWeap->contents->name, weapon->contents->quantity[turn]);
				else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", elWeap->contents->name);
			}			

			if( elWeap->contents->quantity[turn] > 0 )
				rectfill(buffer, x + 3 + elWeap->contents->nNumber * 26, y + 28 + elWeap->contents->nClass * 32, x + 3 + (int)(22 * (float)elWeap->contents->quantity[turn] / elWeap->contents->nRoundStart[turn]) + elWeap->contents->nNumber * 26, y + 31 + elWeap->contents->nClass * 32, 168);
			else if( elWeap->contents->quantity[turn] <= -1 )
			{
				rectfill(buffer, x + 3 + elWeap->contents->nNumber * 26, y + 28 + elWeap->contents->nClass * 32, x + 25 + elWeap->contents->nNumber * 26, y + 31 + elWeap->contents->nClass * 32, 168);
				draw_sprite(buffer, (BITMAP *)data[INFINITY].dat, x + 11 + elWeap->contents->nNumber * 26, y + 28 + elWeap->contents->nClass * 32);
			}
			
			draw_sprite(buffer, elWeap->contents->icon, x + 14 + elWeap->contents->nNumber * 26 - elWeap->contents->icon->w / 2, y + 15 + elWeap->contents->nClass * 32 - elWeap->contents->icon->h / 2);

			nWeapons[elWeap->contents->nClass]++;
		}		
	}	

	ELEMENT<SHIELD_TYPE> *elShl;
	int c;

	for (c = 0, elShl = ShieldType.getfirst(); elShl != NULL; elShl = elShl->next, c++)	
	{
		if( g_pShield == elShl->contents )
		{
			rect(buffer, x + 3 + c * 26, y + 3 + (g_llClasses.size - 1) * 32, x + 25 + c * 26, y + 26 + (g_llClasses.size - 1) * 32, makecol(255, 255, 0));
			if( elShl->contents->quantity[turn] > -1 )
				textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", elShl->contents->name, elShl->contents->quantity[turn]);
			else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", elShl->contents->name);
		}			

		if( elShl->contents->quantity[turn] > 0 )
			rectfill(buffer, x + 3 + c * 26, y + 28 + (g_llClasses.size - 1) * 32, x + 3 + (int)(22 * (float)(elShl->contents->quantity[turn]) / elShl->contents->nRoundStart[turn]) + c * 26, y + 31 + (g_llClasses.size - 1) * 32, 168);
		else if( elShl->contents->quantity[turn] <= -1 )
		{
			rectfill(buffer, x + 3 + c * 26, y + 28 + (g_llClasses.size - 1) * 32, x + 25 + c * 26, y + 31 + (g_llClasses.size - 1) * 32, 168);
			draw_sprite(buffer, (BITMAP *)data[INFINITY].dat, x + 11 + c * 26, y + 28 + (g_llClasses.size - 1) * 32);
		}

		draw_sprite(buffer, elShl->contents->icon, x + 14 + c * 26 - elShl->contents->icon->w / 2, y + 15 + (g_llClasses.size - 1) * 32 - elShl->contents->icon->h / 2);	
	}

	blit(buffer, screen, x, y, x, y, nWidth, nHeight);

	bool bTabPressed = true;
	bool bRightPressed = false, bDownPressed = false;
	bool bLeftPressed = false, bUpPressed = false;

	int b;

	if( !g_pShield )
	{
		a = weapon->contents->nNumber;
		b = weapon->contents->nClass;
	} else {
		b = g_llClasses.size - 1;
		for (elShl = ShieldType.getfirst(), a = 0; elShl != NULL; elShl = elShl->next, a++)
			if( elShl->contents == g_pShield )
				break;
	}

	int omx = mouse_x, omy = mouse_y;

	set_mouse_range(x, y, x + nWidth, y + nHeight);
	position_mouse(x + nWidth / 2, y + nHeight / 2);
	show_mouse(screen);

	bool mouse_over = false;
	int mouse_r = 0;
	bool bAllowed;

	ELEMENT<WEAPONTYPE> *old_weapon = weapon;

	do {
		if( (!g_bMultiplayer || turn == g_nPlayerID) && (key[KEY_TAB] && !bTabPressed) )
		{
			show_mouse(NULL);

			rect(buffer, x + 3 + a * 26, y + 3 + b * 32, x + 25 + a * 26, y + 26 + b * 32, makecol(0,0,150));
			if( g_pShield == NULL )
				draw_sprite(buffer, weapon->contents->icon, x + 14 + a * 26 - weapon->contents->icon->w / 2, y + 15 + b * 32 - weapon->contents->icon->h / 2);
			else draw_sprite(buffer, g_pShield->icon, x + 14 + a * 26 - g_pShield->icon->w / 2, y + 15 + b * 32 - g_pShield->icon->h / 2);
			rectfill(buffer, x + 3, y + nHeight - 20, x - 3 + nWidth, y + nHeight - 4, makecol(0,0,150));

			do {
				a++;			
				
				if( (b < g_llClasses.size - 1 && a >= nWeapons[b]) || (b == g_llClasses.size - 1 && a >= ShieldType.size) )
				{
					a = 0;
					b++;
					if( b >= g_llClasses.size )
						b = 0;
				}
				
				if( b == g_llClasses.size - 1 && a < ShieldType.size )
					g_pShield = &ShieldType[a];
				else {
					g_pShield = NULL;
					for (elWeap = WeaponType.getfirst(); elWeap != NULL; elWeap = elWeap->next)
					{
						if( elWeap->contents->nNumber == a && elWeap->contents->nClass == b )
						{
							weapon = elWeap;
							break;
						}
					}
				}

				bAllowed = true;

				if( !g_pShield && !weapon->contents->quantity[turn] )
					bAllowed = false;
				else if( g_pShield && !g_pShield->quantity[turn] )
					bAllowed = false;
			} while( !bAllowed );

			if( g_bMultiplayer )
			{
				char text[513];
				sprintf(text, "%c%cCLN_SEL_WEAP", a + 1, b + 1);
				net_send (g_llPlayers.getfirst()->contents->chan, text, strlen (text));
			}

			tank[turn].selected_weapon = weapon;
			rectfill(toolbar, 15 + (int)(turn * (680.0 / (g_iPlayers - 1))), 15, 35 + (int)(turn * (680.0 / (g_iPlayers - 1))), 35, makecol(255,99,0));

			rect(buffer, x + 3 + a * 26, y + 3 + b * 32, x + 25 + a * 26, y + 26 + b * 32, makecol(255, 255, 0));

			if( g_pShield == NULL )
			{
				if( weapon->contents->quantity[turn] > -1 )
					textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", weapon->contents->name, weapon->contents->quantity[turn]);
				else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", weapon->contents->name);
			} else {
				if( g_pShield->quantity[turn] > -1 )
					textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", g_pShield->name, g_pShield->quantity[turn]);
				else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", g_pShield->name);
			}

			blit(buffer, screen, x, y, x, y, nWidth, nHeight);

			show_mouse(screen);

			bTabPressed = true;
		}

		if( (!g_bMultiplayer || turn == g_nPlayerID) && ((key[KEY_RIGHT] && !bRightPressed) || (key[KEY_DOWN] && !bDownPressed)) )
		{
			show_mouse(NULL);

			rect(buffer, x + 3 + a * 26, y + 3 + b * 32, x + 25 + a * 26, y + 26 + b * 32, makecol(0,0,150));
			if( g_pShield == NULL )
				draw_sprite(buffer, weapon->contents->icon, x + 14 + a * 26 - weapon->contents->icon->w / 2, y + 15 + b * 32 - weapon->contents->icon->h / 2);
			else draw_sprite(buffer, g_pShield->icon, x + 14 + a * 26 - g_pShield->icon->w / 2, y + 15 + b * 32 - g_pShield->icon->h / 2);
			rectfill(buffer, x + 3, y + nHeight - 20, x - 3 + nWidth, y + nHeight - 4, makecol(0,0,150));

			if( key[KEY_DOWN] && !bDownPressed )
			{
				b++;			
				bDownPressed = true;
			} else if( key[KEY_RIGHT] && !bRightPressed ) {
				a++;
				bRightPressed = true;
			}

			do {				
				if( b < g_llClasses.size - 1 && a >= nWeapons[b] )
				{
					a = 0;
					b++;
				} else if( b == g_llClasses.size - 1 && a >= ShieldType.size ) {
					a = 0;
					b++;
				}

				if( b >= g_llClasses.size )
					b = 0;				
				
				if( b == g_llClasses.size - 1 && a < ShieldType.size )
					g_pShield = &ShieldType[a];
				else {
					g_pShield = NULL;
					
					for (elWeap = WeaponType.getfirst(); elWeap != NULL; elWeap = elWeap->next)
					{
						if( elWeap->contents->nNumber == a && elWeap->contents->nClass == b )
						{
							weapon = elWeap;
							break;
						}
					}
				}

				bAllowed = true;

				if( !g_pShield && !weapon->contents->quantity[turn] )
				{
					bAllowed = false;
					a++;
				} else if( g_pShield && !g_pShield->quantity[turn] ) {
					bAllowed = false;
					a++;
				}

			} while( !bAllowed );

			if( g_bMultiplayer )
			{
				char text[513];
				sprintf(text, "%c%cCLN_SEL_WEAP", a + 1, b + 1);
				net_send (g_llPlayers.getfirst()->contents->chan, text, strlen (text));
			}

			tank[turn].selected_weapon = weapon;
			rectfill(toolbar, 15 + (int)(turn * (680.0 / (g_iPlayers - 1))), 15, 35 + (int)(turn * (680.0 / (g_iPlayers - 1))), 35, makecol(255,99,0));

			rect(buffer, x + 3 + a * 26, y + 3 + b * 32, x + 25 + a * 26, y + 26 + b * 32, makecol(255, 255, 0));

			if( g_pShield == NULL )
			{
				if( weapon->contents->quantity[turn] > -1 )
					textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", weapon->contents->name, weapon->contents->quantity[turn]);
				else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", weapon->contents->name);
			} else {
				if( g_pShield->quantity[turn] > -1 )
					textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", g_pShield->name, g_pShield->quantity[turn]);
				else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", g_pShield->name);
			}

			blit(buffer, screen, x, y, x, y, nWidth, nHeight);

			show_mouse(screen);
		}

		if( (!g_bMultiplayer || turn == g_nPlayerID) && ((key[KEY_LEFT] && !bLeftPressed) || (key[KEY_UP] && !bUpPressed)) )
		{
			show_mouse(NULL);

			rect(buffer, x + 3 + a * 26, y + 3 + b * 32, x + 25 + a * 26, y + 26 + b * 32, makecol(0,0,150));
			if( g_pShield == NULL )
				draw_sprite(buffer, weapon->contents->icon, x + 14 + a * 26 - weapon->contents->icon->w / 2, y + 15 + b * 32 - weapon->contents->icon->h / 2);
			else draw_sprite(buffer, g_pShield->icon, x + 14 + a * 26 - g_pShield->icon->w / 2, y + 15 + b * 32 - g_pShield->icon->h / 2);
			rectfill(buffer, x + 3, y + nHeight - 20, x - 3 + nWidth, y + nHeight - 4, makecol(0,0,150));

			if( key[KEY_UP] && !bUpPressed )
			{
				b--;			
				bUpPressed = true;
			} else if( key[KEY_LEFT] && !bLeftPressed ) {
				a--;
				bLeftPressed = true;
			}

			do {				
				if( a < 0 )
				{					
					b--;
					a = nWeapons[b] - 1;
				}

				if( b < 0 )
					b = g_llClasses.size - 1;				
				
				if( b == g_llClasses.size - 1 && a < ShieldType.size )
					g_pShield = &ShieldType[a];
				else {
					g_pShield = NULL;
					
					for (elWeap = WeaponType.getfirst(); elWeap != NULL; elWeap = elWeap->next)
					{
						if( elWeap->contents->nNumber == a && elWeap->contents->nClass == b )
						{
							weapon = elWeap;
							break;
						}
					}
				}

				bAllowed = true;

				if( !g_pShield && !weapon->contents->quantity[turn] ) {
					bAllowed = false;
					a--;
				} else if( g_pShield && !g_pShield->quantity[turn] ) {
					bAllowed = false;
					a--;
				}
			} while( !bAllowed );

			if( g_bMultiplayer )
			{
				char text[513];
				sprintf(text, "%c%cCLN_SEL_WEAP", a + 1, b + 1);
				net_send (g_llPlayers.getfirst()->contents->chan, text, strlen (text));
			}

			tank[turn].selected_weapon = weapon;
			rectfill(toolbar, 15 + (int)(turn * (680.0 / (g_iPlayers - 1))), 15, 35 + (int)(turn * (680.0 / (g_iPlayers - 1))), 35, makecol(255,99,0));

			rect(buffer, x + 3 + a * 26, y + 3 + b * 32, x + 25 + a * 26, y + 26 + b * 32, makecol(255, 255, 0));

			if( g_pShield == NULL )
			{
				if( weapon->contents->quantity[turn] > -1 )
					textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", weapon->contents->name, weapon->contents->quantity[turn]);
				else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", weapon->contents->name);
			} else {
				if( g_pShield->quantity[turn] > -1 )
					textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", g_pShield->name, g_pShield->quantity[turn]);
				else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", g_pShield->name);
			}

			blit(buffer, screen, x, y, x, y, nWidth, nHeight);

			show_mouse(screen);
		}

		if( (!g_bMultiplayer || turn == g_nPlayerID) && (mouse_x != omx || mouse_y != omy) )
		{
			int a2, b2;
			ELEMENT<WEAPONTYPE> *tempel;

			a2 = (mouse_x - x - 3) / 26;
			b2 = (mouse_y - y - 3) / 32;

			tempel = NULL;

			mouse_over = false;

			bool Changed = false;

			SHIELD_TYPE *oldshield = g_pShield;
			
			//g_pShield = NULL;

			if( b2 == g_llClasses.size - 1 && a2 < ShieldType.size ) {
				if( ShieldType[a2].quantity[turn] )
				{
					g_pShield = &ShieldType[a2];
					mouse_over = true;

					if( a2 != a || b2 != b )
						Changed = true;
				}
			} else {								
				for (elWeap = WeaponType.getfirst(); elWeap != NULL; elWeap = elWeap->next)
				{
					if( elWeap->contents->nNumber == a2 && elWeap->contents->nClass == b2 && (elWeap->contents->quantity[turn] || elWeap->contents->cost) && elWeap->contents->quantity[turn] )
					{
						g_pShield = NULL;
						tempel = elWeap;
						mouse_over = true;
						if( tempel != weapon )
							Changed = true;
						break;
					}
				}				
			}			

			if( (tempel != NULL || g_pShield != NULL) && Changed )
			{
				show_mouse(NULL);

				rect(buffer, x + 3 + a * 26, y + 3 + b * 32, x + 25 + a * 26, y + 26 + b * 32, makecol(0,0,150));
				if( !oldshield )
					draw_sprite(buffer, weapon->contents->icon, x + 14 + a * 26 - weapon->contents->icon->w / 2, y + 15 + b * 32 - weapon->contents->icon->h / 2);
				else draw_sprite(buffer, oldshield->icon, x + 14 + a * 26 - oldshield->icon->w / 2, y + 15 + b * 32 - oldshield->icon->h / 2);

				rectfill(buffer, x + 3, y + nHeight - 20, x - 3 + nWidth, y + nHeight - 4, makecol(0,0,150));

				a = a2;
				b = b2;
				weapon = tempel;

				if( g_bMultiplayer )
				{
					char text[513];
					sprintf(text, "%c%cCLN_SEL_WEAP", a + 1, b + 1);
					net_send (g_llPlayers.getfirst()->contents->chan, text, strlen (text));
				}

				tank[turn].selected_weapon = weapon;
				rectfill(toolbar, 15 + (int)(turn * (680.0 / (g_iPlayers - 1))), 15, 35 + (int)(turn * (680.0 / (g_iPlayers - 1))), 35, makecol(255,99,0));

				rect(buffer, x + 3 + a * 26, y + 3 + b * 32, x + 25 + a * 26, y + 26 + b * 32, makecol(255, 255, 0));

				if( g_pShield == NULL )
				{
					if( weapon->contents->quantity[turn] > -1 )
						textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", weapon->contents->name, weapon->contents->quantity[turn]);
					else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", weapon->contents->name);
				} else {
					if( g_pShield->quantity[turn] > -1 )
						textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", g_pShield->name, g_pShield->quantity[turn]);
					else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", g_pShield->name);
				}

				blit(buffer, screen, x, y, x, y, nWidth, nHeight);

				show_mouse(screen);
			}

			omx = mouse_x;
			omy = mouse_y;
		}

		if( g_bMultiplayer && (!strcmp((const char *)g_MPString + 2, "SVR_SEL_WEAP") || !strcmp((const char *)g_MPString + 2, "SVR_WEAPSEL")) )
		{
			show_mouse(NULL);

			rect(buffer, x + 3 + a * 26, y + 3 + b * 32, x + 25 + a * 26, y + 26 + b * 32, makecol(0,0,150));
			if( g_pShield == NULL )
				draw_sprite(buffer, weapon->contents->icon, x + 14 + a * 26 - weapon->contents->icon->w / 2, y + 15 + b * 32 - weapon->contents->icon->h / 2);
			else draw_sprite(buffer, g_pShield->icon, x + 14 + a * 26 - g_pShield->icon->w / 2, y + 15 + b * 32 - g_pShield->icon->h / 2);
			rectfill(buffer, x + 3, y + nHeight - 20, x - 3 + nWidth, y + nHeight - 4, makecol(0,0,150));
			
			a = g_MPString[0] - 1;
			b = g_MPString[1] - 1;
			
			if( b == g_llClasses.size - 1 && a < ShieldType.size )
				g_pShield = &ShieldType[a];
			else {
				g_pShield = NULL;
				
				for (elWeap = WeaponType.getfirst(); elWeap != NULL; elWeap = elWeap->next)
				{
					if( elWeap->contents->nNumber == a && elWeap->contents->nClass == b )
					{
						weapon = elWeap;
						break;
					}
				}
			}

			tank[turn].selected_weapon = weapon;
			rectfill(toolbar, 15 + (int)(turn * (680.0 / (g_iPlayers - 1))), 15, 35 + (int)(turn * (680.0 / (g_iPlayers - 1))), 35, makecol(255,99,0));

			rect(buffer, x + 3 + a * 26, y + 3 + b * 32, x + 25 + a * 26, y + 26 + b * 32, makecol(255, 255, 0));

			if( g_pShield == NULL )
			{
				if( weapon->contents->quantity[turn] > -1 )
					textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", weapon->contents->name, weapon->contents->quantity[turn]);
				else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", weapon->contents->name);
			} else {
				if( g_pShield->quantity[turn] > -1 )
					textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s (%d)", g_pShield->name, g_pShield->quantity[turn]);
				else textprintf_centre(buffer, (FONT *)data[FONT1].dat, x + nWidth / 2, y + nHeight - 7 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", g_pShield->name);
			}

			blit(buffer, screen, x, y, x, y, nWidth, nHeight);

			show_mouse(screen);

			if( !strcmp((const char *)g_MPString + 2, "SVR_WEAPSEL") )
				break;
		}

		if ((mouse_b & 1) && (mouse_over) && ((!g_bMultiplayer) || (turn == g_nPlayerID)))
			break;

		if (((!g_bMultiplayer) || (turn == g_nPlayerID)) && ((key[KEY_ESC]) || ((mouse_b & 2) && (mouse_r & 2))))
		{
			tank[turn].selected_weapon = weapon = old_weapon;
			break;
		}

		mouse_r = mouse_b ^ 3;

		if( g_bMultiplayer )
			PollNetwork();		

		if( !key[KEY_TAB] )
			bTabPressed = false;	
		if( !key[KEY_RIGHT] )
			bRightPressed = false;
		if( !key[KEY_LEFT] )
			bLeftPressed = false;
		if( !key[KEY_UP] )
			bUpPressed = false;
		if( !key[KEY_DOWN] )
			bDownPressed = false;

		if( key[KEY_F12] )
			ScreenShot();
	} while ((!key[KEY_ESC] && !key[KEY_ENTER] && !key[KEY_SPACE]) || (g_bMultiplayer && turn != g_nPlayerID));

	show_mouse(NULL);

	if( g_bMultiplayer && g_nPlayerID == turn )
	{
		char text[512];
		sprintf(text, "%c%cCLN_WEAPSEL", a + 1, b + 1);
		net_send(g_llPlayers.getfirst()->contents->chan, text, strlen(text));
	}

	set_mouse_range(0, 0, SCREEN_W, SCREEN_H);

	delete[] nWeapons;

	WeaponMenu.Close();

	while(key[KEY_ESC]);
}

//////////////////////////////////////////////////////////////////////
// Update the power bar until it reaches p (Network games only)		//
//////////////////////////////////////////////////////////////////////
void FindMPPower(int p)
{
	int a;
	BITMAP *grab = create_bitmap(555,55);

	blit(buffer,grab,125,425,0,0,555,55);

	rectfill(buffer,125,425,675,475,makecol(150,150,150));
	rect(buffer,126,426,674,474,makecol(200,200,200));
	rectfill(buffer,128,428,672,472,makecol(100,100,100));

	for (a = 0; a < p; a++)
	{
		rectfill(buffer, 128, 428, 128 + (int)(a * (550.0/MAXPOWER)), 472, makecol(0,0,175));
		blit(buffer, screen, 125, 425, 125, 425, 550, 50);
		if (key[KEY_F12])
			ScreenShot();
		rest(40);
	}

	power = p;

	blit(grab, buffer, 0, 0, 125, 425, 555, 55);
	blit(buffer, screen, 125, 425, 125, 425, 555, 55);

	destroy_bitmap(grab);
}

//////////////////////////////////////////////////////////////////////
// Find projection power											//
//////////////////////////////////////////////////////////////////////
void FindPower()
{
	int a;
	BITMAP *grab = create_bitmap(555,55);

	blit(buffer,grab,125,425,0,0,555,55);

	rectfill(buffer,125,425,675,475,makecol(150,150,150));
	rect(buffer,126,426,674,474,makecol(200,200,200));
	rectfill(buffer,128,428,672,472,makecol(100,100,100));

	for (a = 0; a < MAXPOWER && key[KEY_SPACE]; a++)
	{
		rectfill(buffer, 128, 428, 128 + (int)(a * (550.0/MAXPOWER)), 472, makecol(0,0,175));
		blit(buffer, screen, 125, 425, 125, 425, 550, 50);
		if (key[KEY_F12])
			ScreenShot();
		rest(40);
	}

	if (key[KEY_SPACE])
	{
		for (a = MAXPOWER; a >= 0 && key[KEY_SPACE]; a--)
		{
			rectfill(buffer, 672 - (int)((MAXPOWER - a) * 550.0 / MAXPOWER), 428, 672, 472, makecol(100,100,100));
			blit(buffer, screen, 125, 425, 125, 425, 550, 50);
			rest(40);
			if (key[KEY_F12])
				ScreenShot();
		}
	}

	power = a;

	if( g_bMultiplayer )
	{
		char text[513];
		sprintf (text, "%c%c%c%c%c%c%c%c%cCLN_FIND_POWER", tank[turn].x / 255 + 1, (tank[turn].x % 255) + 1, tank[turn].y / 255 + 1, (tank[turn].y % 255) + 1, tank[turn].angle + 1, tank[turn].nBodyAngle / 255 + 1, (tank[turn].nBodyAngle % 255) + 1, (int)power + 1, (int)((power - (int)power) * 100 + 1));
		net_send (g_llPlayers.getfirst()->contents->chan, text, strlen (text));
	}	

	blit(grab, buffer, 0, 0, 125, 425, 555, 55);
	blit(buffer, screen, 125, 425, 125, 425, 555, 55);

	destroy_bitmap(grab);
}

//////////////////////////////////////////////////////////////////////
// Redraw entire screen												//
//////////////////////////////////////////////////////////////////////
void RefreshScreen()
{
	blit(g_bmpMap, buffer, g_iTopleftx, g_iToplefty, 0, 0, SCREEN_W, SCREEN_H);

	GrabTanks();
	DrawTanks();

	for (int a = 0; a < CLOUDS; a++)
		draw_sprite(buffer, cloud[a].pic, cloud[a].x - g_iTopleftx, cloud[a].y - g_iToplefty - cloud[a].pic->h);

	blit(buffer,pointgrab,tank[turn].x - g_iTopleftx - pointgrab->w/2, tank[turn].y - g_iToplefty - 100, 0, 0, pointgrab->w, pointgrab->h);

	if (!shooting)
	{
		BITMAP *pic = (BITMAP *)data[POINTER].dat;
		draw_sprite(buffer, pic, tank[turn].x - g_iTopleftx - pic->w/2, tank[turn].y - g_iToplefty - 100);
	}

	ELEMENT<PROJECTILE> *projel;

	for (projel = Projectile.getfirst(); projel != NULL; projel = projel->next)
		projel->contents->Grab();

	for (projel = Projectile.getfirst(); projel != NULL; projel = projel->next)
		projel->contents->Draw();

	blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

//////////////////////////////////////////////////////////////////////
// Draw tool bar at top of screen									//
//////////////////////////////////////////////////////////////////////
void DrawToolBar()
{
	int a, b, c;
	BITMAP *pic;

	rectfill(toolbar, 0, 0, SCREEN_W, 50, 162);

	pic = (BITMAP *)data[TOOLLEFT].dat;
	blit(pic, toolbar, 0, 0, 0, 0, pic->w, pic->h);
	a = pic->w;
	pic = (BITMAP *)data[TOOLRIGHT].dat;
	blit(pic, toolbar, 0, 0, SCREEN_W - pic->w, 0, pic->w, pic->h);
	b = SCREEN_W - pic->w;

	for (c = a; c < b; c++)
	{
		pic = (BITMAP *)data[TOOLTOP].dat;
		blit(pic, toolbar, 0, 0, c, 0, pic->w, pic->h);
		pic = (BITMAP *)data[TOOLBOTTOM].dat;
		blit(pic, toolbar, 0, 0, c, 50 - pic->h, pic->w, pic->h);
	}

	pic = (BITMAP *)data[TOOLBOX].dat;

	for (a = 0; a < g_iPlayers; a++)
		draw_sprite(toolbar, pic, 10 + (int)(a * (680.0 / (g_iPlayers - 1))), 10);

	if (g_iPlayers == 2)
	{
		pic = (BITMAP *)data[TOOLWORD].dat;
		draw_sprite(toolbar, pic, SCREEN_W/2 - pic->w/2, 25 - pic->h/2);
	}
}

//////////////////////////////////////////////////////////////////////
// Game initialisation routines										//
//////////////////////////////////////////////////////////////////////
void GameInit()
{
	int a;
	BITMAP *pic;

	g_iTopleftx = 0;
	g_iToplefty = 0;	

	g_nParticles = 0;

	g_nScrollSpeed = 0;

	cloudcounter = 0;

	g_iWay = 0;

	g_iRemaining = g_iPlayers;

	MAP_W = 400 * g_iPlayers;
	MAP_H = 600;
	terrain_y = new unsigned int[MAP_W + 1];
	g_nGradient = new float[MAP_W + 1];

	pic = (BITMAP *)data[POINTER].dat;
	pointgrab = create_bitmap(pic->w,pic->h + 20);
       clear_to_color(pointgrab, SKY_COL);
	
	Projectile.clear();
	Explosion.clear();

	bUpdateEx = false;

	weapon = WeaponType.getfirst();

	games++;

	for (a = 0; a < g_iPlayers; a++)
	{
		tank[a].Reset();
	
		for (ELEMENT<WEAPONTYPE> *elWeap = WeaponType.getfirst(); elWeap != NULL; elWeap = elWeap->next)
			elWeap->contents->nRoundStart[a] = elWeap->contents->quantity[a];
		for (ELEMENT<SHIELD_TYPE> *elShl = ShieldType.getfirst(); elShl != NULL; elShl = elShl->next)
			elShl->contents->nRoundStart[a] = elShl->contents->quantity[a];
	}

	while (key[KEY_SPACE]);

	if (keypressed())
		readkey();	

	shooting=0;
	power=powery=10.0;

	wind_speed=((longrand()%5)+2) * ((longrand()%2)*2-1);

	clear_to_color(buffer,SKY_COL);

	DrawWeapon();	

	GenerateTerrain();

	for (a = 0; a < g_iPlayers; a++)
	{
		if (tank[a].x < (int)MAP_W / 2)
		{
			tank[a].angle = 45;
			tank[a].bFacingRight = true;
		} else {
			tank[a].angle = 135;
			tank[a].bFacingRight = false;
		}

		tank[a].xBodyAngle = ftofix(atan2(g_nGradient[tank[a].x], -1) * 128 / 3.142f + 128);
		tank[a].nBodyAngle = 360 - fixtoi(tank[a].xBodyAngle) * 360.0 / 256;
	}

	for (a = 0; a < g_iPlayers; a++)
		tank[a].y = MAP_H - terrain_y[tank[a].x];

	blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

	for (a=0;a<CLOUDS;a++)
	{
		cloud[a].x=longrand()%MAP_W;
		cloud[a].y=longrand()%300;

		cloud[a].pic=(BITMAP *)data[CLOUD1 + (longrand()%6)].dat;
	}

	g_iRound = 0;

	DrawTanks();	

	set_clip(buffer,0,50,SCREEN_W,SCREEN_H);

	DrawToolBar();

	if (g_bShopped)
		fade_from(g_palWhite, g_palGame, 7);
}

//////////////////////////////////////////////////////////////////////
// Scroll the visible viewing area									//
//////////////////////////////////////////////////////////////////////
void Scroll()
{
	int a, b;
	ELEMENT<PROJECTILE> *projel;

	if ((g_iPlayers > 2) && (scroll_count))
	{
		scroll_count = 0;
		
		get_mouse_mickeys(&a, &b);
		
		if (a)
		{
			g_iWay = 0;
			g_iTopleftx += a;
			if (g_iTopleftx < 0)
				g_iTopleftx = 0;
			if (g_iTopleftx >= (int)MAP_W - SCREEN_W)
				g_iTopleftx = MAP_W - SCREEN_W - 1;
			RefreshScreen();
		} else if (Projectile.size) {
			a = 0;
			
			for (projel = Projectile.getfirst(); projel != NULL; projel = projel->next)
				a += (int)projel->contents->x;
			
			a /= Projectile.size;
			
			g_iDestx = a - SCREEN_W/2;
			
			g_iWay = 0;
			if (a < g_iTopleftx + SCREEN_W/2)
				g_iWay = -1;
			else if (a > g_iTopleftx + SCREEN_W/2)
				g_iWay = 1;
		}
		
		if (g_iWay)
		{
			if( g_iWay == 1 && g_nScrollSpeed < 15 )
				g_nScrollSpeed += 7;
			else if( g_iWay == -1 && g_nScrollSpeed > -15 )
				g_nScrollSpeed -= 7;

			g_iTopleftx += g_nScrollSpeed;//g_iWay * 75;
			if ((g_iWay < 0) && (g_iTopleftx <= g_iDestx))
			{
				g_iWay = 0;
				g_iTopleftx = g_iDestx;
				g_nScrollSpeed = 0;
			} else if ((g_iWay > 0) && (g_iTopleftx >= g_iDestx)) {
				g_iWay = 0;
				g_iTopleftx = g_iDestx;
				g_nScrollSpeed = 0;
			}
			
			if (g_iTopleftx < 0)
			{
				g_iTopleftx = 0;
				g_iWay = 0;
			} else if (g_iTopleftx >= (int)MAP_W - SCREEN_W) {
				g_iTopleftx = (int)MAP_W - SCREEN_W - 1;
				g_iWay = 0;
			}
			
			RefreshScreen();
		}
	}
}

//////////////////////////////////////////////////////////////////////
// Check for user input, and make changes accordingly				//
//////////////////////////////////////////////////////////////////////
void CheckInput()
{
	static int mouse_r = 0;
	static bool released_tab = true;	
	BITMAP *pic = tank[turn].pic;
	int a;
	static bool bSpacePressed = true;

	if (!shooting)
	{		
		if (((!g_bMultiplayer) && (((key[KEY_TAB]) && (released_tab)) || ((mouse_b & 2) && (mouse_r & 2))))
			|| ((g_bMultiplayer) && (((turn == g_nPlayerID) && (key[KEY_TAB]) && (released_tab)) || (!strcmp((const char *)g_MPString, "SVR_WEAP_SEL")))))
		{
			if( g_bMultiplayer && turn == g_nPlayerID )
			{
				char text[513];
				sprintf(text, "CLN_WEAP_SEL");
				net_send(g_llPlayers.getfirst()->contents->chan, text, strlen(text));
			}

			SelectWeapon();

			released_tab = false;
		}		
		
		mouse_r = mouse_b ^ 3;

		if (((!g_bMultiplayer) && key[KEY_SPACE] && !bSpacePressed) || ((g_bMultiplayer) && ((!strcmp((const char *)g_MPString + 9, "SVR_FIND_POWER")) || ((turn == g_nPlayerID) && (key[KEY_SPACE])))))
		{
			if( key[KEY_SPACE] )
				bSpacePressed = true;

			if( g_pShield )
			{
                               tank[turn].ActivateShield(g_pShield);
				g_pShield = NULL;	
				rectfill(toolbar, 15 + (int)(turn * (680.0 / (g_iPlayers - 1))), 15, 35 + (int)(turn * (680.0 / (g_iPlayers - 1))), 35, makecol(255,99,0));
				tank[turn].selected_weapon = WeaponType.getfirst();
				weapon = WeaponType.getfirst();
			} else {
				blit(pointgrab, buffer, 0, 0, tank[turn].x - g_iTopleftx - pointgrab->w/2, tank[turn].y - g_iToplefty - 100, pointgrab->w,pointgrab->h);
				blit(buffer, screen, tank[turn].x - g_iTopleftx - pointgrab->w/2, tank[turn].y - g_iToplefty - 110, tank[turn].x - g_iTopleftx - pointgrab->w/2, tank[turn].y - g_iToplefty - 110, pointgrab->w, pointgrab->h + 10);
				
				if ((g_bMultiplayer) && (!strcmp((const char *)g_MPString + 9, "SVR_FIND_POWER")))
				{
					tank[turn].x = (g_MPString[0] - 1) * 255 + g_MPString[1] - 1;
					tank[turn].y = (g_MPString[2] - 1) * 255 + g_MPString[3] - 1;
					tank[turn].angle = g_MPString[4] - 1;
					tank[turn].nBodyAngle = (g_MPString[5] - 1) * 255 + g_MPString[6] - 1;
					FindMPPower((g_MPString[8] - 1) * 100  + g_MPString[7] - 1);
				} else {
					FindPower();
				}
				
				new PROJECTILE(tank[turn].x + 15 * cos((3.142 / 180) * (tank[turn].angle + tank[turn].nBodyAngle)), tank[turn].y - pic->h - 15 * sin((3.142 / 180) * (tank[turn].angle + tank[turn].nBodyAngle)), tank[turn].angle + tank[turn].nBodyAngle, power, weapon->contents, 0);
				
				if ((g_bSound) && (weapon->contents->firesound))
					play_sample(weapon->contents->firesound, 255, 128, 1000, 0);
				
				weapon->contents->quantity[turn]--;
				shooting=1;
				g_iRound = 1;
				g_bOutsideRange = false;				
				pointy=-1;				
				rectfill(toolbar,15+turn*750,15,35+turn*750,35,makecol(255,99,0));
			}
		}
	}
	
	if (((!g_bMultiplayer) && (key[KEY_D])) || ((g_bMultiplayer) && ((!strcmp((const char *)g_MPString, "SVR_EXPLODE")) || ((turn == g_nPlayerID) && (key[KEY_D])))))
	{
		if( g_bMultiplayer && turn == g_nPlayerID )
		{
			char text[513];
			sprintf(text, "CLN_EXPLODE");
			net_send(g_llPlayers.getfirst()->contents->chan, text, strlen(text));
		}

		Explode(turn);
	}

	if( !key[KEY_SPACE] )
		bSpacePressed = false;

	if (!key[KEY_TAB])
		released_tab = true;

	if (key[KEY_R])
		RefreshScreen();			
	
	if (key[KEY_ESC])
	{
		SHRAPNEL_MENU AreUSure;
		char *opts[4] = { "Quit Game", "Main Menu", "Cancel", NULL };
		
		AreUSure.Open(350, 200, 100, 80, 22, 15, opts, NULL);
		AreUSure.DrawOptions();
		
		blit(buffer, screen, 300, 215, 300, 215, 200, 20);
		
		while (key[KEY_ESC]);
		
		do {
			a = AreUSure.Update();
		} while (a >= 3);
		
		if ((a == 1) && (AreUSure.m_selected < 2))
		{
			if( g_bMultiplayer && g_bServer )
				net_closechannel (listenchan);

			if( AreUSure.m_selected == 1 )
			{
				set_clip(buffer, 0, 0, SCREEN_W, SCREEN_H);
				Title();
				DrawToolBar();				

				for (a = 0; a < g_iPlayers; a++)
				{
					tank[a].cash = 1000;
					tank[a].grab = NULL;
				}
				
				games = 0;								
				clear_to_color(screen, BLACK_COL);
				
				Game();
			}

			Exit(EXIT_SUCCESS);
		}
		
		AreUSure.Close();
		
		while (key[KEY_ESC]);
	}		
}

//////////////////////////////////////////////////////////////////////
// Remove clouds etc from screen									//
//////////////////////////////////////////////////////////////////////
void UngrabGraphics()
{
	int a;
	BITMAP *pic;
	
	if (!shooting)
	{
		if (pointy!=-1)
			blit(pointgrab, buffer, 0, 0, pointx, pointy - g_iToplefty - 100, pointgrab->w, pointgrab->h + 20);
		
		blit(buffer,pointgrab,tank[turn].x - g_iTopleftx - pointgrab->w/2, tank[turn].y - g_iToplefty - 100, 0, 0, pointgrab->w, pointgrab->h + 20);
		
		pic = (BITMAP *)data[POINTER].dat;
		draw_sprite(buffer, pic, tank[turn].x - g_iTopleftx - pointgrab->w/2, tank[turn].y - g_iToplefty - 100);
		
		blit(buffer, screen, tank[turn].x - g_iTopleftx - pointgrab->w/2 - 2, tank[turn].y - g_iToplefty - 112, tank[turn].x - g_iTopleftx - pointgrab->w/2 - 2, tank[turn].y - g_iToplefty - 112, pointgrab->w + 4,pointgrab->h + 24);
		
		pointy = tank[turn].y;
		pointx = tank[turn].x - g_iTopleftx - pointgrab->w / 2;
	}
	
	a = wind_speed;
	if (a < 0) a *= -1;

	for (a = 0; a < CLOUDS; a++)		
		rectfill(buffer, cloud[a].x - g_iTopleftx, cloud[a].y - g_iToplefty - cloud[a].pic->h, cloud[a].x + cloud[a].pic->w, cloud[a].y, SKY_COL);
	
	if (cloudcounter > 7 - a)
	{
		cloudcounter = 0;
		for (a = 0; a < CLOUDS; a++)
		{
			//rectfill(buffer, cloud[a].x - g_iTopleftx, cloud[a].y - g_iToplefty - cloud[a].pic->h, cloud[a].x + cloud[a].pic->w, cloud[a].y, SKY_COL);
			
			if (wind_speed>0)
				cloud[a].x++;
			else cloud[a].x--;
			
			if (((wind_speed < 0) && (cloud[a].x < 0 - cloud[a].pic->w)) || ((wind_speed > 0) && (cloud[a].x > (int)MAP_W)))
			{
				cloud[a].x = longrand()%(MAP_W/2);
				cloud[a].y = longrand()%300;
				
				if (wind_speed>0)
				{
					cloud[a].x*=-1;
					cloud[a].x-=cloud[a].pic->w;
				} else cloud[a].x+=MAP_W;
				
				cloud[a].pic = (BITMAP *)data[CLOUD1 + longrand() % 6].dat;
			}
		}
	}

	for (ELEMENT<PROJECTILE> *projel = Projectile.getfirst(); projel != NULL; projel = projel->next)
		projel->contents->UnGrab();
}

//////////////////////////////////////////////////////////////////////
// Update events according to timer									//
//////////////////////////////////////////////////////////////////////
void TimedEvents()
{
	BITMAP *pic = tank[turn].pic;	
		
	if (counter)
	{
		counter = 0;
		cloudcounter++;
		
		bUpdateEx = true;

		UngrabTanks();

		if ((!g_bMultiplayer) || (turn == g_nPlayerID))
		{
			if( !tank[turn].HasShield() )
			{
				if ((!shooting) && (key[KEY_COMMA]) && (tank[turn].x > 0))
				{
					if( g_nGradient[tank[turn].x] > -MAX_GRADIENT )
					{
						if( tank[turn].bFacingRight )
							tank[turn].angle = 180 - tank[turn].angle;
						
						tank[turn].bFacingRight = false;				
						
						if( tank[turn].y > SCREEN_H - (int)terrain_y[ --tank[turn].x ] )
							tank[turn].y = SCREEN_H - terrain_y[tank[turn].x];
						
						tank[turn].xBodyAngle = ftofix(atan2(g_nGradient[tank[turn].x], -1) * 128 / 3.142f + 128);
						tank[turn].nBodyAngle = 360 - fixtoi(tank[turn].xBodyAngle) * 360.0 / 256;
						
						if( g_bMultiplayer )
						{
							char text[513];
							sprintf (text, "%c%c%c%c%c%cCLN_MOVE_TANK", tank[turn].x / 255 + 1, (tank[turn].x % 255) + 1, tank[turn].y / 255 + 1, (tank[turn].y % 255) + 1, (unsigned char)tank[turn].bFacingRight + 2, tank[turn].angle + 1);
							net_send (g_llPlayers.getfirst()->contents->chan, text, strlen (text));
						}
					}
				} else if ((!shooting) && (key[KEY_STOP]) && (tank[turn].x < (int)MAP_W - 1)) { 		
					if( g_nGradient[tank[turn].x] < MAX_GRADIENT )
					{
						if( !tank[turn].bFacingRight )
							tank[turn].angle = 180 - tank[turn].angle;
						
						tank[turn].bFacingRight = true;
						
						if( tank[turn].y > SCREEN_H - (int)terrain_y[ ++tank[turn].x ] )
							tank[turn].y = SCREEN_H - terrain_y[tank[turn].x];
						
						tank[turn].xBodyAngle = ftofix(atan2(g_nGradient[tank[turn].x], -1) * 128 / 3.142f + 128);
						tank[turn].nBodyAngle = 360 - fixtoi(tank[turn].xBodyAngle) * 360.0 / 256;
						
						if( g_bMultiplayer )
						{
							char text[513];
							sprintf (text, "%c%c%c%c%c%cCLN_MOVE_TANK", tank[turn].x / 255 + 1, (tank[turn].x % 255) + 1, tank[turn].y / 255 + 1, (tank[turn].y % 255) + 1, (unsigned char)tank[turn].bFacingRight + 2, tank[turn].angle + 1);
							net_send (g_llPlayers.getfirst()->contents->chan, text, strlen (text));						
						}
					}
				} else {
					if( g_nGradient[tank[turn].x] >= MAX_GRADIENT )
					{
						if( tank[turn].y > SCREEN_H - (int)terrain_y[ --tank[turn].x ] )
							tank[turn].y = SCREEN_H - terrain_y[tank[turn].x];
						
						tank[turn].xBodyAngle = ftofix(atan2(g_nGradient[tank[turn].x], -1) * 128 / 3.142f + 128);
						tank[turn].nBodyAngle = 360 - fixtoi(tank[turn].xBodyAngle) * 360.0 / 256;
					} else if( g_nGradient[tank[turn].x] <= -MAX_GRADIENT ) {
						if( tank[turn].y > SCREEN_H - (int)terrain_y[ ++tank[turn].x ] )
							tank[turn].y = SCREEN_H - terrain_y[tank[turn].x];
						
						tank[turn].xBodyAngle = ftofix(atan2(g_nGradient[tank[turn].x], -1) * 128 / 3.142f + 128);
						tank[turn].nBodyAngle = 360 - fixtoi(tank[turn].xBodyAngle) * 360.0 / 256;
					}
				}
			}
		} else if (g_bMultiplayer) {
			if (!strcmp((const char *)g_MPString + 6, "SVR_MOVE_TANK"))
			{
				tank[turn].x = ((int)g_MPString[0] - 1) * 255 + (int)g_MPString[1] - 1;
				tank[turn].y = ((int)g_MPString[2] - 1) * 255 + (int)g_MPString[3] - 1;
				
				tank[turn].bFacingRight = (g_MPString[4] - 2 ? true : false);
				tank[turn].angle = g_MPString[5] - 1;

				tank[turn].xBodyAngle = ftofix(atan2(g_nGradient[tank[turn].x], -1) * 128 / 3.142f + 128);
				tank[turn].nBodyAngle = 360 - fixtoi(tank[turn].xBodyAngle) * 360.0 / 256;
			}
		}
		
		if ((!g_bMultiplayer) || (turn == g_nPlayerID))
		{
			if ((key[KEY_LEFT]) && (tank[turn].angle < 180))
			{				 
				tank[turn].angle++;

				if( g_bMultiplayer && turn == g_nPlayerID )
				{
					char text[513];
					sprintf(text, "%cCLN_ROTATE_TURRET", tank[turn].angle + 1);
					net_send(g_llPlayers.getfirst()->contents->chan, text, strlen(text));
				}
			}
			if ((key[KEY_RIGHT]) && (tank[turn].angle > 0))
			{				 
				tank[turn].angle--;

				if( g_bMultiplayer && turn == g_nPlayerID )
				{
					char text[513];
					sprintf(text, "%cCLN_ROTATE_TURRET", tank[turn].angle + 1);
					net_send(g_llPlayers.getfirst()->contents->chan, text, strlen(text));
				}
			}
		} else if (g_bMultiplayer) {
			if (!strcmp((const char *)g_MPString + 1, "SVR_ROTATE_TURRET"))
			{
				tank[turn].angle = g_MPString[0] - 1;
				DrawTanks();
			}
		}

		UpdateShields();

		GrabTanks();
		DisplayTanks();

		if (key[KEY_F12])
			ScreenShot();
		
		for (ELEMENT<CExplosion> *explel = Explosion.getfirst(); explel != NULL; explel = explel->next)
			explel->contents->Remove();
		
		ELEMENT<PROJECTILE> *projel, *projel2;

		for (projel = Projectile.getfirst(); projel != NULL; projel = projel2)
		{
			projel2 = projel->next;
			projel->contents->Update();
		}
		
		if ((!g_bMultiplayer) || (turn == g_nPlayerID))
		{
			if (shooting)
			{
				g_iDelay++;
				
				if (g_iDelay >= weapon->contents->delay)
				{					
					if (g_iRound < weapon->contents->rounds)											
					{
						if( g_bMultiplayer && turn == g_nPlayerID )
						{
							char text[513];
							sprintf(text, "%c%c%c%c%c%c%cCLN_FIRE", tank[turn].x / 255 + 1, (tank[turn].x % 255) + 1, tank[turn].y / 255 + 1, (tank[turn].y % 255) + 1, tank[turn].angle + 1, tank[turn].nBodyAngle / 255 + 1, (tank[turn].nBodyAngle % 255) + 1);
							net_send(g_llPlayers.getfirst()->contents->chan, text, strlen(text));
						}

						new PROJECTILE(tank[turn].x + 15 * cos((3.142/180) * (tank[turn].angle + tank[turn].nBodyAngle)), tank[turn].y - pic->h - 15 * sin((3.142/180) * (tank[turn].angle + tank[turn].nBodyAngle)), tank[turn].angle + tank[turn].nBodyAngle,power,weapon->contents,0);
						if ((g_bSound) && (weapon->contents->firesound))
							play_sample(weapon->contents->firesound, 255, 128, 1000, 0);
					}
					g_iDelay = 0;
					g_iRound++; 				
				}
			}
		}
	}

	if ((g_bMultiplayer) && (!strcmp((const char *)g_MPString + 7, "SVR_FIRE")))
	{
		tank[turn].x = (g_MPString[0] - 1) * 255 + g_MPString[1] - 1;
		tank[turn].y = (g_MPString[2] - 1) * 255 + g_MPString[3] - 1;
		tank[turn].angle = g_MPString[4] - 1;
		tank[turn].nBodyAngle = (g_MPString[5] - 1) * 255 + g_MPString[6] - 1;
		new PROJECTILE(tank[turn].x + 15 * cos((3.142/180) * (tank[turn].angle + tank[turn].nBodyAngle)), tank[turn].y - pic->h - 15 * sin((3.142/180) * (tank[turn].angle + tank[turn].nBodyAngle)), tank[turn].angle + tank[turn].nBodyAngle, power, weapon->contents, 0);
		if ((g_bSound) && (weapon->contents->firesound))
			play_sample(weapon->contents->firesound, 255, 128, 1000, 0);

		g_iRound++;
	}
}

//////////////////////////////////////////////////////////////////////
// Draws next frame													//
//////////////////////////////////////////////////////////////////////
void DrawGraphics()
{
	ELEMENT<PROJECTILE> *projel;
	int a;

	for (projel = Projectile.getfirst(); projel != NULL; projel = projel->next)
		projel->contents->Grab();
	
	for (a = 0; a < CLOUDS; a++)		
		draw_sprite(buffer, cloud[a].pic, cloud[a].x - g_iTopleftx, cloud[a].y - g_iToplefty - cloud[a].pic->h);
	
	for (projel = Projectile.getfirst(); projel != NULL; projel = projel->next)
		projel->contents->Draw();
	
	if (bUpdateEx)
	{
		bUpdateEx = false;
		
		ELEMENT<CExplosion> *explel, *explel2;

		for (explel=Explosion.getfirst();explel!=NULL;explel=explel2)
		{
			explel2=explel->next;
			explel->contents->Update();
		}
	}

	DrawWeapon();
}

//////////////////////////////////////////////////////////////////////
// Check status of players etc										//
//////////////////////////////////////////////////////////////////////
void CheckStatus()
{
	int a;

	for (a = 0 ; a < g_iPlayers; a++)
	{
		if ((tank[a].health <= 0) && (!tank[a].dead))
			Explode(a);
	}
		
	if ((shooting == 2) && (!Projectile.getfirst()) && (!Explosion.getfirst()) && (g_iRound >= weapon->contents->rounds))
		NextTurn();
	
	for (a = 0; a < g_iPlayers; a++)
	{
		if ((!tank[a].dead) && ((int)(MAP_H - terrain_y[tank[a].x]) > tank[a].y))
		{
			UngrabTanks();
			tank[a].y++;
			tank[a].Move(tank[a].x, tank[a].y);
			GrabTanks();
			DisplayTanks();
		}
	}
}

//////////////////////////////////////////////////////////////////////
// Draw graphics to screen											//
//////////////////////////////////////////////////////////////////////
void BlitGraphics()
{
	int a;
	BITMAP *pic;

	blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, 50);
	
	for (a=0;a<CLOUDS;a++)
		blit(buffer, screen, cloud[a].x - g_iTopleftx, cloud[a].y - g_iToplefty - cloud[a].pic->h, cloud[a].x - g_iTopleftx, cloud[a].y - g_iToplefty - cloud[a].pic->h, cloud[a].pic->w, cloud[a].pic->h);
	
	pic = (BITMAP *)data[TANK1].dat;
	
	for (a = 0; a < g_iPlayers; a++)
	{
		if (!tank[a].dead)
			blit(buffer, screen, tank[a].x - g_iTopleftx - pic->w/2 - 20, tank[a].y - g_iToplefty - pic->h - 20, tank[a].x - g_iTopleftx - pic->w/2 - 20, tank[a].y - g_iToplefty - pic->h - 20, pic->w + 41, pic->h + 42);
	}
		
	for (ELEMENT<PROJECTILE> *projel = Projectile.getfirst(); projel != NULL; projel = projel->next)
		projel->contents->Blit();

}

//////////////////////////////////////////////////////////////////////
// Make terrain collapse											//
//////////////////////////////////////////////////////////////////////
void CollapseTerrain()
{
	int a,b,c;
	ELEMENT<AREA> *areael,*areael2;

	if ((!Explosion.getfirst()) && (!Projectile.getfirst()))
	{					
		for (areael = Area.getfirst(); areael != NULL; areael = areael2)
		{
			areael2 = areael->next;
			a = 0;
			
			int d, e;
			
			areael->contents->y1 = -1;
			UngrabTanks();
			
			for (c = areael->contents->bound1;c<areael->contents->bound2;c++)
			{
				if ((int)terrain_y[c] > areael->contents->y1)
					areael->contents->y1 = terrain_y[c];
				
				e=0;
				
				for (b = 0; b < (int)terrain_y[c]; b++)
				{
					d = getpixel(g_bmpMap, c, MAP_H - b - 1);
					if ((getpixel(g_bmpMap, c, MAP_H - b) == SKY_COL) && (d != SKY_COL))
					{
						blit(g_bmpMap, g_bmpMap, c, MAP_H - terrain_y[c] - 15, c, MAP_H - terrain_y[c] - 14, 1, terrain_y[c] - b + 15);
						blit(g_bmpMap, buffer, c, MAP_H - terrain_y[c] - 15, c - g_iTopleftx, MAP_H - g_iToplefty - terrain_y[c] - 15, 1, terrain_y[c] - b + 16);
						terrain_y[c]--;
						a=1;
						e=1;
						break;
					}
				}
												
				if (!e)
				{
					for (b = 0; b < (int)terrain_y[c]; b++)
					{
						if (getpixel(g_bmpMap, c, MAP_H - b) == SKY_COL)
						{
							terrain_y[c] = b;
							break;
						}
					}
				}

				if( c > 0 && c < (int)MAP_W - 1 )
					g_nGradient[c] = (float)((int)terrain_y[c + 1] - (int)terrain_y[c - 1]) / 2.0;
			}
			
			GrabTanks();
			DisplayTanks();
			blit(buffer, screen, areael->contents->bound1 - g_iTopleftx, MAP_H - g_iToplefty - areael->contents->y1 - 1, areael->contents->bound1 - g_iTopleftx, MAP_H - g_iToplefty - areael->contents->y1 - 1, areael->contents->bound2 - areael->contents->bound1, areael->contents->y1 + 2);
			
			if (!a)
			{
				AREA *area1 = areael->contents;
				Area.removeitem(areael->contents);
				delete area1;				
			}
		}		
	}	
}

//////////////////////////////////////////////////////////////////////
// Check for network messages										//
//////////////////////////////////////////////////////////////////////
void PollNetwork()
{
	int a, b;	
	char text[512]; 	
	
	if( turn != g_nPlayerID )
	{
		a = net_receive(g_llPlayers.getfirst()->contents->chan, text, 512, NULL);
		
		if( a > 0 )
		{
			text[a] = '\0'; 	
			
			strcpy((char *)g_MPString, text);		
		} else {
			for (a = 0; a < 10; a++)
				g_MPString[a] = '\0';
		}	
	}
	
	if( g_bServer )
	{
		a = net_receive((!turn ? g_llPlayers[0].chan : listenchan), text, 512, NULL);
		
		if( a > 0 )
		{
			text[a] = '\0'; 			
			
			ELEMENT<PLAYER> *tempel;
			
			if( a < 10 )
			{
				b = a + 1;
				
				for (a = b; a < 10; a++)
					text[a] = '\0';
			}
			
			if( !strcmp((const char *)text + 9, "CLN_FIND_POWER") )
			{
				sprintf(text, "%c%c%c%c%c%c%c%c%cSVR_FIND_POWER", text[0], text[1], text[2], text[3], text[4], text[5], text[6], text[7], text[8]);
				for (tempel = g_llPlayers.getfirst(), a = 0; tempel != NULL; tempel = tempel->next, a++)
				{
					if (a != turn)
						net_send(tempel->contents->chan, text, strlen(text));
				}
			} else if ( !strcmp((const char *)text + 6, "CLN_MOVE_TANK") ) {
				sprintf(text, "%c%c%c%c%c%cSVR_MOVE_TANK", text[0], text[1], text[2], text[3], text[4], text[5]);
				for (tempel = g_llPlayers.getfirst(), a = 0; tempel != NULL; tempel = tempel->next, a++)
				{
					if (a != turn)
						net_send(tempel->contents->chan, text, strlen(text));
				}
			} else if ( !strcmp((const char *)text + 2, "CLN_SEL_WEAP") ) {
				sprintf(text, "%c%cSVR_SEL_WEAP", text[0], text[1]);
				for (tempel = g_llPlayers.getfirst(), a = 0; tempel != NULL; tempel = tempel->next, a++)
				{
					if (a != turn)
						net_send(tempel->contents->chan, text, strlen(text));
				}
			} else if ( !strcmp((const char *)text, "CLN_WEAP_SEL") ) {
				sprintf(text, "SVR_WEAP_SEL");
				for (tempel = g_llPlayers.getfirst(), a = 0; tempel != NULL; tempel = tempel->next, a++)
				{
					if (a != turn)
						net_send(tempel->contents->chan, text, strlen(text));
				}
			} else if ( !strcmp((const char *)text, "CLN_EXPLODE") ) {
				sprintf(text, "SVR_EXPLODE");
				for (tempel = g_llPlayers.getfirst(), a = 0; tempel != NULL; tempel = tempel->next, a++)
				{
					if (a != turn)
						net_send(tempel->contents->chan, text, strlen(text));
				}
			} else if ( !strcmp((const char *)text + 1, "CLN_ROTATE_TURRET") ) {
				sprintf(text, "%cSVR_ROTATE_TURRET", text[0]);
				for (tempel = g_llPlayers.getfirst(), a = 0; tempel != NULL; tempel = tempel->next, a++)
				{
					if (a != turn)
						net_send(tempel->contents->chan, text, strlen(text));
				}
			} else if( !strcmp((const char *)text + 7, "CLN_FIRE") ) {			
				sprintf(text, "%c%c%c%c%c%c%cSVR_FIRE", text[0], text[1], text[2], text[3], text[4], text[5], text[6]);
				for (tempel = g_llPlayers.getfirst(), a = 0; tempel != NULL; tempel = tempel->next, a++)
				{
					if (a != turn)
						net_send(tempel->contents->chan, text, strlen(text));
				}
			} else if ( !strcmp((const char *)text + 2, "CLN_WEAPSEL") ) {
				sprintf(text, "%c%cSVR_WEAPSEL", text[0], text[1]);
				for (tempel = g_llPlayers.getfirst(), a = 0; tempel != NULL; tempel = tempel->next, a++)
				{
					if (a != turn)
						net_send(tempel->contents->chan, text, strlen(text));
				}
			}		
		}
	}	
}

//////////////////////////////////////////////////////////////////////
// Main game loop													//
//////////////////////////////////////////////////////////////////////
void Game()
{				
	GameInit();

	do {
		Scroll();
		if( g_bMultiplayer )
			PollNetwork();
		CheckInput();
		UngrabGraphics();
		TimedEvents();
               DrawGraphics();
		CheckStatus();
		BlitGraphics();
		CollapseTerrain();
	} while(1);
}

//////////////////////////////////////////////////////////////////////
// Draw loading dots												//
//////////////////////////////////////////////////////////////////////
void DoDots(DATAFILE *d)
{
	static int n = 0;
	BITMAP *pic = (BITMAP *)loaddata[DOT].dat;
	BITMAP *loading = (BITMAP *)loaddata[LOADING].dat;
	
	int a = n / (TURRET1 + 1);
	draw_sprite(screen, pic, SCREEN_W / 2 + loading->w / 2 + 15 + (pic->w + 15) * a, SCREEN_H / 2 + loading->h - 60);

	n++;	
}

//////////////////////////////////////////////////////////////////////
// Display 'Consular Computing' logo								//
//////////////////////////////////////////////////////////////////////
void FlashScreens()
{
	BITMAP *pic;
	PALETTE blackpal;
	int a;

	for (a = 0; a < 256; a++)
		blackpal[a].r = blackpal[a].g = blackpal[a].b = 0;

	fade_from((RGB *)loaddata[FLASHPAL].dat, blackpal, 4);
	clear_to_color(screen, 255);

	pic = (BITMAP *)data[CONSULAR].dat;
	blit(pic, screen, 0, 0, SCREEN_W / 2 - pic->w / 2, SCREEN_H / 2 - pic->h, pic->w, pic->h);
	pic = (BITMAP *)data[PRESENTS].dat;
	draw_sprite(screen, pic, SCREEN_W / 2 - pic->w / 2, 3 * SCREEN_H / 4 - pic->h * 2);

	fade_from(blackpal, (RGB *)loaddata[FLASHPAL].dat, 4);
	set_palette((RGB *)loaddata[FLASHPAL].dat);
	
	scroll_count = 0;	

	while (scroll_count < 100 && !keypressed());	

	RGB *p = (RGB *)data[GAMEPAL].dat;

	for (a = 0; a < 256; a++)	
		blackpal[a] = p[168];
	
	fade_from((RGB *)loaddata[FLASHPAL].dat, blackpal, 4);
}

//////////////////////////////////////////////////////////////////////
// Program entry point												//
//////////////////////////////////////////////////////////////////////
int main(int argc, char *argv[])
{
	int a;
	bool bFullScreen = true;

	allegro_init();
	install_timer();
	install_keyboard();

	for (a = 1; a < argc; a++)
	{
		if( argv[a][0] == '-' || argv[a][0] == '/' )
		{
			if( !strcmp(argv[a] + 1, "window") )
				bFullScreen = false;
		}
	}

	set_color_depth(8);
	set_gfx_mode((bFullScreen ? GFX_AUTODETECT : GFX_DIRECTX_WIN), 800, 600, 0, 0);

	set_color_conversion(COLORCONV_NONE);
	loaddata = load_datafile("loading.dat");

	PALETTE blackpal;
	for (a = 0; a <= 255; a++)
		blackpal[a].r = blackpal[a].g = blackpal[a].b = 0;
	set_palette(blackpal);

	clear_to_color(screen, 255);
	BITMAP *pic = (BITMAP *)loaddata[LOADING].dat;
	draw_sprite(screen, pic, SCREEN_W / 2 - pic->w / 2, SCREEN_H / 2 - pic->h / 2);	

	fade_from(blackpal, (RGB *)loaddata[FLASHPAL].dat, 7);

	data = load_datafile_callback("graphics.dat", DoDots);
		
	install_mouse();	

	LOCK_FUNCTION(inccounter);
	LOCK_FUNCTION(incscroll);
	LOCK_VARIABLE(counter);
	LOCK_VARIABLE(scroll_count);
	install_int(inccounter,35);
	install_int(incscroll, 15);

	g_bSound = true;

	BITMAP *loading = (BITMAP *)loaddata[LOADING].dat;
	pic = (BITMAP *)loaddata[DOT].dat;	
	draw_sprite(screen, pic, SCREEN_W / 2 + loading->w / 2 + pic->w + 30, SCREEN_H / 2 + loading->h - 60);

	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL))
		g_bSound = false;

	buffer = create_bitmap(SCREEN_W,SCREEN_H);	

	draw_sprite(screen, pic, SCREEN_W / 2 + loading->w / 2 + 15 + (pic->w + 15) * 2, SCREEN_H / 2 + loading->h - 60);

	for (a = 0; a < 255; a++)
		g_palWhite[a].r = g_palWhite[a].g = g_palWhite[a].b = 64;

	SKY_COL = 135;	
	EARTH_COL = 146;
	GRASS_COL = 28;	
	BLACK_COL = 161;	

	text_mode(-1);

	slongrand(time(NULL));	

	CreateTankGraphics();

	g_strName = new char[7];
	strcpy(g_strName, "Player");

	FlashScreens();

	Title();

	fade_from(g_palGame, blackpal, 4);
	clear_to_color(screen, 255);
	pic = (BITMAP *)loaddata[LOADING].dat;
	draw_sprite(screen, pic, SCREEN_W / 2 - pic->w / 2, SCREEN_H / 2 - pic->h / 2);
	
	fade_from(blackpal, (RGB *)loaddata[FLASHPAL].dat, 4);

	toolbar = create_sub_bitmap(buffer,0,0,SCREEN_W,50);

	DrawToolBar();

	LoadWeapons();

	for (a = 0; a < g_iPlayers; a++)
	{
		tank[a].cash = 1000;
		tank[a].grab = NULL;
	}

	games = 0;

	create_trans_table(&g_TransTable, (RGB *)data[GAMEPAL].dat, 128, 128, 128, NULL);
	color_map = &g_TransTable;

	fade_from((RGB *)loaddata[FLASHPAL].dat, blackpal, 4);
	clear_to_color(screen, BLACK_COL);	

	PALETTE *p=(PALETTE *)data[GAMEPAL].dat;
	set_pallete(*p);
	get_palette(g_palGame);

	Game();

	Projectile.clear();
	Explosion.clear();

	exit(EXIT_SUCCESS);
}

END_OF_MAIN();

//////////////////////////////////////////////////////////////////////