#ifndef SHIELD_H	// Check for duplicate includes

#define SHIELD_H

//////////////////////////////////////////////////////////////////////
// Includes															//
//////////////////////////////////////////////////////////////////////
					//												//
#include <math.h>	// Maths routines								//
					//												//
//////////////////////////////////////////////////////////////////////

#ifndef WEAPONS_H

struct VALUEs
{
	short int value;
    short int spread;
};

struct VALUEf
{
	float value;
    float spread;
};

#endif // WEAPONS_H

//////////////////////////////////////////////////////////////////////
// Details of a shield type											//
//////////////////////////////////////////////////////////////////////
class SHIELD_TYPE
{
public:
	char *name;
	char *description;
	int cost;
	int initial;
	BITMAP *icon;

	VALUEf ratio;
	VALUEs effect;
	int duration;
	unsigned char colour;
	SAMPLE *hit_sound;

	VALUEs spark_num;
	int spark_width;
	int spark_height;
	bool spark_border;
	VALUEf spark_mass;
	BITMAP *spark_pic;
	VALUEf spark_scale;
	int anim_type;
	VALUEs anim_rate;	

	int *quantity;
	int *nRoundStart;

	SHIELD_TYPE();
};

//////////////////////////////////////////////////////////////////////
// Details of a shield												//
//////////////////////////////////////////////////////////////////////
class SHIELD
{
private:
	int m_radius;
	int m_thickness;
    int m_frame;
    int m_ang1;
	int m_ang2;
	int m_ang3;
    int m_speed1;
    int m_speed2;
    int m_lightning;
	int m_x, m_y;
	int m_hits;

	SHIELD_TYPE *m_type;

public:
	SHIELD (int x, int y, int col, SHIELD_TYPE *type);	
	SHIELD_TYPE *GetType();
	void Draw();
	void Move(int x, int y);
	bool Hit();
	void Update();
};

#endif // SHIELD_H

//////////////////////////////////////////////////////////////////////