//////////////////////////////////////////////////////////////////////
// Includes															//
//////////////////////////////////////////////////////////////////////
						//											//
#include "shrapnel.h"	// Shrapnel header							//
#include "projectile.h"	// PROJECTILE class definition				//
#include "jrnd.h"		// Prototypes for random number generator	//
						//											//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Create a new projectile											//
//	g: Generation of particle										//
//////////////////////////////////////////////////////////////////////
PROJECTILE::PROJECTILE(int xx,int yy,int ang,float pow,WEAPONTYPE *t,int g)
{
	x = xx;
	y = yy;
	angle = ang;
	power = pow;
	powery = pow * sin((3.142/180) * ang);
	type = t;
	gfx_set = longrand() % (type->pic->h / (type->height + type->border));
	fuse = type->fuse_init;
	generation = g;
	times = 0;
	frame = 0;
	fuse_start = (type->fuse_start.spread ? type->fuse_start.value - type->fuse_start.spread + longrand() % (type->fuse_start.spread * 2) : type->fuse_start.value);
	fuse_loop = (type->fuse_loop.spread ? type->fuse_loop.value - type->fuse_loop.spread + longrand() % (type->fuse_loop.spread * 2) : type->fuse_loop.value);
	gravity = (type->gravity.spread ? type->gravity.value - type->gravity.spread + (longrand() % (int)(type->gravity.spread * 200))/100.0 : type->gravity.value);
	scale = (type->scale.spread ? type->scale.value - type->scale.spread + (longrand() % (int)(type->scale.spread * 200))/100.0 : type->scale.value);
	spin_rate = (type->spin_rate.spread ? type->spin_rate.value - type->spin_rate.spread + longrand() % (type->spin_rate.spread * 2) : type->spin_rate.value);
	anim_rate = (type->anim_rate.spread ? type->anim_rate.value - type->anim_rate.spread + longrand() % (type->anim_rate.spread * 2) : type->anim_rate.value);
	frame_count = anim_rate;
	draw_ang = 0;
	fuse_count = 0;

	// Calculate the widest/tallest possible angle that the image could be at
	int min = MIN(type->width, type->height);
	int max = MAX(type->width, type->height);
	double a = atan((double)min / max);	
	
	// Create grab bitmap
	grab = create_bitmap((int)((max * cos(a) + min * sin(a)) * scale) + 4, (int)((max * cos(a) + min * sin(a)) * scale) + 4);

	// Blit from buffer to the new grab bitmap
	blit(buffer, grab, (int)x - g_iTopleftx - grab->w/2, (int)y - g_iToplefty - grab->h/2, 0, 0, grab->w, grab->h);

	Projectile.additem(this);	// Add projectile to linked list
}

//////////////////////////////////////////////////////////////////////
// Blit from grab to buffer											//
//////////////////////////////////////////////////////////////////////
void PROJECTILE::UnGrab()
{
	blit(grab, buffer, 0, 0, (int)x - g_iTopleftx - grab->w/2, (int)y - g_iToplefty - grab->h/2, grab->w, grab->h);
}

//////////////////////////////////////////////////////////////////////
// Blit from buffer to grab											//
//////////////////////////////////////////////////////////////////////
void PROJECTILE::Grab()
{
	blit(buffer, grab, (int)x - g_iTopleftx - grab->w/2, (int)y - g_iToplefty - grab->h/2, 0, 0, grab->w, grab->h);
}

//////////////////////////////////////////////////////////////////////
// Split projectile p into lots of smaller ones						//
//	randval: Possible range of angles								//
//	startval: Minimum possible angle								//
//////////////////////////////////////////////////////////////////////
bool Split(PROJECTILE *p, int randval, int startval)
{
	if ((!p->type->generations) || (p->generation < p->type->generations))	// Make sure generations limit has not been exceeded
	{
		for (int a = 0; a < (p->type->wh_number.spread ? p->type->wh_number.value - p->type->wh_number.spread + longrand() % (p->type->wh_number.spread * 2) : p->type->wh_number.value); a++)
			new PROJECTILE(p->x, p->y, startval + longrand()%randval, (longrand()%(int)(MAXPOWER/0.2))/10.0, p->type->warhead, p->generation + 1);
	} else return false;

	if (!p->type->Continue)
	{
		Projectile.removeitem(p); // Remove this projectile from linked list

		// Erase projectile from screen
		blit(buffer,screen,p->ox - (int)(p->type->width * p->scale)/2 - 2, p->oy - (int)(p->type->height * p->scale)/2 - 2, p->ox - (int)(p->type->width * p->scale)/2 - 2, p->oy - (int)(p->type->height * p->scale)/2 - 2, (int)(p->type->width * p->scale) + 4, (int)(p->type->height * p->scale) + 4);
	}

	return true;
}

//////////////////////////////////////////////////////////////////////
// Move projectile/check for collisions								//
//////////////////////////////////////////////////////////////////////
void PROJECTILE::Update()
{
	int a;	
	BITMAP *pic;
	bool bl = true;
    int target_tank;

	if (angle < 90)
		draw_ang += spin_rate;
	else draw_ang -= spin_rate;
	draw_ang &= 255;

	if (type->homing)
	{
    	int max_dist = -1;

    	for (a = 0; a < g_iPlayers; a++)
        {
        	if ((a != turn) && (!tank[a].dead) && ((max_dist == -1) || (hypot(tank[a].x - x, tank[a].y - y) < max_dist)))
            {
				max_dist = (int)hypot(tank[a].x - x, tank[a].y - y);
                target_tank = a;
            }
        }

		int d_ang = 256 - (int)(atan2(tank[target_tank].y - y, tank[target_tank].x - x) * 128/3.142);
		d_ang &= 255;

		int ang_diff = d_ang - (int)(angle * 256/360.0);
		a = 0;

		if (ang_diff < 0)
		{
			ang_diff *= -1;
			a = 1;
		}

		int end_dist = 256 - ang_diff;
		int turn_way = 1;

		if (!ang_diff) turn_way = 0;
		else if ((end_dist < ang_diff) && (!a)) turn_way = -1;
		else if ((end_dist < ang_diff) && (a)) turn_way = 1;
		else if ((end_dist >= ang_diff) && (a)) turn_way = -1;

		angle += turn_way * type->turnrate;

		if (angle < 0) angle += 360;
		else if (angle >= 360) angle -= 360;
	}

	frame_count--;
	if (frame_count < 0)
	{
		if (type->anim_type == 2)
			frame = longrand() % (type->pic->w / (type->width + type->border));
		else {
			frame++;

			if (frame * (type->width + type->border) >= type->pic->w)
			{
				if (type->anim_type == 0)
					frame = 0;
				else if (type->anim_type == 1)
				{
					Projectile.removeitem(this);
					UnGrab();
					Blit();
					shooting = 2;
					delete this;
					return;
				} else if (type->anim_type == 3) {
					frame--;
				}
			}
		}

		frame_count = anim_rate;
	}

	ox = (int)x - g_iTopleftx;
	oy = (int)y - g_iToplefty;
	x += power*cos((3.142/180)*angle);
	y -= powery;
	powery -= gravity;	// Each frame vertical power decreases, giving the effect of gravity
	
	if (type->time < 0)
	{		
		for (a = 0; a < g_iPlayers; a++)
			if (hypot(x - tank[a].x, y - tank[a].y) < type->time * -1)
				bl = false;

		if ((bl) && (!g_bOutsideRange))
			g_bOutsideRange = true;
	}

	if (fuse > 0)
		fuse--;

	float h_dist;

	if ((type->time == 3) || (type->wh_relative == 2))
	{
    	int max_dist = -1;

    	for (a = 0; a < g_iPlayers; a++)
        {
        	if ((a != turn) && (!tank[a].dead) && ((max_dist == -1) || (hypot(tank[a].x - x, tank[a].y - y) < max_dist)))
            {
				max_dist = (int)hypot(tank[a].x - x, tank[a].y - y);
                target_tank = a;
            }
        }

		h_dist = x - tank[target_tank].x;
		if (angle < 90)
			h_dist *= -1;
	}

	if (((type->time == 1) && ((int)powery == 0))  // At peak of projection
	|| ((type->time == 0) && (key[KEY_SPACE]))
	|| ((type->time < 0) && (!bl) && (g_bOutsideRange)) // Within range
	|| ((fuse == 0) && ((fuse_count < type->fuse_count) || (!type->fuse_count)))
	|| ((type->time == 3) && (h_dist <= 1)))
	{
		if ((type->fuse_init == -1) && (fuse == -1))
			fuse = fuse_start;

		if ((type->action == 1) || (fuse == 0))// Split
		{
			bool result;

			if( type->times == -1 || times < type->times )
			{
				if (type->wh_relative != 2)
					result = Split(this, (type->wh_angle.spread ? type->wh_angle.spread * 2 : 1), (type->wh_relative ? angle : 0) + type->wh_angle.value - type->wh_angle.spread/2);
				else {
					int p_ang = 360 - (int)(atan2(tank[target_tank].y - y, tank[target_tank].x - x) * 180/3.142);
					result = Split(this, (type->wh_angle.spread ? type->wh_angle.spread * 2 : 1), p_ang - type->wh_angle.spread/2);
				}
				
				times++;			
				
				if ((g_bSound) && (type->hitsound)) // Play explosion sound
					play_sample(type->hitsound, 255, 128, 1000, 0);
				
				if ((!type->Continue) && (result))
				{
					delete this;
					return;
				}
			}
		} else if (type->action == 2) { // Reproject
			int ang = (int)(atan2(powery*-1, power) * 180/3.142);	// Calculate current angle
			if (angle > 90)
				ang=180-ang;

			power /= 2; // Reduce power
			powery = power;
			angle = ang;
			y = oy;
			x += power*cos((3.142/180)*angle);
			y -= powery*sin((3.142/180)*angle);
						
			Grab();
						
			if ((int)power == 0)
			{
				shooting = 2;
				Remove();
				new CExplosion((int)x, (int)y, (type->size.spread ? type->size.value - type->size.spread + longrand() % (type->size.spread * 2) : type->size.value));

				Projectile.removeitem(this);

				if ((g_bSound) && (type->hitsound))
					play_sample(type->hitsound, 255, 128, 1000, 0);

				delete this;
			}			
		}

		if (fuse == 0)
		{
			if (fuse_loop)
				fuse = fuse_loop;
			else fuse = -2;
			fuse_count++;
		}
	}
	
	if ((x/* - grab->w/2*/ > MAP_W - 1) || (x/* + grab->w/2*/ < 0) || (y - (type->height * scale)/2 >= SCREEN_H))
    {
		Projectile.removeitem(this);
		if ((!Projectile.getfirst()) && (!Explosion.getfirst()) && (g_iRound >= weapon->contents->rounds))
			NextTurn();
		blit(buffer, screen, ox - (int)(type->width * scale)/2 - 2, oy - (int)(type->height * scale)/2 - 2, ox - (int)(type->width * scale)/2 - 2, oy - (int)(type->height * scale)/2 - 2, (int)(type->width * scale) + 4, (int)(type->height * scale) + 4);
		delete this;
		return;
	}

	SHIELD_TYPE *SType;

	// Check if tank has been hit
	for (a = 0; a < g_iPlayers; a++)
	{
		if (!tank[a].dead)
		{
			pic = tank[a].pic;
			SType = tank[a].HasShield();

			if( SType )	// Has shield
			{
				if( hypot(x - tank[a].x, y - tank[a].y) < 27 ) // Hit shield
				{
					if( SType->effect.value == 1 ) // Destroy projectile
					{
						Projectile.removeitem(this);
						if ((!Projectile.getfirst()) && (!Explosion.getfirst()) && (g_iRound >= weapon->contents->rounds))
							NextTurn();
						blit(buffer, screen, ox - (int)(type->width * scale)/2 - 2, oy - (int)(type->height * scale)/2 - 2, ox - (int)(type->width * scale)/2 - 2, oy - (int)(type->height * scale)/2 - 2, (int)(type->width * scale) + 4, (int)(type->height * scale) + 4);
						tank[a].HitShield();
						delete this;
						return;
					}
				}
			}

			if (((int)x >= tank[a].x - pic->w/2) && ((int)x < tank[a].x + pic->w/2) && ((int)y <= tank[a].y) && ((int)y > tank[a].y - pic->h))
			{
				if (getpixel(pic, (int)x - tank[a].x + pic->w/2, (int)y - tank[a].y + pic->h) != MASK_COLOR_8)
				{
					Remove();
					new CExplosion((int)x, (int)y, (type->size.spread ? type->size.value - type->size.spread + longrand() % (type->size.spread * 2) : type->size.value));					
					tank[a].health -= ((type->damage.spread ? type->damage.value - type->damage.spread + longrand() % (type->damage.spread * 2) : type->damage.value) - (SType ? (SType->effect.value < 0 ? (SType->effect.spread ? SType->effect.value - SType->effect.spread / 2 + longrand() % SType->effect.spread : SType->effect.value) : 0) : 0) * (type->damage.value > 0 ? 1 : -1)) * (SType ? (SType->ratio.spread ? SType->ratio.value - SType->ratio.spread / 2 + (longrand() % (int)(SType->ratio.spread * 100)) / 100.0f : SType->ratio.value) : 1.0f);
					rectfill(toolbar, 55 + (int)(a * (680.0 / (g_iPlayers - 1))), 20, 104 + (int)(a * (680.0 / (g_iPlayers - 1))), 35, makecol(255,99,0));
					shooting = 2;
					if ((g_bSound) && (type->hitsound))
						play_sample(type->hitsound, 255, 128, 1000, 0);
					Projectile.removeitem(this);
					delete this;
					return;
				}
			}
		}
	}
	
	// Get colour at new position
	if (y > 0)//(type->height * scale)/2)
		a = getpixel(g_bmpMap, (int)x, (int)y);
	else a = SKY_COL;
	
	if (a != SKY_COL) // Projectile has hit the ground
	{
		pic = (BITMAP *)data[TANK1].dat;
		for (a = 0; a < g_iPlayers; a++)
		{
			if (!tank[a].dead)
			{
				// Check if shot is within range of a tank
				if ((hypot(x - tank[a].x, y - tank[a].y) <= type->size.value) || (hypot(x - tank[a].x, y-tank[a].y-pic->h) <= type->size.value) || (hypot(x-tank[a].x - pic->w/2, y-tank[a].y-pic->h/2) <= type->size.value) || (hypot(x - tank[a].x + pic->w/2, y - tank[a].y - pic->h/2) <= type->size.value))
				{
					Remove();
					new CExplosion((int)x, (int)y, (type->size.spread ? type->size.value - type->size.spread + longrand() % (type->size.spread * 2) : type->size.value));
					tank[a].health -= (type->damage.spread ? type->damage.value - type->damage.spread + longrand() % (type->damage.spread * 2) : type->damage.value);
					rectfill(toolbar, 55 + (int)(a * (680.0 / (g_iPlayers - 1))), 20, 104 + (int)(a * (680.0 / (g_iPlayers - 1))), 35, makecol(255,99,0));
					shooting=2;
					
					Projectile.removeitem(this);
					
					if ((g_bSound) && (type->hitsound))
						play_sample(type->hitsound, 255, 128, 1000, 0);
					
					delete this;
					return;
				}
			}
		}
		if (type->time == 2)	// On collision
		{
			if (type->action == 1)	// Split
			{
				if( type->times == -1 || times < type->times )
				{					
					Split(this, (type->wh_angle.spread ? type->wh_angle.spread * 2 : 1), (type->wh_relative ? angle : 0) + type->wh_angle.value - type->wh_angle.spread/2);
					
					if ((g_bSound) && (type->hitsound))
						play_sample(type->hitsound, 255, 128, 1000, 0);
					
					times++;
					
					if (!type->Continue)
						delete this;					
				}
				return;
			} else if (type->action == 2) { // Reproject
				int ang = (int)(atan2(powery*-1, power) * 180/3.142);	// Calculate current angle
				
				if (angle > 90)
					ang=180-ang;
				
				power/=2;
				powery = power;
				
				if (type->angle.value == -1)
					angle = ang;
				else angle = type->angle.value - type->angle.spread + longrand() % (type->angle.spread * 2);
				
				y = oy;
				x += power*cos((3.142/180)*angle);
				y -= powery*sin((3.142/180)*angle); 				
				
				Grab();
				
				a = getpixel(g_bmpMap,(int)x - (int)(type->width * scale)/2, (int)y - (int)(type->height * scale)/2);
				
				if (((int)power==0) || (a!=SKY_COL))
				{
					shooting=2;
					Remove();
					new CExplosion((int)x, (int)y, (type->size.spread ? type->size.value - type->size.spread + longrand() % (type->size.spread * 2) : type->size.value));
					
					Projectile.removeitem(this);
					
					if ((g_bSound) && (type->hitsound))
						play_sample(type->hitsound, 255, 128, 1000, 0);
					
					delete this;
				}
				return;
			}
		}
		
		shooting=2;
		
		if ((g_bSound) && (type->hitsound))
			play_sample(type->hitsound, 255, 128, 1000, 0);
		
		Remove();
		new CExplosion((int)x, (int)y, (type->size.spread ? type->size.value - type->size.spread + longrand() % (type->size.spread * 2) : type->size.value));
		
		Projectile.removeitem(this);
		delete this;							
	}  
}

//////////////////////////////////////////////////////////////////////
// Draw projectile to buffer										//
//////////////////////////////////////////////////////////////////////
void PROJECTILE::Draw()
{
	fixed ang = 0;
	
	if ((type->rotating) || (type->directional)) // Work out what angle projectile is moving in
		ang = itofix(128 - (int)(atan2(powery, power * cos((3.142/180) * angle)) * 128/3.142));
	
	if (spin_rate)
		ang = itofix(draw_ang);
	
	BITMAP *pic = create_bitmap((int)(type->width * scale), (int)(type->height * scale));//create_sub_bitmap(type->pic, frame * type->width, 0, type->width, type->pic->h);
	stretch_blit(type->pic, pic, frame * (type->width + type->border), gfx_set * (type->height + type->border), type->width, type->height, 0, 0, (int)(type->width * scale), (int)(type->height * scale));

	if (!type->directional) // Rotate the sprite
		rotate_sprite(buffer, pic, (int)x - g_iTopleftx - pic->w/2, (int)y - g_iToplefty - pic->h/2, ang);
	else {	// Draw the sprite facing in which ever direction it is moving
		if ((ang > itofix(64)) && (ang < itofix(192)))
			rotate_sprite_v_flip(buffer, pic, (int)x - g_iTopleftx - pic->w/2, (int)y - g_iToplefty - pic->h/2, (type->rotating ? ang : itofix(128)));
		else rotate_sprite(buffer, pic, (int)x - g_iTopleftx - pic->w/2, (int)y - g_iToplefty - pic->h/2, (type->rotating ? ang : 0));
	}

	destroy_bitmap(pic);
}

//////////////////////////////////////////////////////////////////////
// Remove projectile from screen									//
//////////////////////////////////////////////////////////////////////
void PROJECTILE::Remove()
{
	blit (grab, buffer, 0, 0, ox - grab->w / 2, oy - grab->h / 2, grab->w, grab->h);
	blit (buffer, screen, ox - grab->w / 2, oy - grab->h / 2, ox - grab->w / 2, oy - grab->h / 2, grab->w, grab->h);
}

//////////////////////////////////////////////////////////////////////
// Blit from buffer to screen										//
//////////////////////////////////////////////////////////////////////
void PROJECTILE::Blit()
{
	blit (buffer, screen, (int)x - g_iTopleftx - grab->w / 2, (int)y - g_iToplefty - grab->h / 2, (int)x - g_iTopleftx - grab->w / 2, (int)y - g_iToplefty - grab->h / 2, grab->w, grab->h);
	blit (buffer, screen, ox - grab->w / 2, oy - grab->h / 2, ox - grab->w / 2, oy - grab->h / 2, grab->w, grab->h);
}

//////////////////////////////////////////////////////////////////////