#ifndef MENU_H	// Check for duplicate includes

#define MENU_H

//////////////////////////////////////////////////////////////////////
// Defines															//
//////////////////////////////////////////////////////////////////////
								//									//
#define C_RADIUS   5			// Radius of GUI corners			//
								//									//
//////////////////////////////////////////////////////////////////////
// Includes															//
//////////////////////////////////////////////////////////////////////
						//											//
#include <stdlib.h>		// Standard library header					//		
#include <string.h>		// String manipulation functions			//
#include <allegro.h>	// Allegro header							//
#include "array.h"		// ARRAY class definition					//
#include "graphics.h"	// Graphics file header						//
						//											//
//////////////////////////////////////////////////////////////////////
// Global variables													//
//////////////////////////////////////////////////////////////////////
								//									//
extern BITMAP *buffer;			// Video buffer						//
extern DATAFILE *data;			// Graphics data file				//
extern volatile int counter;	// Timer							//
								//									//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Generic GUI object												//
//////////////////////////////////////////////////////////////////////
class SHRAPNEL_GUI
{
protected:
	int m_x, m_y;
	int m_width, m_height;
    BITMAP *m_bmpGrab;
	int c;	

public:
	void Open(int x, int y, int w, int h);
	void Draw(bool Refresh);
	void Close();
};

//////////////////////////////////////////////////////////////////////
// Menu object														//
//////////////////////////////////////////////////////////////////////
class SHRAPNEL_MENU : public SHRAPNEL_GUI
{
private:
	char **m_options;
	int m_cOptions;
	int m_arrowx;
    int m_x, m_y;
    int m_width, m_height;
    int m_bordx, m_bordy;
	void DoBar();
	void RemoveBar();

	int m_AltKey;
	void (*m_Action)(int);
	void (*m_AltAction)(int);
	void (*m_DrawText)(int n, int col);

	int mouse_r;
	int omx, omy;
	bool mouse_in;    

	int e;

public:
	int m_selected;

    void Do(int x, int y, int w, int h, int bordx, int bordy, char **options, void (*DrawText)(int n, int col) = NULL, void (*Action)(int) = NULL, void (*AltAction)(int) = NULL, int akey = -1);
	void Open(int x, int y, int w, int h, int bordx, int bordy, char **options, void (*DrawText)(int n, int col) = NULL, void (*Action)(int) = NULL, void (*AltAction)(int) = NULL, int akey = -1);
	void Draw();
    void DrawOptions();
	void DrawOption();
	void ChangeOption(int n, char *text);
	int Update();
   	void Close();
};

//////////////////////////////////////////////////////////////////////
// Text input box													//
//////////////////////////////////////////////////////////////////////
class SHRAPNEL_INPUT : public SHRAPNEL_GUI
{
private:	
	char *m_strTitle;
	char *m_strText;
	char *m_strOldText;

public:
	char *Do(int x, int y, int w, int h, char *title, char *text);
};

#endif

//////////////////////////////////////////////////////////////////////