#ifndef ARRAY_H

#define ARRAY_H

template <class T>
	class ARRAY;

template<class T>
	class ELEMENT
	{
    	private:
        	ARRAY<T> *array;
    	public:
			T *contents;
			ELEMENT<T> *prev;
			ELEMENT<T> *next;
	};

template <class T>
	class ARRAY
	{
		private:
			ELEMENT<T> *first;
			ELEMENT<T> *last;
		public:
            int size;

        	ARRAY();
            ~ARRAY();
			ELEMENT<T> *additem(T *obj);
            void clear();
            void empty();
            ELEMENT<T> *getfirst() const { return first; }
            ELEMENT<T> *getlast() const { return last; }
			T & operator[](unsigned short offset);
			int removeitem(T *obj);
	};

template <class T>
	class MASTERARRAY : public ARRAY<T>
    {
    	public:
	    	~MASTERARRAY();
    };

#include "array.cpp"

#endif
