#ifndef STRUCTS_H		// Check for duplicate includes

#define STRUCTS_H

struct CLOUD
{
	int x,y;
	BITMAP *pic;
};

struct DEBRIS	// Black debris created when tanks explode
{
	float x,y;				// Co-ordinates of centre
	int points; 			// Number of corners
	int dist[MAXPOINTS];	// Distance of each point from the centre
	int ang[MAXPOINTS]; 	// Angle of each corner
	int fangle; 			// Angle of debris itself
	float fpower,fpowery;	// Horizontal and vertical power
    char col;				// Colour
	int ox,oy;				// Position last frame
	BITMAP *grab;			// Used to store previous screen contents
};

struct SAND // Sand particle used in explosions
{
	double x,y; 			// Position
	double angle;			// Angle of projection
	double power,powery;	// Horizontal and vertical power
	char finished;			// Flag for when particle has landed
	bool started;			// Flag to indicate that particle has not been drawn yet
};

struct PLAYER	// Multiplayer game node
{
	char *name;
	NET_CHANNEL *chan;
	char *address;
};

//////////////////////////////////////////////////////////////////////
// An area sounds each explosion, so that ground can collapse		//
//////////////////////////////////////////////////////////////////////
class AREA	
{
	public:
		int bound1,bound2;	// Left and right x co-ordinate of area
		int y1; 			// Highest point within area
};

//////////////////////////////////////////////////////////////////////
// Particle explosion, for when projectiles hit ground				//
//////////////////////////////////////////////////////////////////////
class CExplosion 
{
	private:
		int x,y;				// Co-ordinates of centre
		int size;				// Radius of explosion
		int bits;				// Number of particles
		SAND *sand; 			// Array of sand particles

	public:
		void Update();			// Move/draw particles
		void Remove();			// Remove particles from screen
		CExplosion(int xx,int yy,int s); // Constructor
};

#endif	// STRUCTS_H