//////////////////////////////////////////////////////////////////////
// Includes															//
//////////////////////////////////////////////////////////////////////
						//											//
#include "shrapnel.h"	// Shrapnel header							//
#include "shield.h"		// SHIELD class definition					//
						//											//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Helper function for lightning() to draw a point					//
//////////////////////////////////////////////////////////////////////
void lightning_helper(BITMAP *buf, int x, int y, int d)
{
	if( getpixel(g_bmpMap, x + g_iTopleftx, y + g_iToplefty) == SKY_COL )
	{
		vline(buffer, x, y - 2, y + 2, d + 2);
		hline(buffer, x - 2, y, x + 2, d + 2);
		vline(buffer, x, y - 1, y + 1, d);
		hline(buffer, x - 1, y, x + 1, d);
		putpixel(buffer, x, y, d + 1);
	}
}

//////////////////////////////////////////////////////////////////////
// Draws an electricity/lightning effect between the given points	//
//////////////////////////////////////////////////////////////////////
void draw_lightning(int x1, int y1, int x2, int y2, int col)
{
	int i;
	int x[10];
	int y[10];
	int dx = (x2-x1)/8;
	int dy = (y2-y1)/8;
	int var = (MAX(abs(x2-x1),abs(y2-y1)) / 5);

	if (var == 0)
		var = 1;
	if (var > 10)
		var = 10;

	x[0] = x1;
	y[0] = y1;
	x[9] = x2;
	y[9] = y2;

	for (i=1; i<9; i++)
	{
		x[i] = x1+(dx*i) - (var>>1) + (rand()%var);
		y[i] = y1+(dy*i) - (var>>1) + (rand()%var);
	}

	// drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	for (i=0; i<9; i++)
		do_line(buffer, x[i], y[i], x[i+1], y[i+1], col, lightning_helper);
	//  drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
}

//////////////////////////////////////////////////////////////////////
// SHIELD constructor												//
//////////////////////////////////////////////////////////////////////
SHIELD::SHIELD(int x, int y, int col, SHIELD_TYPE *type)
{
	m_x = x;
	m_y = y;
	m_type = type;	
	m_frame = 4;
	m_ang1 = m_ang2 = m_ang3 = 0;
    m_speed1 = rand()%5 + 2;
    m_speed2 = rand()%5 + 2;
    m_lightning = -rand()%5;

	if( type->duration > 0 )
		m_hits = type->duration;
}

//////////////////////////////////////////////////////////////////////
// Draws Shield														//
//////////////////////////////////////////////////////////////////////
void SHIELD::Draw()
{
	int a, b;

	for (int nAngle = 0; nAngle < 360; nAngle++)
	{
		for (int nRadius = m_radius + m_thickness; nRadius < m_radius + 3; nRadius++)
		{
			a = m_x + nRadius * sin((3.142/180) * nAngle);
			b = m_y + nRadius * cos((3.142/180) * nAngle);
			if( getpixel(g_bmpMap, a, b) == SKY_COL )
				putpixel(buffer, a - g_iTopleftx, b - g_iToplefty, m_type->colour + rand() % 3);
		}
	}
	
	if( m_lightning >= 0 )
	{
        draw_lightning( m_x + 28 * sin((3.142/180) * m_ang1) - g_iTopleftx, m_y + 28 * cos((3.142/180) * m_ang1) - g_iToplefty,  m_x + 28 * sin((3.142/180) * m_ang2) - g_iTopleftx, m_y + 28 * cos((3.142/180) * m_ang2) - g_iToplefty, m_type->colour);
		m_ang1 -= m_speed1;
        m_ang2 += m_speed2;
        if ((m_ang1 < m_ang3 - 180) || (m_ang2 > m_ang3 + 180))
        {
			m_ang3 = rand()%360;
			m_ang1 = m_ang3;
			m_ang2 = m_ang3;
            m_speed1 = rand()%6 + 4;
            m_speed2 = rand()%6 + 4;
            m_lightning = -rand()%30;
        }
	}	
}

//////////////////////////////////////////////////////////////////////
// Updates Shield													//
//////////////////////////////////////////////////////////////////////
void SHIELD::Update()
{
	m_frame ++;	

	if( m_frame >= 3 )
	{
		m_frame = 0;
		m_radius = rand() % 2 + 27;
		m_thickness = rand() % 3 + 1;
	}
	
	m_lightning++;
}

//////////////////////////////////////////////////////////////////////
// Repositions shield												//
//////////////////////////////////////////////////////////////////////
void SHIELD::Move(int x, int y)
{
	m_x = x;
	m_y = y;
}

//////////////////////////////////////////////////////////////////////
// Called when shield is hit										//
//////////////////////////////////////////////////////////////////////
bool SHIELD::Hit()
{
	if( m_hits > 0 )
	{
		m_hits--;
		
		if( m_hits <= 0 )
			return true;
	}

	return false;
}

//////////////////////////////////////////////////////////////////////
// Return type of shield											//
//////////////////////////////////////////////////////////////////////
SHIELD_TYPE *SHIELD::GetType()
{
	return m_type;
}

//////////////////////////////////////////////////////////////////////
// SHIELD_TYPE Constructor											//
//////////////////////////////////////////////////////////////////////
SHIELD_TYPE::SHIELD_TYPE()
{
	quantity = new int[g_iPlayers];
	nRoundStart = new int[g_iPlayers];

	icon = NULL;
	description = NULL;
	name = NULL;
	cost = 0;
	initial = 0;

	ratio.value = 1.0f;
	ratio.spread = 0.0f;
	effect.value = 0;
	effect.spread = 0;
	duration = 0;
	colour = 253;
	hit_sound = NULL;	

	spark_num.value = 0;
	spark_num.spread = 0;
	spark_border = false;
	spark_mass.value = 0.5f;
	spark_mass.spread = 0.0f;
	spark_pic = NULL;
	spark_width = -1;
	spark_height = -1;
	anim_rate.value = 1;
	anim_rate.spread = 0;
	anim_type = 0;
	spark_scale.value = 1.0f;
	spark_scale.spread = 0.0f;
}

//////////////////////////////////////////////////////////////////////