#ifndef PROJECTILE_H	// Check for duplicate includes

#define PROJECTILE_H

//////////////////////////////////////////////////////////////////////
// Projectile														//
//////////////////////////////////////////////////////////////////////
class PROJECTILE	
{
	private:
		float power,powery; // Horizontal and vertical power
		int angle;			// Angle of projection
		BITMAP *grab;		// Bitmap to store previous screen contents
		int fuse;			// Fuse length
		int fuse_count; 	// Number of fuses that have gone off
		char image; 		// Image to use
		char draw_ang;		// Angle to draw it at
		char frame; 		// Current frame
		char frame_count;	// How long till frame change
		char gfx_set;		// Graphics set
		int times;			// Number of times this has split

		short int anim_rate;	// Rate of animation
		short int spin_rate;	// Rate at which it spins
		short int fuse_start;	// Initial fuse length
		short int fuse_loop;	// Length of subsequent fuses
		float gravity;			// How it is affected by gravity

	public:
		float x,y;			// Co-ordinates
		int ox,oy;			// Previous co-ordinates
		WEAPONTYPE *type;	// Type
		int generation; 	// Is this the original, or a descendant of it?
		float scale;			// Scale factor

		void Update();		// Move/check for collisions
		void Blit();		// Blit to screen from buffer
		void Draw();		// Draw to buffer
		void Grab();		// Grab from screen
		void UnGrab();		// Blit from grab to buffer
		void Remove();		// Remove projectile from screen

		PROJECTILE(int xx,int yy,int ang,float pow,WEAPONTYPE *t,int g);	// Constructor
};

#endif

//////////////////////////////////////////////////////////////////////