//////////////////////////////////////////////////////////////////////
// Includes															//
//////////////////////////////////////////////////////////////////////
						//											//
#include "menu.h"		// SHRAPNEL_GUI class definition			//
#include "shrapnel.h"	// Shrapnel header							//
#include <stdio.h>		// Standard I/O header						//
						//											//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Public function to redraw the currently selected option			//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_MENU::DrawOption()
{
	DoBar();
}

//////////////////////////////////////////////////////////////////////
// Private function to remove the currently selected option	from	//
// the screen														//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_MENU::RemoveBar()
{
	int x1 = m_x + 3; 
	int x2 = m_x + m_width - 3;
	int y1 = m_y + m_bordy - 1 + m_selected * c;
	int y2 = m_y + m_bordy - 5 + (m_selected + 1) * c;

	rectfill(buffer, x1, y1, x2, y2, makecol(0, 0, 150));		
	textprintf(buffer, (FONT *)data[FONT1].dat, m_x + m_bordx, m_y + m_bordy + m_selected * c, makecol(255, 255, 255), "%s", m_options[m_selected]);
	if( m_DrawText )
		m_DrawText(m_selected, makecol(255, 255, 255));
	scare_mouse_area(x1, y1, x2, y2);
	blit(buffer, screen, x1, y1, x1, y1, x2 - x1 + 1, y2 - y1 + 1);
	unscare_mouse();
}

//////////////////////////////////////////////////////////////////////
// Private function to draw the currently selected option			//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_MENU::DoBar()
{
	int x1 = m_x + 3; 
	int x2 = m_x + m_width - 3;
	int y1 = m_y + m_bordy - 1 + m_selected * c;
	int y2 = m_y + m_bordy - 5 + (m_selected + 1) * c;

	rectfill(buffer, x1, y1, x2, y2, BLACK_COL);		
	rectfill(buffer, x1, y1 + 2, x2, y2 - 2, makecol(250, 244, 216));
	textprintf(buffer, (FONT *)data[FONT1].dat, m_x + m_bordx, m_y + m_bordy + m_selected * c, BLACK_COL, "%s", m_options[m_selected]);
	if( m_DrawText )
		m_DrawText(m_selected, BLACK_COL);
	scare_mouse_area(x1, y1, x2, y2);
	blit(buffer, screen, x1, y1, x1, y1, x2 - x1 + 1, y2 - y1 + 1);
	unscare_mouse();
}

//////////////////////////////////////////////////////////////////////
// Public function to open the GUI object							//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_GUI::Open(int x, int y, int w, int h)
{
    m_x = x;
    m_y = y;
    m_width = w;
    m_height = h;

    m_bmpGrab = create_bitmap(m_width + 1, m_height + 1);

    blit(buffer, m_bmpGrab, m_x, m_y, 0, 0, m_width + 1, m_height + 1);

	for (float a = 0; a <= m_height / 2; a += m_height / 10.0)
	{
		rectfill(buffer, m_x, m_y + m_height / 2 - (int)a, m_x + m_width, m_y + m_height / 2 + (int)a, makecol(125,125,125));
		if ((int)a >= 3)
			rectfill(buffer, m_x + 3, m_y + m_height / 2 + 3 - (int)a, m_x + m_width - 3, m_y + m_height / 2 - 3 + (int)a, makecol(0,0,150));
		blit(buffer, screen, m_x, m_y + m_height / 2 - (int)a, m_x, m_y + m_height / 2 - (int)a, m_width + 1, (int)a * 2 + 1);

		while(!counter);
		counter=0;
	}

	blit(m_bmpGrab, buffer, 0, 0, m_x, m_y, m_width + 1, m_height + 1);
	circlefill(buffer, m_x + C_RADIUS, m_y + C_RADIUS, C_RADIUS, makecol(125, 125, 125));
	circlefill(buffer, m_x + C_RADIUS, m_y + C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
	circlefill(buffer, m_x + m_width - C_RADIUS, m_y + C_RADIUS, C_RADIUS, makecol(125, 125, 125));
	circlefill(buffer, m_x + m_width - C_RADIUS, m_y + C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
	circlefill(buffer, m_x + C_RADIUS, m_y + m_height - C_RADIUS, C_RADIUS, makecol(125, 125, 125));
	circlefill(buffer, m_x + C_RADIUS, m_y + m_height - C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
	circlefill(buffer, m_x + m_width - C_RADIUS, m_y + m_height - C_RADIUS, C_RADIUS, makecol(125, 125, 125));
	circlefill(buffer, m_x + m_width - C_RADIUS, m_y + m_height - C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
	rectfill(buffer, m_x, m_y + C_RADIUS, m_x + m_width, m_y + m_height - C_RADIUS, makecol(125, 125, 125));
	rectfill(buffer, m_x + 3, m_y + C_RADIUS, m_x + m_width - 3, m_y + m_height - C_RADIUS, makecol(0, 0, 150));
	rectfill(buffer, m_x + C_RADIUS, m_y, m_x + m_width - C_RADIUS, m_y + m_height, makecol(125, 125, 125));
	rectfill(buffer, m_x + C_RADIUS, m_y + 3, m_x + m_width - C_RADIUS, m_y + m_height - 3, makecol(0, 0, 150));

	blit(buffer, screen, m_x, m_y, m_x, m_y, m_width + 1, m_height + 1);
}

//////////////////////////////////////////////////////////////////////
// Public function to draw the GUI object							//
//	Refresh: Should object be blitted to screen						//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_GUI::Draw(bool Refresh)
{
	blit(m_bmpGrab, buffer, 0, 0, m_x, m_y, m_width + 1, m_height + 1);
	circlefill(buffer, m_x + C_RADIUS, m_y + C_RADIUS, C_RADIUS, makecol(125, 125, 125));
	circlefill(buffer, m_x + C_RADIUS, m_y + C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
	circlefill(buffer, m_x + m_width - C_RADIUS, m_y + C_RADIUS, C_RADIUS, makecol(125, 125, 125));
	circlefill(buffer, m_x + m_width - C_RADIUS, m_y + C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
	circlefill(buffer, m_x + C_RADIUS, m_y + m_height - C_RADIUS, C_RADIUS, makecol(125, 125, 125));
	circlefill(buffer, m_x + C_RADIUS, m_y + m_height - C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
	circlefill(buffer, m_x + m_width - C_RADIUS, m_y + m_height - C_RADIUS, C_RADIUS, makecol(125, 125, 125));
	circlefill(buffer, m_x + m_width - C_RADIUS, m_y + m_height - C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
	rectfill(buffer, m_x, m_y + C_RADIUS, m_x + m_width, m_y + m_height - C_RADIUS, makecol(125, 125, 125));
	rectfill(buffer, m_x + 3, m_y + C_RADIUS, m_x + m_width - 3, m_y + m_height - C_RADIUS, makecol(0, 0, 150));
	rectfill(buffer, m_x + C_RADIUS, m_y, m_x + m_width - C_RADIUS, m_y + m_height, makecol(125, 125, 125));
	rectfill(buffer, m_x + C_RADIUS, m_y + 3, m_x + m_width - C_RADIUS, m_y + m_height - 3, makecol(0, 0, 150));

	if( Refresh )
		blit(buffer, screen, m_x, m_y, m_x, m_y, m_width + 1, m_height + 1);
}

//////////////////////////////////////////////////////////////////////
// Public function to close the GUI object							//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_GUI::Close()
{
	for (float a = (2 * m_height) / 5.0; a >= 0; a -= m_height / 10.0)
	{
		blit(m_bmpGrab, buffer, 0, (2 * m_height) / 5 - (int)a, m_x, m_y + (2 * m_height) / 5 - (int)a, m_width + 1, (int)a * 2 + m_height / 5 + 6);
		rectfill(buffer, m_x, m_y + m_height / 2 - (int)a, m_x + m_width, m_y + m_height / 2 + (int)a, makecol(125,125,125));
		if ((int)a>=3)
			rectfill(buffer, m_x + 3, m_y + m_height / 2 + 3 - (int)a, m_x + m_width - 3, m_y + m_height / 2 - 3 + (int)a, makecol(0,0,150));

		blit(buffer, screen, m_x, m_y + (2 * m_height) / 5 - (int)a, m_x, m_y + (2 * m_height) / 5 - (int)a, m_width + 1, (int)a * 2 + m_height / 5 + 6);
		while(!counter);
		counter=0;
	}

    blit(m_bmpGrab, buffer, 0, m_height / 2 - m_height / 10.0, m_x, m_y + m_height / 2 - m_height / 10.0, m_width + 1, m_height / 5.0 + 2);
    blit(m_bmpGrab, screen, 0, m_height / 2 - m_height / 10.0, m_x, m_y + m_height / 2 - m_height / 10.0, m_width + 1, m_height / 5.0 + 2);
}

//////////////////////////////////////////////////////////////////////
// Public function to draw the menu									//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_MENU::Draw()
{
	SHRAPNEL_GUI::Draw(false);
	DrawOptions();
}

//////////////////////////////////////////////////////////////////////
// Public function to open the menu									//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_MENU::Open(int x, int y, int w, int h, int bordx, int bordy, char **options, void (*DrawText)(int n, int col), void (*Action)(int), void (*AltAction)(int), int akey)
{
	m_options = options;
    m_bordx = bordx;
    m_bordy = bordy;
    m_Action = Action;
    m_AltAction = AltAction;
    m_AltKey = akey;
	m_DrawText = DrawText;
	m_x = x;
	m_y = y;
	m_width = w;
	m_height = h;

	SHRAPNEL_GUI::Open(x, y, w, h);

    c = text_height((FONT *)data[FONT1].dat) + 5;
	e = 0;

	omx = SCREEN_W + 1;
	omy = SCREEN_H + 1;

	m_arrowx = m_x + m_bordx - 20;
	m_selected = 0;

	for (int b = 0; m_options[b] != NULL; b++)
		m_cOptions = b + 1;
}

//////////////////////////////////////////////////////////////////////
// Public function to update the menu								//
//////////////////////////////////////////////////////////////////////
int SHRAPNEL_MENU::Update()
{
	int a;
	int old_sel = m_selected;

	if ((mouse_x != (int)omx) || (mouse_y != (int)omy))
	{
		omx = mouse_x;
		omy = mouse_y;
		
		mouse_in = false;
		
		if ((mouse_y >= m_y + m_bordy) && (mouse_y < m_y + m_bordy + m_cOptions * c))
		{			
			a = (mouse_y - m_y - m_bordy) / c;				

			if ((mouse_x >= m_x + m_bordx) && (mouse_x <= m_x + m_bordx + text_length((FONT *)data[FONT1].dat, m_options[a])))
			{
				if( m_selected != a )
				{
					RemoveBar();					
					m_selected = a;					
					DoBar();
				}

				mouse_in = true;
			}
		}
	}
	
	if( counter )
	{
		counter = 0;
		e++;
		if (e > 2)
		{
			e = 0;
			if (key[KEY_DOWN])
			{
				RemoveBar();

				m_selected++;
				if (m_selected >= m_cOptions)
					m_selected = 0;

				DoBar();
			} else if (key[KEY_UP]) {
				RemoveBar();
				m_selected--;
				if (m_selected < 0)
					m_selected = m_cOptions - 1;
								
				DoBar();
			}
		}
	}

	if( !key[KEY_DOWN] && !key[KEY_UP] )
	{
		counter = 1;
		e = 3;
	}
	
	if ((key[KEY_ENTER]) || ((mouse_b & 1) && (mouse_r & 1) && (mouse_in)))
	{
		mouse_r = mouse_b ^ 3;
		if (m_Action != NULL)
        {
			m_Action(m_selected);
            while(key[KEY_ENTER]);
		} else return 1;
	} else if (((m_AltKey != -1) && (key[m_AltKey])) || ((mouse_b & 2) && (mouse_r & 2) && (mouse_in))) {
		mouse_r = mouse_b ^ 3;
		if (m_AltAction != NULL)
        {
			m_AltAction(m_selected);
            while(key[m_AltKey]);
        } else return 2;
	}

	mouse_r = mouse_b ^ 3;

	if (key[KEY_ESC])
		return 0;
	else if (m_selected == old_sel)
		return 3;
	else return 4;
}

//////////////////////////////////////////////////////////////////////
// Public function to draw all menu options							//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_MENU::DrawOptions()
{
	for (int a = 0; m_options[a] != NULL; a++)
	{
		textprintf(buffer, (FONT *)data[FONT1].dat, m_x + m_bordx, m_y + m_bordy + a * c, makecol(255, 255, 255), "%s", m_options[a]);
		if( m_DrawText )
			m_DrawText(a, makecol(255, 255, 255));
	}

	scare_mouse_area(m_x, m_y, m_x + m_width, m_y + m_height);
    blit(buffer, screen, m_x, m_y, m_x, m_y, m_width + 1, m_height + 1);
    unscare_mouse();

	DoBar();
}

//////////////////////////////////////////////////////////////////////
// Public function to change the text of a given option				//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_MENU::ChangeOption(int n, char *text)
{
	//delete[] m_options[n];
	m_options[n] = text;
}

//////////////////////////////////////////////////////////////////////
// Public function to close the menu								//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_MENU::Close()
{
	show_mouse(NULL);

	SHRAPNEL_GUI::Close();
}

//////////////////////////////////////////////////////////////////////
// Public function to open, run and then close the menu				//
//////////////////////////////////////////////////////////////////////
void SHRAPNEL_MENU::Do(int x, int y, int w, int h, int bordx, int bordy, char **options, void (*DrawText)(int n, int col), void (*Action)(int), void (*AltAction)(int), int akey)
{
	Open(x,y, w, h, bordx, bordy, options, DrawText, Action, AltAction, akey);

    DrawOptions();

    while (Update());

    Close();
}

//////////////////////////////////////////////////////////////////////
// Public function to open run and then close the input box			//
//////////////////////////////////////////////////////////////////////
char *SHRAPNEL_INPUT::Do(int x, int y, int w, int h, char *title, char *text)
{
	m_x = x;
	m_y = y;
	m_width = w;
	m_height = h;
	m_strTitle = title;
	m_strText = text;

	if( text != NULL )
	{
		m_strOldText = new char[strlen(text) + 1];
		strcpy(m_strOldText, text);
	} else m_strOldText = NULL;

	SHRAPNEL_GUI::Open(x, y, w, h);

	textprintf_centre(buffer, (FONT *)data[FONT1].dat, m_x + m_width / 2, m_y + 5, makecol(255, 255, 255), "%s", m_strTitle);	

	if( m_strText != NULL )
		textprintf_centre(buffer, (FONT *)data[FONT1].dat, m_x + m_width / 2, m_y + m_height - 5 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s_", m_strText);

	blit(buffer, screen, m_x, m_y, m_x, m_y, m_width, m_height);		

	char a;
	char *strNewText;

	clear_keybuf();

	do {
		a = readkey();

		if (a == 27)
		{
			if( m_strText != NULL )
				delete[] m_strText;
			else break;
			m_strText = new char[strlen(m_strOldText) + 1];
			strcpy(m_strText, m_strOldText);
			break;
		} else if (a == 8) {
			if( m_strText != NULL && strlen(m_strText) )
			{
				strNewText = new char[strlen(m_strText)];
				m_strText[strlen(m_strText) - 1] = '\0';
				strcpy(strNewText, m_strText);
				delete[] m_strText;
				m_strText = strNewText;

				rectfill(buffer, m_x + 3, m_y + 3, m_x + m_width - 3, m_y + m_height - 3, makecol(0, 0, 150));
				textprintf_centre(buffer, (FONT *)data[FONT1].dat, m_x + m_width / 2, m_y + 5, makecol(255, 255, 255), "%s", m_strTitle);	
				textprintf_centre(buffer, (FONT *)data[FONT1].dat, m_x + m_width / 2, m_y + m_height - 5 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s_", m_strText);
				blit(buffer, screen, m_x, m_y, m_x, m_y, m_width, m_height);
			}
		} else if (a != 13) {
			if( m_strText != NULL )
			{
				strNewText = new char[strlen(m_strText) + 2];
				sprintf(strNewText, "%s%c", m_strText, a);
				delete[] m_strText;
			} else {
				strNewText = new char[2];
				sprintf(strNewText, "%c", a);
			}

			m_strText = strNewText;

			rectfill(buffer, m_x + 3, m_y + 3, m_x + m_width - 3, m_y + m_height - 3, makecol(0, 0, 150));
			textprintf_centre(buffer, (FONT *)data[FONT1].dat, m_x + m_width / 2, m_y + 5, makecol(255, 255, 255), "%s", m_strTitle);	
			textprintf_centre(buffer, (FONT *)data[FONT1].dat, m_x + m_width / 2, m_y + m_height - 5 - text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s_", m_strText);
			blit(buffer, screen, m_x, m_y, m_x, m_y, m_width, m_height);
		}
	} while (a != 13);	

	SHRAPNEL_GUI::Close();

	return m_strText;
}

//////////////////////////////////////////////////////////////////////