/*
** Jason Winnebeck, v2.1  3/8/00
** Also merged with jrnd2.h, a somewhat private implementation of
** jrnd which used fixed numbers, designed for the Allegro library
** This file is public domain
**
** Version 2.1 added #undefs in rndalgor.c to prevent conflicts.
**
** Remember to add jrndglob.h to one of your .c/cpp files, or add
** rndalgor.c to your project and only include this.
*/

#ifndef _JRND_H_
#define _JRND_H_

#ifdef __cplusplus

#include <time.h>

/* prototypes for the RNG */
long longrand(void);                    /* return next random long */
void slongrand(unsigned long seed);     /* to seed it */

#define MAX_LONG 0x7FFFFFFF

/* 
** Initialize the generator
*/
inline void randomize() {
  slongrand((unsigned) time(NULL));
}

/* 
** Initialize the generator
** analogous to Borland C++'s randomize() function
*/
inline void randomize(long seed) {
  slongrand(seed);
}

/*
** returns between 0 and (high - 1) INCLUSIVE
** analogous to Borland C++'s random(int x) function
*/
inline long getrnd(long high) {
  if (high == 0L)
    return 0L;
  else
    return longrand() % high;
}

/*
** returns between low and high INCLUSIVE
*/
inline long getrnd(long high, long low) {
  if ((high - low) == -1L)
    return high;
  else
    return longrand() % (high - low + 1L) + low;
}

/*
** returns a decimal between 0 EXCLUSIVE and high INCLUSIVE
*/
inline float getrndf(float high) {
  return float(longrand()) / MAX_LONG * high;
}

/*
** returns a decimal between low INCLUSIVE and high INCLUSIVE
*/
inline float getrndf(float high, float low) {
  return float(longrand()) / MAX_LONG * (high - low) + low;
}

/* THE BELOW FUNCTIONS WERE DESIGNED TO BE USED TO ALLEGRO'S FIXED
** NUMBER FORMAT.  Its fixed number format is high 16 bits is the signed
** whole part while the last 16 are decimal.  This is why you can
** use mod in these situations.  #define JRND_NO_FIXED to remove these
** functions from the compile
*/

#ifndef JRND_NO_FIXED

//As per Allegro's fixed format, 32 bit fixed point
typedef long fixed;

/*
** returns between 0 and (high) INCLUSIVE
*/
inline fixed getrndfix(fixed high) {
  if (high == 0L)
    return 0L;
  else
    return longrand() % high;
}

/*
** returns between start and (start + range) INCLUSIVE for any positive
** numbers ONLY (includes 0)
*/
inline fixed getrndfix(fixed start, fixed range) {
  if (range == 0L)
    return start;
  else
    return longrand() % range + start;
}

#endif /* #ifndef JRND_NO_FIXED */

#else  /* #ifdef __cplusplus */
#include "jrndc.h" /*instead*/
#endif /* #ifdef __cplusplus */

#endif /* #ifndef _JRND_H_ */