//////////////////////////////////////////////////////////////////////
// Includes															//
//////////////////////////////////////////////////////////////////////
						//											//
#include <stdio.h>		// Standard I/O header						//
#include <stdlib.h>		// Standard library header					//
#include <string.h>		// String functions							//
#include <allegro.h>	// Allegro header							//
#include <time.h>		// Time routines							//
#include <math.h>		// Maths routines							//
#include "graphics.h"	// Data file header							//
#include "array.h"		// Linked List class definition				//
#include "weapons.h"	// WeaponType structure definition			//
#include "menu.h"		// SHRAPNEL_MENU class definition			//
#include "jrnd.h"		// Prototypes for random number generator	//
#include "shrapnel.h"	// Shrapnel header							//
						//											//
//////////////////////////////////////////////////////////////////////
// Global variables			                                        //
//////////////////////////////////////////////////////////////////////
									//								//
extern NET_CHANNEL *listenchan;		// Server connection			//
extern volatile int scroll_count;	// Scrolling timer				//
extern PALETTE g_palGame;			// Game palette					//
extern PALETTE g_palWhite; 			// Totally white palette		//
extern bool g_bShopped;				// Has user just been to shop	//
//////////////////////////////////////////////////////////////////////
DATAFILE *loaddata;					// 'Loading' data file			//
WEAPONTYPE **g_Weap;				// List of weapons for shop		//
int g_nT;							// Current player in shop		//
									//								//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// Start Multiplayer Game Menu										//
//////////////////////////////////////////////////////////////////////
int StartGame()
{
	long int Time = time(NULL);
	char text[512];
	char filename[512];

	slongrand(Time);

	net_init();

	get_executable_name(text, sizeof(text));
	replace_filename(filename, text, "network.cfg", sizeof(filename));

	net_loadconfig(filename);
	
	NET_DRIVERLIST avail;

	avail = net_detectdrivers (net_drivers_all);	

	NET_DRIVERLIST drv;

	drv = net_driverlist_create();
	net_driverlist_clear (drv);
	net_driverlist_add (drv, NET_DRIVER_WSOCK_WIN);

	if (!net_initdrivers (drv))
		return -1;
	
	net_driverlist_destroy (drv);

	listenchan = net_openchannel (NET_DRIVER_WSOCK_WIN, "");

	if (!listenchan)
		return -1;

	g_llPlayers.clear();

	SHRAPNEL_MENU Menu, Players;
	char *dud_options[1] = { NULL };
	char *options[2] = { "Start", NULL };

	Menu.Open(SCREEN_W / 2 - 150, 300, 100, 50, 35, 20, options, NULL);

	Menu.DrawOptions();

	Players.Open(SCREEN_W / 2, 300, 150, 200, 50, 50, dud_options, NULL);

	int a;

	char address[NET_MAX_ADDRESS_LENGTH + 1];	
	PLAYER *player, *server;

	server = player = new PLAYER;
	player->name = g_strName;
	player->chan = net_openchannel (NET_DRIVER_WSOCK_WIN, NULL);
	if( player->chan == NULL )
		return 0;

	strcpy(address, net_getlocaladdress(player->chan));		

	if( net_assigntarget (player->chan, address) )
		return 0;

	textprintf(buffer, (FONT *)data[FONT1].dat, SCREEN_W / 2 + 30, 320 + g_llPlayers.size * (text_height((FONT *)data[FONT1].dat) + 5), makecol(255, 255, 255), "%s", player->name);	
	blit(buffer, screen, SCREEN_W / 2, 300, SCREEN_W / 2, 300, 150, 200);

	g_llPlayers.additem(player);

	ELEMENT<PLAYER> *tempel;

	do {
		a = net_receive(listenchan, text, 512, address);

		if (a > 0)
		{			
			text[a] = '\0';
			
			if( text[0] == 123 )
			{
				player = new PLAYER;
				player->name = new char[strlen(text)];
				strcpy(player->name, text + 1);
				
				player->address = new char[strlen(address) + 1];
				strcpy(player->address, address);
				
				if (!(player->chan = net_openchannel (NET_DRIVER_WSOCK_WIN, NULL)))
					return -1;
				if (net_assigntarget (player->chan, address))
					return -1;
				
				sprintf(text, "%cOK %s", g_llPlayers.size, g_strName);
				net_send (player->chan, text, strlen (text));
				
				textprintf(buffer, (FONT *)data[FONT1].dat, SCREEN_W / 2 + 30, 320 + g_llPlayers.size * (text_height((FONT *)data[FONT1].dat) + 5), makecol(255, 255, 255), "%s", player->name);
				blit(buffer, screen, SCREEN_W / 2, 300, SCREEN_W / 2, 300, 150, 200);
				
				for (tempel = g_llPlayers.getfirst()->next; tempel != NULL; tempel = tempel->next)
				{
					sprintf(text, "%c%c%s %s", 125, strlen(player->name) + 2, player->name, player->address);
					net_send (tempel->contents->chan, text, strlen(text));
				}
				
				g_llPlayers.additem(player);			
			}
			
			if( !strcmp(text, "SH_GETPLAYERS") )
			{	
				for (tempel = g_llPlayers.getfirst()->next, a = 1; tempel != NULL && tempel->contents != player; tempel = tempel->next, a++)
				{				
					sprintf(text, "%c%c%c%s %s", 124, a, strlen(tempel->contents->name) + 3, tempel->contents->name, tempel->contents->address);					
					net_send (player->chan, text, strlen(text));
				}				
			}
		}

		a = Menu.Update();		

		if( a && g_llPlayers.size < 2 )	// Make sure that there are at least 2 players
			a = 5;
	} while (a > 1);

	Players.Close();
	Menu.Close();	

	if( a == 1 )
	{
		sprintf(text, "SHRAP_START:%d", Time);

		for (tempel = g_llPlayers.getfirst()->next; tempel != NULL; tempel = tempel->next)	
			net_send (tempel->contents->chan, text, strlen(text));	

		g_iPlayers = g_llPlayers.size;
	}

	return a;
}

//////////////////////////////////////////////////////////////////////
// Join Multiplayer Game Menu										//
//////////////////////////////////////////////////////////////////////
int JoinGame()
{
	char *address = NULL;
	char text[512];
	char filename[512];

	SHRAPNEL_INPUT Name;

	address = Name.Do(SCREEN_W / 2 - 100, SCREEN_H / 2 - 20, 200, 40, "Server IP Address:", address);

	if( !address )
		return 0;

	net_init();

	get_executable_name(text, sizeof(text));
	replace_filename(filename, text, "network.cfg", sizeof(filename));

	net_loadconfig(filename);
	
	NET_DRIVERLIST avail;

	avail = net_detectdrivers (net_drivers_all);	

	NET_DRIVERLIST drv;

	g_llPlayers.clear();

	drv = net_driverlist_create();
	net_driverlist_clear (drv);
	net_driverlist_add (drv, NET_DRIVER_WSOCK_WIN);

	if (!net_initdrivers (drv))
		return -1;
	
	net_driverlist_destroy (drv);

	PLAYER *server = new PLAYER;

	server->chan = net_openchannel (NET_DRIVER_WSOCK_WIN, NULL);

	if (!server->chan)
		return -1;

	if (net_assigntarget (server->chan, address))
		return -1;

	sprintf(text, "%c%s", 123, g_strName);
	net_send (server->chan, text, strlen (text));

	int a;

	do {
		do {
			a = net_receive(server->chan, text, 512, NULL);
		} while(!a);

		if( a > 0 )
		{
			text[a] = '\0';
			if (strlen(text) > 3)
				text[3] = '\0';
		}
	} while (strcmp(text + 1, "OK"));	

	g_nPlayerID = text[0];

	server->name = new char[strlen(text + 4) + 1];
	strcpy(server->name, text + 4);	

	g_llPlayers.additem(server);

	PLAYER **players;
	players = new PLAYER *[g_nPlayerID];

	int nPlayersLeft = g_nPlayerID - 1;

	for (a = 1; a < g_nPlayerID; a++)
	{
		players[a] = new PLAYER;
		players[a]->name = NULL;	
	}

	strcpy(text, "SH_GETPLAYERS");
	net_send (server->chan, text, strlen(text));

	while (nPlayersLeft)
	{
		a = net_receive(server->chan, text, 512, NULL);

		if( a > 0 )
		{
			text[a] = '\0';

			if( (text[0] == 124) && (players[text[1]]->name == NULL) )
			{				
				text[text[2]] = '\0';
				players[text[1]]->name = new char[strlen(text + 3) + 1];
				strcpy(players[text[1]]->name, text + 3);

				nPlayersLeft--;
				players[text[1]]->chan = net_openchannel (NET_DRIVER_WSOCK_WIN, NULL);
				net_assigntarget (players[text[1]]->chan, text + text[2] + 1);
			}
		}
	};	

	for (a = 1; a < g_nPlayerID; a++)
		g_llPlayers.additem(players[a]);

	PLAYER *player = new PLAYER;
	player->name = g_strName;
	player->chan = NULL;
	g_llPlayers.additem(player);	

	delete[] players;

	SHRAPNEL_GUI Players;
	Players.Open(SCREEN_W / 2 - 75, SCREEN_H / 2, 150, 175);

	ELEMENT<PLAYER> *tempel;

	for (tempel = g_llPlayers.getfirst(), a = 0; tempel != NULL; tempel = tempel->next, a++)
		textprintf_centre(buffer, (FONT *)data[FONT1].dat, SCREEN_W / 2, SCREEN_H / 2 + 13 + (text_height((FONT *)data[FONT1].dat) + 5) * a, makecol(255,255,255), "%s", tempel->contents->name);

	blit(buffer, screen, SCREEN_W / 2 - 75, SCREEN_H / 2, SCREEN_W / 2 - 75, SCREEN_H / 2, 150, 175);

	for (;;)
	{
		a = net_receive(server->chan, text, 512, NULL);
		if( a > 0 )
		{
			text[a] = '\0';

			if( text[0] == 125 )
			{
				text[text[1]] = '\0';
				player = new PLAYER;
				player->name = new char[strlen(text + 2) + 1];
				strcpy(player->name, text + 2);				
				player->address = new char[strlen(text + text[1] + 1) + 1];
				strcpy(player->address, text + text[1] + 1);
				player->chan = net_openchannel (NET_DRIVER_WSOCK_WIN, NULL);
				net_assigntarget (player->chan, player->address);
				
				textprintf_centre(buffer, (FONT *)data[FONT1].dat, SCREEN_W / 2, SCREEN_H / 2 + 13 + (text_height((FONT *)data[FONT1].dat) + 5) * g_llPlayers.size, makecol(255,255,255), "%s", player->name);
				blit(buffer, screen, SCREEN_W / 2 - 75, SCREEN_H / 2, SCREEN_W / 2 - 75, SCREEN_H / 2, 150, 200);
				
				g_llPlayers.additem(player);
			}
			
			if( strlen(text) > 11 )
			{
				text[11] = '\0';				
				if( !strcmp(text, "SHRAP_START") )
				{
					slongrand(atol(text + 12));
					break;
				}
			}
		}

		if (key[KEY_ESC])
		{
			Players.Close();
			return 0;
		}
	}	

	g_iPlayers = g_llPlayers.size;

	return 1;
}

//////////////////////////////////////////////////////////////////////
// Change name for multiplayer game									//
//////////////////////////////////////////////////////////////////////
void ChangeName()
{
	SHRAPNEL_INPUT Name;

	g_strName = Name.Do(SCREEN_W / 2 - 100, SCREEN_H / 2 - 20, 200, 40, "Name:", g_strName);
}

//////////////////////////////////////////////////////////////////////
// Helper function to display shield details in shop				//
//////////////////////////////////////////////////////////////////////
void ShieldText(int a, int col)
{
	SHIELD_TYPE *s = &ShieldType[a];
	int c = text_height((FONT *)data[FONT1].dat) + 5;

	textprintf(buffer,(FONT *)data[FONT1].dat, 430, 110 + a * c, col,"%d", s->cost);
	textprintf(buffer,(FONT *)data[FONT1].dat, 605, 110 + a * c, col,"%d", s->quantity[g_nT]);
}

//////////////////////////////////////////////////////////////////////
// Helper function to display weapon details in shop				//
//////////////////////////////////////////////////////////////////////
void WeaponText(int a, int col)
{
	int c = text_height((FONT *)data[FONT1].dat) + 5;

	textprintf(buffer,(FONT *)data[FONT1].dat, 430, 110 + a * c, col,"%d", g_Weap[a]->cost);
	textprintf(buffer,(FONT *)data[FONT1].dat, 605, 110 + a * c, col,"%d", g_Weap[a]->quantity[g_nT]);
}

//////////////////////////////////////////////////////////////////////
// Main Shop Logic													//
//////////////////////////////////////////////////////////////////////
void Shop()
{
	BITMAP *grab = create_bitmap(SCREEN_W,SCREEN_H);
	ELEMENT<WEAPONTYPE> *tempel;
	ARRAY<char> Classes;
	ELEMENT<char> *char_el;
	WEAPONTYPE **weap;
	BITMAP *pic;
	int a, b, c, d = 0, f = 0;
	char *ClassName;	
	bool mouse_in = false;		

    show_mouse(NULL);

	weap = new WEAPONTYPE*[WeaponType.size];

	g_Weap = weap;

	set_clip(buffer,0,0,SCREEN_W,SCREEN_H);

	blit(buffer,grab,0,0,0,0,SCREEN_W,SCREEN_H);
	
	fade_from(g_palGame, g_palWhite, 7);

	clear_to_color(buffer, 168);//makecol(255,148,0));
	clear_to_color(screen, 168);//makecol(255,148,0));

	pic = (BITMAP *)data[SHOP].dat;

	blit(pic,buffer,0,0,400-pic->w/2,5,pic->w,pic->h);
	blit(pic,screen,0,0,400-pic->w/2,5,pic->w,pic->h);

	fade_from(g_palWhite, g_palGame, 7);

    SHRAPNEL_MENU PlayerBox;	

	char *dudoptions[1];
	dudoptions[0] = NULL;

    PlayerBox.Open(5, 30, 170, 100, 0, 0, dudoptions, NULL, NULL);
	
	int e = 0;

	set_mouse_sprite((BITMAP *)data[CURSOR].dat);	

	for (int t = 0; t < g_iPlayers; t++)
	{
		Classes.empty();

		for (tempel = WeaponType.getfirst(); tempel != NULL; tempel = tempel->next)
		{
			a = 0;

			if( tempel->contents->cost && tempel->contents->quantity[t] > -1 )
			{
				
				for (char_el = Classes.getfirst(); char_el != NULL; char_el = char_el->next)
				{
					if( !strcmp(char_el->contents, tempel->contents->Class) )
					{
						a = 1;					
						break;
					}
				}
				
				if (!a)			
					Classes.additem(tempel->contents->Class);										
			}
		}			

		Classes.additem("Shields");

		f = 0;

		c = text_height((FONT *)data[FONT1].dat) + 5;

		rectfill(buffer, 8, 33, 172, 127, makecol(0, 0, 150));
		textprintf_centre(buffer, (FONT *)data[FONT1].dat, 90, 40, makecol(255, 255, 255), "Player %d", t + 1);
		textprintf_centre(buffer, (FONT *)data[FONT1].dat, 90, 60, makecol(255, 255, 255), "%d", tank[t].cash);
		blit(buffer, screen, 5, 30, 5, 30, 171, 63);

		while (key[KEY_ESC]);

        SHRAPNEL_MENU ClassMenu;

        char **ClassNames = new char *[Classes.size + 1];

        for (a = 0, char_el = Classes.getfirst(); char_el != NULL; char_el = char_el->next, a++)
        	ClassNames[a] = char_el->contents;

        ClassNames[a] = NULL;

        ClassMenu.Open(5, 135, 170, 460, 25, 15, ClassNames, NULL, NULL);

        ClassMenu.DrawOptions();

		show_mouse(screen);

        do {
           	a = ClassMenu.Update();

            if (a == 1)
            {
				mouse_in = false;

				e = 0;
				d = 0;

				ClassName = &Classes[ClassMenu.m_selected];

				a = 0;
				b = 0;
														//80
                char **WeaponName;
				
				bool bShields;
				ELEMENT<SHIELD_TYPE> *elShl;

				if( strcmp(ClassName, "Shields") )
				{
					bShields = false;

					WeaponName = new char *[WeaponType.size + 1];
					
					for (tempel = WeaponType.getfirst();tempel!=NULL;tempel=tempel->next,a++)
					{
						if ((tempel->contents->quantity[t] > -1) && (tempel->contents->cost) && (!strcmp(tempel->contents->Class, ClassName)))
						{											  //80
							weap[b] = tempel->contents;
							WeaponName[b] = tempel->contents->name;
							b++;
						}
					}
				} else {
					bShields = true;

					WeaponName = new char *[ShieldType.size + 1];				

					for (elShl = ShieldType.getfirst(); elShl != NULL; elShl = elShl->next, a++)
					{
						if ((elShl->contents->quantity[t] > -1) && (elShl->contents->cost))
						{
							WeaponName[b] = elShl->contents->name;
							b++;
						}
					}
				}

				g_nT = t;

                WeaponName[b] = NULL;				

                SHRAPNEL_MENU WeaponMenu;
				
				if( strcmp(ClassName, "Shields") )
					WeaponMenu.Open(180, 50, 570, 500, 30, 60, WeaponName, WeaponText, NULL, NULL, KEY_S);
				else WeaponMenu.Open(180, 50, 570, 500, 30, 60, WeaponName, ShieldText, NULL, NULL, KEY_S);

				rectfill(buffer, 181, 80, 749, 83, makecol(125, 125, 125));

				textout(buffer,(FONT *)data[FONT1].dat,"Item",210,60,makecol(255,255,255));
				textout(buffer,(FONT *)data[FONT1].dat,"Cost",430,60,makecol(255,255,255));
				textout(buffer,(FONT *)data[FONT1].dat,"Quantity Owned",605,60,makecol(255,255,255));

                WeaponMenu.DrawOptions();				

				show_mouse(NULL);
				blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
				show_mouse(screen);

                for (a = 0; a < 285; a+= 57)
                {
					rectfill(buffer, 465 - a, 555, 465 + a, 595, makecol(125,125,125));
					if (a>=3)
						rectfill(buffer, 468 - a, 558, 462 + a, 592, makecol(0,0,150));

					show_mouse(NULL);
					blit(buffer, screen, 465 - a, 555, 465 - a, 555, a * 2 + 1, 40);
					show_mouse(screen);

                	while(!counter);
                    counter = 0;
                }

				circlefill(buffer, 180 + C_RADIUS, 555 + C_RADIUS, C_RADIUS, makecol(125, 125, 125));
				circlefill(buffer, 180 + C_RADIUS, 555 + C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
				circlefill(buffer, 180 + 570 - C_RADIUS, 555 + C_RADIUS, C_RADIUS, makecol(125, 125, 125));
				circlefill(buffer, 180 + 570 - C_RADIUS, 555 + C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
				circlefill(buffer, 180 + C_RADIUS, 555 + 40 - C_RADIUS, C_RADIUS, makecol(125, 125, 125));
				circlefill(buffer, 180 + C_RADIUS, 555 + 40 - C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
				circlefill(buffer, 180 + 570 - C_RADIUS, 555 + 40 - C_RADIUS, C_RADIUS, makecol(125, 125, 125));
				circlefill(buffer, 180 + 570 - C_RADIUS, 555 + 40 - C_RADIUS, C_RADIUS - 3, makecol(0, 0, 150));
				rectfill(buffer, 180, 555 + C_RADIUS, 180 + 570, 555 + 40 - C_RADIUS, makecol(125, 125, 125));
				rectfill(buffer, 180 + 3, 555 + C_RADIUS, 180 + 570 - 3, 555 + 40 - C_RADIUS, makecol(0, 0, 150));
				rectfill(buffer, 180 + C_RADIUS, 555, 180 + 570 - C_RADIUS, 555 + 40, makecol(125, 125, 125));
				rectfill(buffer, 180 + C_RADIUS, 555 + 3, 180 + 570 - C_RADIUS, 555 + 40 - 3, makecol(0, 0, 150));
				blit(buffer, screen, 180, 555, 180, 555, 571, 41);

                if (!bShields && weap[0]->description)
	                textprintf(buffer, (FONT *)data[FONT1].dat, 220, 570, makecol(255, 255, 255), "%s", weap[0]->description);
				else if (bShields && ShieldType[0].description)
					textprintf(buffer, (FONT *)data[FONT1].dat, 220, 570, makecol(255, 255, 255), "%s", ShieldType[0].description);

				if (!bShields)
					draw_sprite(buffer, weap[0]->icon, 200 - weap[0]->icon->w/2, 575 - weap[0]->icon->h/2);
				else {
					BITMAP *icon = ShieldType[0].icon;
					draw_sprite(buffer, icon, 200 - icon->w/2, 575 - icon->h/2);
				}

                blit(buffer, screen, 180, 550, 180, 550, 570, 40);

				while (key[KEY_ENTER]);

				do {
                    a = WeaponMenu.Update();

                    if (a == 4)
                    {
						rectfill(buffer, 183, 558, 747, 592, makecol(0,0,150));
                        if (!bShields && weap[WeaponMenu.m_selected]->description)
			                textprintf(buffer, (FONT *)data[FONT1].dat, 220, 570, makecol(255, 255, 255), "%s", weap[WeaponMenu.m_selected]->description);
						else if (bShields && ShieldType[WeaponMenu.m_selected].description)
							textprintf(buffer, (FONT *)data[FONT1].dat, 220, 570, makecol(255, 255, 255), "%s", ShieldType[WeaponMenu.m_selected].description);

						if (!bShields)
							draw_sprite(buffer, weap[WeaponMenu.m_selected]->icon, 200 - weap[WeaponMenu.m_selected]->icon->w/2, 575 - weap[WeaponMenu.m_selected]->icon->h/2);
						else {
							BITMAP *icon = ShieldType[WeaponMenu.m_selected].icon;
							draw_sprite(buffer, icon, 200 - icon->w/2, 575 - icon->h/2);
						}

                        scare_mouse_area(180, 550, 750, 590);
		                blit(buffer, screen, 180, 550, 180, 550, 570, 40);
	                    unscare_mouse();
                    } else if (a == 1) {
						if ((!bShields) && (tank[t].cash >= weap[WeaponMenu.m_selected]->cost))
						{
							tank[t].cash -= weap[WeaponMenu.m_selected]->cost;
							weap[WeaponMenu.m_selected]->quantity[t]++;
							WeaponMenu.DrawOption();

							rectfill(buffer, 8, 33, 172, 127, makecol(0, 0, 150));
							textprintf_centre(buffer, (FONT *)data[FONT1].dat, 90, 40, makecol(255, 255, 255), "Player %d", t + 1);
							textprintf_centre(buffer, (FONT *)data[FONT1].dat, 90, 60, makecol(255, 255, 255), "%d", tank[t].cash);

							show_mouse(NULL);
							blit(buffer, screen, 5, 30, 5, 30, 171, 63);
							show_mouse(screen);
						} else if ((bShields) && (tank[t].cash >= ShieldType[WeaponMenu.m_selected].cost)) {
							SHIELD_TYPE *s = &ShieldType[WeaponMenu.m_selected];
							tank[t].cash -= s->cost;
							s->quantity[t]++;
							WeaponMenu.DrawOption();

							rectfill(buffer, 8, 33, 172, 127, makecol(0, 0, 150));
							textprintf_centre(buffer, (FONT *)data[FONT1].dat, 90, 40, makecol(255, 255, 255), "Player %d", t + 1);
							textprintf_centre(buffer, (FONT *)data[FONT1].dat, 90, 60, makecol(255, 255, 255), "%d", tank[t].cash);

							show_mouse(NULL);
							blit(buffer, screen, 5, 30, 5, 30, 171, 63);
							show_mouse(screen);
						} 
						
						while (key[KEY_ENTER]);
                    } else if (a == 2) {
						if ((!bShields) && (weap[WeaponMenu.m_selected]->quantity[t]>0))
						{
							tank[t].cash += weap[WeaponMenu.m_selected]->cost/2;
							weap[WeaponMenu.m_selected]->quantity[t]--;
							WeaponMenu.DrawOption();

							rectfill(buffer, 8, 33, 172, 127, makecol(0, 0, 150));
							textprintf_centre(buffer, (FONT *)data[FONT1].dat, 90, 40, makecol(255, 255, 255), "Player %d", t + 1);
							textprintf_centre(buffer, (FONT *)data[FONT1].dat, 90, 60, makecol(255, 255, 255), "%d", tank[t].cash);

							show_mouse(NULL);
							blit(buffer, screen, 5, 30, 5, 30, 171, 63);
							show_mouse(screen);
						} else if ((bShields) && (ShieldType[WeaponMenu.m_selected].quantity[t]>0)) {						
							SHIELD_TYPE *s = &ShieldType[WeaponMenu.m_selected];
							tank[t].cash += s->cost/2;
							s->quantity[t]--;
							WeaponMenu.DrawOption();

							rectfill(buffer, 8, 33, 172, 127, makecol(0, 0, 150));
							textprintf_centre(buffer, (FONT *)data[FONT1].dat, 90, 40, makecol(255, 255, 255), "Player %d", t + 1);
							textprintf_centre(buffer, (FONT *)data[FONT1].dat, 90, 60, makecol(255, 255, 255), "%d", tank[t].cash);

							show_mouse(NULL);
							blit(buffer, screen, 5, 30, 5, 30, 171, 63);
							show_mouse(screen);
						}
						while(key[KEY_S]);
                    }

					if (key[KEY_F12])
						ScreenShot();
				} while(a && tank[t].cash > 0);

				show_mouse(NULL);


				rectfill(buffer, 183, 558, 747, 592, makecol(0,0,150));

                for (a = 228; a >= 0; a -= 57)
                {
					rectfill(buffer, 408 - a, 555, 522 + a, 595, makecol(255,148,0));
					rectfill(buffer, 465 - a, 555, 465 + a, 595, makecol(125,125,125));
					if (a>=3)
						rectfill(buffer, 468 - a, 558, 462 + a, 592, makecol(0,0,150));

					blit(buffer, screen, 408 - a, 555, 408 - a, 555, a * 2 + 115, 41);

                	while(!counter);
                    counter = 0;
                }

                rectfill(buffer, 460, 555, 470, 595, makecol(255, 148, 0));
                rectfill(screen, 460, 555, 470, 595, makecol(255, 148, 0));

                WeaponMenu.Close();

				delete[] WeaponName;

                show_mouse(screen);

				a = 1;
			}
		} while (a);

		show_mouse(NULL);

        ClassMenu.Close();
	}

    show_mouse(NULL);

	fade_from(g_palGame, g_palWhite, 7);

	blit(grab,buffer,0,0,0,0,SCREEN_W,SCREEN_H);
	destroy_bitmap(grab);

	g_bShopped = true;

	while(key[KEY_ESC]);
}

//////////////////////////////////////////////////////////////////////
// Network Game Menu												//
//////////////////////////////////////////////////////////////////////
int Multiplayer()
{
	int a;
	char *Options[5] = { "Change Name",
						 "Start Game",
						 "Join Game",
						 "Back",
						 NULL };

	SHRAPNEL_MENU Menu;

	Menu.Open(335, 350, 130, 130, 30, 30, Options);
	Menu.DrawOptions();

	do {
		a = Menu.Update();

		if( a == 1 )
		{
			if( Menu.m_selected == 0 )
				ChangeName();
        	if (Menu.m_selected == 1)
			{				
				if( StartGame() )
				{
					g_bMultiplayer = true;
					g_bServer = true;
					return 1;
				} else {
					while (key[KEY_ESC]);
				}
			}
        	if (Menu.m_selected == 2)
			{
				if( JoinGame() )
				{
					g_bMultiplayer = true;
					g_bServer = false;
            		return 1;
				} else {
					while (key[KEY_ESC]);					
				}
			}
	        if (Menu.m_selected == 3)
                return 0;
 		}
	} while (a);

	Menu.Close();
	return 0;
}

//////////////////////////////////////////////////////////////////////
// Local game menu													//
//////////////////////////////////////////////////////////////////////
int NewGame()
{	
	int a;
	char *Options[4] = { "Start",
						 "Players: 2",						 
						 "Back",
						 NULL };

	SHRAPNEL_MENU Menu;

	g_iPlayers = 2;

	Menu.Open(350, 350, 100, 120, 30, 35, Options);
	Menu.DrawOptions();

	do {
		a = Menu.Update();

		if( a == 1 )
		{
			if( Menu.m_selected == 1 )
			{
				g_iPlayers++;
				if( g_iPlayers > MAXPLAYERS )
					g_iPlayers = 2;
				char *text = new char[12];
				sprintf(text, "Players: %d", g_iPlayers);
				Menu.ChangeOption(1, text);
				Menu.Draw();
				while(key[KEY_ENTER]);
            } else if (Menu.m_selected == 0) {
            	Menu.Close();
				return 1;
	        } else if (Menu.m_selected == 2) {
				Menu.Close();
				return 0;
			}
 		}
	} while (a);

	Menu.Close();
	return 0;
}

//////////////////////////////////////////////////////////////////////
// Display List of Credits											//
//////////////////////////////////////////////////////////////////////
void Credits()
{
	ARRAY<char> Lines;
    ELEMENT<char> *char_el;
    char text[100];
    char *text2;

    PACKFILE *in = pack_fopen("graphics.dat#CREDITS", F_READ_PACKED);

    int a,b, c = text_height((FONT *)data[FONT1].dat);

    b = 0;

    while (!pack_feof(in))
    {
		a = pack_getc(in);
        if ((a != '\n') && (a != '\r'))
        {
        	text[b] = a;
            b++;
        } else if (a == '\n') {
        	text[b] = '\0';

			text2 = new char[strlen(text) + 1];
    	    strcpy(text2, text);

	        Lines.additem(text2);

            b = 0;
        }
    };

    pack_fclose(in);

    for (a = SCREEN_H; a >= 300 - Lines.size * c; a -= 5)
    {
    	rectfill(buffer, 0, 300 - 20, SCREEN_W, SCREEN_H, 168);

    	for (b = 0, char_el = Lines.getfirst(); char_el != NULL; char_el = char_el->next, b++)
        {
	        if (b * c + a >= 300)
    	    {
            	if (char_el->contents[0] == '_')
	            	textprintf_centre(buffer, (FONT *)data[FONT1].dat, 400, b * c + a, BLACK_COL, "%s", char_el->contents + 1);
                else textprintf_centre(buffer, (FONT *)data[FONT1].dat, 400, b * c + a, makecol(255, 255, 255), "%s", char_el->contents);
			}
        }

        blit(buffer, screen, 0, 300 - 20, 0, 300 - 20, SCREEN_W, 300 + 20);

		while(scroll_count<7);
        scroll_count = 0;
    }

    for (char_el = Lines.getfirst(); char_el != NULL; char_el = char_el->next)
    	delete [] char_el->contents;
}

//////////////////////////////////////////////////////////////////////
// Display Readme File												//
//////////////////////////////////////////////////////////////////////
void Help()
{
	SHRAPNEL_MENU HelpMenu;	

	char *options[1];
	options[0] = NULL;

    HelpMenu.Open(150, 300, 500, 290, 0, 0, options, NULL);	

    FILE *in = fopen("readme.txt", "rb");

    ARRAY<char> Lines;
    ELEMENT<char> *eLine, *char_el;
    char text[200], *text2;
    int iLine = 0;
    int a, b;

    clear_keybuf();

    b = 0;

    while (!feof(in))
    {
		a = fgetc(in);
        if ((a != '\n') && (a != '\r'))
        {
        	text[b] = a;
            b++;
        } else if (a == '\n') {
        	text[b] = '\0';

			text2 = new char[strlen(text) + 1];
    	    strcpy(text2, text);

	        Lines.additem(text2);

            b = 0;
        }
    };

    fclose(in);

    eLine = Lines.getfirst();

	for (a = 0, char_el = eLine; char_el != NULL && a <= 16; char_el = char_el -> next, a++)
		textprintf(buffer, (FONT *)data[FONT1].dat, 190, 314 + a * text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", char_el->contents);

	BITMAP *keys = (BITMAP *)data[KEYS].dat;
    draw_sprite(buffer, keys, 640 - keys->w, 570);
	blit(buffer, screen, 155, 305, 155, 305, 490, 280);

	do {
    	if ((scroll_count > 1) && ((key[KEY_UP]) || (key[KEY_DOWN])))
        {
        	scroll_count = 0;
        	if ((key[KEY_UP]) && (iLine > 0))
            {
            	iLine--;
                eLine = eLine->prev;
            }
            if ((key[KEY_DOWN]) && (iLine < Lines.size - 16))
            {
            	iLine++;
                eLine = eLine->next;
            }
            rectfill(buffer, 155, 305, 645, 585, makecol(0, 0, 150));
			for (a = 0, char_el = eLine; char_el != NULL && a <= 16; char_el = char_el -> next, a++)
    			textprintf(buffer, (FONT *)data[FONT1].dat, 190, 314 + a * text_height((FONT *)data[FONT1].dat), makecol(255, 255, 255), "%s", char_el->contents);

		    draw_sprite(buffer, keys, 640 - keys->w, 570);
			blit(buffer, screen, 155, 305, 155, 305, 490, 280);
        }
    } while (!key[KEY_ESC]);

    HelpMenu.Close();

    for (eLine = Lines.getfirst(); eLine != NULL; eLine = eLine->next)
    	delete[] eLine->contents;	
}

//////////////////////////////////////////////////////////////////////
// Title screen and main menu										//
//////////////////////////////////////////////////////////////////////
void Title()
{
	BITMAP *pic;
	int bits=25;
	int a,b,c,r;
	DEBRIS debris[25];//bits];
	V3D_f *pointy[MAXPOINTS+1];

	pic=(BITMAP *)data[TITLE].dat;

	for (a=0;a<MAXPOINTS+1;a++)
		pointy[a] = new V3D_f;

	clear_to_color(buffer, 168);//BLACK_COL);

	PALETTE blackpal;
	RGB *p = (RGB *)data[GAMEPAL].dat;

	for (a = 0; a < 256; a++)	
		blackpal[a] = p[168];	

	for (a=0;a<bits;a++)
	{
		debris[a].fangle=(rand()%100)+40;
		debris[a].fpowery=debris[a].fpower=(rand()%10)+2;
		debris[a].x=400-pic->w/2+rand()%pic->w;
		debris[a].y=b+rand()%pic->h;
		debris[a].points=(rand()%(MAXPOINTS-3)) + 3;
		debris[a].grab=create_bitmap(60,60);
		debris[a].ox=-1000;
		for (b = 0; b < debris[a].points; b++)
		{
			debris[a].dist[b]=(rand()%20)+5;
			debris[a].ang[b]=rand()%360;
		}

		do {
			c=0;
			for (b=0;b<debris[a].points-1;b++)
			{
				if (debris[a].ang[b]>debris[a].ang[b+1])
				{
					r=debris[a].ang[b];
					debris[a].ang[b]=debris[a].ang[b+1];
					debris[a].ang[b+1]=r;
					c=1;
				}
			}
		} while (c);
	}	

    b = 400 - pic->w/2;

	blit(pic, buffer, 0, 0, 400 - pic->w/2, b, pic->w, pic->h);
	textout_centre(buffer,(FONT *)data[FONT1].dat,"by Andrew Geers",400,b+2+pic->h, BLACK_COL);//makecol(255,255,255));
	textout_centre(buffer,(FONT *)data[FONT1].dat,"http://www.geerbox.co.uk", 400, b + 16 + pic->h, BLACK_COL);//makecol(255,255,255));
	textout_right(buffer, (FONT *)data[FONT1].dat, SHRAPNEL_VERSION, 397 + pic->w/2, pic->h + b - 4, BLACK_COL);//makecol(255,255,255));
	blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);

	fade_from(blackpal, p, 4);

	rest(250);	

	do {
		for (a=0;a<bits;a++)
		{
			if (debris[a].ox!=-1000)
				blit(debris[a].grab,buffer,0,0,debris[a].ox,debris[a].oy,60,60);
		}

		for (a=0;a<bits;a++)
			blit(buffer, debris[a].grab, (int)debris[a].x - 30, (int)debris[a].y - 30, 0, 0, 60, 60);

		for (a=0;a<bits;a++)
		{
			for (b=0;b<debris[a].points;b++)
			{
				pointy[b]->x=debris[a].x+debris[a].dist[b]*cos((3.142/180)*debris[a].ang[b]);
				pointy[b]->y=debris[a].y+debris[a].dist[b]*sin((3.142/180)*debris[a].ang[b]);
				pointy[b]->c=BLACK_COL;//makecol(125,125,125);
			}

			polygon3d_f(buffer,POLYTYPE_FLAT,NULL,debris[a].points,pointy);
		}

        c = 0;

        for (a = 0; a < bits; a++)
        {
			for (b = 0; b < debris[a].points; b++)
			{
				debris[a].ang[b]+=20;
				if (debris[a].ang[b]>=360)
					debris[a].ang[b]-=360;
			}

			blit(buffer, screen, (int)debris[a].x - 30, (int)debris[a].y - 30, (int)debris[a].x - 30, (int)debris[a].y - 30, 60, 60);
			blit(buffer, screen, debris[a].ox, debris[a].oy, debris[a].ox, debris[a].oy, 60, 60);
			debris[a].ox = (int)debris[a].x - 30;
			debris[a].oy = (int)debris[a].y - 30;
			debris[a].x += debris[a].fpower*cos((3.142/180)*debris[a].fangle);
			debris[a].y -= debris[a].fpowery*sin((3.142/180)*debris[a].fangle);

            if ((debris[a].x >= 0) && (debris[a].x < SCREEN_W) && (debris[a].y >= 0) && (debris[a].y < SCREEN_H))
            	c = 1;

			debris[a].fpowery -= 0.3;
		}
		while(!counter);
		counter=0;
	} while((!keypressed()) && (c));

	for (a=0;a<bits;a++)
	{
		if (debris[a].ox!=-1000)
		{
			blit(debris[a].grab, buffer, 0, 0, debris[a].ox, debris[a].oy, 60, 60);
			blit(buffer, screen, debris[a].ox, debris[a].oy, debris[a].ox, debris[a].oy, 60, 60);
		}
	}

	char *Options[6] = { "Local Game",
						 "Network Game",
						 "View Readme",
						 "Credits",
						 "Exit",
						 NULL };

	SHRAPNEL_MENU Menu;

	Menu.Open(325, 340, 150, 150, 30, 30, Options);
	Menu.DrawOptions();

	do {
		a = Menu.Update();

		if( a == 1 )
		{
			if( Menu.m_selected == 0 )
			{
        		if (NewGame())
	               	break;
				else while (key[KEY_ESC]);

				while (key[KEY_ENTER]);

				Menu.Draw();
			} else if (Menu.m_selected == 1) {
				if (Multiplayer())
					break;
				else while (key[KEY_ESC]);
				
				while (key[KEY_ENTER]);

				Menu.Draw();
            } else if (Menu.m_selected == 2) {
            	Help();
				while (key[KEY_ESC]);
            } else if (Menu.m_selected == 3) {
            	Credits();
				Menu.Draw();
	        } else if (Menu.m_selected == 4) {
				Menu.Close();
            	Exit(EXIT_SUCCESS);
			}
 		}
	} while (a);

	Menu.Close();
	if( !a )
		Exit(EXIT_SUCCESS);
}

//////////////////////////////////////////////////////////////////////