//////////////////////////////////////////////////////////////////////
// Includes															//
//////////////////////////////////////////////////////////////////////
						//											//
#include <stdio.h>		// Standard I/O routines					//
#include <string.h>		// String manipulation routines				//
#include <allegro.h>	// Allegro header							//
#include "weapons.h"	// WEAPON_TYPE class definition				//
#include "graphics.h"	// Datafile header							//
#include "array.h"		// ARRAY class definition					//
#include "shield.h"		// SHIELD class definition					//
#include "shrapnel.h"	// Shrapnel header							//
						//											//
//////////////////////////////////////////////////////////////////////
// Global variables													//
//////////////////////////////////////////////////////////////////////
										//							//
ARRAY<char> g_llClasses;				// List of weapons classes	//
int g_nLongestClass;					// Length of longest class	//
ARRAY<char> Files;						// List of .wep files		//
int g_iSection;							// Current section			//
WEAPONTYPE *temp_weap;					// Current weapon type		//
SHIELD_TYPE *temp_shield;				// Current shield type		//
BITMAP *g_bmSquare;						// Bitmap of black square	//
//////////////////////////////////////////////////////////////////////
extern int g_iPlayers;					// Number of players		//
extern DATAFILE *data;					// Graphics files			//
extern ARRAY<WEAPONTYPE> WeaponType;	// List of weapons types	//
extern ARRAY<SHIELD_TYPE> ShieldType;	// List of shield types		//
										//							//
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// WEAPONTYPE constructor											//
//////////////////////////////////////////////////////////////////////
WEAPONTYPE::WEAPONTYPE()
{
	quantity = new int[g_iPlayers];
	nRoundStart = new int[g_iPlayers];
	cost = -1;
	name = NULL;
	Class = NULL;
	size.value = -1;
	speed = -1;
	damage.value = -1;
	rotating = -1;
	directional = -1;
	spin_rate.value = -1;
	Continue = -1;
	time = -1;
	delay = -1;
	rounds = -1;
    description = NULL;
	fuse_init = -1;
	fuse_count = -1;
	fuse_start.value = -1;
	turnrate = -1;
	homing = -1;
	fuse_loop.value = -1;
	anim_type = -1;
	anim_rate.value = -1;
	width = -1;
	height = -1;
	border = -1;
	times = -1;
	action = -1;
	scale.value = -1.0;
	angle.spread = -1;
	firesound = NULL;
	hitsound = NULL;
	angle.value = -1;
	gravity.value = -1.0;
	initial = -1;
	generations = -1;
	pic = NULL;
	icon = NULL;
	
	wh_number.value = -1;
	wh_angle.value = -1;
	wh_angle.spread = -1;
	wh_relative = -1;
}

//////////////////////////////////////////////////////////////////////
// Load a floating point value and range pair						//
//////////////////////////////////////////////////////////////////////
void LoadValueF(VALUEf *val, char *text)
{
	char *plus = strchr(text, '+');
	
	if (!plus)	// No plus found
	{
		val->value = atof(text);
		val->spread = 0;
		return;
	}
	
	// Plus found
	*plus = '\0';
	
	val->value = atof(text);
	val->spread = atof(plus + 1);
}

//////////////////////////////////////////////////////////////////////
// Load an integer value and range pair								//
//////////////////////////////////////////////////////////////////////
void LoadValueS(VALUEs *val, char *text)
{
	char *plus = strchr(text, '+');
	
	if (!plus)	// No plus found
	{
		val->value = atoi(text);
		val->spread = 0;
		return;
	}
	
	// Plus found
	*plus = '\0';
	
	val->value = atoi(text);
	val->spread = atoi(plus + 1);
}

//////////////////////////////////////////////////////////////////////
// Converts text to a boolean value									//
//////////////////////////////////////////////////////////////////////
int atobool(char *value)
{
	if (!strcmp(value, "yes"))
		return 1;
	else if (!strcmp(value, "true"))
		return 1;
	else if (!strcmp(value, "1"))
		return 1;
	else if (!strcmp(value, "no"))
		return 0;
	else if (!strcmp(value, "false"))
		return 0;
	else if (!strcmp(value, "0"))
		return 0;
	
	return -1;
}

//////////////////////////////////////////////////////////////////////
// Interpret a line of a weapons file								//
//////////////////////////////////////////////////////////////////////
void Interpret(char *text)
{
	unsigned int a, b;
	char filename[100];
	
	for (a=0; a<strlen(text); a++)
	{
		if ((text[a] != ' ') && (text[a] != '\t'))
		{
			text += a;
			break;
		}
	}
	
	if (text[0] == '[') 	// Section Header
	{
		strlwr(text);
		*strrchr(text, ']') = '\0';
		if (!strcmp(text+1, "general"))
			g_iSection = 0;
		else if (!strcmp(text+1, "projectile"))
			g_iSection = 1;
		else if (!strcmp(text+1, "warheads"))
			g_iSection = 2;
		else if (!strcmp(text+1, "fuse"))
			g_iSection = 3;
	} else {
		for (a=0; a<strlen(text); a++)
		{
			if (text[a] == '=')
			{
				char *property = text;
				char *value = NULL;
				
				for (b=a+1; b<strlen(text); b++)
				{
					if ((text[b] != ' ') && (text[b] != '\t'))
					{
						value = text+b;
						property[a] = '\0';
						break;
					}
				}
				
				if (value == NULL)
					return;
				
				for (b=strlen(property)-1; b>=0; b--)
				{
					if ((property[b] == ' ') || (property[b] == '\t'))
						property[b] = '\0';
					else break;
				}
				
				for (b=strlen(value)-1; b>=0; b--)
				{
					if ((value[b] == ' ') || (property[b] == '\t'))
						value[b] = '\0';
					else break;
				}
				
				strlwr(property);
				
				if ((strcmp(property, "name")) && (strcmp(property, "type")) && (strcmp(property, "class")) && (strcmp(property, "description")))
					strlwr(value);
				else if (!strcmp(property, "class"))
				{
					strupr(value);		// Capitalise first letter
					strlwr(value + 1);	// And make rest lower case
				}
				
				if (g_iSection == 0)	// General
				{
					if (!strcmp(property, "name"))
					{
						temp_weap->name = new char[strlen(value) + 1];
						strcpy(temp_weap->name, value);
                    } else if (!strcmp(property, "description")) {
						temp_weap->description = new char[strlen(value) + 1];
                        strcpy(temp_weap->description, value);
					} else if (!strcmp(property, "class")) {
						temp_weap->Class = new char[strlen(value) + 1];
						strcpy(temp_weap->Class, value);
					} else if (!strcmp(property, "cost")) {
						temp_weap->cost = atoi(value);
					} else if (!strcmp(property, "initial")) {
						temp_weap->initial = atoi(value);
					} else if (!strcmp(property, "icon")) {
						sprintf(filename, "weapons/%s", value);
						//						  if (exists(filename))
						temp_weap->icon = load_bitmap(filename, NULL);
					}
				} else if (g_iSection == 1) {	// Projectile
					if (!strcmp(property, "speed")) {
						temp_weap->speed = atoi(value);
					} else if (!strcmp(property, "mass")) {
						LoadValueF(&temp_weap->gravity, value);
						temp_weap->gravity.value /= 10.0;
						temp_weap->gravity.spread /= 10.0;
					} else if (!strcmp(property, "damage")) {
						LoadValueS(&temp_weap->damage, value);
					} else if (!strcmp(property, "spread")) {
						temp_weap->angle.spread = atoi(value) / 2;
					} else if (!strcmp(property, "homing")) {
						temp_weap->homing = atobool(value);
					} else if (!strcmp(property, "turnrate")) {
						temp_weap->turnrate = atoi(value);
					} else if (!strcmp(property, "angle")) {
						VALUEs a;
						LoadValueS(&a, value);
						if (a.spread)
							temp_weap->angle = a;//atoi(value);
						else temp_weap->angle.value = a.value;
					} else if (!strcmp(property, "continue")) {
						temp_weap->Continue = atobool(value);
					} else if (!strcmp(property, "radius")) {
						LoadValueS(&temp_weap->size, value);
					} else if (!strcmp(property, "action")) {
						temp_weap->action = atoi(value);
					} else if (!strcmp(property, "directional")) {
						temp_weap->directional = atobool(value);
					} else if (!strcmp(property, "time")) {
						temp_weap->time = atoi(value);					
					} else if (!strcmp(property, "rounds")) {
						temp_weap->rounds = atoi(value);	
					} else if (!strcmp(property, "times")) {
						temp_weap->times = atoi(value);						
					} else if (!strcmp(property, "delay")) {
						temp_weap->delay = atoi(value); 				
					} else if (!strcmp(property, "rotating")) {
						temp_weap->rotating = atobool(value);
					} else if (!strcmp(property, "spinrate")) {
						LoadValueS(&temp_weap->spin_rate, value);
						temp_weap->spin_rate.value = (int)(temp_weap->spin_rate.value * 256/360.0);
					} else if (!strcmp(property, "bitmap")) {
						sprintf(filename, "weapons/%s", value);
						if (exists(filename))
							temp_weap->pic = load_bitmap(filename, NULL);
					} else if (!strcmp(property, "width")) {
						temp_weap->width = atoi(value);
					} else if (!strcmp(property, "scale")) {
						LoadValueF(&temp_weap->scale, value);
					} else if (!strcmp(property, "height")) {
						temp_weap->height = atoi(value);
					} else if (!strcmp(property, "border")) {
						temp_weap->border = atobool(value);
					} else if (!strcmp(property, "animtype")) {
						temp_weap->anim_type = atoi(value);
					} else if (!strcmp(property, "animrate")) {
						LoadValueS(&temp_weap->anim_rate, value);
					} else if (!strcmp(property, "firesound")) {						
						sprintf(filename, "weapons/%s", value);
						//						  if (_file_exists(filename))
						temp_weap->firesound = load_sample(filename);
					} else if (!strcmp(property, "hitsound")) { 					
						sprintf(filename, "weapons/%s", value);
						//						  if (_file_exists(filename))
						temp_weap->hitsound = load_sample(filename);
					}
				} else if (g_iSection == 2) {	// Warheads
					if (!strcmp(property, "number")) {
						LoadValueS(&temp_weap->wh_number, value);
					} else if (!strcmp(property, "damage")) {
						LoadValueS(&temp_weap->warhead->damage, value);
					} else if (!strcmp(property, "angle")) {
						VALUEs a;
						LoadValueS(&a, value);
						if (a.spread)
							temp_weap->wh_angle = a;
						else temp_weap->wh_angle.value = a.value;
					} else if (!strcmp(property, "generations")) {
						temp_weap->generations = atoi(value);
					} else if (!strcmp(property, "spread")) {
						temp_weap->wh_angle.spread = atoi(value) / 2;
					} else if (!strcmp(property, "width")) {
						temp_weap->warhead->width = atoi(value);
					} else if (!strcmp(property, "height")) {
						temp_weap->warhead->height = atoi(value);
					} else if (!strcmp(property, "border")) {
						temp_weap->warhead->border = atobool(value);
					} else if (!strcmp(property, "animtype")) {
						temp_weap->warhead->anim_type = atoi(value);
					} else if (!strcmp(property, "animrate")) {
						LoadValueS(&temp_weap->warhead->anim_rate, value);
					} else if (!strcmp(property, "directional")) {
						temp_weap->warhead->directional = atobool(value);
					} else if (!strcmp(property, "relative")) {
						temp_weap->wh_relative = atobool(value);
						if (temp_weap->wh_relative == -1)
							temp_weap->wh_relative = atoi(value);
					} else if (!strcmp(property, "speed")) {
						temp_weap->warhead->speed = atoi(value);
					} else if (!strcmp(property, "radius")) {
						LoadValueS(&temp_weap->warhead->size, value);
					} else if (!strcmp(property, "mass")) {
						LoadValueF(&temp_weap->warhead->gravity, value);
						temp_weap->warhead->gravity.value /= 10.0;
						temp_weap->warhead->gravity.spread /= 10.0;
					} else if (!strcmp(property, "scale")) {
						LoadValueF(&temp_weap->warhead->scale, value);
					} else if (!strcmp(property, "rotating")) {
						temp_weap->warhead->rotating = atobool(value);
					} else if (!strcmp(property, "bitmap")) {
						sprintf(filename, "weapons/%s", value);
						//if (_file_exists(filename))
						temp_weap->warhead->pic = load_bitmap(filename, NULL);
					} else if (!strcmp(property, "hitsound")) { 					
						sprintf(filename, "weapons/%s", value);
						//if (_file_exists(filename))
						temp_weap->warhead->hitsound = load_sample(filename);
					} else if (!strcmp(property, "type")) {
						temp_weap->warhead->name = new char[strlen(value) + 1];
						strcpy(temp_weap->warhead->name, value);
					} else if (!strcmp(property, "homing")) {
						temp_weap->warhead->homing = atobool(value);
                    } else if (!strcmp(property, "spinrate")) {
                        LoadValueS(&temp_weap->warhead->spin_rate, value);
					}
				} else if (g_iSection == 3) { // Fuse
					if (!strcmp(property, "init")) {
						temp_weap->fuse_init = atoi(value);
					} else if (!strcmp(property, "start")) {
						LoadValueS(&temp_weap->fuse_start, value);
					} else if (!strcmp(property, "loop")) {
						LoadValueS(&temp_weap->fuse_loop, value);
					} else if (!strcmp(property, "count")) {
						temp_weap->fuse_count = atoi(value);
					}
				}
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////
// Add the given file to the list of files to be processed			//
//////////////////////////////////////////////////////////////////////
void LoadWeapon(char *filename, int attrib, int param)
{
	char *name = new char[strlen(filename) + 1];
	strcpy(name, filename);
	
	Files.additem(name);
}

//////////////////////////////////////////////////////////////////////
// Load the given .wep file and process it							//
//////////////////////////////////////////////////////////////////////
void ProcessWeapon(char *filename)
{
	FILE *in;
	char text[200];
	int len = 0;
	char c;
	bool commenting = false;
	
	temp_weap = new WEAPONTYPE;
	temp_weap->warhead = new WEAPONTYPE;
	
	in = fopen(filename, "rb");
	
	while (!feof(in))
	{
		c = fgetc(in);
		
		if (c == ';') {
			commenting = true;
		} else if (c == '\n') {
			text[len] = '\0';
			commenting = false;
			len = 0;
			Interpret(text);			
		} else if ((c != '\r') && (!commenting))
			text[len++] = c;			
	};
	
	fclose(in);
	
	WeaponType.additem(temp_weap);	
}

//////////////////////////////////////////////////////////////////////
// Interprets a line of a shield definition file					//
//////////////////////////////////////////////////////////////////////
void ShieldInterpret(char *text)
{
	unsigned int a, b;
	char filename[100];
	
	for (a=0; a<strlen(text); a++)
	{
		if ((text[a] != ' ') && (text[a] != '\t'))
		{
			text += a;
			break;
		}
	}
	
	if (text[0] == '[') 	// Section Header
	{
		strlwr(text);
		*strrchr(text, ']') = '\0';
		if (!strcmp(text+1, "general"))
			g_iSection = 0;
		else if (!strcmp(text+1, "shield"))
			g_iSection = 1;
		else if (!strcmp(text+1, "sparks"))
			g_iSection = 2;
	} else {
		for (a=0; a<strlen(text); a++)
		{
			if (text[a] == '=')
			{
				char *property = text;
				char *value = NULL;
				
				for (b=a+1; b<strlen(text); b++)
				{
					if ((text[b] != ' ') && (text[b] != '\t'))
					{
						value = text+b;
						property[a] = '\0';
						break;
					}
				}
				
				if (value == NULL)
					return;
				
				for (b=strlen(property)-1; b>=0; b--)
				{
					if ((property[b] == ' ') || (property[b] == '\t'))
						property[b] = '\0';
					else break;
				}
				
				for (b=strlen(value)-1; b>=0; b--)
				{
					if ((value[b] == ' ') || (property[b] == '\t'))
						value[b] = '\0';
					else break;
				}
				
				strlwr(property);
				
				if ((strcmp(property, "name")) && (strcmp(property, "description")))
					strlwr(value);
				
				if (g_iSection == 0)	// General
				{
					if (!strcmp(property, "name"))
					{
						temp_shield->name = new char[strlen(value) + 1];
						strcpy(temp_shield->name, value);
                    } else if (!strcmp(property, "description")) {
						temp_shield->description = new char[strlen(value) + 1];
                        strcpy(temp_shield->description, value);
					} else if (!strcmp(property, "cost")) {
						temp_shield->cost = atoi(value);
					} else if (!strcmp(property, "initial")) {
						temp_shield->initial = atoi(value);
					} else if (!strcmp(property, "icon")) {
						sprintf(filename, "shields/%s", value);
						temp_shield->icon = load_bitmap(filename, NULL);
					}
				} else if (g_iSection == 1) {	// Shield
					if (!strcmp(property, "effect")) {
						LoadValueS(&temp_shield->effect, value);
					} else if (!strcmp(property, "ratio")) {
						LoadValueF(&temp_shield->ratio, value);
					} else if (!strcmp(property, "colour") || !strcmp(property, "color")) {
						temp_shield->colour = atoi(value);
					} else if (!strcmp(property, "duration")) {
						temp_shield->duration = atoi(value);					
					} else if (!strcmp(property, "hitsound")) { 					
						sprintf(filename, "shields/%s", value);
						temp_shield->hit_sound = load_sample(filename);
					}
				} else if (g_iSection == 2) {	// Sparks
					if (!strcmp(property, "number")) {
						LoadValueS(&temp_shield->spark_num, value);
					} else if (!strcmp(property, "animtype")) {
						temp_shield->anim_type = atoi(value);
					} else if (!strcmp(property, "animrate")) {
						LoadValueS(&temp_shield->anim_rate, value);
					} else if (!strcmp(property, "mass")) {
						LoadValueF(&temp_shield->spark_mass, value);
						temp_shield->spark_mass.value /= 10.0;
						temp_shield->spark_mass.spread /= 10.0;
					} else if (!strcmp(property, "scale")) {
						LoadValueF(&temp_shield->spark_scale, value);
					} else if (!strcmp(property, "bitmap")) {
						sprintf(filename, "shields/%s", value);
						temp_shield->spark_pic = load_bitmap(filename, NULL);
					}
				}
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////
// Load and process the given .shl file								//
//////////////////////////////////////////////////////////////////////
void ProcessShield(char *filename)
{
	FILE *in;
	char text[200];
	int len = 0;
	char c;
	bool commenting = false;
	
	temp_shield = new SHIELD_TYPE;	
	
	in = fopen(filename, "rb");
	
	while (!feof(in))
	{
		c = fgetc(in);
		
		if (c == ';') {
			commenting = true;
		} else if (c == '\n') {
			text[len] = '\0';
			commenting = false;
			len = 0;
			ShieldInterpret(text);			
		} else if ((c != '\r') && (!commenting))
			text[len++] = c;			
	};
	
	fclose(in);
	
	ShieldType.additem(temp_shield);	
}

//////////////////////////////////////////////////////////////////////
// Set any unspecified properties to their default value			//
//////////////////////////////////////////////////////////////////////
void SetDefaults(WEAPONTYPE *t)
{	
	if (t->speed == -1)
		t->speed = 1;
	if (t->gravity.value == -1.0)
	{
		t->gravity.value = 5.0;
		t->gravity.spread = 0.0;
	}
	if (t->damage.value == -1)
	{
		t->damage.value = 5;
		t->damage.spread = 0;
	}
	if (t->scale.value == -1.0)
	{
		t->scale.value = 1.0;
		t->scale.spread = 0;
	}
	if (t->generations == -1)
		t->generations = 0;
	if (t->angle.spread == -1)
		t->angle.spread = 45;
	if (t->cost == -1)
		t->cost = 0;	
	if (t->homing == -1)
		t->homing = 0;
	if (t->turnrate == -1)
		t->turnrate = 5;
	if (t->spin_rate.value == -1)
	{
		t->spin_rate.value = 0;
		t->spin_rate.spread = 0;
	}
	if (t->fuse_loop.value == -1)
	{
		t->fuse_loop.value = 0;
		t->fuse_loop.spread = 0;
	}
	if (t->fuse_start.value == -1)
	{
		t->fuse_start.value = 0;
		t->fuse_start.spread = 0;
	}
	if (t->pic == NULL)
		t->pic = g_bmSquare;
	if (t->border == -1)
		t->border = 0;
	if (t->width == -1)
		t->width = t->pic->w - t->border;
	if (t->height == -1)
		t->height = t->pic->h - t->border;
	if (t->anim_rate.value == -1)
	{
		t->anim_rate.value = 1;
		t->anim_rate.spread = 0;
	}
	if (t->anim_type == -1)
		t->anim_type = 0;
	if (t->icon == NULL)
		t->icon = t->pic;
	if (t->fuse_count == -1)
		t->fuse_count = 0;
	if (t->size.value == -1)
	{
		t->size.value = 10;
		t->size.spread = 0;
	}
	if (t->Class == NULL)
	{
		t->Class = new char[14];
		strcpy(t->Class, "Miscellaneous");
	}
	if (t->rounds == -1)
		t->rounds = 1;
	if (t->delay == -1)
		t->delay = 1;
	if (t->rotating == -1)
		t->rotating = 1;
	if (t->Continue == -1)
		t->Continue = 0;
	if (t->action == -1)
		t->action = 0;
	if (t->directional == -1)
		t->directional = 0;
	if (t->time == -1)
		t->time = 2;	
	if (t->wh_number.value == -1)
	{
		t->wh_number.value = 1;
		t->wh_number.spread = 0;
	}
	if (t->wh_angle.value == -1)
		t->wh_angle.value = 50;
	if (t->wh_relative == -1)
		t->wh_relative = 1;
	if (t->wh_angle.spread == -1)
		t->wh_angle.spread = 10;
}

//////////////////////////////////////////////////////////////////////
// Set any unspecified fields to their default values				//
//////////////////////////////////////////////////////////////////////
void SetShieldDefaults(SHIELD_TYPE *t)
{
	if( t->spark_pic == NULL )
	{
		t->spark_pic = create_bitmap(3, 3);
		clear(t->spark_pic);
		vline(t->spark_pic, 1, 0, 2, t->colour);
		hline(t->spark_pic, 0, 1, 2, t->colour);
	}
	if( t->spark_width == -1 )
		t->spark_width = t->spark_pic->w;
	if( t->spark_height == -1 )
		t->spark_height = t->spark_pic->h;
	
	if( t->icon == NULL )
	{
		t->icon = create_bitmap(1, 1);
		clear(t->icon);
	}
}

//////////////////////////////////////////////////////////////////////
// Load all weapons	and shields										//
//////////////////////////////////////////////////////////////////////
void LoadWeapons()
{	
	g_iSection = -1;
	
	g_bmSquare = create_bitmap(2,2);
	
	clear_to_color(g_bmSquare, BLACK_COL);
	
	set_color_conversion(COLORCONV_TOTAL);
	
	for_each_file("weapons/*.wep", 0, LoadWeapon, 0);
	
    ELEMENT<char> *char_el;

	int n;
	BITMAP *pic = (BITMAP *)loaddata[DOT].dat;
	BITMAP *loading = (BITMAP *)loaddata[LOADING].dat;
	
	for (char_el = Files.getfirst(), n = 0; char_el != NULL; char_el = char_el->next, n++)
	{
		ProcessWeapon(char_el->contents);
		
		int a = (n * 3) / Files.size;
		draw_sprite(screen, pic, SCREEN_W / 2 + loading->w / 2 + 15 + (pic->w + 15) * a, SCREEN_H / 2 + loading->h - 60);
	}
	
	ELEMENT<WEAPONTYPE> *tempel, *tempel2;
	WEAPONTYPE *t;	
	
	for (tempel=WeaponType.getfirst(); tempel!=NULL; tempel=tempel->next)
	{
		t = tempel->contents;
		
		if (t->warhead->name != NULL)
		{
			for (tempel2 = WeaponType.getfirst(); tempel2 != NULL; tempel2 = tempel2->next)
			{
				if (!strcmp(tempel2->contents->name, t->warhead->name))
				{					
					if (t->warhead->size.value == -1)
						t->warhead->size = tempel2->contents->size;
					if (t->warhead->speed == -1)
						t->warhead->speed = tempel2->contents->speed;
					if (t->warhead->damage.value == -1)
						t->warhead->damage = tempel2->contents->damage;
					if (t->warhead->scale.value == -1.0)
						t->warhead->scale = tempel2->contents->scale;
					if (t->warhead->directional == -1)
						t->warhead->directional = tempel2->contents->directional;
                    if (t->warhead->homing == -1)
						t->warhead->homing = tempel2->contents->homing;
					if (t->warhead->rotating == -1)
						t->warhead->rotating = tempel2->contents->rotating;
					if (t->warhead->gravity.value == -1.0)
						t->warhead->gravity = tempel2->contents->gravity;
					if (t->warhead->pic == NULL)
						t->warhead->pic = tempel2->contents->pic;
					if (t->warhead->hitsound == NULL)
						t->warhead->hitsound = tempel2->contents->hitsound;
					if (t->warhead->anim_rate.value == -1)
						t->warhead->anim_rate = tempel2->contents->anim_rate;
					if (t->warhead->spin_rate.value == -1)
						t->warhead->spin_rate = tempel2->contents->spin_rate;
					
					t->warhead->width = tempel2->contents->width;
					t->warhead->height = tempel2->contents->height;
					t->warhead->anim_type = tempel2->contents->anim_type;
					t->warhead->fuse_init = tempel2->contents->fuse_init;
					t->warhead->fuse_loop = tempel2->contents->fuse_loop;
					t->warhead->fuse_start = tempel2->contents->fuse_start;
					t->warhead->fuse_count = tempel2->contents->fuse_count;
					t->warhead->border = tempel2->contents->border;
					t->warhead->action = tempel2->contents->action;
					t->warhead->Continue = tempel2->contents->Continue;
					t->warhead->time = tempel2->contents->time;
					t->warhead->wh_number = tempel2->contents->wh_number;
					t->warhead->wh_angle = tempel2->contents->wh_angle;
					t->warhead->wh_relative = tempel2->contents->wh_relative;
					t->warhead->homing = tempel2->contents->homing;
					t->warhead->turnrate = tempel2->contents->turnrate;
					t->warhead->angle = tempel2->contents->angle;
					t->warhead->generations = tempel2->contents->generations;
					t->warhead->warhead = tempel2->contents->warhead;
					
					break;
				}
			}
		}
	}
	
	for (tempel = WeaponType.getfirst(); tempel != NULL; tempel = tempel->next)
	{
		t = tempel->contents;
		
		SetDefaults(t);
		SetDefaults(t->warhead);
		
        for (int a = 0; a < g_iPlayers; a++)
			t->quantity[a] = t->initial;
	}
	
	int a, b, c = 0;
	g_nLongestClass = 0;
	int *nWeapons;	
	
	g_llClasses.empty();
	
	nWeapons = new int[WeaponType.size + 1];	
	
	for (tempel = WeaponType.getfirst(); tempel != NULL; tempel = tempel->next)
	{
		if( tempel->contents->cost )
		{
			a = 0;
			
			for (b = 0, char_el = g_llClasses.getfirst(); char_el != NULL; char_el = char_el->next, b++)
			{
				if( !strcmp(char_el->contents, tempel->contents->Class) )
				{
					a = 1;
					
					tempel->contents->nNumber = nWeapons[b];
					tempel->contents->nClass = b;
					
					nWeapons[b]++;
					
					if( nWeapons[b]	> g_nLongestClass )
						g_nLongestClass = nWeapons[b];
					if( text_length((FONT *)data[FONT1].dat, tempel->contents->name) / 26 +1 > g_nLongestClass )
						g_nLongestClass = text_length((FONT *)data[FONT1].dat, tempel->contents->name) / 26 + 1;
					
					break;
				}
			}
			
			if (!a)
			{
				tempel->contents->nNumber = 0;
				tempel->contents->nClass = g_llClasses.size;
				
				g_llClasses.additem(tempel->contents->Class);
				
				nWeapons[c] = 1;
				
				if( nWeapons[c] > g_nLongestClass )
					g_nLongestClass = nWeapons[c];
				if( text_length((FONT *)data[FONT1].dat, tempel->contents->name) / 26 + 1 > g_nLongestClass )
					g_nLongestClass = text_length((FONT *)data[FONT1].dat, tempel->contents->name) / 26 + 1;
				c++;
			}
		} else {
			tempel->contents->nNumber = 0;
			tempel->contents->nClass = 0;
		}
	}		
	
	delete[] nWeapons;
	
	
	g_iSection = -1;
	
	Files.clear();
	
	for_each_file("shields/*.shl", 0, LoadWeapon, 0);    
	
	for (char_el = Files.getfirst(); char_el != NULL; char_el = char_el->next)
		ProcessShield(char_el->contents);
	
	ELEMENT<SHIELD_TYPE> *sh_el;
	
	for (sh_el = ShieldType.getfirst(); sh_el != NULL; sh_el = sh_el->next)
	{
		SetShieldDefaults(sh_el->contents);
		
		for (a = 0; a < g_iPlayers; a++)
			sh_el->contents->quantity[a] = sh_el->contents->initial;
	}
	
	if( ShieldType.size > g_nLongestClass )
		g_nLongestClass = ShieldType.size;
	
	g_llClasses.additem("Shields");
}

//////////////////////////////////////////////////////////////////////