// Trigonometry tables and lookup functions

void CalculateTrigTables()
{
	for (int angle = 0; angle <= 359; angle++)
     {
   		SinTable[angle] = sin(angle * (Pi / 180));
	}
        
     for (int angle = 0; angle <= 359; angle++)
     {
   		CosTable[angle] = cos(angle * (Pi / 180));
	}
}

double Sin(int Angle)
{
	do
	{
		if (Angle > 359)
			Angle -= 360;
		if (Angle < 0)
			Angle += 360;
	} while (Angle < 0 && Angle > 359);
	return SinTable[Angle];
}

double Cos(int Angle)
{
	do
	{
		if (Angle > 359)
			Angle -= 360;
		if (Angle < 0)
			Angle += 360;
	} while (Angle < 0 && Angle > 359);
	return CosTable[Angle];
}

int To360(int Angle)
{
	do
	{
		if (Angle > 359)
			Angle -= 360;
		if (Angle < 0)
			Angle += 360;
	} while (Angle < 0 && Angle > 359);
	return Angle;
}

int FindAngle(float x1, float y1, float x2, float y2)
// takes two points, finds the slope of the line connecting them, and
// determines the angle of (x2,y2) from (x1,y1).
{
	float DiffY = y2 - y1;
	float DiffX = x2 - x1;
	
	// if slope is undefined (i.e. line is vertical)...
	if (DiffX == 0)
	{
		if (DiffY < 0)
			return 90;
		else
			return -90;
	}
	
	float Angle_rad = atan2(DiffY, DiffX);
	
	//convert from radians to degrees
	return -(int)(Angle_rad / (Pi / 180)) + 180;
}
