// powerups

#define MAX_PWRUP	6

#define SHIELD		0
#define RAPID		1	// 30%
#define LASER		2	// 30%
#define MISSILE	3	// 20%
#define BOMB		4	// 12%
#define LIGHTNING	5	// 8%

class Powerup
{
	public:
		void Init(float _x, float _y, int _angle, float _speed, int _type)
		{
			x = _x;
			y = _y;
			
			angle = _angle;
			
			xspeed = Cos(angle)*_speed;
			yspeed = Sin(angle)*_speed;
			
			if (_type == -1)
			{
				do
				{
					int choice = rand()%3;
				
					if (choice == 0)
						type = SHIELD;
					else				
					{
    						int choice2 = rand()%100;
				
						if (choice2 >= 0 && choice2 < 30)
							type = RAPID;
				     	if (choice2 >= 30 && choice2 < 60)
							type = LASER;	
						if (choice2 >= 68 && choice2 < 80)
							type = MISSILE;
						if (choice2 >= 80 && choice2 < 92)
							type = BOMB;
						if (choice2 >= 92 && choice2 < 100)
							type = LIGHTNING;
					}
					
				} while (!CONFIG.AllowPowerup[type]);
			}
			else
				type = _type;
				
			active = false;
			dying = false;
			
			Explosion.Init(x, y, 32, 60, 1, 0);
		}
		
		void Activate()	{active = true;}
		
		int GetType()		{return type;}
		float GetX()		{return x;}
		float GetY()		{return y;}
		
		bool IsGood()
		{
			if (!active || dying)
				return false;
			else
				return true;
		}
		
		void Update(DATAFILE *snd)
		{
			if (IsGood())
			{
				x += xspeed;
				y += yspeed;
			
				if (x > 800)
					x = 0;
				if (x < 0)
					x = 799;
				if (y > 600)
					y = 42;
				if (y < 42)
					y = 599;
				
				xspeed *= .995;
				yspeed *= .995;
				
				if (GetSpeed() < .5 && !dying)
				{
					M_play_sample((SAMPLE *)snd[powerupdie].dat, CONFIG.SFXVol, 128, 1000, 0);
					Die();
				}
			}
				
			if (dying)
			{
				Explosion.Update();
				
				if (!Explosion.IsExploding())
				{
					active = false;
					dying = false;
				}
			}
		}
		
		void Die()
		{
			dying = true;
			Explosion.Init(x, y, 32, 60, 1, 0);
			Explosion.Activate();
		}
		
		void Draw(BITMAP *_bmp, BITMAP *_sprites)
		{
			if (IsGood())
			{
   				masked_blit(_sprites, _bmp, 15*type, 0, (int)(x-7), (int)(y-7), 15, 15);
    			}	
			if (dying)
				Explosion.Draw(_bmp);
		}
		
		float GetSpeed()
  		{
  			// need to avoid those pesky divide by zero errors...
    			if (angle == 270 || angle == 90)
	       		return fabs(yspeed/Sin(angle));
   			else if (angle == 0 || angle == 180)
   				return fabs(xspeed/Cos(angle));
			else
				return fabs(xspeed/Cos(angle));
    		}
		
	private:
		bool active;
		bool dying;
	
		float x;
		float y;
		int angle;

		float xspeed;
		float yspeed;
		
		int type;
		
		RingExplosion Explosion;
};
