// projectile classes

#define NUM_OF_PARTICLES 50
#define NUM_RING_PARTICLES 100
#define NUM_SHIP_PARTICLES 300


class Spark // engine sparks
{
	public:
	
		Spark()
		{
			life = 0;
		}
		
	 	void Init(float _x, float _y, float _xs, float _ys, int _life)
		{
			x = _x;
			y = _y;
			xs = _xs;
			ys = _ys;
			maxlife = _life;
			life = _life;
		}
	
	
		int life;
	
		void Draw(BITMAP *_bmp, int colorstart, int colorend)
		{
			if (life)
			{
				/*int r, g, b;
				int *pR = &r;
				int *pG = &g;
				int *pB = &b;
				float v = (float)(life) / maxlife;
				hsv_to_rgb(rand()%colorend + colorstart, 1, v, pR, pG, pB);
				putpixel(_bmp, (int)x, (int)y, makecol(r, g, b));*/

				int r, g, b;
				int *pR = &r;
				int *pG = &g;
				int *pB = &b;
				hsv_to_rgb(rand()%colorend + colorstart, 1, 1, pR, pG, pB);
				transputpixel(_bmp, (int)x, (int)y, r, g, b, (float)(life) / maxlife);
			}
		}
	
		void Update()
		{
			if (life)
			{
				x += xs;
				y += ys;
				life--;
			}
		}
	
		private:
			float x;
			float y;
			float xs;
			float ys;
			int maxlife;
};

class Particle	// explosion particles (base class)
{
	public:
		void Init(float _x, float _y, int _angle, float _radint, int _life, int _col, int _size)
		{
			x = _x;
			y = _y;
			angle = _angle;
			radius = 0;
			radint = _radint;
			life = _life;
			maxlife = _life;
			color = _col;
			size = _size;
		}

 		void Draw(BITMAP *_bmp)
 		{
			if (life > 0)
			{
				int r, g, b;
				int *pR = &r;
				int *pG = &g;
				int *pB = &b;
				float v = (float)(life) / maxlife;
					
				if (color == -1)
					hsv_to_rgb(color, 0, v, pR, pG, pB);
				else
					hsv_to_rgb(color, 1, v, pR, pG, pB);
				
    				if (size == 0)
					putpixel(_bmp, (int)(x+Cos(angle)*radius), (int)(y+Sin(angle)*radius), makecol(r,g,b));
				else
			     	circlefill(_bmp, (int)(x+Cos(angle)*radius), (int)(y+Sin(angle)*radius), size, makecol(r,g,b));
			}
		}
 
    		void Update()
    		{
			if (life > 0)
			{
	 			radius += radint;
			 	life--;
			}	
		}

  		void Update(float _xs, float _ys)
		{
			if (life > 0)
			{
			 	radius += radint;
			 	life--;
			 	x += _xs;
			 	y += _ys;
			}	
		}
		
		float GetRad()	{return radius;}
  		int GetLife()	{return life;}
	protected:
		float x;
		float y;
		int angle;
		float radius;
		float radint;
		int life;
		int maxlife;
		int color;
		int size;
};

class LineShrap : public Particle // twirly line shrapnel
{
	public:
		void Init(float _x, float _y, int _angle, float _radint, int _life, int _col)
		{
			x = _x;
			y = _y;
			angle = _angle;
			radius = 0;
			radint = _radint;
			life = _life;
			maxlife = life;
			color = _col;
	
			int i;
			for (i = 0; i < 2; i++)
			{
				Point[i] = rand()%360;
			}
		
		}
		
	 	void Draw(BITMAP *_dest)
	 	{
			if (life > 0)
			{
				int r, g, b;
				int *pR = &r;
				int *pG = &g;
				int *pB = &b;
		
				float v = (float)(life) / maxlife;
				if (color == -1)
					hsv_to_rgb(color, 0, v, pR, pG, pB);
				else
					hsv_to_rgb(color, 1, v, pR, pG, pB);
	
	     		thickline(_dest,(int)((x+Cos(angle)*radius)+(Cos(Point[0])*5)),
      				(int)((y+Sin(angle)*radius)+(Sin(Point[0])*5)),
      				(int)((x+Cos(angle)*radius)+(Cos(Point[1])*5)),
      				(int)((y+Sin(angle)*radius)+(Sin(Point[1])*5)), makecol(r, g, b));
			}
		}

 	 	void Update()
 	 	{
			if (life > 0)
			{
	 			radius += radint;
			 	life--;
			 	int i;
			 	for (i = 0; i < 2; i++)
			 	{
			 		Point[i]+=10;
		 		}
			}	
		}
		
 	 	void Update(float _xs, float _ys)
		{
			if (life > 0)
			{
			 	radius += radint;
			 	life--;
			 	int i;
			 	for (i = 0; i < 2; i++)
			 	{
			 		Point[i]+=10;
		 		}
		 		x += _xs;
		 		y += _ys;
			}
		}
 	 	
 	private:
	 	int Point[2];

};

class LineExplosion
{
	public:
		void Init(float _x, float _y, int _life)
		{
			int i;
			for (i = 0; i < NUM_OF_PARTICLES; i++)
			{
					Line[i].Init(_x, _y, rand()%360, (rand()%100)*.07, _life, rand()%50+250);
			}
			x = _x;
			y = _y;
			Exploding = false;
			Life = _life;
			MaxLife = _life;
		}

		void Activate()	{Exploding = true;};

		void Draw(BITMAP *_dest)
		{
			if (Exploding)
			{
		  		int i;
				for (i = 0; i < NUM_OF_PARTICLES; i++)
				{
					Line[i].Draw(_dest);
				}
			}
		}
		
		void Update()
		{
			if (Exploding)
			{
				int i;
				for (i = 0; i < NUM_OF_PARTICLES; i++)
				{
					Line[i].Update();
				}
				Life--;
		
				if (Life == 0)
					Exploding = false;
			}
		}

		void Update(float _xs, float _ys)
		{
			if (Exploding)
			{
				int i;
				for (i = 0; i < NUM_OF_PARTICLES; i++)
				{
					Line[i].Update(_xs, _ys);
				}
				Life--;
		
				if (Life == 0)
					Exploding = false;
			}
		}
		
		bool IsExploding()	{return Exploding;};
	  	//void ChangePos(int _x, int _y) {x += _x; y += _y;};
	private:
		float x;
		float y;
  		int Life;
  		int MaxLife;
		bool Exploding;
		bool Mode;
		LineShrap Line[NUM_OF_PARTICLES];
};

class StdExplosion
{
	public:
		void Init(int _x, int _y, int _life, int _colstart, int _colend, int _size)
		{
			int i;
			for (i = 0; i < NUM_RING_PARTICLES; i++)
			{
					Part[i].Init(_x, _y, rand()%360, (rand()%100)*.05, _life, rand()%_colend+_colstart, _size);
			}
			x = _x;
			y = _y;
			Exploding = false;
			Life = _life;
			MaxLife = _life;
		}

		void Activate()	{Exploding = true;};

		void Draw(BITMAP *_dest)
		{
			if (Exploding)
			{
		  		int i;
				for (i = 0; i < NUM_RING_PARTICLES; i++)
				{
					Part[i].Draw(_dest);
				}
			}
		}
		
		void Update()
		{
			if (Exploding)
			{
				int i;
				for (i = 0; i < NUM_RING_PARTICLES; i++)
				{
					Part[i].Update();
				}
				Life--;
		
				if (Life == 0)
					Exploding = false;
			}
		}

		void Update(int _xs, int _ys)
		{
			if (Exploding)
			{
				int i;
				for (i = 0; i < NUM_RING_PARTICLES; i++)
				{
					Part[i].Update(_xs, _ys);
				}
				Life--;
		
				if (Life == 0)
					Exploding = false;
			}
		}
		
		bool IsExploding()	{return Exploding;};
	  	//void ChangePos(int _x, int _y) {x += _x; y += _y;};
	protected:
		int x;
		int y;
  		int Life;
  		int MaxLife;
		bool Exploding;
		bool Mode;
		Particle Part[NUM_RING_PARTICLES];
};

class RingExplosion : public StdExplosion
{
	public:
		void Init(int _x, int _y, int _life, int _colstart, int _colend, int _size)
		{
			int i;
			for (i = 0; i < NUM_RING_PARTICLES; i++)
			{
					Part[i].Init(_x, _y, rand()%360, (rand()%10+80)*.05, _life, rand()%_colend+_colstart, _size);
			}
			x = _x;
			y = _y;
			Exploding = false;
			Life = _life;
			MaxLife = _life;
		}
		
		float Radius()
		{
			return Part[0].GetRad();
		}
		
		int GetLife() {return Part[0].GetLife();}
		
};

class ShipExplosion
{
	public:
		void Init(float _x, float _y, int _life)
		{
			int i;
			for (i = 0; i < NUM_SHIP_PARTICLES; i++)
				Spark[i].Init(_x, _y, rand()%360, (rand()%100)*.08, _life, -1, rand()%2);
			//for (i = 0; i < NUM_OF_PARTICLES; i++)
			//	Line[i].Init(_x, _y, rand()%360, (rand()%100)*.07, _life, -1);

			x = _x;
			y = _y;
			Exploding = false;
			Life = _life;
			MaxLife = _life;
		}

		void Activate()	{Exploding = true;};

		void Draw(BITMAP *_dest)
		{
			if (Exploding)
			{
		  		int i;
				for (i = 0; i < NUM_SHIP_PARTICLES; i++)
					Spark[i].Draw(_dest);
				//for (i = 0; i < NUM_OF_PARTICLES; i++)
				//	Line[i].Draw(_dest);

			}
		}
		
		void Update()
		{
			if (Exploding)
			{
				int i;
				for (i = 0; i < NUM_SHIP_PARTICLES; i++)
					Spark[i].Update();
				//for (i = 0; i < NUM_OF_PARTICLES; i++)
				//	Line[i].Update();

				Life--;
		
				if (Life == 0)
					Exploding = false;
			}
		}

		void Update(float _xs, float _ys)
		{
			if (Exploding)
			{
				int i;
				for (i = 0; i < NUM_SHIP_PARTICLES; i++)
					Spark[i].Update(_xs, _ys);
				//for (i = 0; i < NUM_OF_PARTICLES; i++)
				//	Line[i].Update(_xs, _ys);
				Life--;
		
				if (Life == 0)
					Exploding = false;
			}
		}
		
		bool IsExploding()	{return Exploding;};
	  	//void ChangePos(int _x, int _y) {x += _x; y += _y;};
	private:
		float x;
		float y;
  		int Life;
  		int MaxLife;
		bool Exploding;
		Particle Spark[NUM_SHIP_PARTICLES];
		//LineShrap Line[NUM_OF_PARTICLES];
};

class Comet
{
	public:
		void Init(float _x, float _y, int _angle, float _speed, int _color)
		{
			x = _x;
			y = _y;
			angle = _angle;
			speed = _speed;
			color = _color;
			
			dying = false;
			active = true;
		}
		
		void Init(int side, float _speed, int _color)
		{
			switch (side)
			{
				case 0:
					x = 0;
					y = 300;
					angle = To360(rand()%178+271);
					break;
				case 1:
					x = 400;
					y = 0;
					angle = rand()%178+1;
					break;
				case 2:
					x = 800;
					y = 300;
					angle = rand()%178+90;
					break;
				case 3:
					x = 400;
					y = 600;
					angle = rand()%178+180;
					break;
				default:
					x = 400;
					y = 600;
					angle = rand()%178+180;
					break;
			}
			speed = _speed;
   			color = _color;
   			active = true;
   			dying = false;
		}
		
		
		int NextSpark()
		{
		 	int i;
			for (i = 0; i < 500; i++)
			{
				if (!sprk[i].life)
				return i;
			}
			return -1;
		}
		
		bool AllSparksDead()
		{
		 	int i;
			for (i = 0; i < 500; i++)
			{
				if (sprk[i].life)
					return false;
			}
			return true;
		}		
		
		bool IsActive()	{return active;}
		
		void Update()
		{
			if (active)
			{
				if (!dying)
				{
					x += Cos(angle)*speed;
					y += Sin(angle)*speed;
				
					int i;
					for (i = 0; i < 5; i++)
					{
						if (NextSpark() > -1)
						{
							int spread = rand()%120-60;
							float spd = (rand()%8+1)*.25;
							sprk[NextSpark()].Init(	x+Cos(angle + 180)*10,
											y+Sin(angle + 180)*10,
											Cos(angle + 180 + spread)*spd,
											Sin(angle + 180 + spread)*spd, 64);
						}
					}	
		   		}
			
				int i;
				for (i = 0; i < 500; i++)
					sprk[i].Update();
			
				if (x > 800 || x < 0)
    					dying = true;
         			if (y > 600 || y < 0)
   					dying = true;
       		}
       		
       		if (AllSparksDead())
       			active = false;
		}
		
		void Draw(BITMAP *_dest)
		{
			if (!dying)
			{
				int r, g, b;
				int *pR = &r;
				int *pG = &g;
				int *pB = &b;
				hsv_to_rgb(color, 1, 1, pR, pG, pB);

				circlefill(_dest, (int)x, (int)y, 1, makecol(r, g, b));
			}
			
			if (active)
			{
				int i;
				for (i = 0; i < 500; i++)
				{
					if (sprk[i].life)
						sprk[i].Draw(_dest, color, 10);
				}
			}
		}
		
	private:
		float x;
		float y;
		
		int angle;
		
		float speed;
		
		int color;
		
		bool dying;
		bool active;
		
		Spark sprk[500];
};
