// miscellaneous

void thickline(BITMAP *_dest, int _x1, int _y1, int _x2, int _y2, int _color)
{
	line(_dest, _x1, _y1, _x2, _y2, _color);
	line(_dest, _x1+1, _y1, _x2+1, _y2, _color);
	line(_dest, _x1-1, _y1, _x2-1, _y2, _color);
	line(_dest, _x1, _y1+1, _x2, _y2+1, _color);
	line(_dest, _x1, _y1-1, _x2, _y2-1, _color);
}

void transputpixel(BITMAP *_dest, int x, int y, int r, int g, int b, float a)
// a is between 0 and 1
{
	float a2;
	a2 = 1 - a;
	
	int bcolor = getpixel(_dest, x, y);
	int r2 = getr(bcolor);
	int g2 = getg(bcolor);
	int b2 = getb(bcolor);
	
	putpixel(_dest, x, y, makecol((int)((r * a) + (r2 * a2)), (int)((g * a) + (g2 * a2)), (int)((b * a) + (b * a2))));
}

struct Point
{
    float x;
    float y;
    float woo;
};


class ZigzagLine
{
    public:
        void Init(int _numofpoints);
        void Redim(int _newnumofpoints);
        void Draw(BITMAP *_dest, int _x1, int _y1, int _x2, int _y2, int _color, float _z);

    private:
        Point *point_array;
        int points;       
};

void ZigzagLine::Init(int _numofpoints)
{
    point_array = new Point[_numofpoints];
    points = _numofpoints;
}

void ZigzagLine::Redim(int _newnumofpoints)
{
    delete[ ] point_array;		
    point_array = new Point[_newnumofpoints];
    points = _newnumofpoints;
}


void ZigzagLine::Draw(BITMAP *_dest, int _x1, int _y1, int _x2, int _y2, int _color, float _z)
{
    float XSlope = (_x2-_x1)/points;
    float YSlope = (_y2-_y1)/points;
    float PerpSlope = -(YSlope/XSlope);
    float Rand;

    int i;
    for (i = 0; i < points; i++)
    {
        Rand = (float)(rand() % 101) /100;
        point_array[i].x = _x1+(XSlope*i)+(XSlope*Rand);
        point_array[i].y = _y1+(YSlope*i)+(YSlope*Rand);
        
        if (i % 2)
        {
                point_array[i].x -= -YSlope * ((float)(rand() % 101*_z) /100);
                point_array[i].y -= XSlope * ((float)(rand() % 101*_z) /100);
        }
        else
        {
               point_array[i].x -= YSlope * ((float)(rand() % 101*_z) /100);
               point_array[i].y -= -XSlope * ((float)(rand() % 101*_z) /100);
        }
                
                
    }
    
    line(_dest, _x1, _y1, (int)(point_array[0].x), (int)(point_array[0].y), _color);
    for (i = 1; i < points; i++)
    {
        line(_dest,    (int)(point_array[i-1].x), (int)(point_array[i-1].y),
                       (int)(point_array[i].x), (int)(point_array[i].y),
                       _color);
    }
    line(_dest, (int)(point_array[points-1].x), (int)(point_array[points-1].y), _x2, _y2, _color);
}
