// Confrontation--a spacewar-type game
// By Matt Sarnoff - matts226@cox.net, http://mjs2k.cox.net
// Version 1.2 - July 8, 2003

//// New in version 1.2:
//     - Incorporated JPGAlleg 2.6 into the program, backdrops are now jpeg files
//     - Increased framecap from 30 fps to 45 fps; the game plays slightly faster now
//     - Ship rotation interval has been reduced from 9 degrees per keypress to 5 degrees
//       per keypress, allowing more accurate aiming
//     - Progress messages appear while the program is loading

#define FRAMERATE	45
#define ANGLE_INT	5
#define THRUST_INT	.15


#define BLUE	0
#define RED	1

#define NUM_COLL_EXPLS	5

#define VERSION "Version 1.2 - July 8, 2003"

#define TITLE_JPG_PATH	"jpg/title.jpg"
#define BG_JPG_PATH		"jpg/backdrop.jpg"
#define INST_JPG_PATH	"jpg/instructions.jpg"
#define OPT_JPG_PATH	"jpg/backdrop-o.jpg"
#define CREDITS_JPG_PATH	"jpg/backdrop-c.jpg"

#define GFX_DAT_PATH	"gfx.dat"
#define SND_DAT_PATH	"snd.dat"

#define TITLE_XM_PATH	"music/deadlock.xm"
#define MUSIC_XM_PATH	"music/contact.xm"

#include <allegro.h>
#include <jpgalleg.h>
#include <aldumb.h>


#include <math.h>
#include <time.h>
#include <string.h>
#include <fstream.h>

const double Pi = 3.141592654;
double SinTable[360];
double CosTable[360];

float dist(float x1, float y1, float x2, float y2);
float max(float a, float b);

#include "config.h"
ConfigData CONFIG;

void M_play_sample(const SAMPLE *spl, int vol, int pan, int freq, int loop);

void M_al_poll_duh(AL_DUH_PLAYER *dp);

#include "gfxdefs.h"
#include "snddefs.h"

#include "trig.h"
#include "misc.h"
#include "particles.h"
#include "weapons.h"
#include "powerups.h"
#include "ship.h"

void validate_input(char str[], DIALOG *d_object, int min, int max);

int Game(BITMAP *bg, DATAFILE *pic, DATAFILE *snd);
int PlayRound(BITMAP *_bmp, Ship ship[2], BITMAP *bg, DATAFILE *pic, DATAFILE *snd, Powerup &Pwrup, int &PwrupNext, int &PwrupCnt, int AllowPowerups);
int NextCollExplosion(StdExplosion _CollExpl[]);
void DrawStatusBar(BITMAP *_bmp, DATAFILE *pic, Ship ship[2]);

int TitleScreen(BITMAP *bg, DATAFILE *pic);
int OptionsScreen(ConfigData &conf, DATAFILE *pic, BITMAP *bg);
int InstructionsScreen(DATAFILE *pic, BITMAP *bg);
int AudioScreen(ConfigData &conf, DATAFILE *pic, DATAFILE *snd, BITMAP *bg, DUH *mus);
int CreditsScreen(DATAFILE *pic, BITMAP *bg);

int PauseMenu(ConfigData &conf, DATAFILE *pic, DATAFILE *snd, DUH *mus);

int sfx_slider(void *dp3, int d2);
int music_slider(void *dp3, int d2);
int defaults_btn_proc(int msg, DIALOG *d, int c);

volatile int speed_counter = 0;
void increment_speed_counter()
{
	speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter);

DUH *music;
DUH *titlemusic;
AL_DUH_PLAYER *dp;

BITMAP *opt_bg;
BITMAP *instructions;

int main(int argc, char *argv[])
{ 
	int coldepth = 16;
	
	if (argc == 2 && strcmp(argv[1],"-32bit") == 0)
		coldepth = 32;
		
	allegro_init();
	jpgalleg_init();
	
	atexit(&dumb_exit);
	dumb_register_stdfiles();

	dumb_resampling_quality = DUMB_RQ_LINEAR;
	
	install_keyboard();
	install_timer();
	
 	if (install_mouse() == -1)
 	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Failed to initialize the mouse driver. Make sure it is properly connected.");
		return 0;
	}
	
	if (install_sound(DIGI_AUTODETECT, MIDI_NONE, "") == -1)
 	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Failed to initialize a sound card. This program requires a compatible sound card to run.");
		return 0;
	}
		
	set_window_title("Confrontation");
	
	set_color_depth(coldepth);
	
	if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 800, 600, 0, 0) != 0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Could not set graphics mode. In order to run this program, your video card must be capable of 800x600 resolution in 16- or 32-bit color.");
		return 0;
	}
    
	text_mode(-1);
 	
 	textprintf(screen, font, 0, 0, -1, "--- Confrontation by Matt Sarnoff ---");
 	textprintf(screen, font, 0, 9, -1, VERSION);
 	
 	textprintf(screen, font, 0, 18, -1, "Graphics mode set: 800x600, %d-bit", coldepth);
 	
  	srand(time(NULL));

 	textprintf(screen, font, 0, 27, -1, "Calculating trig tables");
	CalculateTrigTables();

 	textprintf(screen, font, 0, 36, -1, "Initializing timer");
 	LOCK_VARIABLE(speed_counter);
	LOCK_FUNCTION(increment_speed_counter);
	install_int_ex(increment_speed_counter, BPS_TO_TIMER(FRAMERATE));
 	BITMAP *framebuf = create_bitmap(800,600);
	clear_bitmap(framebuf);

 	textprintf(screen, font, 0, 45, -1, "Loading backdrop images...");
 	
 	textprintf(screen, font, 16, 54, -1, TITLE_JPG_PATH);
	BITMAP *title_bg = create_bitmap(800,600);
 	clear_bitmap(title_bg);
 	title_bg = load_bitmap(TITLE_JPG_PATH, default_palette);
 	if (!title_bg)
 	{
 		alert("File \"jpg\\title.jpg\" not found.", "", "", "Quit", NULL, 0, 0);
 		return 0;
 	}
 	
 	textprintf(screen, font, 16, 63, -1, BG_JPG_PATH);
 	BITMAP *bg = create_bitmap(800,600);
 	clear_bitmap(bg);
 	bg = load_bitmap(BG_JPG_PATH, default_palette);
 	if (!bg)
 	{
 		alert("File \"jpg\\backdrop.jpg\" not found.", "", "", "Quit", NULL, 0, 0);
 		return 0;
 	}
 	
 	textprintf(screen, font, 16, 72, -1, OPT_JPG_PATH);
 	opt_bg = create_bitmap(800,600);
 	clear_bitmap(opt_bg);
 	opt_bg = load_bitmap(OPT_JPG_PATH, default_palette);
 	if (!opt_bg)
 	{
 		alert("File \"jpg\\backdrop-o.jpg\" not found.", "", "", "Quit", NULL, 0, 0);
 		return 0;
 	}

 	textprintf(screen, font, 16, 81, -1, CREDITS_JPG_PATH); 	
 	BITMAP *credits_bg = create_bitmap(800,600);
 	clear_bitmap(credits_bg);
 	credits_bg = load_bitmap(CREDITS_JPG_PATH, default_palette);
 	if (!credits_bg)
 	{
 		alert("File \"jpg\\backdrop-c.jpg\" not found.", "", "", "Quit", NULL, 0, 0);
 		return 0;
 	}

 	textprintf(screen, font, 16, 90, -1, INST_JPG_PATH); 	
 	instructions = create_bitmap(800,600);
 	clear_bitmap(instructions);
 	instructions = load_bitmap(INST_JPG_PATH, default_palette);
 	if (!instructions)
 	{
 		alert("File \"jpg\\instructions.jpg\" not found.", "", "", "Quit", NULL, 0, 0);
 		return 0;
 	}
 	
 	textprintf(screen, font, 0, 99, -1, "Loading datafiles...");

 	textprintf(screen, font, 16, 108, -1, GFX_DAT_PATH);
 	DATAFILE *pic = load_datafile(GFX_DAT_PATH);
 	if (!pic)
 	{
 		alert("File \"gfx.dat\" not found.", "", "", "Quit", NULL, 0, 0);
 		return 0;
 	}
 	
 	textprintf(screen, font, 16, 117, -1, SND_DAT_PATH);
 	DATAFILE *snd = load_datafile("snd.dat");
 	if (!snd)
 	{
 		alert("File \"snd.dat\" not found.", "", "", "Quit", NULL, 0, 0);
 		return 0;
 	}
 	
	textprintf(screen, font, 0, 126, -1, "Reading game configuration file");
 	ReadGameConfig(CONFIG);

	textprintf(screen, font, 0, 135, -1, "Reading audio configuration file");
 	ReadAudioConfig(CONFIG);
 	
 	
	textprintf(screen, font, 0, 144, -1, "Loading music files...");
	textprintf(screen, font, 16, 153, -1, TITLE_XM_PATH);
 	titlemusic = dumb_load_xm(TITLE_XM_PATH);
 	if (!titlemusic)
 	{
 		alert("File \"music\\deadlock.xm\" not found.", "", "", "Quit", NULL, 0, 0);
 		return 0;
 	} 	
 	
	textprintf(screen, font, 16, 162, -1, MUSIC_XM_PATH);
 	music = dumb_load_xm(MUSIC_XM_PATH);
 	if (!music)
 	{
 		alert("File \"music\\contact.xm\" not found.", "", "", "Quit", NULL, 0, 0);
 		return 0;
 	} 


	if (CONFIG.PlayMusic)
	{
		textprintf(screen, font, 0, 171, -1, "Playing music");
	 	dp = al_start_duh(titlemusic, 1, 0, (float)CONFIG.MusicVol / 100, 4096, 22050);
 	}
 	
	textprintf(screen, font, 0, 180, -1, "Setup complete, starting game...");
 	
 	bool QuitGame = false;

 	clear_bitmap(framebuf);
 	clear_bitmap(screen);

	while (!QuitGame)
	{
		int TitleChoice = TitleScreen(title_bg, pic);
	
  		switch (TitleChoice)
    		{
     		case 0:
     			if (OptionsScreen(CONFIG, pic, opt_bg) == 1)
     			{
     				Game(bg, pic, snd);
     				
     				if (CONFIG.PlayMusic)
     				{
     					al_stop_duh(dp);
     			   		dp = al_start_duh(titlemusic, 1, 0, (float)CONFIG.MusicVol / 100, 4096, 22050);
			   		}
 				}
     			break;
			case 1:
				InstructionsScreen(pic, instructions);
				break;	
			case 2:
				AudioScreen(CONFIG, pic, snd, opt_bg, titlemusic);
				break;
			case 3:
				CreditsScreen(pic, credits_bg);
				break;	
         		case 4:
      			QuitGame = true;
      			break;
       	}	
  	
	}
 	
 	
	unload_datafile(pic);
	unload_datafile(snd);
	unload_duh(titlemusic);
	unload_duh(music);
	allegro_exit();
	return 0;     
}     
END_OF_MAIN();

int Game(BITMAP *bg, DATAFILE *pic, DATAFILE *snd)
{
	BITMAP *framebuf = create_bitmap(800, 600);

	Ship ship[2];
  
  	ship[0].Init(100,300,270,BLUE);
 	ship[1].Init(700,300,270,RED);
 	
 	int Result;
 	
	Powerup Pwrup;
	
	int AllowPowerups = 6;
	int i;
	for (i = 0; i < 6; i++)
	{
 		if (!CONFIG.AllowPowerup[i])
			AllowPowerups--;
	}
 
 	int PwrupNext = -1, PwrupCnt = 0;
  
  	if (AllowPowerups)
  		PwrupNext = rand()%66 + 166;

	bool Quit = false;

	if (CONFIG.PlayMusic)
		al_stop_duh(dp);

	scare_mouse();
	clear_bitmap(screen);
	
	M_play_sample((SAMPLE *)snd[start].dat, CONFIG.SFXVol, 128, 1000, 0);
	
	blit(bg,framebuf,0,0,0,0,800,600);
	textprintf_centre(framebuf, (FONT *)pic[twcen].dat, 400, 290, -1, "Press Enter to begin...");
	blit(framebuf,screen,0,0,0,0,800,600);

	clear_keybuf();
	while(!key[KEY_ENTER])
		poll_keyboard();
	
	stop_sample((SAMPLE *)snd[start].dat);
	
	if (CONFIG.PlayMusic)
		dp = al_start_duh(music, 1, 0, (float)CONFIG.MusicVol / 100, 4096, 22050);
	
 	while (ship[0].GetScore() < CONFIG.Goal && ship[1].GetScore() < CONFIG.Goal && !Quit)
 	{
 		ship[0].Reset(100,300,270);
 		ship[1].Reset(700,300,270);
 		
 		stop_sample((SAMPLE *)snd[thrust1].dat);
 		stop_sample((SAMPLE *)snd[thrust2].dat);
 		stop_sample((SAMPLE *)snd[lightcharge].dat);
 		stop_sample((SAMPLE *)snd[missiletrack].dat);
 		
 		M_play_sample((SAMPLE *)snd[thrust1].dat, 0, 128, 1000, 1);
 		adjust_sample((SAMPLE *)snd[thrust1].dat, 0, 128, 1000, 1);
 		M_play_sample((SAMPLE *)snd[thrust2].dat, 0, 128, 1000, 1);
 		adjust_sample((SAMPLE *)snd[thrust2].dat, 0, 128, 1000, 1);		
 		
  		Result = PlayRound(framebuf, ship, bg, pic, snd, Pwrup, PwrupNext, PwrupCnt, AllowPowerups);
		
		if (Result == -99)
			Quit = true;
		else if (Result > -1)
			ship[Result].ChScore(1);

		if (Result != -99)
		{
			textprintf_centre(framebuf, (FONT *)pic[twcen].dat, 400, 290, -1, "Press Enter");
			blit(framebuf,screen,0,0,0,0,800,600);
		
			while (!key[KEY_ENTER])
			{
				M_al_poll_duh(dp);
				poll_keyboard();
			}
		}
 	}
 	
 	if (Result != -99)
 	{
 		stop_sample((SAMPLE *)snd[thrust1].dat);
 		stop_sample((SAMPLE *)snd[thrust2].dat);
 		stop_sample((SAMPLE *)snd[lightcharge].dat);
 		stop_sample((SAMPLE *)snd[missiletrack].dat);
		
		clear_keybuf();
		
		Comet comet[12];
	
		int col;
		
		if (ship[0].GetScore() > ship[1].GetScore())
			col = 240;
		else if (ship[1].GetScore() > ship[0].GetScore())
			col = 0;
	
		int i;
		for (i = 0; i < 12; i++)
			comet[i].Init(400, 300, 30*i, 8, col);
		
		while (!key[KEY_ESC])
		{
			M_al_poll_duh(dp);
			poll_keyboard();
			
			clear_bitmap(framebuf);
 	
		 	if (ship[0].GetScore() > ship[1].GetScore())
	 			textprintf_centre(framebuf, (FONT *)pic[twcen].dat, 400, 200, -1, "%s is the winner!", CONFIG.P1Name);
			else if (ship[1].GetScore() > ship[0].GetScore())
 				textprintf_centre(framebuf, (FONT *)pic[twcen].dat, 400, 200, -1, "%s is the winner!", CONFIG.P2Name);

			textprintf_centre(framebuf, (FONT *)pic[twcen_m].dat, 400, 290, -1, "Final Score:");
			textprintf_centre(framebuf, (FONT *)pic[twcen_l].dat, 400, 310, -1, "%s: %d   %s: %d",
 				CONFIG.P1Name, ship[0].GetScore(), CONFIG.P2Name, ship[1].GetScore());
 			
 			textprintf_centre(framebuf, (FONT *)pic[twcen_m].dat, 400, 450, -1, "Press Esc to return to the main menu");
 			
 			for (i = 0; i < 12; i++)
			{
				comet[i].Update();
				if (!comet[i].IsActive())
					comet[i].Init(rand()%4, 8, col);

				comet[i].Draw(framebuf);
			}
 			
			blit(framebuf,screen,0,0,0,0,800,600);
		}
	}
	
	stop_sample((SAMPLE *)snd[thrust1].dat);
	stop_sample((SAMPLE *)snd[thrust2].dat);
	stop_sample((SAMPLE *)snd[lightcharge].dat);
	stop_sample((SAMPLE *)snd[missiletrack].dat);
	
}

int PlayRound(BITMAP *_bmp, Ship ship[2], BITMAP *bg, DATAFILE *pic, DATAFILE *snd, Powerup &Pwrup, int &PwrupNext, int &PwrupCnt, int AllowPowerups)
{
 	StdExplosion CollExpl[5];
	int i;
	for (i = 0; i < 5; i++)
		CollExpl[i].Init(0,0,16,250,50,1);

	bool P1FirePressed = false, P1SwitchPressed = false;
	bool P2FirePressed = false, P2SwitchPressed = false;

	int P1ThrustVol = 0, P2ThrustVol = 0;

	clear_keybuf();

	while(ship[0].IsAlive() && ship[1].IsAlive())
	{		
		while (speed_counter > 0)
		{		
			M_al_poll_duh(dp);
			poll_keyboard();
			
   			if (key[KEY_D])
   				ship[0].ChAngle(ANGLE_INT);
			if (key[KEY_A])
   				ship[0].ChAngle(-ANGLE_INT);
			if (key[KEY_W])
			{
				if (P1ThrustVol < CONFIG.SFXVol)
					P1ThrustVol+=2;
					
				adjust_sample((SAMPLE *)snd[thrust1].dat, P1ThrustVol, 128, 1000, 1);
				ship[0].Thrust();
			}
			else
			{			
   				if (P1ThrustVol > 0)
					P1ThrustVol-=2;
				
    				adjust_sample((SAMPLE *)snd[thrust1].dat, P1ThrustVol, 128, 1000, 1);
			}	
			
			if (key[KEY_S])
			{
				if (ship[0].CurrWeapon() == 1 || ship[0].CurrWeapon() == 5)
				{
					ship[0].FireWeapon(snd);
					P1FirePressed = true;
				}
				else if (ship[0].CurrWeapon() == 3)
				{
					ship[0].Wepn[3]->SetTarget(ship[1].X(), ship[1].Y(), ship[1].GetSpeed());
					ship[0].FireWeapon(snd);
					P1FirePressed = true;
				}
				else
				{
					if (!P1FirePressed)
					{
						ship[0].FireWeapon(snd);
						P1FirePressed = true;
					}
				}
			}
			else
			{
				P1FirePressed = false;
				
     			if (ship[0].CurrWeapon() == 5)
     			{
     			 	if (ship[0].Wepn[5]->GetStrength() > 0 && !ship[0].Wepn[5]->IsActive())
   					{
    						ship[0].Wepn[5]->Target(ship[1].X(),ship[1].Y());
               			ship[0].Wepn[5]->Activate(snd);
               			stop_sample((SAMPLE *)snd[lightcharge].dat);
    					}
     			}
			}

			if (key[KEY_TAB])
			{
				if (!P1SwitchPressed)
				{
					ship[0].SwitchWeapons();
					P1SwitchPressed = true;
				}
			}
			else
				P1SwitchPressed = false;
				
			if (key[KEY_RIGHT])
   				ship[1].ChAngle(ANGLE_INT);
			if (key[KEY_LEFT])
   				ship[1].ChAngle(-ANGLE_INT);
			if (key[KEY_UP])
			{
				if (P2ThrustVol < CONFIG.SFXVol)
					P2ThrustVol+=2;
					
				adjust_sample((SAMPLE *)snd[thrust2].dat, P2ThrustVol, 128, 1000, 1);
				ship[1].Thrust();
			}
			else
			{			
   				if (P2ThrustVol > 0)
					P2ThrustVol-=2;
				
    				adjust_sample((SAMPLE *)snd[thrust2].dat, P2ThrustVol, 128, 1000, 1);
			}	

			if (key[KEY_DOWN])
			{
				if (ship[1].CurrWeapon() == 1 || ship[1].CurrWeapon() == 5)
				{
					ship[1].FireWeapon(snd);
					P2FirePressed = true;
				}
				else if (ship[1].CurrWeapon() == 3)
				{
					ship[1].Wepn[3]->SetTarget(ship[0].X(), ship[0].Y(), ship[0].GetSpeed());
					ship[1].FireWeapon(snd);
					P2FirePressed = true;
				}
				else
				{
					if (!P2FirePressed)
					{
						ship[1].FireWeapon(snd);
						P2FirePressed = true;
					}
				}
			}
			else
			{
				P2FirePressed = false;
				
     			if (ship[1].CurrWeapon() == 5)
     			{
     			 	if (ship[1].Wepn[5]->GetStrength() > 0 && !ship[1].Wepn[5]->IsActive())
   					{
    						ship[1].Wepn[5]->Target(ship[0].X(),ship[0].Y());
               			ship[1].Wepn[5]->Activate(snd);
               			stop_sample((SAMPLE *)snd[lightcharge].dat);
               			
    					}
     			}
			}

			if (key[KEY_0_PAD])
			{
				if (!P2SwitchPressed)
				{
					ship[1].SwitchWeapons();
					P2SwitchPressed = true;
				}
			}
			else
				P2SwitchPressed = false;

			if (key[KEY_ESC])
			{
				if (PauseMenu(CONFIG, pic, snd, music) == -1)
					return -99;
			}

			if (ship[0].GetShield() > 0 && ship[1].GetShield() > 0)
			{
				if (dist(	ship[0].X(), ship[0].Y(),
						ship[1].X(), ship[1].Y()) < 12)
				{
					if (ship[0].GetSpeed() > ship[1].GetSpeed())
					{
						switch (CONFIG.CollisionType)
						{
							case 0:
								ship[0].ChShield(-(ship[0].GetSpeed()/2));
								ship[1].ChShield(-(ship[0].GetSpeed()/2));
								break;
							case 1:
								ship[0].ChShield(-(ship[0].GetSpeed()));
								ship[1].ChShield(-(ship[0].GetSpeed()/2));
								break;
							case 2:
								ship[0].ChShield(-(ship[0].GetSpeed()/2));
								ship[1].ChShield(-(ship[0].GetSpeed()));
								break;
						}								
						
						int nextexpl = NextCollExplosion(CollExpl);
						if (nextexpl > -1)
						{
							CollExpl[nextexpl].Init(ship[1].X(),ship[1].Y(),32,250,50,1);
							CollExpl[nextexpl].Activate();
						}
 						
 						M_play_sample((SAMPLE *)snd[shipcollide].dat, CONFIG.SFXVol, 128, 1000, 0);
 						
						ship[0].Rebound();
						ship[0].StartSpin(ship[0].GetSpeed());
						
						if (ship[0].GetSpeed() < 3)
							ship[1].Bounce(ship[0].TA(), ship[0].GetSpeed()*2);
						else
							ship[1].Bounce(ship[0].TA(), ship[0].GetSpeed());

						ship[1].StartSpin(ship[0].GetSpeed());
					}
					else
					{
						switch (CONFIG.CollisionType)
						{
							case 0:
								ship[0].ChShield(-(ship[1].GetSpeed()/2));
								ship[1].ChShield(-(ship[1].GetSpeed()/2));
								break;
							case 1:
								ship[0].ChShield(-(ship[1].GetSpeed()/2));
								ship[1].ChShield(-(ship[1].GetSpeed()));
								break;
							case 2:
								ship[0].ChShield(-(ship[1].GetSpeed()));
								ship[1].ChShield(-(ship[1].GetSpeed()/2));
								break;
						}			
	
						int nextexpl = NextCollExplosion(CollExpl);
						if (nextexpl > -1)
						{
							CollExpl[nextexpl].Init(ship[0].X(),ship[0].Y(),32,250,50,1);
							CollExpl[nextexpl].Activate();
						}

 						M_play_sample((SAMPLE *)snd[shipcollide].dat, CONFIG.SFXVol, 128, 1000, 0);

						ship[1].Rebound();
						ship[1].StartSpin(ship[1].GetSpeed());
	
						if (ship[1].GetSpeed() < 3)
							ship[0].Bounce(ship[1].TA(), ship[1].GetSpeed()*2);
						else
							ship[0].Bounce(ship[1].TA(), ship[1].GetSpeed());

						ship[0].StartSpin(ship[1].GetSpeed());
					}
				}
			}
			
			for (i = 0; i < 2; i++)
			{
				ship[i].Update(snd);
				ship[i].PowerupCollisionDetect(Pwrup, snd);
			}
			
			ship[0].UpdateWeapons(snd, ship[1].GetShield());
			ship[1].UpdateWeapons(snd, ship[0].GetShield());
			
			ship[0].Wepn[3]->SetTarget(ship[1].X(), ship[1].Y(), ship[1].GetSpeed());
			ship[1].Wepn[3]->SetTarget(ship[0].X(), ship[0].Y(), ship[0].GetSpeed());
			
			ship[0].Wepn[5]->Target(ship[1].X(), ship[1].Y());
			ship[1].Wepn[5]->Target(ship[0].X(), ship[0].Y());
			
			ship[0].WeaponCollisionDetect(ship[1], snd);
			ship[1].WeaponCollisionDetect(ship[0], snd);
			
			for (i = 0; i < 5; i++)
				CollExpl[i].Update();
			
			if (PwrupCnt == PwrupNext && AllowPowerups)
			{
				Pwrup.Init(rand()%800, rand()%560+40, rand()%360, 3, -1);
				Pwrup.Activate();
				M_play_sample((SAMPLE *)snd[powerupspawn].dat, CONFIG.SFXVol, 128, 1000, 0);
				PwrupCnt = -1;
			}
			
			if (PwrupCnt == -1 && !Pwrup.IsGood() && AllowPowerups)
			{
				PwrupCnt = 0;
				PwrupNext = rand()%66 + 166;
			}
			
			if (AllowPowerups)
   				Pwrup.Update(snd);
	
   			if (PwrupCnt > -1 && AllowPowerups)		
				PwrupCnt++;		

			speed_counter--;
		} // speed counter loop		
  	
	
		clear_bitmap(_bmp);
  		blit(bg,_bmp,0,0,0,0,800,600);

		for (i = 0; i < 2; i++)
		{
			ship[i].Draw(_bmp, pic);
			ship[i].DrawWeapons(_bmp);
		}

		for (i = 0; i < 5; i++)
				CollExpl[i].Draw(_bmp);

		Pwrup.Draw(_bmp, (BITMAP *)pic[powerups].dat);
		
		DrawStatusBar(_bmp, pic, ship);

		blit(_bmp,screen,0,0,0,0,800,600);

 	}
 	
 	if (!ship[0].IsAlive() && !ship[1].IsAlive())
 		return -1; // return -1 if round was a tie
	
	if (ship[0].IsAlive())
		return 0;	// return 0 if ship 0 won
	if (ship[1].IsAlive())
		return 1;	// return 1 if ship 1 won
}

float dist(float x1, float y1, float x2, float y2)
{
	return sqrt( (y2-y1)*(y2-y1) + (x2-x1)*(x2-x1) );
}

float max(float a, float b)
{
	if (a > b)
		return a;
	else
		return b;
}

int NextCollExplosion(StdExplosion _CollExpl[])
{
 	int i;
	for (i = 0; i < 5; i++)
	{
		if (!_CollExpl[i].IsExploding())
		return i;
	}
	return -1;
}

void DrawStatusBar(BITMAP *_bmp, DATAFILE *pic, Ship ship[2])
{
	int i;
	
	char tmp[3], pl;
	
 	rectfill(_bmp,0,0,800,42,makecol(0,0,0));
			
	draw_sprite(_bmp, (BITMAP *)pic[barblue_e].dat,0,0);
	
  	if (ship[0].GetShield() > 0)
		masked_blit((BITMAP *)pic[barblue].dat,_bmp,0,0,0,0,ship[0].GetShield()*10,25);

     textprintf(_bmp, (FONT *)pic[twcen].dat, 205, -5, -1, "%d", ship[0].GetScore());
	
	sprintf(tmp,"%d",ship[0].GetScore());
	
	textprintf(_bmp, (FONT *)pic[twcen_l].dat,
 			212+text_length((FONT *)pic[twcen].dat, tmp), -5, -1, "%s", CONFIG.P1Name);
	
	for (i = 0; i < 6; i++)
	{
		masked_blit((BITMAP *)pic[pwrupicons].dat, _bmp, 15*i, 0, 40*i, 26, 15, 15);

		if (ship[0].WeaponAmmo(i) == -1)
			textprintf(_bmp, (FONT *)pic[twcen_l].dat, 40*i+16, 21, -1, "inf.");
		else
			textprintf(_bmp, (FONT *)pic[twcen_l].dat, 40*i+16, 21, -1, "%d", ship[0].WeaponAmmo(i));
	}	
	rect(_bmp, ship[0].CurrWeapon()*40, 25, ship[0].CurrWeapon()*40+38, 42, makecol(255,0,0));		
	
	///////////////////////////////////
	
	draw_sprite(_bmp, (BITMAP *)pic[barred_e].dat,600,0);

	if (ship[1].GetShield() > 0)
		masked_blit((BITMAP *)pic[barred].dat,_bmp,
			(20-ship[1].GetShield())*10,0,
   			600+(20-ship[1].GetShield())*10,0,
     		ship[1].GetShield()*10,25);
   	
   	textprintf_right(_bmp, (FONT *)pic[twcen].dat, 595, -5, -1, "%d", ship[1].GetScore());

	sprintf(tmp,"%d",ship[1].GetScore());
	
	textprintf_right(_bmp, (FONT *)pic[twcen_l].dat,
 			588-text_length((FONT *)pic[twcen].dat, tmp), -5, -1, "%s", CONFIG.P2Name);

	for (i = 0; i < 6; i++)
	{
		masked_blit((BITMAP *)pic[pwrupicons].dat, _bmp, 15*i, 0, 558+40*i, 26, 15, 15);

		if (ship[1].WeaponAmmo(i) == -1)
			textprintf(_bmp, (FONT *)pic[twcen_l].dat, 558+40*i+16, 21, -1, "inf.");
		else
			textprintf(_bmp, (FONT *)pic[twcen_l].dat, 558+40*i+16, 21, -1, "%d", ship[1].WeaponAmmo(i));
	}	
	rect(_bmp, 558+ship[1].CurrWeapon()*40, 25, ship[1].CurrWeapon()*40+596, 42, makecol(255,0,0));
	
	if (CONFIG.Goal != 1)
		pl = 's';
	else
		pl = ' ';
	
	textprintf_centre(_bmp, (FONT *)pic[twcen_l].dat, 400, 20, -1, "Goal: First to %d point%c", CONFIG.Goal, pl);
}

int TitleScreen(BITMAP *bg, DATAFILE *pic)
{
	Comet comet[5];
	
	int i;
	for (i = 0; i < 5; i++)
		comet[i].Init(400, 300, 72*i, 8, rand()%350);

	BITMAP *framebuf = create_bitmap(800,600);
	//show_mouse(framebuf);
	
	int pulse = 250;
	int pulseint = 3;

	scare_mouse();

	do
 	{
 		poll_mouse();
 		
 		clear_bitmap(framebuf);
 		blit(bg,framebuf,0,0,0,0,800,600);
		textprintf(framebuf, (FONT *)pic[twcen_l].dat, 0,  578, -1, VERSION);

		draw_sprite(framebuf, (BITMAP *)pic[titlebuttons].dat, 150, 275);
		rect(framebuf, 148, 274, 252, 426, makecol(0, 0, pulse));

		pulse += pulseint;

		if (pulse > 250 || pulse < 20)
			pulseint = -pulseint;

		for (i = 0; i < 5; i++)
		{
			comet[i].Update();
			if (!comet[i].IsActive())
				comet[i].Init(rand()%4, 8, rand()%350);

			comet[i].Draw(framebuf);
		}

		for (i = 275; i < 425; i+=30)
		{
			if ((mouse_x >= 150 && mouse_x <= 250) && (mouse_y >= i+1 && mouse_y <= i+29))
			{
				rect(framebuf, 150, i+1, 250, i+29, makecol(0, 128, 255));
				
				if (mouse_b & 1)
				{
					clear_bitmap(framebuf);
					return (i-275)/30; // returns 0, 1, 2, 3, or 4
				}
			}
		}

		M_al_poll_duh(dp);  

		draw_sprite(framebuf, (BITMAP *)pic[cursor].dat, mouse_x, mouse_y);
		blit(framebuf,screen, 0,0,0,0,800,600);
   	}
	while (true);
}

int OptionsScreen(ConfigData &conf, DATAFILE *pic, BITMAP *bg)
{
	char strGoal[3], strP1Shield[3], strP2Shield[3];
	char strARapid[4], strALaser[3], strAMiss[3], strABomb[3], strALight[3];
	
	sprintf(strGoal,"%d",conf.Goal);
	sprintf(strP1Shield,"%d",conf.P1Shield);
	sprintf(strP2Shield,"%d",conf.P2Shield);
	
	sprintf(strARapid,"%d",conf.RapidAmmoStart);
	sprintf(strALaser,"%d",conf.LaserAmmoStart);
	sprintf(strAMiss,"%d",conf.MissileAmmoStart);
	sprintf(strABomb,"%d",conf.BombAmmoStart);
	sprintf(strALight,"%d",conf.LightningAmmoStart);

	strcpy(conf.P1Name, "Player 1");
	strcpy(conf.P2Name, "Player 2");

 	font = (FONT *)pic[fixed].dat;

	DIALOG options_dialog[] =
	{
   		/* (dialog proc)    (x)  (y)  (w)  (h)  (fg)					(bg) (key)(flags)   (d1)                    	(d2)  	(dp)              					(dp2) (dp3) */
   		{ d_ctext_proc,	400,	20,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Game Options",				(FONT *)pic[twcen].dat,	NULL	},

   		{ d_text_proc,		220,	80,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Player 1's name:",			(FONT *)pic[twcen_m].dat,	NULL	},
   		{ d_box_proc,		359, 84,	217, 20,	makecol(128,128,128),	0,	0,	0,		0,					0,		NULL,							NULL,				NULL	},
   		{ d_edit_proc,		360, 85,	215, 20,	makecol(255,255,255),	0,	0,	0,		20,					0,		(void *)conf.P1Name,						NULL,					NULL	},

   		{ d_text_proc,		220,	110,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Player 2's name:",			(FONT *)pic[twcen_m].dat,	NULL	},
   		{ d_box_proc,		359, 114,	217, 20,	makecol(128,128,128),	0,	0,	0,		0,					0,		NULL,							NULL,				NULL	},
   		{ d_edit_proc,		360, 115,	215, 20,	makecol(255,255,255),	0,	0,	0,		20,					0,		(void *)conf.P2Name,					NULL,					NULL	},

   		{ d_text_proc,		20,	160,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Point goal: (1-99)",			(FONT *)pic[twcen_m].dat,NULL },
   		{ d_box_proc,		249, 164,	37, 20,	makecol(128,128,128),	0,	0,	0,		0,					0,		NULL,							NULL,				NULL	},
   		{ d_edit_proc,		250, 165,	35, 20,	makecol(255,255,255),	0,	0,	0,		2,					0,		(void *)strGoal,					NULL,				NULL	},

  		{ d_text_proc,		20,	220,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Player 1's shield: (1-20)",	(FONT *)pic[twcen_m].dat,NULL },
		{ d_box_proc,		249, 224,	37, 20,	makecol(128,128,128),	0,	0,	0,		0,					0,		NULL,							NULL,				NULL	},
   		{ d_edit_proc,		250, 225,	35, 20,	makecol(255,255,255),	0,	0,	0,		2,					0,		(void *)strP1Shield,				NULL,				NULL	},

  		{ d_text_proc,		20,	241,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Player 2's shield: (1-20)",	(FONT *)pic[twcen_m].dat,NULL },
		{ d_box_proc,		249, 245,	37, 20,	makecol(128,128,128),	0,	0,	0,		0,					0,		NULL,							NULL,				NULL	},
   		{ d_edit_proc,		250, 246,	35, 20,	makecol(255,255,255),	0,	0,	0,		2,					0,		(void *)strP2Shield,				NULL,				NULL	},

  		{ d_text_proc,		20,	280,	0,	0,	-1,					0,	0,	0,		0,					0,		(void *)"Collision rule:",			(FONT *)pic[twcen_m].dat,NULL },
  		{ d_radio_proc,	50,	311,	9,	9,	makecol(255,255,255),	0,	0,	0,		1,					0,		(void *)"",						NULL,				NULL },
  		{ d_radio_proc,	50,	335,	9,	9,	makecol(255,255,255),	0,	0,	0,		1,					0,		(void *)"",						NULL,				NULL },
  		{ d_radio_proc,	50,	359,	9,	9,	makecol(255,255,255),	0,	0,	0,		1,					0,		(void *)"",						NULL,				NULL },

  		{ d_text_proc,		65,	303,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Both players damaged equally",	(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		65,	327,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Faster player is damaged more (i.e. players penalized for \"kamikaze\" tactics)",	(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		65,	351,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Slower player is damaged more (your ship can be used as a battering ram)",	(FONT *)pic[twcen_l].dat,NULL },
       	
       	{ d_text_proc,		20,	390,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Powerup restrictions:",		(FONT *)pic[twcen_m].dat,NULL },
  		{ d_check_proc,	50,	420,	11,	11,	makecol(255,255,255),	0,	0,	0,		1,					0,		(void *)"",						NULL,				NULL },
  		{ d_check_proc,	50,	444,	11,	11,	makecol(255,255,255),	0,	0,	0,		1,					0,		(void *)"",						NULL,				NULL },
 		{ d_check_proc,	50,	468,	11,	11,	makecol(255,255,255),	0,	0,	0,		1,					0,		(void *)"",						NULL,				NULL },
 		{ d_check_proc,	50,	492,	11,	11,	makecol(255,255,255),	0,	0,	0,		1,					0,		(void *)"",						NULL,				NULL },
    		{ d_check_proc,	50,	516,	11,	11,	makecol(255,255,255),	0,	0,	0,		1,					0,		(void *)"",						NULL,				NULL },  		  		
 		{ d_check_proc,	50,	540,	11,	11,	makecol(255,255,255),	0,	0,	0,		1,					0,		(void *)"",						NULL,				NULL },
 		
       	{ d_text_proc,		65,	413,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Allow shield restores",		(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		65,	437,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Allow rapid-fire ammo",		(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		65,	461,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Allow laser ammo",			(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		65,	485,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Allow missiles",			(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		65,	509,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Allow bombs",				(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		65,	533,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Allow lightning gun energy",	(FONT *)pic[twcen_l].dat,NULL },

		{ d_text_proc,		300,	390,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Starting ammunition:",		(FONT *)pic[twcen_m].dat,NULL },

		{ d_check_proc,	315,	420,	11,	11,	makecol(255,255,255),	0,	0,	0,		1,					0,		(void *)"",						NULL,				NULL },
		{ d_text_proc,		330,	413,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Replenish this ammo after a player dies",		(FONT *)pic[twcen_l].dat,NULL },
		
		{ d_text_proc,		345,	437,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Players start with           rapid-fire shots (0-200)",		(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		345,	461,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Players start with         laser shots (0-50)",		(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		345,	485,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Players start with         missiles (0-10)",		(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		345,	509,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Players start with         bombs (0-10)",		(FONT *)pic[twcen_l].dat,NULL },
		{ d_text_proc,		345,	534,	0,	0,	-1,					-1,	0,	0,		0,					0,		(void *)"Players start with         units of lightning gun energy (0-30)",		(FONT *)pic[twcen_l].dat,NULL },

		{ d_box_proc,		464, 441,	47, 20,	makecol(128,128,128),	0,	0,	0,		0,					0,		NULL,							NULL,				NULL	},
		{ d_edit_proc,		465, 442,	45, 	20,	makecol(255,255,255),	0,	0,	0,		3,					0,		(void *)strARapid,					NULL,				NULL	},  	
		{ d_box_proc,		464, 465,	37,	20,	makecol(128,128,128),	0,	0,	0,		0,					0,		NULL,							NULL,				NULL	},
		{ d_edit_proc,		465, 466,	35, 	20,	makecol(255,255,255),	0,	0,	0,		2,					0,		(void *)strALaser,					NULL,				NULL	},  	             					
		{ d_box_proc,		464, 489,	37,	20,	makecol(128,128,128),	0,	0,	0,		0,					0,		NULL,							NULL,				NULL	},
      	{ d_edit_proc,		465, 490,	35, 	20,	makecol(255,255,255),	0,	0,	0,		2,					0,		(void *)strAMiss,					NULL,				NULL	},  	             					
		{ d_box_proc,		464, 513,	37,	20,	makecol(128,128,128),	0,	0,	0,		0,					0,		NULL,							NULL,				NULL	},
      	{ d_edit_proc,		465, 514,	35, 	20,	makecol(255,255,255),	0,	0,	0,		2,					0,		(void *)strABomb,					NULL,				NULL	},  	             						
		{ d_box_proc,		464, 537,	37,	20,	makecol(128,128,128),	0,	0,	0,		0,					0,		NULL,							NULL,				NULL	},
       	{ d_edit_proc,		465, 538,	35, 	20,	makecol(255,255,255),	0,	0,	0,		2,					0,		(void *)strALight,					NULL,				NULL	},  	             					

		{ d_button_proc,	510, 165,	240,	30,	makecol(0,128,255),		0,	0,	D_EXIT,	0,					0,		(void *)"Start Game",				NULL,				NULL	},
		{ d_button_proc,	510,	200,	240,	30,	makecol(255,255,255),	0,	0,	D_EXIT,	0,					0,		(void *)"Cancel",					NULL,				NULL	},
		{ d_button_proc,	510,	270,	240,	30,	makecol(255,255,255),	0,	0,	D_EXIT,	0,					0,		(void *)"Restore Default Settings",	NULL,				NULL	},
        	
       	{ NULL,             0,   0,   0,   0,   0,					0,   0,   0,        0,                      	0,    	NULL,             					NULL,				NULL }
	};
	
	options_dialog[17+conf.CollisionType].flags = D_SELECTED;
	
	int i;
	for (i = 0; i < 6; i++)
	{
		if (conf.AllowPowerup[i])
			options_dialog[24+i].flags = D_SELECTED;
	}
	
	if (conf.ReplenishAmmo)
			options_dialog[37].flags = D_SELECTED;
	
	clear_bitmap(screen);
	blit(bg,screen,0,0,0,0,800,600);

	set_mouse_sprite((BITMAP *)pic[cursor].dat);
	show_mouse(screen);

	DIALOG_PLAYER *options_player = init_dialog(options_dialog, -1);

	bool DoDia = true;
	
	while (DoDia)
  	{
  		if (!update_dialog(options_player));
  		{
  			if (options_player->obj == 54)
  			{
  				conf.Goal = atoi(strGoal);
				conf.P1Shield = atoi(strP1Shield);
				conf.P2Shield = atoi(strP2Shield);

				int i;
				for (i = 17; i <= 19; i++)
				{
					if (options_dialog[i].flags & D_SELECTED)
						conf.CollisionType = i-17;
				}
				
				for (i = 0; i < 6; i++)
				{
					if (options_dialog[24+i].flags & D_SELECTED)
	  					conf.AllowPowerup[i] = true;
					else
						conf.AllowPowerup[i] = false;
				}
	
				conf.RapidAmmoStart = atoi(strARapid);
				conf.LaserAmmoStart = atoi(strALaser);
				conf.MissileAmmoStart = atoi(strAMiss);
				conf.BombAmmoStart = atoi(strABomb);
				conf.LightningAmmoStart = atoi(strALight);
	
      			if (options_dialog[37].flags & D_SELECTED)
					conf.ReplenishAmmo = true;
				else
					conf.ReplenishAmmo = false;
	
				if (!WriteGameConfig(conf))
				{
					alert("Unable to access gconfig.dat.",
						"Your changes could not be saved to disk.",
      					"", "OK", NULL, KEY_ENTER, 0);
				}
	
  				DoDia = false;
  				shutdown_dialog(options_player);
  				return 1;
  			}
  			else if (options_player->obj == 55)
  			{
  				DoDia = false;
  				shutdown_dialog(options_player);
  				return 0;
  			}  			
  			else if (options_player->obj == 56)
  			{
  				SetGameDefaults(conf);
  			
  				sprintf(strGoal,"%d",conf.Goal);
				sprintf(strP1Shield,"%d",conf.P1Shield);
				sprintf(strP2Shield,"%d",conf.P2Shield);
	
				sprintf(strARapid,"%d",conf.RapidAmmoStart);
				sprintf(strALaser,"%d",conf.LaserAmmoStart);
				sprintf(strAMiss,"%d",conf.MissileAmmoStart);
				sprintf(strABomb,"%d",conf.BombAmmoStart);
				sprintf(strALight,"%d",conf.LightningAmmoStart);
	
  				int i;
				for (i = 0; i < 6; i++)
				{
					if (conf.AllowPowerup[i])
						options_dialog[24+i].flags = D_SELECTED;
					else
						options_dialog[24+i].flags = 0;
	
					object_message(&options_dialog[24+i], MSG_DRAW, 0);
				}
	
				if (conf.ReplenishAmmo)
					options_dialog[37].flags = D_SELECTED;
				else
					options_dialog[37].flags = 0;
					
				object_message(&options_dialog[37], MSG_DRAW, 0);
				
				options_dialog[17].flags = 0;
				options_dialog[18].flags = 0;
				options_dialog[19].flags = 0;
				options_dialog[17+conf.CollisionType].flags = D_SELECTED;
				
				object_message(&options_dialog[17], MSG_DRAW, 0);
				object_message(&options_dialog[18], MSG_DRAW, 0);
				object_message(&options_dialog[19], MSG_DRAW, 0);
  			}
  			options_player->obj = -1;
  		}
  		
   		poll_mouse();
     	M_al_poll_duh(dp);
     	
  		if (find_dialog_focus(options_dialog) != 3)
  		{
			if (strcmp(conf.P1Name, "") == 0)
			{
	    			strcpy(conf.P1Name, "Player 1");
	    			object_message(&options_dialog[3], MSG_DRAW, 0);
			}
		}
  		if (find_dialog_focus(options_dialog) != 6)
  		{
			if (strcmp(conf.P2Name, "") == 0)
			{
		    		strcpy(conf.P2Name, "Player 2");
		    		object_message(&options_dialog[6], MSG_DRAW, 0);
 			}
		}
     	
   		if (find_dialog_focus(options_dialog) != 9)
      		validate_input(strGoal, &options_dialog[9], 1, 99);

		if (find_dialog_focus(options_dialog) != 12)
			validate_input(strP1Shield, &options_dialog[15], 1, 20);

		if (find_dialog_focus(options_dialog) != 15)
			validate_input(strP2Shield, &options_dialog[18], 1, 20);
			
		if (find_dialog_focus(options_dialog) != 45)
			validate_input(strARapid, &options_dialog[45], 0, 200);
		if (find_dialog_focus(options_dialog) != 47)
			validate_input(strALaser, &options_dialog[47], 0, 50);
		if (find_dialog_focus(options_dialog) != 49)
			validate_input(strAMiss, &options_dialog[49], 0, 10);
		if (find_dialog_focus(options_dialog) != 51)
			validate_input(strABomb, &options_dialog[51], 0, 10);
		if (find_dialog_focus(options_dialog) != 53)
			validate_input(strALight, &options_dialog[53], 0, 30);
	};
 	
	return 0;
}

void validate_input(char str[], DIALOG *d_object, int min, int max)
{
	sprintf(str,"%d",atoi(str));
   			
   	if (atoi(str) < min)
    		sprintf(str,"%d",min);
    		
   	if (atoi(str) > max)
    		sprintf(str,"%d", max);
    		
   	object_message(d_object, MSG_DRAW, 0);
}

/*int defaults_btn_proc(int msg, DIALOG *d, int c)
{
	int ret;

	ret = d_button_proc(msg, d, c);

	if (ret == D_CLOSE)
	{
		SetGameDefaults(CONFIG);
		return D_O_K;
	}

   	return ret;
}*/

int AudioScreen(ConfigData &conf, DATAFILE *pic, DATAFILE *snd, BITMAP *bg, DUH *mus)
{
	font = (FONT *)pic[twcen_m].dat;

	DIALOG options_dialog[] =
	{
   		/* (dialog proc)    (x)  (y)  (w)  (h)  (fg)					(bg) (key)(flags)   (d1) (d2)  	(dp)              					(dp2) (dp3) */
   		{ d_ctext_proc,	400,	20,	0,	0,	-1,					-1,	0,	0,		0,	0,		(void *)"Audio Options",				(FONT *)pic[twcen].dat,		NULL	},
   		{ d_text_proc,		150,	200,	0,	0,	-1,					-1,	0,	0,		0,	0,		(void *)"Play sound effects",			(FONT *)pic[twcen_m].dat,	NULL	},
		{ d_check_proc,	135,	207,	11,	11,	makecol(255,255,255),	0,	0,	0,		1,	0,		(void *)"",						NULL,					NULL	},
		{ d_text_proc,		170,	224,	0,	0,	-1,					-1,	0,	0,		0,	0,		(void *)"Sound effects volume:",		(FONT *)pic[twcen_m].dat,	NULL	},		
		{ d_slider_proc,	350,	230,	200,	15,	makecol(255,255,255),	0,	0,	0,		255,	conf.SFXVol,		NULL,							sfx_slider,				NULL	},		

   		{ d_text_proc,		150,	300,	0,	0,	-1,					-1,	0,	0,		0,	0,		(void *)"Play music",				(FONT *)pic[twcen_m].dat,	NULL	},
		{ d_check_proc,	135,	307,	11,	11,	makecol(255,255,255),	0,	0,	0,		1,	0,		(void *)"",						NULL,					NULL	},
		{ d_text_proc,		170,	324,	0,	0,	-1,					-1,	0,	0,		0,	0,		(void *)"Music volume:",				(FONT *)pic[twcen_m].dat,	NULL	},		
		{ d_slider_proc,	350,	330,	200,	15,	makecol(255,255,255),	0,	0,	0,		100,	conf.MusicVol,		NULL,							music_slider,				NULL	},		

   		{ d_text_proc,		170,	345,	0,	0,	-1,					-1,	0,	0,		0,	0,		(void *)"Turning off the music will allow more sound effects to be played simultaneously.",				(FONT *)pic[twcen_l].dat,	NULL	},

		{ d_button_proc,	350,	450,	100,	30,	-1,					0,	0,	D_EXIT,	0,	0,		(void *)"OK",						(FONT *)pic[twcen_l].dat,	NULL	},
    		{ NULL,             0,   0,   0,   0,   0,					0,   0,   0,        0, 	0,    	NULL,             					NULL,					NULL }
	};
 
 	DIALOG_PLAYER *options_player;
 
 	if (conf.PlaySFX)
 		options_dialog[2].flags = D_SELECTED;
 		
 	if (conf.PlayMusic)
 		options_dialog[6].flags |= D_SELECTED;

	scare_mouse();
	clear_bitmap(screen);
	blit(bg,screen,0,0,0,0,800,600);

	set_mouse_sprite((BITMAP *)pic[cursor].dat);
	scare_mouse();
	show_mouse(screen);
	
	options_player = init_dialog(options_dialog, -1);

	bool DoDia = true;
	
	bool MusicChecked = conf.PlayMusic;
	
	while (DoDia)
  	{
  		if (!update_dialog(options_player));
  		{
  			if (options_player->obj == 10)
  			{
  				if (!WriteAudioConfig(conf))
				{
					font = (FONT *)pic[fixed].dat;
					alert("Unable to access aconfig.dat.",
						"Your changes could not be saved to disk.",
      					"", "OK", NULL, KEY_ENTER, 0);
				}
  			
  				DoDia = false;
  				shutdown_dialog(options_player);
  			}
  		}
  	
   		poll_mouse();
     	M_al_poll_duh(dp);

		if (options_dialog[2].flags & D_SELECTED)
			conf.PlaySFX = true;
		else
			conf.PlaySFX = false;

		if (options_dialog[6].flags & D_SELECTED)
			conf.PlayMusic = true;
		else
			conf.PlayMusic = false;

		if (MusicChecked != conf.PlayMusic)
		{
			if (conf.PlayMusic == true)
			{
				MusicChecked = true;
				dp = al_start_duh(mus, 1, 0, (float)CONFIG.MusicVol / 100, 4096, 22050);
			}
			else
			{
				MusicChecked = false;
				al_stop_duh(dp);
			}
		}

	}	
}

int music_slider(void *dp3, int d2)
{
    	M_al_poll_duh(dp);
    	al_duh_set_volume(dp, (float)d2 / 100);
    	
    	CONFIG.MusicVol = d2;
    	
    	return 0;
}

int sfx_slider(void *dp3, int d2)
{
    	M_al_poll_duh(dp);
    	
    	CONFIG.SFXVol = d2;
    	
    	return 0;
}

int InstructionsScreen(DATAFILE *pic, BITMAP *bg)
{
	font = (FONT *)pic[twcen_m].dat;

	DIALOG options_dialog[] =
	{
   		/* (dialog proc)    (x)  (y)  (w)  (h)  (fg)					(bg) (key)(flags)   (d1) (d2)  	(dp)              					(dp2) (dp3) */
		{ d_button_proc,	575,	495,	100,	30,	-1,					0,	0,	D_EXIT,	0,	0,		(void *)"OK",						(FONT *)pic[twcen_l].dat,	NULL	},
    		{ NULL,             0,   0,   0,   0,   0,					0,   0,   0,        0, 	0,    	NULL,             					NULL,					NULL }
	};
	
	scare_mouse();
	clear_bitmap(screen);
	blit(bg,screen,0,0,0,0,800,600);

	set_mouse_sprite((BITMAP *)pic[cursor].dat);
	show_mouse(screen);
	
	DIALOG_PLAYER *options_player = init_dialog(options_dialog, -1);
	
	while (update_dialog(options_player))
  	{
		poll_mouse;
		M_al_poll_duh(dp);
	}
	
	return 0;
	
}

int CreditsScreen(DATAFILE *pic, BITMAP *bg)
{
	font = (FONT *)pic[twcen_m].dat;

	DIALOG options_dialog[] =
	{
   		/* (dialog proc)    (x)  (y)  (w)  (h)  (fg)					(bg) (key)(flags)   (d1) (d2)  	(dp)              					(dp2) (dp3) */
		{ d_button_proc,	350,	495,	100,	30,	-1,					0,	0,	D_EXIT,	0,	0,		(void *)"OK",						(FONT *)pic[twcen_l].dat,	NULL	},
    		{ NULL,             0,   0,   0,   0,   0,					0,   0,   0,        0, 	0,    	NULL,             					NULL,					NULL }
	};
	
	clear_bitmap(screen);
	blit(bg,screen,0,0,0,0,800,600);

	textprintf_centre(screen, (FONT *)pic[twcen].dat, 400, 20, -1, "Credits"); 
	
	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 100, -1, "Program and graphics by Matt Sarnoff");
	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 130, -1, "Uses Allegro 4.0.0 by Shawn Hargreaves et al.,");
	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 149, -1, "JPGAlleg 2.6 by Angelo Mottola, and DUMB 0.9.2 by Ben Davis");

	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 180, -1, "Most sound effects are from Lucasarts' \"X-Wing Alliance,\" and are probably copyrighted.");

	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 210, -1, "Title music: \"Dead Lock\" by Elwood");
	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 229, -1, "In-game music: \"Contact\" by Andreas Viklund");
	textprintf_centre(screen, (FONT *)pic[twcen_l].dat, 400, 248, -1, "Find these and more songs at the Ultimate MODs Page: www.tump.net");

	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 300, -1, "Composed using Bloodshed Software's Dev-C++ (VC++ sucks...gcc forever!)");

	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 360, -1, VERSION);
	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 396, -1, "matts226@cox.net");
	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 420, -1, "http://mjs2k.xs3.com");
	textprintf_centre(screen, (FONT *)pic[twcen_m].dat, 400, 455, -1, "peace");


	set_mouse_sprite((BITMAP *)pic[cursor].dat);
	show_mouse(screen);
	
	DIALOG_PLAYER *options_player = init_dialog(options_dialog, -1);
	
	while (update_dialog(options_player))
  	{
		poll_mouse;
		M_al_poll_duh(dp);
	}
	
	return 0;
	
}

int PauseMenu(ConfigData &conf, DATAFILE *pic, DATAFILE *snd, DUH *mus)
{
	while(key[KEY_ESC])
		poll_keyboard();

	clear_keybuf();

	font = (FONT *)pic[twcen_m].dat;

	BITMAP *scrcap = create_bitmap(800, 600);
	clear_bitmap(scrcap);
	
	blit(screen, scrcap, 0, 0, 0, 0, 800, 600);

	DIALOG options_dialog[] =
	{
   		/* (dialog proc)    (x)  (y)  (w)  (h)  (fg)					(bg) (key)(flags)   (d1) (d2)  	(dp)              					(dp2) (dp3) */
		{ d_ctext_proc,	400,	200,	200,	30,	-1,					-1,	0,	D_EXIT,	0,	0,		(void *)"Paused",					(FONT *)pic[twcen].dat,	NULL	},
		{ d_button_proc,	300,	250,	200,	30,	-1,					0,	0,	D_EXIT,	0,	0,		(void *)"Resume Game",				NULL,	NULL	},
		{ d_button_proc,	300,	285,	200,	30,	-1,					0,	0,	D_EXIT,	0,	0,		(void *)"Instructions",				NULL,	NULL	},
		{ d_button_proc,	300,	320,	200,	30,	-1,					0,	0,	D_EXIT,	0,	0,		(void *)"Audio Options",				NULL,	NULL	},
		{ d_button_proc,	300,	355,	200,	30,	-1,					0,	0,	D_EXIT,	0,	0,		(void *)"End Game",					NULL,	NULL	},			
    		{ NULL,             0,   0,   0,   0,   0,					0,   0,   0,        0, 	0,    	NULL,             					NULL,					NULL }
	};
	
	set_mouse_sprite((BITMAP *)pic[cursor].dat);
	show_mouse(screen);
	
	DIALOG_PLAYER *options_player = init_dialog(options_dialog, -1);
	
	bool DoDia = true;
	
	while (DoDia)
  	{
  		if (!update_dialog(options_player));
  		{
  			if (options_player->obj == 1)
  			{
  				DoDia = false;
  				shutdown_dialog(options_player);
  				scare_mouse();
  				return 0;
			}
			else if (options_player->obj == 2)
  			{
				InstructionsScreen(pic, instructions);
				scare_mouse();
				blit(scrcap, screen, 0, 0, 0, 0, 800, 600);
				dialog_message(options_dialog, MSG_DRAW, 0, (int *)options_player->obj);
				scare_mouse();
				show_mouse(screen);
			}
			else if (options_player->obj == 3)
  			{
				AudioScreen(conf, pic, snd, opt_bg, music);
				scare_mouse();
				blit(scrcap, screen, 0, 0, 0, 0, 800, 600);
				dialog_message(options_dialog, MSG_DRAW, 0, (int *)options_player->obj);
				scare_mouse();
				show_mouse(screen);
			}
			else if (options_player->obj == 4)
  			{
  				DoDia = false;
  				shutdown_dialog(options_player);
  				scare_mouse();
  				return -1;
			}
			options_player->obj = -1;
			
			poll_mouse;
			M_al_poll_duh(dp);	
		}
	}
	
	scare_mouse;
 	
	return 0;
}

void M_play_sample(const SAMPLE *spl, int vol, int pan, int freq, int loop)
{
	if (CONFIG.PlaySFX)
		play_sample(spl, vol, pan, freq, loop);
}

void M_al_poll_duh(AL_DUH_PLAYER *dp)
{
	if (CONFIG.PlayMusic)
		al_poll_duh(dp);
}


