// weaponry object model

#define BASIC	0
#define RAPID	1
#define LASER	2

class Bullet
{
    public:
  		void Init(float _x, float _y, float _xs, float _ys, int _ang, int _life, int _type)
  		{
  		    x = _x;
  		    y = _y;
  		    xs = _xs;
  		    ys = _ys;
  		    angle = _ang;
  		    active = true;
  		    dying = false;
  		    life = _life;
  		    
  		    type = _type;
  		    
  		    int i;
  		    for (i = 0; i < 100; i++)
	  		    sprk[i].life = 0;
  		}
  		
		bool IsActive() {return active;}
		
		bool IsGood()
		{
			if (!active || dying)
				return false;
			else
				return true;
		}
		
		void SetActiveState(bool _state) {active = _state;};
		float GetX()  {return x;};
		float GetY()  {return y;};

		int GetA()	{return angle;}

		void Update()
		{
          	if (!dying)
            	{
               	x+=xs;
               	y+=ys;
               	
               	int i;
               	
               	int numsparks, sparklife;
               	
               	switch (type)
               	{
               		case BASIC:	numsparks = 2;
               					sparklife = 16;
	               				break;
     				case RAPID: 	numsparks = 2;
     							sparklife = 16;
	     						break;
					case LASER: 	numsparks = 5;
								sparklife = 32;
								break;
				}
               	
				for (i = 0; i < numsparks; i++)
				{
					if (NextSpark() > -1)
					{
						int spread;
      					float spd;
						
						switch (type)
						{
      					case BASIC:
            					spread = rand()%120-60;
							spd = (rand()%6)*.18;
							break;
						case RAPID:
							spread = rand()%60-30;
							spd = (rand()%6+4)*.18;
							break;
						case LASER:
							spread = rand()%30-15;
							spd = (rand()%6+4)*.18;
							break;
						}
						
      					sprk[NextSpark()].Init(	x+Cos(angle + 180)*10,
										y+Sin(angle + 180)*10,
										Cos(angle + 180 + spread)*spd,
										Sin(angle + 180 + spread)*spd, sparklife);
					}
				}
               	
              		if (x > 800)
                    	x = 0;
               	if (x < 0)
          			x = 799;
				if (y > 600)
					y = 42;
				if (y < 42)
					y = 599;
					
				life--;
          	}
          	
          	if (life <= 0 && active)
          	{
          		dying = true;
          		active = false;
			}
          		
     		int i;
			for (i = 0; i < 100; i++)
			{
				if (sprk[i].life)
				sprk[i].Update();
			}
			
			if (dying && active)
			{
				if (sprk[0].life == 0)
				{
					dying = false;
					active = false;
				}
			}
          }
	
		void Die()
		{
			dying = true;
		}
	
		int SparkLife()	{return sprk[0].life;}
	
		int NextSpark()
		{
		 	int i;
			for (i = 0; i < 100; i++)
			{
				if (!sprk[i].life)
				return i;
			}
			return -1;
		}
	
		void SparkExplosion()
		{
			int i;
			for (i = 0; i < 100; i++)
			{
				float spd = (rand()%100)*.2;
				int ang = rand()%360;
				sprk[i].Init(	x,
							y,
							Cos(ang)*spd,
							Sin(ang)*spd, 32);
				
			}
		}
	
		void Draw(BITMAP *_dest)
		{
	          if (IsGood())
     		{
		    		switch (type)
				{
				case BASIC:
          			circlefill(_dest, (int)x, (int)y, 1, makecol(0,255,0));
          			break;
				case RAPID:
					line(_dest, (int)x, (int)y, (int)(x+(xs/4)), (int)(y+(ys/4)), makecol(255,160,0));
          			break;
				case LASER:
					thickline(_dest, (int)x, (int)y, (int)(x+xs*1.5), (int)(y+ys*1.5), makecol(0,255,186));
          			break;
				}
            	}
            	
             	int i;				
			for (i = 0; i < 100; i++)
			{
				if (sprk[i].life)
				{
					switch (type)
					{
					case BASIC:
						sprk[i].Draw(_dest, 120, 3);
						break;
					case RAPID:
						sprk[i].Draw(_dest, 30, 3);
						break;
					case LASER:
						sprk[i].Draw(_dest, 150, 3);
						break;

					}
				}
			}
		}

		float DistToPoint(float _x, float _y)
		{
			return dist(x, y, _x, _y);
		}
		
		float MidDistToPoint(float _x, float _y)
		{
			return dist(x+(xs/2), y+(ys/2), _x, _y);
		}

	private:
		float x;
		float y;
		float xs;
		float ys;
		bool active;
		bool dying;
		int life;
		int angle;
		int type;
		
		Spark sprk[100];
};

class Missile
{
    public:
  		void Init(float _x, float _y, int _ang)
  		{
  		    x = _x;
  		    y = _y;
 
 			xspeed = 0;
 			yspeed = 0;
 
  		    angle = _ang;
  		    active = true;
  		    dying = false;
  		    life = 300;
  		    
  		    TargetX = 0;
  		    TargetY = 0;
  		    
  		    int i;
  		    for (i = 0; i < 300; i++)
	  		    sprk[i].life = 0;
    
    			Explosion.Init(x, y, 32, 0, 50, 1);
  		}
  		
  		void Target(float _x, float _y, float _spd)
  		{
  			TargetX = _x;
  			TargetY = _y;
  			TargetSpeed = _spd;
  		}
  		
		bool IsActive() {return active;}
		
		bool IsGood()
		{
			if (!active || dying)
				return false;
			else
				return true;
		}
		
		void SetActiveState(bool _state) {active = _state;};
		float GetX()  {return x;};
		float GetY()  {return y;};

		int GetA()	{return angle;}

		void Update(DATAFILE *snd)
		{
          	if (!dying)
            	{		
            	
            		float Dist = dist(x, y, TargetX, TargetY);
            		
            		float spd;
            		
            		spd = 12;
            		
            		float DistCW = dist(x+Cos(angle-19)*spd, y+Sin(angle-19)*spd, TargetX, TargetY);
            		float DistCCW = dist(x+Cos(angle+19)*spd, y+Sin(angle+19)*spd, TargetX, TargetY);
            		
            		if (DistCW < DistCCW)
            			angle -= 19;
               	else
               		angle += 19;
            		
				/*int TargetAngle = FindAngle(x, y, TargetX, TargetY);
				
				if (TargetAngle - angle > 0 && TargetAngle - angle <= 180)
					angle += 1;
				else if (TargetAngle - angle > 0 && TargetAngle - angle > 180)
					angle -= 1;
				else if (TargetAngle - angle < 0 && TargetAngle - angle <= 180)
					angle -= 1;
				else if (TargetAngle - angle < 0 && TargetAngle - angle > 180)
					angle += 1;*/
		
    				/*if ( abs(TargetAngle - angle) < 5 || abs(TargetAngle - angle) > 355)
    				{
    				}
    				else
    				{
					if ( abs(TargetAngle - angle) <= 180)
						angle += 5;
					else
						angle -= 5;
				}*/
				
				//angle = (TargetAngle - angle);
            	
            		angle = To360(angle);
            	
				xspeed = Cos(angle)*spd;
				yspeed = Sin(angle)*spd;
            	
               	x += xspeed;
               	y += yspeed;
               	
               	float sound_speed = ((1036-dist(x, y, TargetX, TargetY))/200)*1000;
               	
               	adjust_sample((SAMPLE *)snd[missiletrack].dat, 255, 128, (int)(sound_speed), 1);
               	
               	int i;
               	
				for (i = 0; i < 5; i++)
				{
					if (NextSpark() > -1)
					{
						int spread;
      					float spd;
						
         					spread = rand()%160-80;
						spd = (rand()%8)*.25;
					
      					sprk[NextSpark()].Init(	x+Cos(angle + 180)*10,
										y+Sin(angle + 180)*10,
										Cos(angle + 180 + spread)*spd,
										Sin(angle + 180 + spread)*spd, 32);
					}
				}
               	
              		if (x > 800)
                    	x = 0;
               	if (x < 0)
          			x = 799;
				if (y > 600)
					y = 42;
				if (y < 42)
					y = 599;
					
				life--;
          	
          		if (life <= 0 && active)
          		{
					M_play_sample((SAMPLE *)snd[explosion1+rand()%7].dat, CONFIG.SFXVol, 128, 1000, 0);
					stop_sample((SAMPLE *)snd[missiletrack].dat);
		         		Explode();
          			Die();
				}
			}
          		
     		int i;
			for (i = 0; i < 300; i++)
			{
				if (sprk[i].life)
				sprk[i].Update();
			}
			
			if (dying && active)
			{
				Explosion.Update();
				
				if (!Explosion.IsExploding())
				{
					dying = false;
					active = false;
				}
			}
          }
	
		void Die()
		{
			dying = true;
		}
	
		int SparkLife()	{return sprk[0].life;}
	
		int NextSpark()
		{
		 	int i;
			for (i = 0; i < 300; i++)
			{
				if (!sprk[i].life)
				return i;
			}
			return -1;
		}
	
		void Explode()
		{
       		Explosion.Init(x, y, 32, 0, 50, 1);
       		Explosion.Activate();
		}
	
		void Draw(BITMAP *_dest)
		{
	          if (IsGood())
     		{
          		thickline(_dest, (int)x, (int)y, (int)(x+Cos(angle)*9), (int)(y+Sin(angle)*9), makecol(255,255,255));
          		//line(_dest, (int)x, (int)y, (int)x+Cos(angle)*10, (int)y+Sin(angle)*10, makecol(255,255,255));
          		line(_dest, (int)x, (int)y, (int)(x+Cos(angle+130)*5), (int)(y+Sin(angle+130)*5), makecol(255,255,255)); 
	         		line(_dest, (int)x, (int)y, (int)(x+Cos(angle-130)*5), (int)(y+Sin(angle-130)*5), makecol(255,255,255)); 
          		
            		//textprintf(_dest, font, 0, 50, makecol(255,255,255), "%f", 1036-dist(x, y, TargetX, TargetY));
            	}
            	
             	int i;				
			for (i = 0; i < 300; i++)
			{
				if (sprk[i].life)
					sprk[i].Draw(_dest, 0, 50);
			}
			
			if (Explosion.IsExploding())
				Explosion.Draw(_dest);
				
		}
		
		float DistToPoint(float _x, float _y)
		{
			return dist(x, y, _x, _y);
		}

	private:
		float x;
		float y;
		float xspeed;
		float yspeed;
		
		float TargetX;
		float TargetY;
		float TargetSpeed;
		
		bool active;
		bool dying;
		int life;
		int angle;
		
		Spark sprk[300];
		StdExplosion Explosion;
};

class Bomb
{
    public:
  		void Init(float _x, float _y, int _xs, int _ys, int _ang)
  		{
  		    x = _x;
  		    y = _y;
        		xs = _xs;
 			ys = _ys;
 
  		    angle = _ang;
  		    active = true;
  		    dying = false;
  		    life = 40;
  		    
  
  		    int i;
  		    for (i = 0; i < 300; i++)
	  		    sprk[i].life = 0;
    
    			Explosion.Init(x, y, 32, 0, 50, 1);
    			Shockwave.Init(x, y, 50, 0, 50, 1);
  		}
  		
		bool IsActive() {return active;}
		
		bool IsGood()
		{
			if (!active || dying)
				return false;
			else
				return true;
		}
		
		void SetActiveState(bool _state) {active = _state;};
		float GetX()  {return x;};
		float GetY()  {return y;};

		int GetA()	{return angle;}

		void Update(DATAFILE *snd)
		{
          	if (!dying)
            	{		            	
               	x += xs;
               	y += ys;
               	
               	int i;
               	
				for (i = 0; i < 10; i++)
				{
					if (NextSpark() > -1)
					{
						int spread;
      					float spd;
						
         					spread = rand()%180-90;
						spd = (rand()%8)*.25;
					
      					sprk[NextSpark()].Init(	x+Cos(angle + 180)*10,
										y+Sin(angle + 180)*10,
										Cos(angle + 180 + spread)*spd,
										Sin(angle + 180 + spread)*spd, 32);
					}
				}
               	
              		if (x > 800)
                    	x = 0;
               	if (x < 0)
          			x = 799;
				if (y > 600)
					y = 42;
				if (y < 42)
					y = 599;
					
				life--;
          	
          		if (life <= 0 && active)
          		{
          			M_play_sample((SAMPLE *)snd[bombexplode].dat, CONFIG.SFXVol, 128, 1000, 0);
		         		Explode();
          			Die();
				}
			}
          		
     		int i;
			for (i = 0; i < 300; i++)
			{
				if (sprk[i].life)
				sprk[i].Update();
			}
			
			if (dying && active)
			{
				Explosion.Update();
				Shockwave.Update();
				
				if (!Shockwave.IsExploding())
				{
					dying = false;
					active = false;
				}
			}
          }
	
		bool IsExploding() {return Shockwave.IsExploding();}
		
		void Die()
		{
			dying = true;
		}
	
		float GetRad() {return Shockwave.Radius();}
		int GetLife()	{return Shockwave.GetLife();}
	
		int SparkLife()	{return sprk[0].life;}
	
		int NextSpark()
		{
		 	int i;
			for (i = 0; i < 300; i++)
			{
				if (!sprk[i].life)
				return i;
			}
			return -1;
		}
	
		void Explode()
		{
       		Explosion.Init(x, y, 64, 0, 50, 1);
       		Explosion.Activate();

       		Shockwave.Init(x, y, 48, 60, 1, 1);
       		Shockwave.Activate();
		}
	
		void Draw(BITMAP *_dest)
		{
	          if (IsGood())
     		{
 				circlefill(_dest, (int)x, (int)y, 2, makecol(255,0,0));
            	}
            	
             	int i;				
			for (i = 0; i < 300; i++)
			{
				if (sprk[i].life)
					sprk[i].Draw(_dest, 0, 50);
			}
			
			if (Explosion.IsExploding())
				Explosion.Draw(_dest);

			if (Shockwave.IsExploding())
				Shockwave.Draw(_dest);
				
		}
		
		float DistToPoint(float _x, float _y)
		{
			return dist(x, y, _x, _y);
		}

	private:
		float x;
		float y;
		float xs;
		float ys;

		bool active;
		bool dying;
		int life;
		int angle;
		
		Spark sprk[300];
		StdExplosion Explosion;
		RingExplosion Shockwave;
};


class Weapon
{
    public:
    
	   Weapon()
	   {
	   }
    
        Weapon(int _ammo) : ammo(_ammo)
        {
            ammo = _ammo;
        }
        
        virtual void Init() {}
        virtual void Init(int) {}
        
        int GetAmmo()          {return ammo;};
        void ChangeAmmo(int _byhowmuch) {ammo += _byhowmuch;};
        void SetAmmo(int _amount) {ammo = _amount;};
        
        virtual void Update() {}
        virtual void Update(float, float, int, int) {}
        virtual void Update(DATAFILE *) {}         
        virtual void Draw(BITMAP *_dest) {}
        virtual void Fire(int, int) {}
        virtual int NextBullet() {}
        virtual bool IsActive() {}
        
        	virtual void Fire(float, float, float, float, int) {}
        	virtual float DistToBullet(int, float, float) {}
   		virtual float DistToMidBullet(int, float, float) {}
        	virtual int GetBulletA(int _num) {}
		virtual void BulletSparkExplosion(int) {}
		virtual void KillBullet(int) {}
		virtual bool BulletIsGood(int) {}
		
		virtual void Explode() {}
		virtual void Deactivate() {}	
  
		virtual bool IsGood() {}
		virtual void Fire(float, float, int) {}
		virtual void SetTarget(float, float, float) {}
		
		virtual bool LockedOn() {}
		virtual int TargetAng() {}
		virtual bool DamageTarget() {}
		
		virtual void Target(float, float) {}
		
		virtual bool IsExploding() {}
		virtual float X() {}
		virtual float Y() {}
  		virtual float Radius() {}
  		virtual int Life() {}
  		
        // for charged weapons
        virtual float GetStrength() {}
        virtual void Charge(int) {}
        virtual void SetStrength(int) {}
        virtual void Activate(DATAFILE *snd) {}

		int rofcount;
		int rof;
		
		
	protected:
		Bullet bull;
		int ammo;

};


class BasicGun : public Weapon
{
	public:
		
		BasicGun()
		{
		}
	
     	BasicGun(int _ammo) : Weapon(_ammo)
        	{
        		int i;
         		for (i = 0; i < 5; i++)
  	     	{
  				bull[i].SetActiveState(false);
        		}
             	ammo = _ammo;
             	rof = 0;
             	rofcount = 0;
        	}

     	void Init(int _ammo)
        	{
        		int i;
         		for (i = 0; i < 5; i++)
  	     	{
  				bull[i].SetActiveState(false);
        		}
             	ammo = _ammo;
            	rof = 0;
             	rofcount = 0;
        	}
   
     	void Fire(float _xstart, float _ystart, float _xs, float _ys, int _ang)
		{
			if (NextBullet() > -1)
				bull[NextBullet()].Init(_xstart, _ystart, _xs, _ys, _ang, 30, BASIC);
		}

	     void Draw(BITMAP *_dest)
	     {
 			int i;
			for (i = 0; i < 5; i++)
			{
				if (bull[i].IsActive())
					bull[i].Draw(_dest);
			}
		}
     
     	int NextBullet()
		{
			int i;
			for (i = 0; i < 5; i++)
			{
				if (!bull[i].IsActive())
				return i;
			}
			return -1;
		}

		float DistToBullet(int _num, float _x, float _y) {return bull[_num].DistToPoint(_x, _y);}
		int GetBulletA(int _num) {return bull[_num].GetA();}
		void BulletSparkExplosion(int _num)	{bull[_num].SparkExplosion();}
		void KillBullet(int _num)	{bull[_num].Die();}
		bool BulletIsGood(int _num)	{return bull[_num].IsGood();}

		void Update()
        	{
    			int i;
	    		for (i = 0; i < 5; i++)
        			bull[i].Update();
		}
		

    private:
        Bullet bull[5];
        int ammo;
};

class RapidGun : public Weapon
{
	public:
		
		RapidGun()
		{
		}
	
     	RapidGun(int _ammo) : Weapon(_ammo)
        	{
        		int i;
         		for (i = 0; i < 50; i++)
  	     	{
  				bull[i].SetActiveState(false);
        		}
             	ammo = _ammo;
             	rof = 3;
             	rofcount = 0;
        	}

     	void Init(int _ammo)
        	{
        		int i;
         		for (i = 0; i < 50; i++)
  	     	{
  				bull[i].SetActiveState(false);
        		}
             	ammo = _ammo;
            	rof = 3;
             	rofcount = 0;
        	}
   
     	void Fire(float _xstart, float _ystart, float _xs, float _ys, int _ang)
		{
			if (NextBullet() > -1)
				bull[NextBullet()].Init(_xstart, _ystart, _xs, _ys, _ang, 25, RAPID);
		}

	     void Draw(BITMAP *_dest)
	     {
 			int i;
			for (i = 0; i < 50; i++)
			{
				if (bull[i].IsActive())
					bull[i].Draw(_dest);
			}
		}
     
     	int NextBullet()
		{
			int i;
			for (i = 0; i < 50; i++)
			{
				if (!bull[i].IsActive())
				return i;
			}
			return -1;
		}

		float DistToBullet(int _num, float _x, float _y) {return bull[_num].DistToPoint(_x, _y);}
		int GetBulletA(int _num) {return bull[_num].GetA();}
		void BulletSparkExplosion(int _num)	{bull[_num].SparkExplosion();}
		void KillBullet(int _num)	{bull[_num].Die();}
		bool BulletIsGood(int _num)	{return bull[_num].IsGood();}

		void Update()
        	{
    			int i;
	    		for (i = 0; i < 50; i++)
        			bull[i].Update();
		}

		Bullet bull[50];

    private:
        
        int ammo;
};

class LaserGun : public Weapon
{
	public:
		
		LaserGun()
		{
		}
	
     	LaserGun(int _ammo) : Weapon(_ammo)
        	{
        		int i;
        		for (i = 0; i < 3; i++)
			{
  				bull[i].SetActiveState(false);
			}
             	ammo = _ammo;
             	rof = 0;
             	rofcount = 0;
        	}

     	void Init(int _ammo)
        	{
        		int i;
        		for (i = 0; i < 3; i++)
			{
  				bull[i].SetActiveState(false);
			}
             	ammo = _ammo;
            	rof = 0;
             	rofcount = 0;
        	}
   
     	void Fire(float _xstart, float _ystart, float _xs, float _ys, int _ang)
		{
			if (NextBullet() > -1)
			{
				bull[NextBullet()].Init(_xstart, _ystart, _xs, _ys, _ang, 25, LASER);
				ChangeAmmo(-1);
			}
		}

     	int NextBullet()
		{
			int i;
			for (i = 0; i < 3; i++)
			{
				if (!bull[i].IsActive())
				return i;
			}
			return -1;
		}

	     void Draw(BITMAP *_dest)
	     {
 			int i;
			for (i = 0; i < 3; i++)
			{
				if (bull[i].IsActive())
					bull[i].Draw(_dest);
			}
		}

		float DistToBullet(int _num, float _x, float _y) {return bull[_num].DistToPoint(_x, _y);}
		float DistToMidBullet(int _num, float _x, float _y) {return bull[_num].MidDistToPoint(_x, _y);}
		int GetBulletA(int _num) {return bull[_num].GetA();}
		void BulletSparkExplosion(int _num)	{bull[_num].SparkExplosion();}
		void KillBullet(int _num)	{bull[_num].Die();}
		bool BulletIsGood(int _num)	{bull[_num].IsGood();}

		void Update()
        	{
    			int i;
	    		for (i = 0; i < 3; i++)
        			bull[i].Update();
		}

    private:
        Bullet bull[3];
        int ammo;
};

class MissileGun : public Weapon
{
	public:
		
		MissileGun()
		{
		}
	
     	MissileGun(int _ammo) : Weapon(_ammo)
        	{
        		int i;
        		miss.SetActiveState(false);
             	ammo = _ammo;
             	rof = 0;
             	rofcount = 0;
        	}

     	void Init(int _ammo)
        	{
        		int i;
        		miss.SetActiveState(false);
             	ammo = _ammo;
            	rof = 0;
             	rofcount = 0;
        	}
   
     	void Fire(float _xstart, float _ystart, int _ang)
		{
			if (!miss.IsActive())
			{
				miss.Init(_xstart, _ystart, _ang);
				ChangeAmmo(-1);
			}
		}
		
		bool IsGood()
		{
			return miss.IsGood();
		}
		
		bool IsActive()
		{
			return miss.IsActive();
		}
		
		void SetTarget(float _x, float _y, float _spd)
		{
			miss.Target(_x, _y, _spd);
		}

     	/*int NextBullet()
		{
			int i;
			for (i = 0; i < 3; i++)
			{
				if (!bull[i].IsActive())
				return i;
			}
			return -1;
		}*/

	     void Draw(BITMAP *_dest)
	     {
 			int i;
			if (miss.IsActive())
				miss.Draw(_dest);
				//rect(_dest, 0, 0, 400, 400, 255);
		}

		float DistToBullet(int _num, float _x, float _y) {return miss.DistToPoint(_x, _y);}
		//float DistToMidBullet(int _num, float _x, float _y) {return miss.MidDistToPoint(_x, _y);}
		int GetBulletA(int _num) {return miss.GetA();}
		void Explode()	{miss.Explode();}
		void KillBullet(int _num)	{miss.Die();}
		bool BulletIsGood(int _num)	{miss.IsGood();}

		void Update(DATAFILE *snd)
        	{
    			int i;
    			miss.Update(snd);
		}
		
		void Deactivate()
		{
			miss.SetActiveState(false);
		}


		
    private:
        Missile miss;
        int ammo;
};

class BombGun : public Weapon
{
	public:
		
		BombGun()
		{
		}
	
     	BombGun(int _ammo) : Weapon(_ammo)
        	{
        		int i;
        		bomb.SetActiveState(false);
             	ammo = _ammo;
             	rof = 0;
             	rofcount = 0;
        	}

     	void Init(int _ammo)
        	{
        		int i;
        		bomb.SetActiveState(false);
             	ammo = _ammo;
            	rof = 0;
             	rofcount = 0;
        	}
   
     	void Fire(float _xstart, float _ystart, float _xs, float _ys, int _ang)
		{
			if (!bomb.IsActive())
			{
				bomb.Init(_xstart, _ystart, _xs, _ys, _ang);
				ChangeAmmo(-1);
			}
		}
		
		bool IsGood()
		{
			return bomb.IsGood();
		}
		
	     void Draw(BITMAP *_dest)
	     {
 			int i;
			if (bomb.IsActive())
				bomb.Draw(_dest);
				//rect(_dest, 0, 0, 400, 400, 255);
		}

		float DistToBullet(int _num, float _x, float _y) {return bomb.DistToPoint(_x, _y);}
		//float DistToMidBullet(int _num, float _x, float _y) {return miss.MidDistToPoint(_x, _y);}
		int GetBulletA(int _num) {return bomb.GetA();}
		void Explode()	{bomb.Explode();}
		void KillBullet(int _num)	{bomb.Die();}
		bool BulletIsGood(int _num)	{bomb.IsGood();}

		void Update(DATAFILE *snd)
        	{
    			int i;
    			bomb.Update(snd);
		}
		
		void Deactivate()
		{
			bomb.SetActiveState(false);
		}
		
		float X()	{return bomb.GetX();}
		float Y() {return bomb.GetY();}
		
		float Radius() {return bomb.GetRad();}
		
		int Life()	{return bomb.GetLife();}
		
		bool IsExploding() {return bomb.IsExploding();}
		
    private:
        Bomb bomb;
        int ammo;
};

class LightningGun : public Weapon
{
	public:
		LightningGun(int _ammo) : Weapon(_ammo)
		{
            active = false;
            strength = 0;
            int i;
            
            for (i = 0; i < 3; i++)
            {
                bolt[i].Init(32);
            }
            
            TargetX = 0;
            TargetY = 0;
            
            ammo = _ammo;
            
 	        	rof = 3;
            	rofcount = 0;
		}
		
		
		void SetStrength(int _strength)           {strength = _strength;}
		void Charge(int _byhowmuch)               {strength += _byhowmuch;}
		float GetStrength()                         {return strength;}
		bool IsActive()                           {return active;}

		int NextSpark()
		{
		 	int i;
			for (i = 0; i < 500; i++)
			{
				if (!sprk[i].life)
				return i;
			}
			return -1;
		}
		
		int NextExplosion()
		{
		 	int i;
			for (i = 0; i < 20; i++)
			{
				if (!Explosion[i].IsExploding())
				return i;
			}
			return -1;
		}
		
		
		bool LockedOn()
		{
			int TargetAngle = To360(-FindAngle(x, y, TargetX, TargetY)+180);
			
			if (TargetAngle > 330 && angle < 30)
			{
				if (TargetAngle < angle+360+30 && TargetAngle > angle+360-30)
					return true;
				else
    					return false;
			}
			else if (TargetAngle < 30 && angle > 330)
			{
				if (TargetAngle < angle-360+30 && TargetAngle > angle-360-30)
					return true;
				else
    					return false;
			}
			else
			{
				if (TargetAngle < angle+30 && TargetAngle > angle-30)
					return true;
				else
					return false;
			}
		}
		
		int TargetAng()
		{
			return To360(-FindAngle(x, y, TargetX, TargetY)+180);
		}
	
		void Activate(DATAFILE *snd)
  		{
  			if (LockedOn())
  			{
  				active = true;
  				M_play_sample((SAMPLE *)snd[firelightning].dat, CONFIG.SFXVol, 128, 1000, 0);
			}
			else
			{
    				int i;
				for (i = 0; i < 20; i++)
				{
					if (NextSpark() > -1)
					{
						float spd = (rand()%100)*.2;
						int spread = rand()%20-10;
						sprk[NextSpark()].Init(	x,
									y,
									Cos(angle+spread)*spd,
									Sin(angle+spread)*spd, 32);
					}
				}
				SetStrength(0);
  			}
		}
       	
		void Deactivate()                         {active = false;}

		void Draw(BITMAP *_dest)
		{
			if (IsActive())
			{
				int color;
				int i;
				for (i = 0; i < 3; i++)
				{
					bolt[i].Redim((rand() % 32) + 8);
					bolt[i].Draw(_dest, x, y, TargetX, TargetY, makecol(rand()%255,255,255), (float)(strength)/10);
				}
			}
			
			int i;
			for (i = 0; i < 500; i++)
			{
				if (sprk[i].life)
					sprk[i].Draw(_dest, 180, 3);
			}

			for (i = 0; i < 20; i++)
			{
				if (Explosion[i].IsExploding())
					Explosion[i].Draw(_dest);
			}

		}

		void Update(float _x, float _y, int _angle, int _sh)
		{
			x = _x;
			y = _y;
			angle = _angle;
	
			if (active && !LockedOn())
			{
    				int i;
				for (i = 0; i < 20; i++)
				{
					if (NextSpark() > -1)
					{
						float spd = (rand()%100)*.2;
						int spread = rand()%20-10;
						sprk[NextSpark()].Init(	x,
									y,
									Cos(angle+spread)*spd,
									Sin(angle+spread)*spd, 32);
					}
				}
				SetStrength(0);
				active = false;
  			}
	
			if (active)
			{				
				if (ceil(strength) == strength && _sh > 0)
				{
					ChangeAmmo(-1);
			
					if (NextExplosion() > -1)
					{							
         		    			Explosion[NextExplosion()].Init(TargetX+(rand()%40-20), TargetY+(rand()%40-20), 32, 180, 50, 0);
			   			Explosion[NextExplosion()].Activate();
 					}
				}
		
				strength-=.5;
		
				if (strength <= 0 || ammo <= 0)
				{
					Deactivate();
					strength = 0;
				}
			}
			
			int i;
			for (i = 0; i < 500; i++)
			{
				if (sprk[i].life)
				sprk[i].Update();
			}
			
			for (i = 0; i < 20; i++)
			{
				if (Explosion[i].IsExploding())
					Explosion[i].Update();
			}
		}

		void Target(float _x, float _y)
		{
			TargetX = _x;
			TargetY = _y;
		}
		
		bool DamageTarget()
		{
			if (IsActive() && ceil(strength) != strength)
				return true;
			else
				return false;
		}

		//int CollisionDetect(int _numobjects, ObjectClass _obj[], SAMPLE *_explsound);
	private:
		float x;
		float y;
		int angle;
		float TargetX;
		float TargetY;
		bool active;
		bool dying;
		float strength;
		ZigzagLine bolt[3];
		Spark sprk[500];
		StdExplosion Explosion[20];
};

