// ship class

#define MAX_WEAPON	5

class Ship
{
	public:
	
		Ship()
		{
		}
		/*Ship(float _x, float _y, int _angle, int _col)
     	{
     		x = _x;
     		y = _y;
     		angle = _angle;
     		color = _col;
     		speed = 0;
     		xspeed = 0;
     		yspeed = 0;
	     }*/
	     
      	Weapon* Wepn[6];
	     	
	     void Init(float _x, float _y, int _angle, int _col)
     	{
     		x = _x;
     		y = _y;
     		angle = _angle;
     		color = _col;
     		speed = 0;
     		xspeed = 0;
     		yspeed = 0;
     		
     		if (color == BLUE)
     			shield = CONFIG.P1Shield;
     		if (color == RED)
     			shield = CONFIG.P2Shield;
     		
  			score = 0;
     		spin = 0;
     		Explosion.Init(x, y, 48);
     		currweapon = 0;
     		Alive = true;
     		Dying = false;
     		
			Wepn[0] = new BasicGun(-1);		
			Wepn[1] = new RapidGun(CONFIG.RapidAmmoStart);
			Wepn[2] = new LaserGun(CONFIG.LaserAmmoStart);
			Wepn[3] = new MissileGun(CONFIG.MissileAmmoStart);
			Wepn[4] = new BombGun(CONFIG.BombAmmoStart);
			Wepn[5] = new LightningGun(CONFIG.LightningAmmoStart);
	     }
	     
	     void Reset(float _x, float _y, int _angle)
	     {
	     	x = _x;
	     	y = _y;
	     	angle = _angle;
	     	speed = 0;
	     	xspeed = 0;
	     	yspeed = 0;
	     	spin = 0;

	     	if (shield <= 0)
	     	{
     			if (color == BLUE)
     				shield = CONFIG.P1Shield;
     			if (color == RED)
	     			shield = CONFIG.P2Shield;
			}
  	
  			if (Wepn[3]->IsGood())
  				Wepn[3]->Deactivate();
	
  			if (Wepn[4]->IsGood())
  				Wepn[4]->Deactivate();
  				
  	
	     	Alive = true;
	     	Dying = false;
	     }
  
  		float X()		{return x;}
		float Y()		{return y;}
		int A()		{return angle;}
		int TA()		{return thrustangle;}
		
		void ChAngle(int inc)
  		{
    			angle += inc;
    			
    			if (spin)
    				spin -= .5;
    		}
		
		int GetShield()	{return shield;}
		void ChShield(int inc)	{shield += inc;}
		
		void ChShield(int &shld, int inc)	{shld += inc;}
		
		int GetScore()			{return score;}
		void ChScore(int inc)	{score += inc;}
		
		bool IsAlive()			{return Alive;}
		
		bool IsGood()
		{
			if (!Alive || Dying)
				return false;
			else
				return true;
		}
		
		float GetSpeed()
  		{
  			// need to avoid those pesky divide by zero errors...
    			if (thrustangle == 270 || thrustangle == 90)
	       		return fabs(yspeed/Sin(thrustangle));
   			else if (thrustangle == 0 || thrustangle == 180)
   				return fabs(xspeed/Cos(thrustangle));
			else
				return fabs(xspeed/Cos(thrustangle));
    		}
		
		void Draw(BITMAP *_bmp, DATAFILE *pic)
		{
			int color1, color2, spstart, spend;
			
			if (!Dying)
			{
        			if (color == BLUE)
          		{
          	 		color1 = makecol(43,113,219);
          	 		color2 = makecol(149,190,231);
          	    		spstart = 180;
          	    		spend = 50;
          	    	}
              		else if (color == RED)
              		{
              			color1 = makecol(170,44,44);
              			color2 = makecol(229,151,151);
              			spstart = 0;
              			spend = 50;
              		}
				/*triangle(_bmp,		(int)((x+Cos(angle+140)*15)),
								(int)((y+Sin(angle+140)*15)),
								(int)((x+Cos(angle+120)*2)),
								(int)((y+Sin(angle+120)*2)),
								(int)((x+Cos(angle+160)*8)),
								(int)((y+Sin(angle+160)*8)),color1);
			
				triangle(_bmp,		(int)((x+Cos(angle-140)*15)),
								(int)((y+Sin(angle-140)*15)),
								(int)((x+Cos(angle-120)*2)),
								(int)((y+Sin(angle-120)*2)),
								(int)((x+Cos(angle-160)*8)),
								(int)((y+Sin(angle-160)*8)),color1);
								
				triangle(_bmp,		(int)((x+Cos(angle)*10)),
								(int)((y+Sin(angle)*10)),
								(int)((x+Cos(angle+160)*8)),
								(int)((y+Sin(angle+160)*8)),
								(int)((x+Cos(angle-160)*8)),
								(int)((y+Sin(angle-160)*8)),color2);*/

				float newang = (float)angle * .711111111111;
			
				//textprintf(_bmp, font, 0, 50*(color+1), -1, "%f", newang);
			
				if (color == BLUE)
					rotate_sprite(_bmp, (BITMAP *)pic[shipblue].dat, (int)(x-12), (int)(y-12), ftofix(newang));
				if (color == RED)
					rotate_sprite(_bmp, (BITMAP *)pic[shipred].dat, (int)(x-12), (int)(y-12), ftofix(newang));

				if (currweapon == 5)
				{
					line(_bmp, (int)((x+Cos(angle+30)*10)),
						(int)((y+Sin(angle+30)*10)),
						(int)((x+Cos(angle+30)*20)),
						(int)((y+Sin(angle+30)*20)), makecol(255,255,255));

					line(_bmp, (int)((x+Cos(angle-30)*10)),
						(int)((y+Sin(angle-30)*10)),
						(int)((x+Cos(angle-30)*20)),
						(int)((y+Sin(angle-30)*20)), makecol(255,255,255));
						
					if (Wepn[5]->LockedOn() && Wepn[5]->GetAmmo() > 0)
					{
						thickline(_bmp, (int)((x+Cos(angle+30)*10)),
							(int)((y+Sin(angle+30)*10)),
							(int)((x+Cos(angle+30)*20)),
							(int)((y+Sin(angle+30)*20)), makecol(255,0,0));

						thickline(_bmp, (int)((x+Cos(angle-30)*10)),
							(int)((y+Sin(angle-30)*10)),
							(int)((x+Cos(angle-30)*20)),
							(int)((y+Sin(angle-30)*20)), makecol(255,0,0));
					}
	
					if (angle > 30 && angle < 150)
					{
     					draw_sprite(_bmp, (BITMAP *)pic[power].dat, (int)x-21, (int)y-23);
						if (Wepn[5]->GetStrength() > 0)
							rectfill(_bmp, (int)x+1, (int)y-21, (int)(x+Wepn[5]->GetStrength()), (int)y-17, makecol(0,255,255));
					}
					else
					{
     					draw_sprite(_bmp, (BITMAP *)pic[power].dat, (int)x-21, (int)y+20);
     					if (Wepn[5]->GetStrength() > 0)
							rectfill(_bmp, (int)x+1, (int)y+22, (int)(x+Wepn[5]->GetStrength()), (int)y+26, makecol(0,255,255));
					}
				}
			}
			
			int i;				
			for (i = 0; i < 500; i++)
			{
				if (sprk[i].life)
					sprk[i].Draw(_bmp, spstart, spend);
			}
  	 		
			if (Explosion.IsExploding())
				Explosion.Draw(_bmp);
		}
		
		void Thrust()
		{
			if (!Dying)
			{
				thrustangle = angle;
		
				if (GetSpeed() <= 16)
				{
					xspeed += Cos(angle)*THRUST_INT;
					yspeed += Sin(angle)*THRUST_INT;
				}
			
				// pop some sparks out the tailpipe
				int i;
				for (i = 0; i < 5; i++)
				{
					if (NextSpark() > -1)
					{
						int spread = rand()%120-60;
						float spd = (rand()%8+1)*.25;
						sprk[NextSpark()].Init(	x+Cos(angle + 180)*10,
										y+Sin(angle + 180)*10,
										Cos(angle + 180 + spread)*spd,
										Sin(angle + 180 + spread)*spd, 64);
					}
				}
			}
		}
		
		void Update(DATAFILE *snd)
		{
			if (!Dying)
			{
				angle = To360(angle);
			
				angle += (int)(spin);

				if (x > 800)
					x = 0;
				if (x < 0)
					x = 799;
				if (y > 600)
					y = 42;
				if (y < 42)
					y = 599;
	
				x += xspeed;
				y += yspeed;
			
				xspeed *= .99;
				yspeed *= .99;
			
				if (spin > 0)
					spin -= .1;
				
				if (spin < 0)
					spin = 0;
					
				if (shield <= 0)
				{
					Explosion.Init(x, y, 48);
					Explosion.Activate();
					M_play_sample((SAMPLE *)snd[shipexplosion].dat, CONFIG.SFXVol, 128, 800, 0);
					Dying = true;
					
					if (CONFIG.ReplenishAmmo)
					{
						Wepn[1]->SetAmmo(CONFIG.RapidAmmoStart);
			  			Wepn[2]->SetAmmo(CONFIG.LaserAmmoStart);
			  			Wepn[3]->SetAmmo(CONFIG.MissileAmmoStart);
		  				Wepn[4]->SetAmmo(CONFIG.BombAmmoStart);
		  				Wepn[5]->SetAmmo(CONFIG.LightningAmmoStart);
					}
					else
					{
			  			Wepn[1]->SetAmmo(0);
			  			Wepn[2]->SetAmmo(0);
			  			Wepn[3]->SetAmmo(0);
		  				Wepn[4]->SetAmmo(0);
		  				Wepn[5]->SetAmmo(0);
					}
		  			currweapon = 0;
				}
			}
			
			int i;
			for (i = 0; i < 500; i++)
			{
				if (sprk[i].life)
				sprk[i].Update();
			}
			
			if (Explosion.IsExploding())
				Explosion.Update();

			if (Dying && !Explosion.IsExploding())
				Alive = false;
		}
		
		void Rebound()
		{
			thrustangle += 180;
			thrustangle = To360(thrustangle);
			
			xspeed = -xspeed;
			yspeed = -yspeed;
		}
		
		void Bounce(int ang, int speed)
		{
			ang = To360(ang + 180);
		
			thrustangle = ang;
			
			xspeed = Cos(ang)*(speed/2);
			yspeed = Sin(ang)*(speed/2);
		}
		
		void StartSpin(float amount)
		{
			spin = amount;
		}
		
		int NextSpark()
		{
		 	int i;
			for (i = 0; i < 500; i++)
			{
				if (!sprk[i].life)
				return i;
			}
			return -1;
		}
		
		void FireWeapon(DATAFILE *snd)
		{
			if (Wepn[currweapon]->GetAmmo() != 0)
			{
				switch (currweapon)
				{
   					case 0:
   						if (Wepn[0]->NextBullet() > -1)
						{
      						Wepn[0]->Fire(	x+Cos(angle)*10,
							y+Sin(angle)*10,
							Cos(angle)*20,
							Sin(angle)*20, angle);
							M_play_sample((SAMPLE *)snd[firebasic].dat, CONFIG.SFXVol, 128, 1000, 0);
						}
						break;
	   				case 1:
						if (Wepn[1]->rofcount == 0)
						{
      						Wepn[1]->Fire(x+Cos(angle)*10,
							y+Sin(angle)*10,
							Cos(angle)*25,
							Sin(angle)*25, angle);
							Wepn[1]->ChangeAmmo(-1);
							M_play_sample((SAMPLE *)snd[firerapid].dat, CONFIG.SFXVol, 128, 1000, 0);
						}
						break;
					case 2:
						if (Wepn[2]->NextBullet() > -1)
						{
      						Wepn[2]->Fire(	x+Cos(angle)*10,
							y+Sin(angle)*10,
							Cos(angle)*30,
							Sin(angle)*30, angle);
		
							xspeed += Cos(angle+180)*1.5;
							yspeed += Sin(angle+180)*1.5;
							M_play_sample((SAMPLE *)snd[firelaser].dat, CONFIG.SFXVol, 128, 1000, 0);
						}
						break;
   					case 3:
   						if (!Wepn[3]->IsActive())
   						{
      						Wepn[3]->Fire(	x+Cos(angle)*10,y+Sin(angle)*10, angle);
	      					M_play_sample((SAMPLE *)snd[firemissile].dat, CONFIG.SFXVol, 128, 1000, 0);
	      					M_play_sample((SAMPLE *)snd[missiletrack].dat, CONFIG.SFXVol, 128, 1000, 1);
                   				xspeed += Cos(angle+180)*1.5;
							yspeed += Sin(angle+180)*1.5;
						}
						break;
   					case 4:
   						if (Wepn[4]->IsGood())
						{
							M_play_sample((SAMPLE *)snd[bombexplode].dat, CONFIG.SFXVol, 128, 1000, 0);
							Wepn[4]->Explode();
							Wepn[4]->KillBullet(0);
						}
   						else if (!Wepn[4]->IsExploding())
   						{
      						Wepn[4]->Fire(	x+Cos(angle)*10,
       									y+Sin(angle)*10, 
                							Cos(angle)*10,
										Sin(angle)*10, angle);
           					
                   				xspeed += Cos(angle+180)*2.25;
							yspeed += Sin(angle+180)*2.25;
							
							M_play_sample((SAMPLE *)snd[firebomb].dat, CONFIG.SFXVol, 128, 1000, 0);
						}
						break;
					case 5:
						if (!Wepn[5]->IsActive())
						{
          	          		if (Wepn[5]->GetAmmo() > 0)
               	     		{
               	     			if (Wepn[5]->GetStrength() == 0 && Wepn[5]->GetStrength() <= Wepn[5]->GetAmmo())
 				                   {
               	     				Wepn[5]->Charge(1);
               	     				M_play_sample((SAMPLE *)snd[lightcharge].dat, CONFIG.SFXVol, 128, (int)Wepn[5]->GetStrength()*80, 1);
          	     				}
          	     				
                    				if (Wepn[5]->rofcount == 0)
                    				{
                    					if (Wepn[5]->GetStrength() <= 20 && Wepn[5]->GetStrength() <= Wepn[5]->GetAmmo())
                    					{
                        						Wepn[5]->Charge(1);
					    	                    adjust_sample((SAMPLE *)snd[lightcharge].dat, 255, 128, (int)Wepn[5]->GetStrength()*80, 1);
              							}
         							}
         							        							
                    				x += (rand() % 4)-2;
                        				y += (rand() % 4)-2;
                        			}
						}
						break;
				}
			}

		}
		
		void SwitchWeapons()
		{
			int w = currweapon;
			
			do
			{
				w++;
				if (w > MAX_WEAPON)
					w = 0;
					
			}while (Wepn[w]->GetAmmo() == 0);

			currweapon = w;
		}
		
		int CurrWeapon()	{return currweapon;}
		
		int WeaponAmmo(int _num)
  		{
  			if (_num == -1)
  				return Wepn[currweapon]->GetAmmo();
			else
    				return Wepn[_num]->GetAmmo();
        	}
		
		void DrawWeapons(BITMAP *_bmp)
		{
			int i;
			for (i = 0; i <= MAX_WEAPON; i++)
				Wepn[i]->Draw(_bmp);
		}
		
		void UpdateWeapons(DATAFILE *snd, int _sh)
		{
			int i;
			for (i = 0; i <= MAX_WEAPON; i++)
			{
				if (i == 5)
				{
					Wepn[i]->Update(x, y, angle, _sh);
				}
				else if (i == 3 || i == 4)
					Wepn[i]->Update(snd);
				else
					Wepn[i]->Update();					
			}
    	
			for (i = 0; i <= MAX_WEAPON; i++)
			{
				if (Wepn[i]->rof != 0)
				{
					Wepn[i]->rofcount++;
					if (Wepn[i]->rofcount > Wepn[i]->rof)
						Wepn[i]->rofcount = 0;
				}
			}
		}
		
		void WeaponCollisionDetect(Ship &ship, DATAFILE *snd)
		{
		if (ship.IsGood())
		{
			int i;
			for (i = 0; i < 5; i++)
			{
				if (Wepn[0]->BulletIsGood(i))
				{
    					if ( Wepn[0]->DistToBullet(i, ship.X(), ship.Y()) < 15)
					{
						ship.ChShield(-2);
						ship.Bounce(To360(Wepn[0]->GetBulletA(i)+180), 3);
						ship.StartSpin(4.5);
						Wepn[0]->BulletSparkExplosion(i);
						Wepn[0]->KillBullet(i);
						M_play_sample((SAMPLE *)snd[explosion1+rand()%7].dat, CONFIG.SFXVol, 128, 2000, 0);
					}
				}
			}
		
			
			for (i = 0; i < 50; i++)
			{
				if (Wepn[1]->BulletIsGood(i))
				{
    					if ( Wepn[1]->DistToBullet(i, ship.X(), ship.Y()) < 15)
					{
						ship.ChShield(-1);
						ship.Bounce(To360(Wepn[1]->GetBulletA(i)+180), 2);
						ship.StartSpin(2.25);
						Wepn[1]->BulletSparkExplosion(i);
						Wepn[1]->KillBullet(i);
						M_play_sample((SAMPLE *)snd[explosion1+rand()%7].dat, CONFIG.SFXVol, 128, 2000, 0);
					}
				}
			}
			
			for (i = 0; i < 3; i++)
			{
    				if (Wepn[2]->BulletIsGood(i))
				{
    					if ( Wepn[2]->DistToBullet(i, ship.X(), ship.Y()) < 15)// || 
         					//Wepn[2]->DistToMidBullet(i, ship.X(), ship.Y()) < 30 )
					{
						ship.ChShield(-4);
						ship.Bounce(To360(Wepn[1]->GetBulletA(i)+180), 5);
						ship.StartSpin(7.5);
						M_play_sample((SAMPLE *)snd[hitbylaser].dat, CONFIG.SFXVol, 128, 1000, 0);
						Wepn[2]->BulletSparkExplosion(i);
						Wepn[2]->KillBullet(i);
					}
				}
			}
			
			if (Wepn[3]->IsGood())
			{
 				if ( Wepn[3]->DistToBullet(0, ship.X(), ship.Y()) < 15)// || 
         			{
					ship.ChShield(-6);
					ship.Bounce(To360(Wepn[3]->GetBulletA(0)+180), 6);
					ship.StartSpin(11.25);
					Wepn[3]->Explode();
					Wepn[3]->KillBullet(0);
					M_play_sample((SAMPLE *)snd[explosion1+rand()%7].dat, CONFIG.SFXVol, 128, 1000, 0);
					stop_sample((SAMPLE *)snd[missiletrack].dat);
				}
			}
			
			if (Wepn[4]->IsGood())
			{
 				if ( Wepn[4]->DistToBullet(0, ship.X(), ship.Y()) < 15)
         			{
					Wepn[4]->Explode();
					Wepn[4]->KillBullet(0);
				}
			}
				if (Wepn[4]->IsExploding() && Wepn[4]->Life() > 10)
				{
					if (Wepn[4]->DistToBullet(0, ship.X(), ship.Y()) < Wepn[4]->Radius())
					{
						ship.ChShield(-2);
						ship.Bounce( To360(-FindAngle(Wepn[4]->X(), Wepn[4]->Y(), ship.X(), ship.Y())), 10);
						ship.StartSpin(3.75);
						M_play_sample((SAMPLE *)snd[hitbybomb].dat, CONFIG.SFXVol, 128, 1000, 0);
					}
					
					if (Wepn[4]->DistToBullet(0, x, y) < Wepn[4]->Radius())
					{
						ChShield(-2);
						Bounce( To360(-FindAngle(Wepn[4]->X(), Wepn[4]->Y(), x, y)), 10);
						StartSpin(3.75);
						M_play_sample((SAMPLE *)snd[hitbybomb].dat, CONFIG.SFXVol, 128, 1000, 0);
					}
				}
				
			if (Wepn[5]->DamageTarget())
			{
				ship.ChShield(-1);
				ship.Bounce( Wepn[5]->TargetAng(), 10);
				ship.StartSpin(3.75);
				M_play_sample((SAMPLE *)snd[hitbylight2].dat, CONFIG.SFXVol, 128, 1000, 0);
			}
		}
		}
		
		void PowerupCollisionDetect(Powerup &Pwrup, DATAFILE *snd)
		{
			if (Pwrup.IsGood() && !Dying)
			{
				if (dist(Pwrup.GetX(), Pwrup.GetY(), x, y) < 15)
				{
					M_play_sample((SAMPLE *)snd[powerup].dat, CONFIG.SFXVol, 128, 1000, 0);
					switch (Pwrup.GetType())
					{
						case 0:
							if (shield <= 16)
								ChShield(5);
							else
								shield = 20;
							break;
						case 1:
							if (Wepn[1]->GetAmmo() <= 150)
								Wepn[1]->ChangeAmmo(50);
							else
								Wepn[1]->SetAmmo(200);
							break;
						case 2:
							if (Wepn[2]->GetAmmo() <= 40)
								Wepn[2]->ChangeAmmo(10);
							else
								Wepn[2]->SetAmmo(50);
							break;
    						case 3:
							if (Wepn[3]->GetAmmo() <= 7)
								Wepn[3]->ChangeAmmo(3);
							else
								Wepn[3]->SetAmmo(10);
							break;
    						case 4:
							if (Wepn[4]->GetAmmo() <= 7)
								Wepn[4]->ChangeAmmo(3);
							else
								Wepn[4]->SetAmmo(10);
							break;
    						case 5:
							if (Wepn[5]->GetAmmo() <= 15)
								Wepn[5]->ChangeAmmo(15);
							else
								Wepn[5]->SetAmmo(30);
							break;
					}
					Pwrup.Die();
					
				}
			}
		}
		
		int shield;
		
	private:
		bool Alive;
		bool Dying;
	
		float x;
		float y;
		int angle;
		float speed;
		float xspeed;
		float yspeed;
		
		int thrustangle;
		
		float spin;
		
		int color;
		
		int score;
		
		int currweapon;
		
		Spark sprk[500];
		ShipExplosion Explosion;
};
