// projectile classes

#define NUM_OF_PARTICLES 50

class Spark // engine sparks
{
	public:
	
		Spark()
		{
			life = 0;
		}
		
	 	void Init(float _x, float _y, float _xs, float _ys)
		{
			x = _x;
			y = _y;
			xs = _xs;
			ys = _ys;
			life = 64;
		}
	
	
		int life;
	
		void Draw(BITMAP *_bmp, int colorstart, int colorend)
		{
			if (life)
			{
				int r, g, b;
				int *pR = &r;
				int *pG = &g;
				int *pB = &b;
				float v = (float)(life) / 64;
				hsv_to_rgb(rand()%colorend + colorstart, 1, v, pR, pG, pB);
				putpixel(_bmp, (int)x, (int)y, makecol(r, g, b));
			}
		}
	
		void Update()
		{
			if (life)
			{
				x += xs;
				y += ys;
				life--;
			}
		}
	
		private:
			float x;
			float y;
			float xs;
			float ys;
};

class Particle	// explosion particles (base class)
{
	public:
		void Init(int _x, int _y, int _angle, int _radint, int _life, int _col)
		{
			x = _x;
			y = _y;
			angle = _angle;
			radius = 0;
			radint = _radint;
			life = _life;
			maxlife = _life;
			color = _col;
		}

 		void Draw(BITMAP *_bmp)
 		{
			if (life > 0)
			{
				int r, g, b;
				int *pR = &r;
				int *pG = &g;
				int *pB = &b;
		
				float v = (float)(life) / maxlife;
				hsv_to_rgb(color, 1, v, pR, pG, pB);
		
		     	putpixel(_bmp,	(int)(x+Cos(angle)*radius), (int)(y+Sin(angle)*radius), makecol(r,g,b));
			}
		}
 
    		void Update()
    		{
			if (life > 0)
			{
	 			radius += radint;
			 	life--;
			}	
		}

  		void Update(int _xs, int _ys)
		{
			if (life > 0)
			{
			 	radius += radint;
			 	life--;
			 	x += _xs;
			 	y += _ys;
			}	
		}
  		
	protected:
		int x;
		int y;
		int angle;
		int radius;
		int radint;
		int life;
		int maxlife;
		int color;
};

class LineShrap : public Particle // twirly line shrapnel
{
	public:
		void Init(int _x, int _y, int _angle, int _radint, int _life, int _col)
		{
			x = _x;
			y = _y;
			angle = _angle;
			radius = 0;
			radint = _radint;
			life = _life;
			maxlife = life;
			color = _col;
	
			int i;
			for (i = 0; i < 2; i++)
			{
				Point[i] = rand()%360;
			}
		
		}
		
	 	void Draw(BITMAP *_dest)
	 	{
			if (life > 0)
			{
				int r, g, b;
				int *pR = &r;
				int *pG = &g;
				int *pB = &b;
		
				float v = (float)(life) / maxlife;
				hsv_to_rgb(color, 1, v, pR, pG, pB);
	
	     		line(_dest,(int)((x+Cos(angle)*radius)+(Cos(Point[0])*10)),
      				(int)((y+Sin(angle)*radius)+(Sin(Point[0])*10)),
      				(int)((x+Cos(angle)*radius)+(Cos(Point[1])*10)),
      				(int)((y+Sin(angle)*radius)+(Sin(Point[1])*10)), makecol(r, g, b));
			}
		}

 	 	void Update()
 	 	{
			if (life > 0)
			{
	 			radius += radint;
			 	life--;
			 	int i;
			 	for (i = 0; i < 2; i++)
			 	{
			 		Point[i]+=10;
		 		}
			}	
		}
		
 	 	void Update(int _xs, int _ys)
		{
			if (life > 0)
			{
			 	radius += radint;
			 	life--;
			 	int i;
			 	for (i = 0; i < 2; i++)
			 	{
			 		Point[i]+=10;
		 		}
		 		x += _xs;
		 		y += _ys;
			}
		}
 	 	
 	private:
	 	int Point[2];

};

class Explosion
{
	public:
		void Init(int _x, int _y, int _life)
		{
			int i;
			for (i = 0; i < NUM_OF_PARTICLES; i++)
			{
					Line[i].Init(_x, _y, rand()%360, (rand()%10)+1, _life, rand()%50+250);
			}
			x = _x;
			y = _y;
			Exploding = false;
			Life = _life;
			MaxLife = _life;
		}

		void Activate()	{Exploding = true;};

		void Draw(BITMAP *_dest)
		{
			if (Exploding)
			{
		  		int i;
				for (i = 0; i < NUM_OF_PARTICLES; i++)
				{
					Line[i].Draw(_dest);
				}
			}
		}
		
		void Update()
		{
			if (Exploding)
			{
				int i;
				for (i = 0; i < NUM_OF_PARTICLES; i++)
				{
					Line[i].Update();
				}
				Life--;
		
				if (Life == 0)
					Exploding = false;
			}
		}

		void Update(int _xs, int _ys)
		{
			if (Exploding)
			{
				int i;
				for (i = 0; i < NUM_OF_PARTICLES; i++)
				{
					Line[i].Update(_xs, _ys);
				}
				Life--;
		
				if (Life == 0)
					Exploding = false;
			}
		}
		
		bool IsExploding()	{return Exploding;};
	  	//void ChangePos(int _x, int _y) {x += _x; y += _y;};
	private:
		int x;
		int y;
  		int Life;
  		int MaxLife;
		bool Exploding;
		bool Mode;
		LineShrap Line[NUM_OF_PARTICLES];
};

