struct ConfigData
{
	int Goal;				// point goal (1-100)
	char P1Name[20];		// Player 1's name
	char P2Name[20];		// Player 2's name
	
	int P1Shield;			// amount of shield Player 1 starts with (1-20)
	int P2Shield;			// amount of shield Player 2 starts with (1-20)

	int CollisionType;		// collision rule
	
	// allow/restrict powerups
	bool AllowPowerup[6];
	
	// starting ammo
	int RapidAmmoStart;		// max 200
	int LaserAmmoStart;		// max 50
	int MissileAmmoStart;	// max 10
	int BombAmmoStart;		// max 10
	int LightningAmmoStart;	// max 30
	
	bool ReplenishAmmo;
	
	// sound config
	bool PlayMusic;
	bool PlaySFX;
	
	int SFXVol;
	int MusicVol;	
};

void SetDefaults (ConfigData &conf)
{
	conf.Goal = 10;
	strcpy(conf.P1Name, "");
	strcpy(conf.P2Name, "");
	
	conf.P1Shield = 20;
	conf.P2Shield = 20;
	
	conf.CollisionType = 0;
	
	int i;
 	for (i = 0; i < 6; i++)
  		conf.AllowPowerup[i] = true;

	conf.RapidAmmoStart = 0;
	conf.LaserAmmoStart = 0;
	conf.MissileAmmoStart = 0;
	conf.BombAmmoStart = 0;
	conf.LightningAmmoStart = 0;
	
	conf.ReplenishAmmo = false;
	
	conf.PlayMusic = true;
	conf.PlaySFX = true;
	
	conf.MusicVol = 100;
	conf.SFXVol = 255;
 }
 
void SetGameDefaults (ConfigData &conf)
// does not change audio preferences
{
	conf.Goal = 10;
	
	conf.P1Shield = 20;
	conf.P2Shield = 20;
	
	conf.CollisionType = 0;
	
	int i;
 	for (i = 0; i < 6; i++)
  		conf.AllowPowerup[i] = true;

	conf.RapidAmmoStart = 0;
	conf.LaserAmmoStart = 0;
	conf.MissileAmmoStart = 0;
	conf.BombAmmoStart = 0;
	conf.LightningAmmoStart = 0;
	
	conf.ReplenishAmmo = false;
}

void SetAudioDefaults (ConfigData &conf)
{
	conf.PlayMusic = true;
	conf.PlaySFX = true;
	
	conf.MusicVol = 100;
	conf.SFXVol = 255;
 }
 
int WriteGameConfig(ConfigData conf)
{
	ofstream fout("gconfig.dat");
	
	if (fout)
	{
		fout << "gameconfigdata ";
	
 		fout << conf.Goal << " ";
		fout << conf.P1Shield << " ";
		fout << conf.P2Shield << " ";
		
		fout << conf.CollisionType << " ";
	
		int i;
 		for (i = 0; i < 6; i++)
  			fout << conf.AllowPowerup[i] << " ";

		fout << conf.RapidAmmoStart << " ";
		fout << conf.LaserAmmoStart << " ";
		fout << conf.MissileAmmoStart << " ";
		fout << conf.BombAmmoStart << " ";
		fout << conf.LightningAmmoStart << " ";
	
		fout << conf.ReplenishAmmo;
		fout.close();
		return 1;
	}
	else
		return 0;
}

int WriteAudioConfig(ConfigData conf)
{
	ofstream fout("aconfig.dat");
	
	if (fout)
	{
		fout << "audioconfigdata ";
	
 		fout << conf.PlayMusic << " ";
		fout << conf.PlaySFX << " ";
		fout << conf.MusicVol << " ";
		fout << conf.SFXVol;
		fout.close();
		return 1;
	}
	else
		return 0;
}

int ReadGameConfig(ConfigData &conf)
{
	ifstream fin("gconfig.dat");
	
	char Verify[15];
	
	if (fin)
	{
		fin >> Verify;
		
		if (strcmp(Verify, "gameconfigdata") != 0)
		{
			SetGameDefaults(conf);
			return 0;
		}
			
 		fin >> conf.Goal;
 		if (conf.Goal < 1)				{conf.Goal = 1;}
 		if (conf.Goal > 99)				{conf.Goal = 99;}

		fin >> conf.P1Shield;
 		if (conf.P1Shield < 1)			{conf.P1Shield = 1;}
 		if (conf.P1Shield > 20)			{conf.P1Shield = 20;}

		fin >> conf.P2Shield;
 		if (conf.P2Shield < 1)			{conf.P2Shield = 1;}
 		if (conf.P2Shield > 20)			{conf.P2Shield = 20;}
  
		fin >> conf.CollisionType;
 		if (conf.CollisionType < 0)		{conf.CollisionType = 0;}		
 		if (conf.CollisionType > 2)		{conf.CollisionType = 2;}		

		int i;
 		for (i = 0; i < 6; i++)
  			fin >> conf.AllowPowerup[i];

		fin >> conf.RapidAmmoStart;
 		if (conf.RapidAmmoStart < 0)		{conf.RapidAmmoStart = 0;}		
 		if (conf.RapidAmmoStart > 200)	{conf.RapidAmmoStart = 200;}		
				
		fin >> conf.LaserAmmoStart;
 		if (conf.LaserAmmoStart < 0)		{conf.LaserAmmoStart = 0;}		
 		if (conf.LaserAmmoStart > 50)		{conf.LaserAmmoStart = 50;}		
		
		fin >> conf.MissileAmmoStart;
 		if (conf.MissileAmmoStart < 0)	{conf.MissileAmmoStart = 0;}		
 		if (conf.MissileAmmoStart > 10)	{conf.MissileAmmoStart = 10;}		
		
		fin >> conf.BombAmmoStart;
 		if (conf.BombAmmoStart < 0)		{conf.BombAmmoStart = 0;}		
 		if (conf.BombAmmoStart > 10)		{conf.BombAmmoStart = 10;}		
		
		fin >> conf.LightningAmmoStart;
 		if (conf.LightningAmmoStart < 0)	{conf.LightningAmmoStart = 0;}		
 		if (conf.LightningAmmoStart > 30)	{conf.LightningAmmoStart = 30;}		
	
		fin >> conf.ReplenishAmmo;
		fin.close();
		return 1;
	}
	else
	{
		SetGameDefaults(conf);
		return 1;
	}
}

int ReadAudioConfig(ConfigData &conf)
{
	ifstream fin("aconfig.dat");
	
	char Verify[16];
	
	if (fin)
	{
		fin >> Verify;
		
		if (strcmp(Verify, "audioconfigdata") != 0)
		{
			SetAudioDefaults(conf);
			return 0;
		}
			
 		fin >> conf.PlayMusic;

		fin >> conf.PlaySFX;
		
		fin >> conf.MusicVol;
 		if (conf.MusicVol < 0)			{conf.MusicVol = 0;}
 		if (conf.MusicVol > 100)			{conf.MusicVol = 100;}

		fin >> conf.SFXVol;
 		if (conf.SFXVol < 0)			{conf.SFXVol = 0;}
 		if (conf.SFXVol > 255)			{conf.SFXVol = 255;}

		fin.close();
		return 1;
	}
	else
	{
		SetAudioDefaults(conf);
		return 1;
	}
}
