#ifndef INC_GAME_H
#define INC_GAME_H


#include "level.h"

typedef struct BALL BALL;
typedef struct GAME GAME;

#define ADVANCE_MAX_SHIFT 4
#define ADVANCE_MAX (1 << ADVANCE_MAX_SHIFT)

struct GAME
{
	LEVEL level;
	unsigned char under[LEVEL_H][LEVEL_W]; /* whatever is under each ball will be stored here */
	BALL *ball; /* this is for mid-air balls only */
	unsigned char advance; /* goes from 0 to ADVANCE_MAX-1, making balls move forwards */
	int balls_left;
	int goals_left;
};

struct BALL
{
	BALL *next;
	unsigned char x, y;
	unsigned char phase; /* 1: going up. 0: going down. */
	unsigned char dir; /* direction; a TILE_BALL_* constant in fact */
};

GAME *create_game(LEVEL *level);
void destroy_game(GAME *game);

void propagate_game(GAME *game);
void draw_level(BITMAP *bmp, GAME *game, LEVEL *level, int frame);


#endif /* INC_GAME_H */
