OBJDIR := obj
DEPDIR := obj

SOURCES := $(wildcard *.c)
OBJECTS := $(patsubst %.c,$(OBJDIR)/%.o,$(SOURCES))

CC := gcc
CFLAGS := -W -Wall -Wwrite-strings
CFLAGS += -O2 -ffast-math -fomit-frame-pointer -funroll-loops
CFLAGS += -Wmissing-declarations -Wstrict-prototypes -Wno-system-headers

LIBS := -laldmb -ldumb `allegro-config --libs`

ifdef EFENCE
LIBS += -lefence
endif

balls: $(OBJECTS)
	$(CC) $^ -o $@ $(LIBS)

$(OBJDIR)/%.o: %.c
	$(CC) $(CFLAGS) -c $< -o $@

$(DEPDIR)/%.d: %.c
	$(CC) -MM $(CFLAGS) $< > _depend.tmp
	sed -e "s/^\([a-zA-Z0-9_]*\)\.o:/$(OBJDIR)\/\1\.o $(DEPDIR)\/\1\.d:/" _depend.tmp > $@
	rm _depend.tmp

-include $(patsubst %.c,$(DEPDIR)/%.d,$(SOURCES))
