#ifndef INC_LEVEL_H
#define INC_LEVEL_H


typedef struct LEVEL LEVEL;
typedef struct LINKED_LEVEL LINKED_LEVEL;

#define LEVEL_W 20
#define LEVEL_H 15

#define TILE_BLANK                  0
#define TILE_WALL                   1
#define TILE_WEAK_WALL              2
#define TILE_DEFLECTOR_UP_RIGHT     3
#define TILE_DEFLECTOR_DOWN_RIGHT   4
#define TILE_BOMB                   5
#define TILE_MOUND                  6
#define TILE_PIT                    7
#define TILE_GOAL                   8
#define TILE_BALL_LEFT              9
#define TILE_BALL_RIGHT            10
#define TILE_BALL_UP               11
#define TILE_BALL_DOWN             12

#define TILE_N_PLACEABLE           13

#define TILE_BALL_LEFT_STUCK       13
#define TILE_BALL_RIGHT_STUCK      14
#define TILE_BALL_UP_STUCK         15
#define TILE_BALL_DOWN_STUCK       16
#define TILE_FILLED_GOAL           17
#define TILE_EXPLOSION_BASE        18
#define TILE_EXPLOSION_SOURCE_BASE 22
#define TILE_EXPLOSION_N            4

#define TILE_N_TOTAL               26

#define TILE_PLACEABLE_IS_BALL_OR_GOAL(t) ((t) >= TILE_GOAL)
#define TILE_RAW_DIR(t) (((t) - TILE_BALL_LEFT) & 3)
#define TILE_IS_UNSTUCK_BALL(t) ((t) >= TILE_BALL_LEFT && (t) <= TILE_BALL_DOWN)
#define TILE_IS_BALL(t) ((t) >= TILE_BALL_LEFT && (t) <= TILE_BALL_DOWN_STUCK)
#define TILE_IS_STUCK(t) ((t) >= TILE_BALL_LEFT_STUCK && (t) <= TILE_BALL_DOWN_STUCK)
#define STICK_TILE(t) ((t) + 4)
#define UNSTICK_TILE(t) ((t) - 4)
#define TILE_IS_EXPLOSION(t) ((t) >= TILE_EXPLOSION_BASE && (t) < TILE_EXPLOSION_SOURCE_BASE + TILE_EXPLOSION_N)
#define TILE_EXPLOSION_IS_SOURCE(t) ((t) >= TILE_EXPLOSION_SOURCE_BASE)
#define TILE_IS_SOURCE_EXPLOSION(t) ((t) >= TILE_EXPLOSION_SOURCE_BASE && (t) < TILE_EXPLOSION_SOURCE_BASE + TILE_EXPLOSION_N)
#define TILE_UNSOURCE_EXPLOSION(t) ((t) - 4)

#define TILE_W 32
#define TILE_H 28

#define WALL_H 12

struct LEVEL
{
	unsigned char map[LEVEL_H][LEVEL_W];
};

struct LINKED_LEVEL
{
	LEVEL level;
	int n_to_place[TILE_N_PLACEABLE];
	LINKED_LEVEL *next, *prev;
};

LINKED_LEVEL *load_levels(const char *filename, int *n);
void unload_levels(LINKED_LEVEL *l);

void draw_tile(BITMAP *bmp, unsigned char c, int x, int y, int xs, int ys, int frame);

#define DBE_EXPLOSION         1
#define DBE_LEFT_RIGHT_STUCK  2
#define DBE_UP                4
#define DBE_DOWN              8
#define DBE_ARROW            16

void draw_ball_or_explosion(BITMAP *bmp, int flags, unsigned char tile, int x, int y, int xs, int ys, int advance, int frame, int y_offset);


#endif /* INC_LEVEL_H */
