#include <stdlib.h>
#include <string.h>
#include "main.h"
#include "game.h"


GAME *create_game(LEVEL *level)
{
	int x, y;
	GAME *game = malloc(sizeof(*game));
	if (!game) return NULL;

	game->level = *level;
	memset(game->under, TILE_BLANK, LEVEL_H*LEVEL_W);
	game->ball = NULL;
	game->advance = 0;
	game->balls_left = 0;
	game->goals_left = 0;

	for (y = 0; y < LEVEL_H; y++) {
		for (x = 0; x < LEVEL_W; x++) {
			switch (game->level.map[y][x]) {
				case TILE_GOAL:
					game->goals_left++;
					break;
				case TILE_BALL_LEFT:
				case TILE_BALL_RIGHT:
				case TILE_BALL_UP:
				case TILE_BALL_DOWN:
					game->balls_left++;
					break;
			}
		}
	}

	return game;
}


void destroy_game(GAME *game)
{
	if (game) {
		BALL *ball = game->ball;
		while (ball) {
			BALL *next = ball->next;
			free(ball);
			ball = next;
		}
		free(game);
	}
}
