#include "includes.h"

#define SCRIPT_NONE        0
#define SCRIPT_PAUSE       1
#define SCRIPT_START_LEVEL 2
#define SCRIPT_SHOW_ENDING 3
#define SCRIPT_PLACE_ENEMY 4
#define SCRIPT_FADE_OUT    5
#define SCRIPT_FADE_IN     6
#define SCRIPT_DRAW        7
#define SCRIPT_END_LEVEL   8

char command[SCRIPT_MAX_COMMANDS][1024] =
{
	"none",
	"pause",
	"start_level",
	"show_ending",
	"place_enemy",
	"fade_out",
	"fade_in",
	"draw",
	"end_level"
};

/* divide up all commands and arguments */
void script_tokenize(SCRIPT * sp)
{
	int i;
	
	for(i = 0; i < SCRIPT_MAX; i++)
	{
		if(sp->text[i] == ' ')
		{
			sp->text[i] = 0;
		}
	}
}

int script_load(SCRIPT * sp, char * fn)
{
	PACKFILE * fp;
	int i = 0;
	
	fp = pack_fopen(fn, "r");
	if(!fp)
	{
		return 0;
	}
	while(!pack_feof(fp))
	{
		sp->text[i] = pack_getc(fp);
		i++;
	}
	sp->length = i;
	sp->pos = 0;
	pack_fclose(fp);
	script_tokenize(sp);
	return 1;
}

char * script_peek(SCRIPT * sp)
{
	int i;
	int arg = 0;
	int len = 0;
	int old = sp->pos;

	/* make sure we don't read if script is finished */
	if(sp->pos >= sp->length)
	{
		return NULL;
	}
	
	/* clear the script */
	sp->command = NULL;
	for(i = 0; i < SCRIPT_MAX_ARGS; i++)
	{
		sp->argument[i] = NULL;
	}
	
	for(i = 0; i < SCRIPT_LINE_MAX; i++)
	{
		sp->command_line[i] = 0;
	}
	
	/* read the command line */
	i = 0;
	while(sp->text[sp->pos] != '\n' && i < SCRIPT_LINE_MAX)
	{
		sp->command_line[i] = sp->text[sp->pos];
		printf("%c", sp->command_line[i]);
		if(sp->command_line[i] == ' ' || sp->command_line[i] == '\r' || sp->command_line[i] == '\n')
		{
			sp->command_line[i] = 0;
		}
		sp->pos++;
		i++;
	}
	sp->pos++;
	sp->command_line[i] = 0;
	printf("\n");
	sp->command = &sp->command_line[0];
	sp->pos = old;

	return sp->command;
}

/* read next line */
int script_read_line(SCRIPT * sp)
{
	int i;
	int arg = 0;
	int len = 0;

	/* make sure we don't read if script is finished */
	if(sp->pos >= sp->length)
	{
		return 0;
	}
	
	/* clear the script */
	sp->command = NULL;
	for(i = 0; i < SCRIPT_MAX_ARGS; i++)
	{
		sp->argument[i] = NULL;
	}
	
	for(i = 0; i < SCRIPT_LINE_MAX; i++)
	{
		sp->command_line[i] = 0;
	}
	
	/* read the command line */
	i = 0;
	while(sp->text[sp->pos] != '\n' && i < SCRIPT_LINE_MAX)
	{
		sp->command_line[i] = sp->text[sp->pos];
		printf("%c", sp->command_line[i]);
		if(sp->command_line[i] == ' ' || sp->command_line[i] == '\r' || sp->command_line[i] == '\n')
		{
			sp->command_line[i] = 0;
		}
		sp->pos++;
		i++;
	}
	sp->pos++;
	sp->command_line[i] = 0;
	printf("\n");
	sp->command = &sp->command_line[0];

	/* read the arguments */
	i = strlen(sp->command);
	while(i < SCRIPT_LINE_MAX)
	{
		/* skip spaces */
		while(sp->command_line[i] == 0)
		{
			i++;
		}
		
		/* if we haven't already filled all arguments */
		if(arg < SCRIPT_MAX_ARGS)
		{
			sp->argument[arg] = &sp->command_line[i];
			arg++;
			
			/* skip rest of argument to find next one */
			while(sp->command_line[i] != 0 && i < SCRIPT_LINE_MAX)
			{
				printf("%c [%d]\n", sp->command_line[i], i);
				i++;
			}
		}
	}
	return 1;
}

void script_interpret(SCRIPT * sp)
{
	int i, ir;
	
	/* compile the script line */
	for(i = 0; i < SCRIPT_MAX_COMMANDS; i++)
	{
		if(!strcmp(command[i], sp->command))
		{
			sp->c_command = i;
			break;
		}
	}
	
	switch(sp->c_command)
	{
		case SCRIPT_NONE:
		{
			break;
		}
		case SCRIPT_PAUSE:
		{
			sp->pause = 1;
			break;
		}
		case SCRIPT_PLACE_ENEMY:
		{
			build_water_list();
			if(lw_water_count > 0)
			{
				ir = alrand_generate(lw_rand_game) % lw_water_count;
				switch(atoi(sp->argument[0]))
				{
					case 0:
					{
						create_enemy(LW_SPRITE_FLOATER, lw_water_list[ir].x * LW_TILE_W, lw_water_list[ir].y * LW_TILE_H);
						break;
					}
					case 1:
					{
						create_enemy(LW_SPRITE_FLOATER_MED, lw_water_list[ir].x * LW_TILE_W, lw_water_list[ir].y * LW_TILE_H);
						break;
					}
					case 2:
					{
						create_enemy(LW_SPRITE_FLOATER_HARD, lw_water_list[ir].x * LW_TILE_W, lw_water_list[ir].y * LW_TILE_H);
						break;
					}
					default:
					{
						create_enemy(LW_SPRITE_FLOATER, lw_water_list[ir].x * LW_TILE_W, lw_water_list[ir].y * LW_TILE_H);
						break;
					}
				}
			}
			break;
		}
		case SCRIPT_START_LEVEL:
		{
			int i, j, k, l, sx, sy, r;
			drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
	
			for(i = 0; i < MAX_SPRITES; i++)
			{
				lw_sprite[i].active = 0;
				lw_sprite[i].num = i;
				lw_laser[i].active = 0;
			}
		
			/* get map ready */
			lw_map_load(&lw_map, sp->argument[0]);
			clear_to_color(lw_map.property, LW_MAP_PROPERTY_CLEAR);
			clear_to_color(lw_map.cannon, PLAYER_MAX_CANNONS);
			turn = 0;
			set_pieces(turn);
			
			/* get players ready */
			for(i = 0; i < lw_game_option[LW_OPTION_PLAYERS]; i++)
			{
				lw_player[0].controller.mouse_x = 320;
				lw_player[0].controller.mouse_y = 240;
				lw_player[0].ok = 0;
				lw_player[0].select = -1;
				for(j = 0; j < PLAYER_MAX_LASERS; j++)
				{
					lw_player[i].laser[j].active = 0;
				}
				for(j = 0; j < PLAYER_MAX_CASTLES; j++)
				{
					lw_player[i].castle[j].active = 0;
					lw_player[i].castle[j].ap[0] = lw_animation[LW_SPRITE_CASTLE];
					lw_player[i].castle[j].owned = 0;
				}
				for(j = 0; j < PLAYER_MAX_CANNONS; j++)
				{
					lw_player[i].cannon[j].active = 0;
					lw_player[i].laser[j].active = 0;
					lw_player[i].cannon[j].flag[PLAYER_CANNON_FLAG_CHARGED] = 1;
					lw_player[i].cannon[j].flag[PLAYER_CANNON_FLAG_INACTIVE] = 0;
					lw_player[i].cannon[j].flag[PLAYER_CANNON_FLAG_HITS] = 12;
					lw_player[i].cannon[j].flag[PLAYER_CANNON_FLAG_FIRE] = 0;
				}
				for(j = 0; j < LW_MAP_H; j++)
				{
					for(k = 0; k < LW_MAP_W; k++)
					{
						if(lw_map.object->line[j][k] == i)
						{
							for(l = 0; l < PLAYER_MAX_CASTLES; l++)
							{
								if(!lw_player[i].castle[l].active)
								{
									lw_player[i].castle[l].x = k * LW_TILE_W;
									lw_player[i].castle[l].y = j * LW_TILE_H;
									lw_player[i].castle[l].ap[0] = lw_animation[LW_SPRITE_CASTLE];
									lw_player[i].castle[l].active = 1;
									lw_map.property->line[lw_player[i].castle[l].y / LW_TILE_H][lw_player[i].castle[l].x / LW_TILE_W] = LW_MAP_PROPERTY_BLOCKED;
									lw_map.property->line[lw_player[i].castle[l].y / LW_TILE_H + 1][lw_player[i].castle[l].x / LW_TILE_W] = LW_MAP_PROPERTY_BLOCKED;
									lw_map.property->line[lw_player[i].castle[l].y / LW_TILE_H][lw_player[i].castle[l].x / LW_TILE_W + 1] = LW_MAP_PROPERTY_BLOCKED;
									lw_map.property->line[lw_player[i].castle[l].y / LW_TILE_H + 1][lw_player[i].castle[l].x / LW_TILE_W + 1] = LW_MAP_PROPERTY_BLOCKED;
									lw_player_generate_piece(&lw_player[i]);
									lw_player[i].castle[l].active = 1;
									break;
								}
							}
						}
					}
				}
			}
			for(i = lw_game_option[LW_OPTION_PLAYERS]; i < LW_MAX_PLAYERS; i++)
			{
				lw_player[i].active = 0;
				lw_player[i].crosshair.active = 0;
			}

			/* finish up */
			lw_frame = 0;
			lw_map.f = lw_frame;
			for(i = 0; i < LW_MAP_H; i++)
			{
				                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  