// Editor.c


#include <stdio.h>
#include <allegro.h>
#include "shared.h"
#include "data.h"



#define MODE_TILE1	0
#define MODE_TILE2	1
#define MODE_TILE3	2


#define TILE_HORIZONTAL_SLASH_TOP_DOWNWARD		19
#define _TILE_HORIZONTAL_SLASH_TOP_DOWNWARD		246
#define TILE_HORIZONTAL_SLASH_TOP_UPWARD		20
#define _TILE_HORIZONTAL_SLASH_TOP_UPWARD		241
#define TILE_HORIZONTAL_SLASH_BOTTOM_UPWARD		21
#define _TILE_HORIZONTAL_SLASH_BOTTOM_UPWARD	236
#define TILE_HORIZONTAL_SLASH_BOTTOM_DOWNWARD	22
#define _TILE_HORIZONTAL_SLASH_BOTTOM_DOWNWARD	231

#define TILE_VERTICAL_SLASH_RIGHT_LEFTWARD		23
#define _TILE_VERTICAL_SLASH_RIGHT_LEFTWARD		226
#define TILE_VERTICAL_SLASH_RIGHT_RIGHTWARD		24
#define _TILE_VERTICAL_SLASH_RIGHT_RIGHTWARD	221
#define TILE_VERTICAL_SLASH_LEFT_RIGHTWARD		25
#define _TILE_VERTICAL_SLASH_LEFT_RIGHTWARD		216
#define TILE_VERTICAL_SLASH_LEFT_LEFTWARD		26
#define _TILE_VERTICAL_SLASH_LEFT_LEFTWARD		211


#define TILE_MODE_BG	251
#define TILE_MODE_INT	252
#define TILE_MODE_FG	253
#define TILE_UPWARD		254
#define TILE_DOWNWARD	255







int	level_being_edited,		// number of the level being edited, this cannot change
	last_frame_ticks,
	panel_index=0,			// tile panel on the right, what tile is on top
	current_tile=0,			// current tile being drawn
	current_enemy=0,
	drawLayer1=TRUE,		// whether or not to draw each layer - for level debugging
	drawLayer2=TRUE,
	drawLayer3=TRUE,
	drawGrid=TRUE,
	editMode=MODE_TILE2,	// mode to place enemies or to place tiles
	TILE_SIZE=3,
	TILE_SIZES[] = {2,4,8,16,24,32,64,0};










void update_timer(void)
{
	TICKS++;
}
END_OF_FUNCTION(update_timer);







int determineStartX(tLayer *layer)
{
	int x,y;

	for(x=0; x<LEVEL_W; x++)
	{
		for(y=0; y<LEVEL_H; y++)
		{
			if(layer->data[y][x] > 0) return x;
		}
	}

	return LEVEL_W;	//error
}


int determineStartY(tLayer *layer)
{
	int x,y;

	for(y=0; y<LEVEL_H; y++)
	{
		for(x=0; x<LEVEL_W; x++)
		{
			if(layer->data[y][x] > 0) return y;
		}
	}

	return LEVEL_H;	//error
}


int determineEndX(tLayer *layer)
{
	int x,y;

	for(x=LEVEL_W-1; x>=0; x--)
	{
		for(y=0; y < LEVEL_H; y++)
		{
			if(layer->data[y][x] > 0) return x+1;
		}
	}

	return LEVEL_W;	//error
}


int determineEndY(tLayer *layer)
{
	int x,y;

	for(y=LEVEL_H-1; y>=0; y--)
	{
		for(x=0; x<LEVEL_W; x++)
		{
			if(layer->data[y][x] > 0) return y+1;
		}
	}

	return LEVEL_H;	//error
}


void saveLevel(void)
{
	int x,y,x1,x2,y1,y2;
	char temp[80];
	PACKFILE *file;

	fLogfile("Saving the level...");

	START_SAVING:
	sprintf(temp,"level%02d.l2",level_being_edited);
	file = pack_fopen(temp,F_WRITE_PACKED);
	if(!file)
	{
		switch(alert3("Error opening file for writing!",NULL,NULL,"&Abort","&Retry","&Ignore",KEY_A,KEY_R,KEY_I))
		{
			case 1:
				break;
			case 2:
				goto START_SAVING;
				break;
			case 3:
				break;
		}

		return;
	}


	// lander starting coordinates
	pack_iputw(startX,file);		// x
	pack_iputw(startY,file);		// y


	// walking blocks
	x1 = determineStartX(level->interactive);
	x2 = determineEndX(level->interactive);
	y1 = determineStartY(level->interactive);
	y2 = determineEndY(level->interactive);


	pack_putc(tileset,file);				// tileset
	pack_iputl(makecol(128,128,255),file);	// background color, for future versions
	pack_putc(0,file);						// music, for future versions
	pack_iputw(y1,file);					// starting y offset for loading data
	pack_iputw(y2,file);					// ending y offset
	pack_iputw(x1,file);					// starting x offset for loading data
	pack_iputw(x2,file);					// ending x offset

	for(y=MAX(y1,0); y<MIN(y2,LEVEL_H); y++)
	{
		for(x=MAX(x1,0); x<MIN(x2,LEVEL_W); x++)
		{
			pack_putc(level->interactive->data[y][x],file);
		}
	}



	// background layer
	x1 = determineStartX(level->background);
	x2 = determineEndX(level->background);
	y1 = determineStartY(level->background);
	y2 = determineEndY(level->background);


	pack_iputw(y1,file);	// starting y offset
	pack_iputw(y2,file);	// ending y offset
	pack_iputw(x1,file);	// starting x offset
	pack_iputw(x2,file);	// ending x offset

	for(y=y1; y<y2; y++)
	{
		for(x=x1; x<x2; x++)
		{
			pack_putc(level->background->data[y][x],file);
		}
	}



	// foreground layer
	x1 = determineStartX(level->foreground);
	x2 = determineEndX(level->foreground);
	y1 = determineStartY(level->foreground);
	y2 = determineEndY(level->foreground);


	pack_iputw(y1,file);	// starting y offset
	pack_iputw(y2,file);	// ending y offset
	pack_iputw(x1,file);	// starting x offset
	pack_iputw(x2,file);	// ending x offset

	for(y=y1; y<y2; y++)
	{
		for(x=x1; x<x2; x++)
		{
			pack_putc(level->foreground->data[y][x],file);
		}
	}






	pack_fclose(file);
	while(key[KEY_S]);


	fLogfile("good.\n");
}





/*
void updateTiles(int START_TILE, int END_TILE, tLevel *level, int x, int y)
{
	int top=0,bottom=0,left=0,right=0,upper_left=0,upper_right=0,bottom_left=0,bottom_right=0,
		top2=0, bottom2=0, left2=0, right2=0;


	// First determine what the 8 surrounding tiles are
	// left
	if(x > 0 && level->data[y][x-1] >= START_TILE && level->data[y][x-1] <= END_TILE) left = level->data[y][x-1];

	// right
	if(x < LEVEL_W-1 && level->data[y][x+1] >= START_TILE && level->data[y][x+1] <= END_TILE) right = level->data[y][x+1];

	// top
	if(y > 0 && level->data[y-1][x] >= START_TILE && level->data[y-1][x] <= END_TILE) top = level->data[y-1][x];

	// bottom
	if(y < LEVEL_H-1 && level->data[y+1][x] >= START_TILE && level->data[y+1][x] <= END_TILE) bottom = level->data[y+1][x];

	// upper left
	if(y > 0 && x > 0 && level->data[y-1][x-1] >= START_TILE && level->data[y-1][x-1] <= END_TILE) upper_left = level->data[y-1][x-1];

	// upper right
	if(y > 0 && x < LEVEL_W-1 && level->data[y-1][x+1] >= START_TILE && level->data[y-1][x+1] <= END_TILE) upper_right = level->data[y-1][x+1];

	// lower left
	if(y < LEVEL_H-1 && x > 0 && level->data[y+1][x-1] >= START_TILE && level->data[y+1][x-1] <= END_TILE) bottom_left = level->data[y+1][x-1];

	// lower right
	if(y < LEVEL_H-1 && x < LEVEL_W-1 && level->data[y+1][x+1] >= START_TILE && level->data[y+1][x+1] <= END_TILE) bottom_right = level->data[y+1][x+1];
	
	// two spaces above
	if(y-1 > 0 && level->data[y-2][x] >= START_TILE && level->data[y-2][x] <= END_TILE) top2 = level->data[y-2][x];

	// two spaces below
	if(y < LEVEL_H-2 && level->data[y+2][x] >= START_TILE && level->data[y+2][x] <= END_TILE) bottom2 = level->data[y+2][x];

	// two spaces left
	if(x-1 > 0 && level->data[y][x-2] >= START_TILE && level->data[y][x-2] <= END_TILE) left2 = level->data[y][x-2];

	// two spaces right
	if(x < LEVEL_W-2 && level->data[y][x+2] >= START_TILE && level->data[y][x+2] <= END_TILE) right2 = level->data[y][x+2];
	

	



	

	// STUFF FOR TILESET0!!!!!!!
	// STUFF FOR TILESET0!!!!!!!
	// STUFF FOR TILESET0!!!!!!!
	// STUFF FOR TILESET0!!!!!!!
	// STUFF FOR TILESET0!!!!!!!
	// STUFF FOR TILESET0!!!!!!!
	if(tileset == 0)
	{
		if(!top && !right && !bottom && !left)
		{
			level->data[y][x] = TILE0_TOP;
		}
		else if(top && right && bottom && left)
		{
			if( (top == TILE0_LEFT || top == TILE0_TOP_LEFT) && (left == TILE0_TOP || left == TILE0_TOP_LEFT)) level->data[y][x] = TILE0_CORNER_UPPER_LEFT;
			else if( (top == TILE0_RIGHT || top == TILE0_TOP_RIGHT) && (right == TILE0_TOP || right == TILE0_TOP_RIGHT)) level->data[y][x] = TILE0_CORNER_UPPER_RIGHT;
			else level->data[y][x] = TILE0_CENTER;
		}	



		else if(top && !right && !bottom && !left)
		{
			level->data[y][x] = TILE0_CENTER;
			level->data[y-1][x] = TILE0_TOP;
		}
		else if(!top && right && !bottom && !left)
		{
			level->data[y][x] = TILE0_TOP_LEFT;
			if(!upper_right)
			{
				level->data[y][x+1] = TILE0_TOP;
			}
			else if(upper_right == TILE0_LEFT || upper_right == TILE0_TOP_LEFT) level->data[y][x+1] = TILE0_CORNER_UPPER_LEFT;
		}
		else if(!top && !right && bottom && !left)
		{
			level->data[y][x] = TILE0_TOP;
			if(bottom_right && !bottom_left)
			{
				level->data[y+1][x] = TILE0_LEFT;
				level->data[y][x] = TILE0_TOP_LEFT;
			}
			else if(bottom_left && !bottom_right)
			{
				level->data[y+1][x] = TILE0_RIGHT;
				level->data[y][x] = TILE0_TOP_RIGHT;
			}
		
			level->data[y+1][x] = TILE0_CENTER;
		}
		else if(!top && !right && !bottom && left)
		{
			level->data[y][x] = TILE0_TOP_RIGHT;
			if(!upper_left)
			{
				level->data[y][x-1] = TILE0_TOP;
			}
			else if(upper_left == TILE0_RIGHT || upper_left == TILE0_TOP_RIGHT) level->data[y][x-1] = TILE0_CORNER_UPPER_RIGHT;
		}


		else if(top && right && !bottom && !left)
		{
			level->data[y][x] = TILE0_LEFT;
		}
		else if(!top && right && bottom && !left)
		{
			level->data[y][x] = TILE0_TOP_LEFT;
			if(bottom_left)
			{
				level->data[y+1][x] = TILE0_CORNER_UPPER_LEFT;
			}
		}
		else if(!top && !right && bottom && left)
		{
			level->data[y][x] = TILE0_TOP_RIGHT;
			if(bottom_right)
			{
				level->data[y+1][x] = TILE0_CORNER_UPPER_RIGHT;
			}
		}
		else if(top && !right && !bottom && left)
		{
			level->data[y][x] = TILE0_RIGHT;
		}



		else if(top && right && bottom && !left)
		{
			level->data[y][x] = TILE0_LEFT;
		}
		else if(!top && right && bottom && left)
		{
			level->data[y][x] = TILE0_TOP;
		}
		else if(top && !right && bottom && left)
		{
			level->data[y][x] = TILE0_RIGHT;
		}
		else if(top && right && !bottom && left)
		{
			if( (top == TILE0_LEFT || top == TILE0_TOP_LEFT) && (left == TILE0_TOP || left == TILE0_TOP_LEFT)) level->data[y][x] = TILE0_CORNER_UPPER_LEFT;
			else if( (top == TILE0_RIGHT || top == TILE0_TOP_RIGHT) && (right == TILE0_TOP || right == TILE0_TOP_RIGHT)) level->data[y][x] = TILE0_CORNER_UPPER_RIGHT;
			else level->data[y][x] = TILE0_CENTER;
		}



		else if(top && !right && bottom && !left)
		{
			level->data[y][x] = TILE0_CENTER;
		}
		else if(!top && right && !bottom && left)
		{
			level->data[y][x] = TILE0_TOP;
			if(!upper_right && !right2) level->data[y][x+1] = TILE0_TOP;
			else if(upper_right == TILE0_LEFT) level->data[y][x+1] = TILE0_CORNER_UPPER_LEFT;

			if(!upper_left && !left2) level->data[y][x-1] = TILE0_TOP;
			else if(upper_left == TILE0_RIGHT) level->data[y][x-1] = TILE0_CORNER_UPPER_RIGHT;
		}
	}




	// STUFF FOR TILESET1 NOW!!!!!!!
	// STUFF FOR TILESET1 NOW!!!!!!!
	// STUFF FOR TILESET1 NOW!!!!!!!
	// STUFF FOR TILESET1 NOW!!!!!!!
	// STUFF FOR TILESET1 NOW!!!!!!!
	// STUFF FOR TILESET1 NOW!!!!!!!
	else if(tileset == 1)
	{
		if(!top && !right && !bottom && !left)
		{
		}
		else if(top && right && bottom && left)
		{
		}	



		else if(top && !right && !bottom && !left)
		{
		}
		else if(!top && right && !bottom && !left)
		{
		}
		else if(!top && !right && bottom && !left)
		{
		}
		else if(!top && !right && !bottom && left)
		{
		}


		else if(top && right && !bottom && !left)
		{
		}
		else if(!top && right && bottom && !left)
		{
		}
		else if(!top && !right && bottom && left)
		{
		}
		else if(top && !right && !bottom && left)
		{
		}



		else if(top && right && bottom && !left)
		{
		}
		else if(!top && right && bottom && left)
		{
		}
		else if(top && !right && bottom && left)
		{
		}
		else if(top && right && !bottom && left)
		{
		}



		else if(top && !right && bottom && !left)
		{
		}
		else if(!top && right && !bottom && left)
		{
		}
	}
}
*/


void parseMouse(void)
{
	int non_enemy;
	if(mouse_x < SCREEN_W-TILE_SIZES[TILE_SIZE])
	{
		int X, Y;
		tLayer *LAYER;
		switch(editMode)
		{
		case MODE_TILE1:
			LAYER = level->background;
			non_enemy = TRUE;
			break;
		case MODE_TILE2:
			LAYER = level->interactive;
			non_enemy = TRUE;
			break;
		case MODE_TILE3:
			LAYER = level->foreground;
			non_enemy = TRUE;
			break;
		}


		X = (mouse_x + camera_x) / TILE_SIZES[TILE_SIZE];
		Y = (mouse_y + camera_y) / TILE_SIZES[TILE_SIZE];
		switch(current_tile)
		{
		case TILE_HORIZONTAL_SLASH_TOP_DOWNWARD:
				LAYER->data[Y][X] = _TILE_HORIZONTAL_SLASH_TOP_DOWNWARD;
				LAYER->data[Y][X+1] = _TILE_HORIZONTAL_SLASH_TOP_DOWNWARD+1;
				LAYER->data[Y][X+2] = _TILE_HORIZONTAL_SLASH_TOP_DOWNWARD+2;
				LAYER->data[Y][X+3] = _TILE_HORIZONTAL_SLASH_TOP_DOWNWARD+3;
				LAYER->data[Y+1][X+3] = _TILE_HORIZONTAL_SLASH_TOP_DOWNWARD+4;
				break;

		case TILE_HORIZONTAL_SLASH_TOP_UPWARD:
				LAYER->data[Y][X] = _TILE_HORIZONTAL_SLASH_TOP_UPWARD;
				LAYER->data[Y-1][X] = _TILE_HORIZONTAL_SLASH_TOP_UPWARD+1;
				LAYER->data[Y-1][X+1] = _TILE_HORIZONTAL_SLASH_TOP_UPWARD+2;
				LAYER->data[Y-1][X+2] = _TILE_HORIZONTAL_SLASH_TOP_UPWARD+3;
				LAYER->data[Y-1][X+3] = _TILE_HORIZONTAL_SLASH_TOP_UPWARD+4;
				break;

		case TILE_HORIZONTAL_SLASH_BOTTOM_UPWARD:
				LAYER->data[Y][X] = _TILE_HORIZONTAL_SLASH_BOTTOM_UPWARD;
				LAYER->data[Y][X+1] = _TILE_HORIZONTAL_SLASH_BOTTOM_UPWARD+1;
				LAYER->data[Y][X+2] = _TILE_HORIZONTAL_SLASH_BOTTOM_UPWARD+2;
				LAYER->data[Y][X+3] = _TILE_HORIZONTAL_SLASH_BOTTOM_UPWARD+3;
				LAYER->data[Y-1][X+3] = _TILE_HORIZONTAL_SLASH_BOTTOM_UPWARD+4;
				break;

		case TILE_HORIZONTAL_SLASH_BOTTOM_DOWNWARD:
				LAYER->data[Y][X] =		_TILE_HORIZONTAL_SLASH_BOTTOM_DOWNWARD;
				LAYER->data[Y+1][X] =	_TILE_HORIZONTAL_SLASH_BOTTOM_DOWNWARD+1;
				LAYER->data[Y+1][X+1] =	_TILE_HORIZONTAL_SLASH_BOTTOM_DOWNWARD+2;
				LAYER->data[Y+1][X+2] =	_TILE_HORIZONTAL_SLASH_BOTTOM_DOWNWARD+3;
				LAYER->data[Y+1][X+3] =	_TILE_HORIZONTAL_SLASH_BOTTOM_DOWNWARD+4;
				break;

		case TILE_VERTICAL_SLASH_RIGHT_LEFTWARD:
				LAYER->data[Y][X] = _TILE_VERTICAL_SLASH_RIGHT_LEFTWARD;
				LAYER->data[Y+1][X] = _TILE_VERTICAL_SLASH_RIGHT_LEFTWARD+1;
				LAYER->data[Y+2][X] = _TILE_VERTICAL_SLASH_RIGHT_LEFTWARD+2;
				LAYER->data[Y+3][X] = _TILE_VERTICAL_SLASH_RIGHT_LEFTWARD+3;
				LAYER->data[Y+3][X-1] = _TILE_VERTICAL_SLASH_RIGHT_LEFTWARD+4;
				break;

		case TILE_VERTICAL_SLASH_RIGHT_RIGHTWARD:
				LAYER->data[Y][X] = _TILE_VERTICAL_SLASH_RIGHT_RIGHTWARD;
				LAYER->data[Y][X+1] = _TILE_VERTICAL_SLASH_RIGHT_RIGHTWARD+1;
				LAYER->data[Y+1][X+1] = _TILE_VERTICAL_SLASH_RIGHT_RIGHTWARD+2;
				LAYER->data[Y+2][X+1] = _TILE_VERTICAL_SLASH_RIGHT_RIGHTWARD+3;
				LAYER->data[Y+3][X+1] = _TILE_VERTICAL_SLASH_RIGHT_RIGHTWARD+4;
				break;

		case TILE_VERTICAL_SLASH_LEFT_RIGHTWARD:
				LAYER->data[Y][X] = _TILE_VERTICAL_SLASH_LEFT_RIGHTWARD;
				LAYER->data[Y+1][X] = _TILE_VERTICAL_SLASH_LEFT_RIGHTWARD+1;
				LAYER->data[Y+2][X] = _TILE_VERTICAL_SLASH_LEFT_RIGHTWARD+2;
				LAYER->data[Y+3][X] = _TILE_VERTICAL_SLASH_LEFT_RIGHTWARD+3;
				LAYER->data[Y+3][X+1] = _TILE_VERTICAL_SLASH_LEFT_RIGHTWARD+4;
				break;

		case TILE_VERTICAL_SLASH_LEFT_LEFTWARD:
				LAYER->data[Y][X] = _TILE_VERTICAL_SLASH_LEFT_LEFTWARD;
				LAYER->data[Y-1][X] = _TILE_VERTICAL_SLASH_LEFT_LEFTWARD+1;
				LAYER->data[Y-2][X] = _TILE_VERTICAL_SLASH_LEFT_LEFTWARD+2;
				LAYER->data[Y-3][X] = _TILE_VERTICAL_SLASH_LEFT_LEFTWARD+3;
				LAYER->data[Y-3][X+1] = _TILE_VERTICAL_SLASH_LEFT_LEFTWARD+4;
				break;
				

		default:
				LAYER->data[Y][X] = current_tile;
		}
	}

	else
	{
		if(mouse_y/TILE_SIZES[TILE_SIZE] == 0)
		{
			editMode ++;
			if(editMode > MODE_TILE3) editMode = MODE_TILE1;
			while(mouse_b & 1);
		}
		else if(mouse_y/TILE_SIZES[TILE_SIZE] == 1)
		{
			if(panel_index > 0)
			{
				if(key[KEY_LSHIFT])
				{
					panel_index -= SCREEN_H/TILE_SIZES[TILE_SIZE] - 3;
					if(panel_index < 0) panel_index = 0;
				}
				else panel_index--;
			}
			while(mouse_b & 1);
		}
		else if(mouse_y >= SCREEN_H - TILE_SIZES[TILE_SIZE])
		{
			if(panel_index+((SCREEN_H/TILE_SIZES[TILE_SIZE]) - 3) < 256)
			{
				if(key[KEY_LSHIFT])
				{
					panel_index+=(SCREEN_H/TILE_SIZES[TILE_SIZE]) - 3;
					if(panel_index+((SCREEN_H/TILE_SIZES[TILE_SIZE]) - 3) > 255) panel_index = 255-((SCREEN_H/TILE_SIZES[TILE_SIZE]) - 3);
				}
				else panel_index++;
			}
			while(mouse_b & 1);
		}
		else
		{
			int n;
			for(n=0; unselectableTiles[tileset][n] != 0; n++)
			{
				if(panel_index + mouse_y/TILE_SIZES[TILE_SIZE] - 2 == unselectableTiles[tileset][n]) return;
			}
			current_tile = panel_index + mouse_y/TILE_SIZES[TILE_SIZE] - 2;
			

			/// THIS SECTION COULD BE FASTER IF A TILE CLASS WERE MADE!!!
			// check if it's a bg tile
			for(n=0; backgroundTiles[tileset][n] != 0; n++)
			{
				if(backgroundTiles[tileset][n] == current_tile)
				{
					editMode = MODE_TILE1;
					return;
				}
			}
			// check if its a level tile
			for(n=0; levelTiles[tileset][n] != 0; n++)
			{
				if(levelTiles[tileset][n] == current_tile)
				{
					editMode = MODE_TILE2;
					return;
				}
			}
			// check if its a fg tile
			for(n=0; foregroundTiles[tileset][n] != 0; n++)
			{
				if(foregroundTiles[tileset][n] == current_tile)
				{
					editMode = MODE_TILE3;
					return;
				}
			}
		}
	}
}



void floodLayer(tLayer *layer, int x, int y, int tile)
{
	int left, right, n, o, tile_being_replaced;

	// if we're drawing the same color tile, no flooding will occure
	if(layer->data[y][x] == tile) return;
	else tile_being_replaced = layer->data[y][x];


	for(o=y; layer->data[o][x] == tile_being_replaced; o++)
	{
		if(o > LEVEL_H) break;

		// determine left limit
		n = x;
		while(n >= 0)
		{
			if(layer->data[o][n] == tile_being_replaced)
			{
				left = n;
				n--;
			}
			else break;
		}

		// determine right limit
		n = x;
		while(n < LEVEL_W)
		{
			if(layer->data[o][n] == tile_being_replaced)
			{
				right = n;
				n++;
			}
			else break;
		}

		// draw from left to right
		for(n=left; n<=right; n++) layer->data[o][n] = tile;
	}

}



void keycheck(void)
{
//	fLogfile("Keycheck\n");
	if(keypressed())
	{
		int k = readkey() >> 8;
		switch(k)
		{
			case KEY_1:
				if(drawLayer1 == TRUE) drawLayer1 = FALSE;
				else drawLayer1 = TRUE;
				break;
			case KEY_2:
				if(drawLayer2 == TRUE) drawLayer2 = FALSE;
				else drawLayer2 = TRUE;
				break;
			case KEY_3:
				if(drawLayer3 == TRUE) drawLayer3 = FALSE;
				else drawLayer3 = TRUE;
				break;
			case KEY_S:
				saveLevel();
				break;
			case KEY_G:
				if(drawGrid == TRUE) drawGrid = FALSE;
				else drawGrid = TRUE;
				break;
			case KEY_T:
				TILE_SIZE++;
				if(TILE_SIZES[TILE_SIZE] == 0) TILE_SIZE = 0;
				break;
			case KEY_F2:
				tileset++;
				loadTileset(tileset);
				break;
			case KEY_F:
				floodLayer(level->interactive, (mouse_x + camera_x) / TILE_SIZES[TILE_SIZE], (mouse_y + camera_y) / TILE_SIZES[TILE_SIZE], current_tile);
				break;
			case KEY_F12:
				save_bitmap("ss.bmp",buffer,NULL);
				break;
		}
	}


	if(key[KEY_LEFT])
	{
		if(key[KEY_LSHIFT]) camera_x -= 25.0 * TIME_SINCE_LAST_FRAME;
		else camera_x -= 5.0 * TIME_SINCE_LAST_FRAME;
		if(camera_x < 0) camera_x = 0;
	}
	if(key[KEY_RIGHT])
	{
		if(key[KEY_LSHIFT]) camera_x += 25.0 * TIME_SINCE_LAST_FRAME;
		else camera_x += 5.0 * TIME_SINCE_LAST_FRAME;
		if(camera_x > LEVEL_W*TILE_SIZES[TILE_SIZE] - SCREEN_W + TILE_SIZES[TILE_SIZE]) camera_x = LEVEL_W*TILE_SIZES[TILE_SIZE] - SCREEN_W + TILE_SIZES[TILE_SIZE];
	}
	if(key[KEY_UP])
	{
		if(key[KEY_LSHIFT]) camera_y -= 25.0 * TIME_SINCE_LAST_FRAME;
		else camera_y -= 5.0 * TIME_SINCE_LAST_FRAME;
		if(camera_y < 0.0f) camera_y = 0.0f;
	}
	if(key[KEY_DOWN])
	{
		if(key[KEY_LSHIFT]) camera_y += 25.0 * TIME_SINCE_LAST_FRAME;
		else camera_y += 5.0 * TIME_SINCE_LAST_FRAME;
		if(camera_y > LEVEL_H*TILE_SIZES[TILE_SIZE] - SCREEN_H) camera_y = LEVEL_H*TILE_SIZES[TILE_SIZE] - SCREEN_H;
	}
	if(mouse_b & 1) parseMouse();
	if(mouse_b & 2)
	{
		if(mouse_x < SCREEN_W-TILE_SIZES[TILE_SIZE])
		{
			if(current_tile == 0)
			{
				startX = (camera_x + mouse_x)/TILE_SIZES[TILE_SIZE] * TILE_W;
				startY = (camera_y + mouse_y)/TILE_SIZES[TILE_SIZE] * TILE_H;
			}

			else
			{
				switch(editMode)
				{
					case MODE_TILE1:
						level->background->data[(mouse_y+(int)camera_y)/TILE_SIZES[TILE_SIZE]][(mouse_x+(int)camera_x)/TILE_SIZES[TILE_SIZE]] = 0;
						break;
					case MODE_TILE2:
						level->interactive->data[(mouse_y+(int)camera_y)/TILE_SIZES[TILE_SIZE]][(mouse_x+(int)camera_x)/TILE_SIZES[TILE_SIZE]] = 0;
						break;
					case MODE_TILE3:
						level->foreground->data[(mouse_y+(int)camera_y)/TILE_SIZES[TILE_SIZE]][(mouse_x+(int)camera_x)/TILE_SIZES[TILE_SIZE]] = 0;
						break;
				}
			}

			
		}
	}


	if(mouse_x == 0)
	{
		camera_x-= TILE_W;
		if(camera_x < 0) camera_x = 0;
	}
	else if(mouse_x == SCREEN_W-1)
	{
		camera_x+=TILE_W;
		if(camera_x > (LEVEL_W+1) * TILE_SIZES[TILE_SIZE] - SCREEN_W) camera_x = (LEVEL_W+1) * TILE_SIZES[TILE_SIZE] - SCREEN_W;
	}
	if(mouse_y == 0)
	{
		camera_y-=TILE_H;
		if(camera_y < 0) camera_y = 0;
	}
	else if(mouse_y == SCREEN_H-1)
	{
		camera_y+=TILE_H;
		if(camera_y > (LEVEL_H) * TILE_SIZES[TILE_SIZE] - SCREEN_H) camera_y = (LEVEL_H) * TILE_SIZES[TILE_SIZE] - SCREEN_H;
	}
}



void update(void)
{
	int n;
	float temp;

//	fLogfile("Update\n");


	TIME_SINCE_LAST_FRAME = (TICKS - last_frame_ticks) / 10.0;
	last_frame_ticks = TICKS;


	temp = 100.0 / TIME_SINCE_LAST_FRAME;
	if(temp > 0 && temp < 500)
	{
		fpsRecord[fpsIndex] = temp;
		fpsIndex++;
	}


	fps = 0.0;
	for(n=0; n<256; n++) fps += fpsRecord[n];
	fps = fps/256.0;

}


// draw tilemap -- method A: multiple conditionals
void drawTilemapA(void)
{
	int y,x;
	for(y=MAX(camera_y/TILE_SIZES[TILE_SIZE] - 1, 0); y<MIN(LEVEL_H, (camera_y + SCREEN_H) / TILE_SIZES[TILE_SIZE]); y++)
	{
		for(x=MAX(camera_x/TILE_SIZES[TILE_SIZE] - 1,0); x<MIN((camera_x + SCREEN_W)/TILE_SIZES[TILE_SIZE],LEVEL_W); x++)
		{
			if(level->background->data[y][x] > 0 && drawLayer1) stretch_blit(tile[(int)level->background->data[y][x]], buffer, 0, 0, TILE_W, TILE_H, x*TILE_SIZES[TILE_SIZE] - camera_x, y*TILE_SIZES[TILE_SIZE] - camera_y, TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE]);
			if(level->interactive->data[y][x] > 0 && drawLayer2) stretch_blit(tile[(int)level->interactive->data[y][x]], buffer, 0, 0, TILE_W, TILE_H, x*TILE_SIZES[TILE_SIZE] - camera_x, y*TILE_SIZES[TILE_SIZE] - camera_y, TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE]);
			if(level->foreground->data[y][x] > 0 && drawLayer3) stretch_blit(tile[(int)level->foreground->data[y][x]], buffer, 0, 0, TILE_W, TILE_H, x*TILE_SIZES[TILE_SIZE] - camera_x, y*TILE_SIZES[TILE_SIZE] - camera_y, TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE]);
		}
	}
}


// draw tilemap -- method B: multiple for's
void drawTilemapB(void)
{
	int y,x;
	//fLogfile("Layer 1\n");
	if(drawLayer1)
	{
		for(y=MAX(camera_y/TILE_SIZES[TILE_SIZE] - 1,0); y<MIN((camera_y + SCREEN_H) / TILE_SIZES[TILE_SIZE], LEVEL_H); y++)
		{
			for(x=MAX(camera_x/TILE_SIZES[TILE_SIZE] - 1,0); x<MIN((camera_x + SCREEN_W)/TILE_SIZES[TILE_SIZE],LEVEL_W); x++)
			{
				if(level->background->data[y][x] > 0) masked_stretch_blit(tile[(int)level->background->data[y][x]], buffer, 0, 0, TILE_W, TILE_H, x*TILE_SIZES[TILE_SIZE] - camera_x, y*TILE_SIZES[TILE_SIZE] - camera_y, TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE]);
			}
		}
	}
	//fLogfile("Layer 2\n");
	if(drawLayer2)
	{
		for(y=MAX(camera_y/TILE_SIZES[TILE_SIZE] - 1,0); y<MIN((camera_y + SCREEN_H) / TILE_SIZES[TILE_SIZE], LEVEL_H); y++)
		{
			for(x=MAX(camera_x/TILE_SIZES[TILE_SIZE] - 1,0); x<MIN((camera_x + SCREEN_W)/TILE_SIZES[TILE_SIZE],LEVEL_W); x++)
			{
				if(level->interactive->data[y][x] > 0) masked_stretch_blit(tile[(int)level->interactive->data[y][x]], buffer, 0, 0, TILE_W, TILE_H, x*TILE_SIZES[TILE_SIZE] - camera_x, y*TILE_SIZES[TILE_SIZE] - camera_y, TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE]);
			}
		}
	}

	//draw landing pads

	//fLogfile("Layer 3\n");
	if(drawLayer3)
	{
		for(y=MAX(camera_y/TILE_SIZES[TILE_SIZE] - 1,0); y<MIN((camera_y + SCREEN_H) / TILE_SIZES[TILE_SIZE], LEVEL_H); y++)
		{
			for(x=MAX(camera_x/TILE_SIZES[TILE_SIZE] - 1,0); x<MIN((camera_x + SCREEN_W)/TILE_SIZES[TILE_SIZE],LEVEL_W); x++)
			{
				if(level->foreground->data[y][x] >0) masked_stretch_blit(tile[(int)level->foreground->data[y][x]], buffer, 0, 0, TILE_W, TILE_H, x*TILE_SIZES[TILE_SIZE] - camera_x, y*TILE_SIZES[TILE_SIZE] - camera_y, TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE]);
			}
		}
	}
}


void draw(void)
{
	int x,y;
	
	clear(buffer);
//	fLogfile("Draw\n");
	

	//drawTilemapA();
	drawTilemapB();


//	fLogfile("draw grid\n");
	if(drawGrid)
	{
		for(y=-(int)camera_y%TILE_SIZES[TILE_SIZE]; y<SCREEN_H; y+=TILE_SIZES[TILE_SIZE])
		{
			line(buffer,0,y,SCREEN_W-TILE_SIZES[TILE_SIZE],y,makecol(32,32,128));
		}
		for(x=-(int)camera_x%TILE_SIZES[TILE_SIZE]; x<SCREEN_W; x+=TILE_SIZES[TILE_SIZE])
		{
			line(buffer,x,0,x,SCREEN_H,makecol(32,32,128));
		}
	}

	
	
//	fLogfile("draw options (on the right side)\n");
	{
		int n;
		switch(editMode)
		{
		case MODE_TILE1:
			n = TILE_MODE_BG;
			break;
		case MODE_TILE2:
			n = TILE_MODE_INT;
			break;
		case MODE_TILE3:
			n = TILE_MODE_FG;
			break;
		}
		stretch_blit(tile[n],buffer,0,0,TILE_W,TILE_H,SCREEN_W - TILE_SIZES[TILE_SIZE], 0, TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE]);
		stretch_blit(tile[TILE_UPWARD],buffer,0,0,TILE_W,TILE_H,SCREEN_W - TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE]);
		stretch_blit(tile[TILE_DOWNWARD],buffer,0,0,TILE_W,TILE_H,SCREEN_W - TILE_SIZES[TILE_SIZE], SCREEN_H - TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE]);
		n=0;
		for(x=MAX(0,panel_index); x<MIN(panel_index+(SCREEN_H/TILE_SIZES[TILE_SIZE]) - 3,255); x++)
		{
			stretch_blit(tile[panel_index+n],buffer,0,0,TILE_W,TILE_H,SCREEN_W-TILE_SIZES[TILE_SIZE],TILE_SIZES[TILE_SIZE]*2 + n*TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE], TILE_SIZES[TILE_SIZE]);
			n++;
		}
		// rectangle around selected tile
		rect(buffer,SCREEN_W-TILE_SIZES[TILE_SIZE],(current_tile - panel_index + 2) * TILE_SIZES[TILE_SIZE],SCREEN_W-1,(current_tile - panel_index + 2) * TILE_SIZES[TILE_SIZE] + TILE_SIZES[TILE_SIZE]-1,makecol(32,192,64));
	}


	textprintf(buffer,font,0,0,makecol(127,127,127),"%0.0f, cx%0.2f cy%0.2f %dpt sx%d sy%d",fps,camera_x,camera_y,TILE_SIZES[TILE_SIZE],startX,startY);


	// lander start position
	stretch_blit(data[B_LANDER].dat,buffer,0,0,LANDER_W,LANDER_H,
		(startX - camera_x)/TILE_SIZES[TILE_SIZE] * TILE_W,
		(startY - camera_y)/TILE_SIZES[TILE_SIZE] * TILE_H,
		TILE_SIZES[TILE_SIZE]/TILE_W * LANDER_W,
		TILE_SIZES[TILE_SIZE]/TILE_H * LANDER_H);

//	fLogfile("draw mouse\n");
	{
//		int x1 = (mouse_x/TILE_SIZES[TILE_SIZE] * TILE_SIZES[TILE_SIZE]) - (int)camera_x%TILE_SIZES[TILE_SIZE],
			//y1 = mouse_y/TILE_SIZES[TILE_SIZE] * TILE_SIZES[TILE_SIZE];

		draw_sprite(buffer,mouse_sprite,mouse_x,mouse_y);
		//rect(buffer,x1,y1,x1+TILE_SIZES[TILE_SIZE]-1,y1+TILE_SIZES[TILE_SIZE]-1,makecol(255,128,128));
	}


//	fLogfile("final step..\n");
	vsync();	// makes everything prettier
	blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
}



int main(int argc, char *argv[])
{
	int n;
//	char temp[80];
	fLogfileFlush();


	allegro_init();
	install_timer();
	install_keyboard();
	install_mouse();


	if(argc > 1)
		level_being_edited = atoi(argv[1]);
	else
		level_being_edited = 1;

	level = allocateLevel();




	
	SetGFXMode(GFX_AUTODETECT_FULLSCREEN,800,600);






	packfile_password("fruitpunch");
	data = load_datafile("data.dat");
		if(!data) FATAL_ERROR("Error loading data.dat");
	packfile_password(NULL);
	set_palette(data[P_GAME].dat);

	buffer = create_bitmap(SCREEN_W,SCREEN_H);
		if(!buffer) FATAL_ERROR("Error making buffer");

	loadLevel(level_being_edited);


	LOCK_FUNCTION(update_timer);
	LOCK_VARIABLE(TICKS);
	install_int_ex(&update_timer, MSEC_TO_TIMER(1));


	START_MAIN_LOOP:
	fLogfile("Starting main game loop.\n");
	while(!key[KEY_ESC])
	{
		keycheck();
		update();
		draw();
	}

	switch(alert3("Save changes to level?",NULL,NULL,"&Yes","&No","Cancel",KEY_Y,KEY_N,KEY_ESC))
	{
		case 1:
			saveLevel();
			break;

		case 2:
			break;

		case 3:
			goto START_MAIN_LOOP;
			break;
	}

	destroyLevel(level);
	destroy_bitmap(buffer);
	for(n=0; n<256; n++) destroy_bitmap(tile[n]);
	unload_datafile(data);

	return 0;
}
END_OF_MAIN();
