// COLLIDE.C
// PIXEL-PRECISION BITMAP COLLISION ROUTINES FOR LANDER
// 2003-01-15: Very old code, this stuff.  Taken from original game :-p


#include <allegro.h>
#include "collide.h"




void mk_spr_mask(BITMAP *s3, int spr_no)
{
	int bb_height=0;
	int bb_width=0;
	int x1,y1,z;
	int p;

	
	/* Clears the area is overwriting a mask */
	for(y1=0;y1<NUM_Y;y1++)
	{
		for(z=0;z<NUM_CHUNKS;z++)
		{
			for(x1=(z*32);x1<((z*32)+32);x1++)
			{
				spr_mask[spr_no].sp_mask[y1][z]=0x00000000 >> (x1 - ((z+1)*32));
			}
		}
	}

	for(y1=0;y1<NUM_Y;y1++)
	{
		for(z=0;z<NUM_CHUNKS;z++)
		{
			for(x1=(z*32);x1<((z*32)+32);x1++)
			{
				p=getpixel(s3,x1,y1);
				if(p>0)
				{
					if(z>spr_mask[spr_no].max_chunk) (spr_mask[spr_no].max_chunk = z);
					if(y1>bb_height) bb_height=y1;
					if(x1>bb_width)  bb_width =x1;
					spr_mask[spr_no].sp_mask[y1][z]+=0x80000000 >> (x1 - ((z+1)*32));
				}
			}
		}
	}

	spr_mask[spr_no].bb_height=bb_height;
	spr_mask[spr_no].bb_width =bb_width;
}





int check_pp_collision(int spr1, int spr1x, int spr1y, int spr2, int spr2x, int spr2y)
{
	int dx1,dx2,dy1,dy2,ddy1,ddy2;
	int spr1_chunk,spr2_chunk;
	int dx1_chunk,dx2_chunk;

	{
		if(spr1x>spr2x)
		{
			dx1=0;               // don't need to shift sprite 1
			dx2=spr1x-spr2x;     // need to shift sprite 2 left
		}
		else
		{
			dx1=spr2x-spr1x;     // need to shift sprite 1 left
			dx2=0;               // don't need to shift sprite 2
		}

		if(spr1y>spr2y)
		{
			dy1=0;               // don't need to skip any rows for sprite 1
			dy2=spr1y-spr2y;     // need to skip this many rows for sprite 2
		}
		else
		{
			dy1=spr2y-spr1y;     // need to skip this many rows for sprite 1
			dy2=0;               // don't need to skip any rown for sprite 2
		}

		spr1_chunk = dx1/32;
		spr2_chunk = dx2/32;
		dx1_chunk = dx1 - (32 * spr1_chunk);
		dx2_chunk = dx2 - (32 * spr2_chunk);

		while((spr1_chunk <= spr_mask[spr1].max_chunk) & (spr2_chunk <= spr_mask[spr2].max_chunk))
		{
			ddy1 = dy1;
			ddy2 = dy2;
			while((ddy1<=spr_mask[spr1].bb_height)&&(ddy2<=spr_mask[spr2].bb_height))
			{
				if((spr_mask[spr1].sp_mask[ddy1][spr1_chunk]<<dx1_chunk)&(spr_mask[spr2].sp_mask[ddy2][spr2_chunk]<<dx2_chunk))
					return TRUE;
				ddy1++;
				ddy2++;
			}

			if((!dx1_chunk) && (!dx2_chunk)) //If both sprites lined up on x-axis
			{
				spr1_chunk++;
				spr2_chunk++;
			}
			else
			{
				if(!dx1_chunk)
				{
					spr2_chunk++;
					dx1_chunk = 32 - dx2_chunk;
					dx2_chunk = 0;
				}
				else if(!dx2_chunk)
				{
					spr1_chunk++;
					dx2_chunk = 32 - dx1_chunk;
					dx1_chunk = 0;
				}
			}
		}
		return FALSE;  // No collision
	}
}




