//shared.h
// stuff thats used in both the editor and the game




#define PLAYER_W	33
#define PLAYER_H	27
#define LANDER_W	PLAYER_W
#define LANDER_H	PLAYER_H


// names for various tiles
// REMEMBER THAT TILE 0 DOESNT GET DRAWN!!!!
#define TILE_LAND_GEN				0
#define TILE0_TOP					1
#define TILE0_TOP_RIGHT				2
#define TILE0_TOP_LEFT				3
#define TILE0_RIGHT					4
#define TILE0_LEFT					5
#define TILE0_CENTER				6
#define TILE0_CORNER_UPPER_RIGHT	7
#define TILE0_CORNER_UPPER_LEFT		8

#define TILE0_BRICK					9

#define TILE1_TOP_LEFT_BG				1
#define TILE1_TOP_LEFT_CENTER_BG		2
#define TILE1_TOP_CENTER_BG				3
#define TILE1_TOP_RIGHT_CENTER_BG		4
#define TILE1_TOP_RIGHT_BG				5
#define TILE1_CENTER_LEFT_BG			6
#define TILE1_CENTER_LEFT_CENTER_FG		10
#define TILE1_CENTER_CENTER_FG			11
#define TILE1_CENTER_RIGHT_CENTER_FG	12
#define TILE1_CENTER_RIGHT_BG			8
#define TILE1_BOTTOM_LEFT_BG			7
#define TILE1_BOTTOM_LEFT_CENTER_FG		13
#define TILE1_BOTTOM_CENTER_FG			14
#define TILE1_BOTTOM_RIGHT_CENTER_FG	15
#define TILE1_BOTTOM_RIGHT_BG			9


#define TILE_W	32
#define TILE_H	32
#define LEVEL_W	128
#define LEVEL_H	128





#define GRAVITY	0.0015f		// 0.0015f is good...



// All levels are 512x15 tiles
typedef struct tLayer{
	void *level;
	unsigned char *data[ZERO_SIZE];
} tLayer;


typedef struct tLevel{
	struct tLayer *background;
	struct tLayer *interactive;
	struct tLayer *foreground;
} tLevel;
extern tLevel *level;






extern unsigned char fpsIndex;
extern float fpsRecord[256], fps;
extern DATAFILE *data;
extern BITMAP *buffer, *tile[256], *enemy_sprite[256];
extern volatile int TICKS;
extern float TIME_SINCE_LAST_FRAME, camera_x, camera_y;



extern unsigned char backgroundTiles[2][256],
	foregroundTiles[2][256],
	unselectableTiles[2][256],
	levelTiles[2][256],
	deathTiles[2][256];
extern int pickupTiles[2][256*2],
	animatedTiles[2][256*3],
	tileset;


extern float soundVolume, musicVolume;
extern char *keyName[KEY_MAX];
extern int color_depth, startX, startY;


extern void fLogfileFlush(void);
extern void fLogfile(const char *format);
extern void update_timer(void);
extern void FATAL_ERROR(const char *msg);
extern tLayer *allocateLayer(void);
extern void destroyLayer(tLayer *layer);
extern tLevel *allocateLevel(void);
extern void destroyLevel(tLevel *level);
extern void loadTileset(int number);
extern void destroyTileset(void);
extern void loadLevel(int number);
extern void SetGFXMode(int mode, int w, int h);
extern void addEnemy(int x, int y, int type);
extern void destroyEnemy(int n);
extern void destroyEnemyXY(int x, int y);
extern void updateEnemies(void);
extern void loadEnemies(void);
extern void BITMAP_DUMP(void);
extern void check_collision_when_falling(float *x, float *y, float *dy, int w, int h);
extern void check_collision_when_jumping(float *x, float *y, float *dy, int w, int h);
extern void check_collision_when_walking_left(float *x, float dx, float *y, int w, int h);
extern void check_collision_when_walking_right(float *x, float dx, float *y, int w, int h);
extern int doMenu(void (*bg_func)(void), FONT *title_font, const char *title, int items, FONT *item_font, char *options);
extern void fScreenshot(const char *prefix);




