// shared.c
// stuff thats used in both the editor and the game


#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <allegro.h>
#include "shared.h"
#include "data.h"



int startX, startY;


// basically for the editor -- so it'll switch into the proper mode when you select a tile
unsigned char backgroundTiles[2][256]={
/*tileset0*/	{0},
/*tileset1*/	{0}
};



unsigned char foregroundTiles[2][256]={
/*tileset0*/	{0},
/*tileset1*/	{0}
};



unsigned char unselectableTiles[2][256]={
/*tileset0*/	{0},
/*tileset1*/	{0}
};



unsigned char levelTiles[2][256]={
/*tileset0*/	{/*0,*/ 0},
/*tileset1*/	{/*0,*/ 0}
};



// animated tiles: {[FIRST_TILE_INDEX],[LENGTH],[WHAT FRAME WE'RE ON -- INIT AS 1],repeat, ..., -1 [END]}
int animatedTiles[2][256*3] = {	// += 3
/*tileset0*/
	{
		-1
	},
/*tileset1*/
	{
		-1
	}
};
// item pickups: {[TILE INDEX], [POINT VALUE], repeat, ..., -1 [END]}
int pickupTiles[2][256*2]={	// += 2
/*tileset0*/
	{
		-1
	},
/*tileset1*/
	{
		-1
	}
};


float soundVolume=100.0f, musicVolume=50.0f;


int tileset=0;

unsigned char fpsIndex=0;
float fpsRecord[256], fps;
volatile int TICKS=0;
int color_depth;

tLevel *level;
float TIME_SINCE_LAST_FRAME = 1.0, camera_x=0.0f, camera_y=0.0f;

DATAFILE *data;
BITMAP *buffer, *tile[256], *enemy_sprite[256];





char *keyName[KEY_MAX] = {
		"(NULL)", // 0
		"'A'",
		"'B'",
		"'C'",
		"'D'",
		"'E'",	//5
		"'F'",
		"'G'",
		"'H'",
		"'I'",
		"'J'",	//10
		"'K'",
		"'L'",
		"'M'",
		"'N'",
		"'O'",	//15
		"'P'",
		"'Q'",
		"'R'",
		"'S'",
		"'T'",	//20
		"'U'",
		"'V'",
		"'W'",
		"'X'",
		"'Y'",	//25
		"'Z'",
		"'0'",
		"'1'",
		"'2'",
		"'3'",	//30
		"'4'",
		"'5'",
		"'6'",
		"'7'",
		"'8'",	//35
		"'9'",
		"Keypad '0'",
		"Keypad '1'",
		"Keypad '2'",
		"Keypad '3'",	//40
		"Keypad '4'",
		"Keypad '5'",
		"Keypad '6'",
		"Keypad '7'",
		"Keypad '8'",	//45
		"Keypad '9'",
		"'F1'",
		"'F2'",
		"'F3'",
		"'F4'",	//50
		"'F5'",
		"'F6'",
		"'F7'",
		"'F8'",
		"'F9'", //55
		"'F10'",
		"'F11'",
		"'F12'",
		"Escape",
		"Tilde '~'", //60
		"Minus '-'",
		"Equals '='",
		"Backspace",
		"Tab",
		"Open Brace '{'", //65
		"Close Brace '}'",
		"Enter",
		"Colon ':'",
		"Quote '\"'",
		"Backslash '\\'", //70
		"Backslash2 '\\'",
		"Comma ','",
		"Period '.'",
		"Slash '/'",
		"Spacebar", //75
		"Insert",
		"Delete",
		"Home",
		"End",
		"Page Up", //80
		"Page Down",
		"Left Arrow",
		"Right Arrow",
		"Up Arrow",
		"Down Arrow", //85
		"Keypad Slash '/'",
		"Asterix '*'",
		"Keypad Minus '-'",
		"Keypad Plus '+'",
		"Keypad Delete", //90
		"Keypad Enter",
		"Print Screen",
		"Pause",
		"ABNT_C1",
		"Yen", //95
		"Kana",
		"Convert",
		"No Convert",
		"At",
		"Circumflex", //100
		"Colon 2",
		"Kanji",
		"Left Shift",
		"Right Shift",
		"Left Control", //105
		"Right Control",
		"Alt",
		"Alt (grey)",
		"Left Windows Key",
		"Right Windows Key", //110
		"Menu",
		"Scroll Lock",
		"Num Lock",
		"Caps Lock"}; //114




void FATAL_ERROR(const char *msg)
{
	set_gfx_mode(GFX_TEXT,0,0,0,0);
	allegro_message(msg);
	destroy_bitmap(buffer);
	unload_datafile(data);
	allegro_exit();
	exit(1);
}





void fLogfileFlush(void)
{
#ifdef _DEBUG
	FILE *file;
	file = fopen("log.txt","wt");
	fclose(file);
#endif
	return;
}


void fLogfile(const char *format)
{
#ifdef _DEBUG
	FILE *file;
	file = fopen("log.txt","at");
	fputs(format,file);
	fclose(file);
#endif
	return;
}


tLayer *allocateLayer()
{
	int n,x,y;
	tLayer *level;

	fLogfile("Allocating space for a level...");


	level = malloc(sizeof(*level) + (sizeof(char *) * LEVEL_H));
	if(!level)
	{
		FATAL_ERROR("Couldn't allocate layer");
	}


	level->level = malloc(LEVEL_W * LEVEL_H * sizeof(unsigned char));
	if(!level->level)
	{
		free(level);
		FATAL_ERROR("Couldn't allocate layer data");
	}

	level->data[0] = level->level;
	for(n=1; n<LEVEL_H; n++)
		level->data[n] = level->data[n-1] + LEVEL_W * sizeof(unsigned char);


	// clear it to zero
	for(y=0;y<LEVEL_H;y++)
		for(x=0;x<LEVEL_W;x++)
			level->data[y][x] = 0;


	fLogfile("good.\n");

	return level;
}

void clearLayer(tLayer *layer)
{
	int x,y;

	for(y=0; y<LEVEL_H; y++)
	{
		for(x=0; x<LEVEL_W; x++)
		{
			layer->data[y][x] = 0;
		}
	}
}


void clearLevel(tLevel *level)
{
	clearLayer(level->background);
	clearLayer(level->interactive);
	clearLayer(level->foreground);
}



tLevel *allocateLevel(void)
{
	tLevel *level;

	level = malloc(sizeof(*level));
	if(!level)
	{
		FATAL_ERROR("Couldn't allocate level");
	}

	level->background = allocateLayer();
	level->interactive = allocateLayer();
	level->foreground = allocateLayer();


	clearLevel(level);

	return level;
}


void destroyLayer(tLayer *layer)
{
	if(layer)
	{
		if(layer->level) free(layer->level);
		free(layer);
	}
}


void destroyLevel(tLevel *level)
{
	if(level)
	{
		if(level->background) destroyLayer(level->background);
		if(level->interactive) destroyLayer(level->interactive);
		if(level->foreground) destroyLayer(level->foreground);
	}
}


void destroyTileset(void)
{
	int n;
	for(n=0; n<256; n++)
	{
		if(tile[n]) destroy_bitmap(tile[n]);
	}
}

void loadTileset(int number)
{
	BITMAP *bmp;
	int n,x,y;

	fLogfile("Loading tileset...");


	bmp = data[B_TILEMAP0 + number].dat;

	if(bmp->w != 1056 || bmp->h != 264)
	{
		FATAL_ERROR("Tileset dimensions are incorrect.");
	}



	// I'm too lazy to do math, this seems pretty harmless
	x=0;y=0;
	for(n=0; n<256; n++)
	{
		if(!tile[n]) tile[n] = create_bitmap(TILE_W,TILE_H);
		blit(bmp,tile[n],x,y,0,0,32,32);
		x += 33;
		if(x >= bmp->w)
		{
			x = 0;
			y += 33;
		}
	}

	fLogfile("good.\n");
}


void loadLevel(int number)
{
	int n,x,x1,x2,y,y1,y2;
	char temp[80];
	PACKFILE *file;


	fLogfile("Loading the level...");

	sprintf(temp,"level%02d.l2",number);
	if(!exists(temp))
	{
		fLogfile("level not found.\n");
		loadTileset(0);
//		FATAL_ERROR("Level file doesn't exist");
		return;
	}

	file = pack_fopen(temp,F_READ_PACKED);
	if(!file)
	{
		fLogfile("couldn't open level file.\n");
//		FATAL_ERROR("Couldn't open level file :-\\");
		return;
	}


	startX = pack_igetw(file);
	startY = pack_igetw(file);



	tileset = pack_getc(file);	// tileset
	sprintf(temp,"Tileset %d",tileset);
	fLogfile(temp);
	loadTileset(tileset);
	n = pack_igetl(file);	// bg color -- future versions
	n = pack_getc(file);	// music -- for future..



	// walking level
	y1 = pack_igetw(file);
	y2 = pack_igetw(file);
	x1 = pack_igetw(file);
	x2 = pack_igetw(file);

	sprintf(temp,"Background layer: x1=%d x2=%d y1=%d y2=%d\n",x1,x2,y1,y2);
	fLogfile(temp);


	for(y=MAX(0,y1); y<MIN(y2,LEVEL_H); y++)
	{
		for(x=MAX(0,x1); x<MIN(x2,LEVEL_W); x++)
		{
			level->interactive->data[y][x] = pack_getc(file);
		}
	}




	// background
	y1 = pack_igetw(file);
	y2 = pack_igetw(file);
	x1 = pack_igetw(file);
	x2 = pack_igetw(file);

	sprintf(temp,"Walking layer: x1=%d x2=%d y1=%d y2=%d\n",x1,x2,y1,y2);
	fLogfile(temp);

	for(y=MAX(0,y1); y<MIN(y2,LEVEL_H); y++)
	{
		for(x=MAX(0,x1); x<MIN(x2,LEVEL_W); x++)
		{
			level->background->data[y][x] = pack_getc(file);
		}
	}


	// foreground
	y1 = pack_igetw(file);
	y2 = pack_igetw(file);
	x1 = pack_igetw(file);
	x2 = pack_igetw(file);

	sprintf(temp,"Foreground layer: x1=%d x2=%d y1=%d y2=%d\n",x1,x2,y1,y2);
	fLogfile(temp);

	for(y=MAX(0,y1); y<MIN(y2,LEVEL_H); y++)
	{
		for(x=MAX(0,x1); x<MIN(x2,LEVEL_W); x++)
		{
			level->foreground->data[y][x] = pack_getc(file);
		}
	}




	pack_fclose(file);


	fLogfile("good.\n");
}


// set gfx mode
void SetGFXMode(int mode, int w, int h)
{
	int gfx_set = FALSE;
	CHEAP_GFX_HACK:
	{
		int n;
		static int bpp[] = {8,32,24,16,15,0};

		if(!gfx_set)
		{
			for(n=0; bpp[n] != 0; n++)
			{
				color_depth = bpp[n];
				set_color_depth(color_depth);
				if(set_gfx_mode(mode,w,h,0,0) == 0)
				{
					gfx_set = TRUE;
					goto CHEAP_GFX_HACK;
				}
			}
			allegro_message("Sorry, no suitable GFX driver could be found :-\\");
			allegro_exit();
			exit(1);			
		}
	}

	text_mode(-1);
}




// dumps all bitmaps to external file -- for debugging
void BITMAP_DUMP(void)
{
	int n,x,y;
	char temp[80];
	BITMAP *bmp;

	fLogfile("Dumping all bitmap data...\n");

	// tiles
	for(n=0; n<256; n++)
	{
		if(tile[n])
		{
			sprintf(temp,"_bmp//tile%03d.bmp",n);
			save_bmp(temp,tile[n],NULL);
		}
	}



	// buffer
	save_bmp("_bmp//buffer.bmp",buffer,_current_palette);

	// screen
	save_bmp("_bmp//screen.bmp",screen,_current_palette);

	// palette
	bmp = create_bitmap_ex(32,512,512);
	n=0;
	for(y=0; y<16; y++)
	{
		for(x=0; x<16; x++)
		{
			rectfill(bmp,x*16, y*16, x*16 + 15, y*16 + 15, makecol32(_current_palette[n].r*4, _current_palette[n].g*4, _current_palette[n].b*4));
			n++;
		}
	}
	save_bmp("_bmp//palette.bmp",bmp,NULL);
	destroy_bitmap(bmp);
}









int doMenu(void (*bg_func)(void), FONT *title_font, const char *title,
		   int items, FONT *item_font, char *options)
{
	int n,selected = 0;
    char** opt_addr;
    int i, a;

    opt_addr = (char**)malloc(sizeof(char *) * items);
    opt_addr[0] = options;
    a = 1;
    for(i = 0; a < (int)items; ++i)
    {
        if(options[i] == '\0')
        {
            opt_addr[a] = options + i + 1;
            ++a;
        }
    }




	while(1)
	{
		int k;

		clear_keybuf();
		while(!keypressed())
		{
			clear(buffer);
			// so that animation continutes
			bg_func();
			textprintf_centre(buffer,title_font,SCREEN_W/2, SCREEN_H / 10, makecol(255,255,255), title);

			for(n=0; n<items; n++)
			{
				textprintf_centre(buffer, item_font, SCREEN_W/2, text_height(title_font) + SCREEN_H/6 + (text_height(item_font)+5)*n, makecol(255,255,255), opt_addr[n]);
			}
			draw_sprite(buffer,data[B_ARROW].dat,SCREEN_W/2 - text_length(item_font, opt_addr[selected]) / 2 - 64, text_height(title_font) + SCREEN_H/6 + (text_height(item_font)+5)*selected - 8);
			draw_sprite_h_flip(buffer,data[B_ARROW].dat,SCREEN_W/2 + text_length(item_font, opt_addr[selected]) / 2 + 32, text_height(title_font) + SCREEN_H/6 + (text_height(item_font)+5)*selected - 8);
			blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
		}

		k = readkey() >> 8;
		switch(k)
		{
			case KEY_UP:
			{
				selected--;
				if(selected < 0) selected = 0;
				break;
			}
			case KEY_DOWN:
			{
				selected++;
				if(selected >= items) selected = items-1;
				break;
			}
			case KEY_ENTER:
			{
				return selected;
				break;
			}
			case KEY_ESC:
			{
				return items-1;
				break;
			}
			case KEY_F12:
			{
				fScreenshot("LAND");
				break;
			}
		}
	}

}


// stolen from allegro, changed to work properly :-p
int save_pcx_ex(AL_CONST char *filename, BITMAP *bmp, AL_CONST RGB *pal)
{
   PACKFILE *f;
   PALETTE tmppal;
   int c;
   int x, y;
   int runcount;
   int depth, planes;
   char runchar;
   char ch;

   if (!pal) {
      get_palette(tmppal);
      pal = tmppal;
   }

   f = pack_fopen(filename, F_WRITE);
   if (!f)
      return *allegro_errno;

   depth = bitmap_color_depth(bmp);
   if (depth == 8)
      planes = 1;
   else
      planes = 3;

   pack_putc(10, f);                      /* manufacturer */
   pack_putc(5, f);                       /* version */
   pack_putc(1, f);                       /* run length encoding  */
   pack_putc(8, f);                       /* 8 bits per pixel */
   pack_iputw(0, f);                      /* xmin */
   pack_iputw(0, f);                      /* ymin */
   pack_iputw(bmp->w-1, f);               /* xmax */
   pack_iputw(bmp->h-1, f);               /* ymax */
   pack_iputw(320, f);                    /* HDpi */
   pack_iputw(200, f);                    /* VDpi */

   for (c=0; c<16; c++) {
      pack_putc(_rgb_scale_6[pal[c].r], f);
      pack_putc(_rgb_scale_6[pal[c].g], f);
      pack_putc(_rgb_scale_6[pal[c].b], f);
   }

   pack_putc(0, f);                       /* reserved */
   pack_putc(planes, f);                  /* one or three color planes */
   pack_iputw(bmp->w, f);                 /* number of bytes per scanline */
   pack_iputw(1, f);                      /* color palette */
   pack_iputw(bmp->w, f);                 /* hscreen size */
   pack_iputw(bmp->h, f);                 /* vscreen size */
   for (c=0; c<54; c++)                   /* filler */
      pack_putc(0, f);

   for (y=0; y<bmp->h; y++) {             /* for each scanline... */
      runcount = 0;
      runchar = 0;
      for (x=0; x<bmp->w*planes; x++) {   /* for each pixel... */
	 if (depth == 8) {
	    ch = getpixel(bmp, x, y);
	 }
	 else {
	    if (x<bmp->w) {
	       c = getpixel(bmp, x, y);
	       ch = getr_depth(depth, c);
	    }
	    else if (x<bmp->w*2) {
	       c = getpixel(bmp, x-bmp->w, y);
	       ch = getg_depth(depth, c);
	    }
	    else {
	       c = getpixel(bmp, x-bmp->w*2, y);
	       ch = getb_depth(depth, c);
	    }
	 }
	 if (runcount==0) {
	    runcount = 1;
	    runchar = ch;
	 }
	 else {
	    if ((ch != runchar) || (runcount >= 0x3f)) {
	       if ((runcount > 1) || ((runchar & 0xC0) == 0xC0))
		  pack_putc(0xC0 | runcount, f);
	       pack_putc(runchar,f);
	       runcount = 1;
	       runchar = ch;
	    }
	    else
	       runcount++;
	 }
      }
      if ((runcount > 1) || ((runchar & 0xC0) == 0xC0))
	 pack_putc(0xC0 | runcount, f);
      pack_putc(runchar,f);
   }

   if (depth == 8) {                      /* 256 color palette */
      pack_putc(12, f); 

      for (c=0; c<256; c++) {
//	 pack_putc(_rgb_scale_6[pal[c].r], f);
//	 pack_putc(_rgb_scale_6[pal[c].g], f);
//	 pack_putc(_rgb_scale_6[pal[c].b], f);
	 pack_putc(pal[c].r * 4, f);
	 pack_putc(pal[c].g * 4, f);
	 pack_putc(pal[c].b * 4, f);
      }
   }

   pack_fclose(f);
   return *allegro_errno;
}




void fScreenshot(const char *prefix)
{
	char temp[80];
	int n;

	for(n=0;;n++)
	{
		sprintf(temp,"%s%04d.pcx",prefix,n);
		if(!exists(temp)) break;
	}

	save_pcx_ex(temp,buffer,_current_palette);
}
