#ifndef _METRONOME_H_
#define _METRONOME_H_

#include <string>
#include <allegro.h>

using namespace std;

class Metronome
{
public:
    Metronome();
    ~Metronome();

    // start and stop the metronome
    void start();
    void stop();
    int play();       // call this in a tight loop after starting
    
    // set and retrieve the pattern "012", 0 = nothing, 1 = soft, 2 = emphasis
    int set_pattern(string const &npat);    // returns succes/failure
    string const &get_pattern() const;
    int get_pattern_length() const;

    // set and retrieve the sample
    void set_sample(SAMPLE *smp);
    SAMPLE *get_sample() const;

    // set and retrieve pattern position
    int set_pattern_pos(int npp);        // return success
    int get_pattern_pos() const;
    
    // set and retriever the beats per minute
    int set_bpm(int nbpm);               // return success
    int get_bpm() const;

    // timer procedure, sets a global flag
    static void timer_proc();
    
private:
    int bpm;
    string pattern;
    int pattern_pos;     // which note of the pattern to play next
    SAMPLE *sample;
};

#endif
